/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.util;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcNameClashObjectSet;
import org.dmd.dmc.DmcNameClashResolverIF;
import org.dmd.dmc.DmcNamedObjectIF;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.rules.DmcRuleExceptionSet;
import org.dmd.dmc.rules.SourceInfo;
import org.dmd.dmc.util.DmcUncheckedObject;
import org.dmd.dms.AttributeDefinition;
import org.dmd.dms.ClassDefinition;
import org.dmd.dms.DmsDefinition;
import org.dmd.dms.MetaSchema;
import org.dmd.dms.MetaSchemaAG;
import org.dmd.dms.SchemaDefinition;
import org.dmd.dms.SchemaDefinitionListenerIF;
import org.dmd.dms.SchemaManager;
import org.dmd.dms.TypeDefinition;
import org.dmd.dms.generated.dmo.AttributeDefinitionDMO;
import org.dmd.dms.generated.dmo.DmsDefinitionDMO;
import org.dmd.dms.generated.dmo.MetaDMSAG;
import org.dmd.dms.generated.dmw.AttributeDefinitionIterableDMW;
import org.dmd.dms.generated.dmw.SchemaDefinitionDMW;
import org.dmd.dms.generated.dmw.TypeDefinitionIterableDMW;
import org.dmd.dms.util.DmoObjectFactory;
import org.dmd.dmv.server.DmvDynamicRuleManager;
import org.dmd.dmv.shared.DmvRuleManager;
import org.dmd.dmw.DmwObjectFactory;
import org.dmd.dmw.DmwWrapper;
import org.dmd.util.UtilityOptions;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.exceptions.ResultException;
import org.dmd.util.parsing.ConfigFinder;
import org.dmd.util.parsing.ConfigLocation;
import org.dmd.util.parsing.ConfigVersion;
import org.dmd.util.parsing.DmcUncheckedOIFHandlerIF;
import org.dmd.util.parsing.DmcUncheckedOIFParser;

public class DmsSchemaParser
implements DmcUncheckedOIFHandlerIF,
SchemaDefinitionListenerIF,
DmcNameClashResolverIF {
    SchemaManager dmsSchema;
    SchemaManager allSchema;
    SchemaDefinition schemaLoading;
    Stack<SchemaDefinition> schemaStack;
    String currFile;
    HashMap<String, SchemaDefinition> loadedFiles;
    String schemaDir;
    DmcUncheckedOIFParser schemaParser;
    DmcUncheckedOIFParser defParser;
    ConfigFinder finder;
    boolean terseV;
    DmwObjectFactory dmwfactory;
    DmoObjectFactory dmofactory;
    DmvRuleManager ruleManager;

    public DmsSchemaParser(SchemaManager sm, ConfigFinder f) throws ResultException {
        this.dmsSchema = sm;
        this.finder = f;
        this.initialize();
    }

    public SchemaDefinition parseSchema(SchemaManager am, String schemaName, boolean terse) throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException {
        this.allSchema = am;
        this.initialize();
        this.terseV = terse;
        SchemaDefinition rc = this.parseSchemaInternal(schemaName);
        return rc;
    }

    public void checkRules(SchemaDefinition sd) throws DmcRuleExceptionSet, DmcNameClashException, DmcValueException {
        DmvDynamicRuleManager drm = new DmvDynamicRuleManager();
        drm.loadAndCheckRules(this.allSchema, sd);
    }

    void initialize() {
        this.schemaLoading = null;
        this.currFile = null;
        this.loadedFiles = new HashMap();
        this.schemaParser = new DmcUncheckedOIFParser(this);
        this.defParser = new DmcUncheckedOIFParser(this);
        for (AttributeDefinition def : MetaSchemaAG._metaSchema.getAttributeDefList()) {
            if (!def.getPreserveNewlines().booleanValue()) continue;
            this.schemaParser.addPreserveNewlinesAttribute(def.getName().getNameString());
            this.defParser.addPreserveNewlinesAttribute(def.getName().getNameString());
        }
        this.schemaStack = new Stack();
        this.dmwfactory = new DmwObjectFactory(this.allSchema);
        this.dmofactory = new DmoObjectFactory(this.allSchema);
        this.ruleManager = new DmvRuleManager();
    }

    SchemaDefinition parseSchemaInternal(String schemaName) throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException {
        ConfigVersion config = this.finder.getConfig(schemaName);
        ConfigLocation location = null;
        SchemaDefinition currSchema = null;
        String currFile = null;
        SchemaDefinition nativeSchema = null;
        if (config == null) {
            ResultException ex = new ResultException();
            ex.addError("The specified schema couldn't be found: " + schemaName);
            ex.addError(DebugInfo.getCurrentStack());
            throw ex;
        }
        location = config.getLatestVersion();
        currFile = location.getFileName();
        if (!this.terseV && !UtilityOptions.instance().quietProgress()) {
            System.out.println("\nParsing schema: " + schemaName);
        }
        this.schemaDir = new String(location.getDirectory());
        if (!this.loadedFiles.containsKey(currFile) && (nativeSchema = this.allSchema.isSchema(schemaName)) == null) {
            TypeDefinitionIterableDMW tdl;
            this.loadedFiles.put(currFile, null);
            if (!this.terseV && !UtilityOptions.instance().quietProgress()) {
                System.out.println("    Reading " + currFile);
            }
            this.schemaParser.parseFile(currFile, location.isFromJAR());
            currSchema = this.schemaStack.pop();
            this.loadedFiles.remove(currFile);
            this.loadedFiles.put(currFile, currSchema);
            this.allSchema.addDefinition(currSchema, this);
            for (DmsDefinition def : this.allSchema.globallyUniqueMAP.values()) {
                this.ruleManager.executeAttributeValidation(def.getDmcObject());
            }
            this.allSchema.resolveReferences(currSchema, this);
            AttributeDefinitionIterableDMW adl = currSchema.getAttributeDefList();
            if (adl != null) {
                this.allSchema.resolveNameTypes(adl);
            }
            if ((tdl = currSchema.getTypeDefList()) != null) {
                while (tdl.hasNext()) {
                    TypeDefinition td = (TypeDefinition)tdl.next();
                    if (!td.getIsNameType().booleanValue() || td.getNameAttributeDef() != null) continue;
                    ResultException ex = new ResultException("The " + td.getName() + " TypeDefinition is flagged as a name type but doesn't have a corresponding attribute of the same type with the designatedNameAttribute flag set to true.");
                    ex.setLocationInfo(td.getFile(), td.getLineNumber());
                    throw ex;
                }
            }
        } else {
            currSchema = nativeSchema == null ? this.loadedFiles.get(currFile) : nativeSchema;
        }
        currSchema.setVersion(location.getVersion());
        return currSchema;
    }

    @Override
    public void handleObject(DmcUncheckedObject uco, String infile, int lineNumber) throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException {
        ClassDefinition cd = null;
        boolean isSchema = false;
        DmsDefinition newDef = null;
        Iterator<String> dependsOnSchemas = null;
        Iterator<String> defFiles = null;
        SchemaDefinition currSchema = null;
        String depSchema = null;
        SchemaDefinition newSchema = null;
        String currFile = null;
        String srcFile = "";
        cd = this.allSchema.isClass(uco.classes.get(0));
        if (cd == null) {
            ResultException ex = new ResultException();
            ex.result.addResult(3, "Unknown class: " + uco.classes.get(0));
            ex.result.lastResult().lineNumber(uco.lineNumber);
            ex.result.lastResult().fileName(infile);
            throw ex;
        }
        try {
            ClassDefinition checkClass;
            if (uco.classes.get(0).equals(MetaSchema._SchemaDefinition.getName())) {
                this.allSchema.schemaPreAdd(uco);
            }
            int srcloc = infile.indexOf("/src");
            srcFile = "";
            srcFile = srcloc != -1 ? infile.substring(srcloc) : infile;
            if (this.schemaLoading == null) {
                if (uco.getSV(MetaDMSAG.__name.name) != null) {
                    uco.addValue(MetaDMSAG.__dotName.name, uco.getSV(MetaDMSAG.__name.name) + "." + uco.getConstructionClass());
                }
            } else if (uco.getSV(MetaDMSAG.__name.name) != null) {
                uco.addValue(MetaDMSAG.__dotName.name, this.schemaLoading.getName() + "." + uco.getSV(MetaDMSAG.__name.name) + "." + uco.getConstructionClass());
            }
            if ((checkClass = this.allSchema.isClass(uco.classes.get(0))) != null && checkClass.getRuleDefinition() != null) {
                uco.addValue(MetaDMSAG.__lineNumber.name, lineNumber + "");
                uco.addValue(MetaDMSAG.__file.name, srcFile);
                uco.addValue(MetaDMSAG.__definedIn.name, this.schemaLoading.getName().getNameString());
                this.schemaLoading.addParsedRule(uco);
                return;
            }
            DmwWrapper newObj = this.dmwfactory.createWrapper(uco);
            newDef = null;
            newDef = (DmsDefinition)newObj;
            newDef.setFile(srcFile);
            newDef.setLineNumber(lineNumber);
            this.ruleManager.executeAttributeValidation(newDef.getDmcObject());
            this.ruleManager.executeObjectValidation(newDef.getDmcObject());
        }
        catch (ResultException e) {
            e.result.lastResult().fileName(infile);
            e.result.lastResult().lineNumber(lineNumber);
            throw e;
        }
        catch (DmcValueException e) {
            ResultException ex = new ResultException(e.getMessage());
            ex.result.lastResult().fileName(infile);
            ex.result.lastResult().lineNumber(lineNumber);
            throw ex;
        }
        catch (ClassCastException e) {
            ResultException ex = new ResultException();
            ex.addError("Invalid object in a schema definition: " + uco.classes.get(0));
            ex.result.lastResult().moreMessages(e.getMessage());
            ex.result.lastResult().moreMessages(DebugInfo.extractTheStack(e));
            ex.result.lastResult().lineNumber(uco.lineNumber);
            ex.result.lastResult().fileName(infile);
            throw ex;
        }
        catch (ClassNotFoundException e) {
            ResultException ex = new ResultException();
            ex.addError(e.getMessage());
            ex.result.lastResult().moreMessages(DebugInfo.extractTheStack(e));
            throw ex;
        }
        catch (DmcRuleExceptionSet e) {
            e.source(new SourceInfo(srcFile, lineNumber + ""));
            throw e;
        }
        if (cd.getObjectName().getNameString().compareTo("SchemaDefinition") == 0) {
            isSchema = true;
        }
        if (this.schemaLoading == null) {
            if (isSchema) {
                this.schemaLoading = (SchemaDefinition)newDef;
                this.schemaStack.push(this.schemaLoading);
                dependsOnSchemas = this.schemaLoading.getDependsOn();
                if (dependsOnSchemas != null) {
                    currSchema = this.schemaLoading;
                    this.schemaLoading = null;
                    while (dependsOnSchemas.hasNext()) {
                        ResultException ex;
                        depSchema = dependsOnSchemas.next();
                        ConfigVersion config = this.finder.getConfig(depSchema);
                        ConfigLocation location = null;
                        if (config == null) {
                            ex = new ResultException();
                            ex.addError("Couldn't find schema: " + depSchema + " on which schema: " + currSchema.getObjectName() + " depends.");
                            throw ex;
                        }
                        location = config.getLatestVersion();
                        currFile = location.getFileName();
                        if (!this.loadedFiles.containsKey(currFile)) {
                            newSchema = this.parseSchemaInternal(depSchema);
                            if (newSchema == null) {
                                ex = new ResultException();
                                ex.result.addResult(4, "Failed to parse schema: " + depSchema);
                                throw ex;
                            }
                            currSchema.addDependsOnRef(newSchema);
                            this.schemaLoading = null;
                            continue;
                        }
                        currSchema.addDependsOnRef(this.loadedFiles.get(currFile));
                    }
                    this.schemaLoading = currSchema;
                    this.allSchema.schemaBeingLoaded(this.schemaLoading);
                }
                if ((defFiles = this.schemaLoading.getDefFiles()) != null) {
                    ConfigLocation location = this.finder.getConfig(this.schemaLoading.getName().getNameString()).getLatestVersion();
                    while (defFiles.hasNext()) {
                        currFile = location.isFromJAR() ? "/" + location.getDirectory() + "/" + defFiles.next() : location.getDirectory() + File.separator + defFiles.next();
                        if (!this.terseV && !UtilityOptions.instance().quietProgress()) {
                            if (location.isFromJAR()) {
                                System.out.println("      Reading " + currFile + " - from " + location.getJarFilename());
                            } else {
                                System.out.println("      Reading " + currFile);
                            }
                        }
                        if (location.isFromJAR()) {
                            this.defParser.parseFile(currFile, true);
                            continue;
                        }
                        this.defParser.parseFile(currFile);
                    }
                }
            }
        } else {
            if (isSchema) {
                ResultException ex = new ResultException();
                ex.result.addResult(4, "Already loading schema: " + this.schemaLoading.getObjectName());
                ex.result.lastResult().moreMessages("This may have occurred because you have two schema definitions in the same file.");
                ex.result.lastResult().fileName(infile);
                throw ex;
            }
            newDef.setDefinedIn(this.schemaLoading);
            this.allSchema.addDefinition(newDef, this);
            this.schemaLoading.addDefinition(newDef);
        }
    }

    @Override
    public void definitionAdded(DmsDefinitionDMO def) {
        AttributeDefinitionDMO attr;
        if (def instanceof AttributeDefinitionDMO && (attr = (AttributeDefinitionDMO)def).getPreserveNewlines().booleanValue()) {
            this.schemaParser.addPreserveNewlinesAttribute(attr.getName().getNameString());
            this.defParser.addPreserveNewlinesAttribute(attr.getName().getNameString());
        }
    }

    @Override
    public DmcNamedObjectIF resolveClash(DmcObject obj, DmcAttributeInfo ai, DmcNameClashObjectSet<?> ncos) throws DmcValueException {
        DmsDefinition rc = null;
        DmsDefinition fromMeta = null;
        Iterator<DmcNamedObjectIF> it = ncos.getMatches();
        while (it.hasNext()) {
            try {
                DmsDefinition def = (DmsDefinition)it.next();
                if (def.getDMO().getDefinedIn() == null) continue;
                if (this.schemaLoading.getName().equals(def.getDMO().getDefinedIn().getObjectName().getNameString())) {
                    rc = def;
                    break;
                }
                if (!((SchemaDefinitionDMW)def.getDefinedIn()).getName().equals("meta")) continue;
                fromMeta = def;
            }
            catch (ClassCastException e) {
                throw new IllegalStateException("The DmsSchemaParser can only be used to resolve references to DmsDefinition objects!");
            }
        }
        if (rc == null) {
            if (fromMeta == null) {
                StringBuffer sb = new StringBuffer();
                sb.append("You must qualify the name of the object you're referring to: ");
                it = ncos.getMatches();
                while (it.hasNext()) {
                    DmsDefinition def = (DmsDefinition)it.next();
                    sb.append(def.getDMO().getDefinedIn().getObjectName() + "." + def.getName() + "  ");
                }
                DmcValueException ex = new DmcValueException(sb.toString());
                throw ex;
            }
            rc = fromMeta;
        }
        return rc;
    }
}

