/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.dmd.dms.ComplexTypeDefinition;
import org.dmd.dms.ExtendedReferenceTypeDefinition;
import org.dmd.dms.SchemaDefinition;
import org.dmd.dms.TypeDefinition;
import org.dmd.dms.generated.dmo.TypeDefinitionDMO;
import org.dmd.dms.generated.dmw.SchemaDefinitionDMW;
import org.dmd.dms.generated.types.Field;
import org.dmd.dms.util.GenUtility;
import org.dmd.util.FileUpdateManager;
import org.dmd.util.ManagedFileWriter;
import org.dmd.util.codegen.ImportManager;
import org.dmd.util.codegen.Manipulator;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.exceptions.ResultException;
import org.dmd.util.formatting.PrintfFormat;

public class ExtendedReferenceTypeFormatter {
    public static void dumpExtendedReferenceTypes(String fileHeader, SchemaDefinition sd, String typedir) throws IOException, ResultException {
        for (ExtendedReferenceTypeDefinition ctd : sd.getExtendedReferenceTypeDefList()) {
            ExtendedReferenceTypeFormatter.dumpExtendedReferenceType(fileHeader, typedir, ctd);
        }
    }

    static void dumpExtendedReferenceType(String header, String od, ExtendedReferenceTypeDefinition ertd) throws IOException, ResultException {
        TypeDefinition type;
        Object field;
        String ctn = ertd.getName().getNameString();
        String fieldSeparator = ertd.getFieldSeparator();
        Iterator<Field> fields = null;
        ImportManager imports = new ImportManager();
        if (fieldSeparator == null) {
            fieldSeparator = " ";
        }
        if (header == null) {
            header = "";
        }
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(od, ctn + ".java");
        fields = ertd.getField();
        boolean hasRefs = false;
        ArrayList<String> refFields = new ArrayList<String>();
        while (fields.hasNext()) {
            Field field2 = fields.next();
            TypeDefinitionDMO type2 = (TypeDefinitionDMO)field2.getType().getObject();
            if (type2 == null) {
                DebugInfo.debug("Unknown type in ExtendedReferenceTypeDefinition: " + field2.getType().getObjectName());
                System.exit(1);
            }
            if (!type2.getIsRefType().booleanValue()) continue;
            hasRefs = true;
            refFields.add(field2.getName());
        }
        out.write(header);
        out.write("package " + ((SchemaDefinitionDMW)ertd.getDefinedIn()).getSchemaPackage() + ".generated.types;\n\n");
        String nameBaseImport = ((SchemaDefinitionDMW)ertd.getExtendedReferenceClass().getIsNamedBy().getType().getDefinedIn()).getSchemaPackage() + ".generated.types.DmcType";
        String nameImport = ertd.getExtendedReferenceClass().getIsNamedBy().getType().getName().getNameString() + "SV";
        String staticNameType = ertd.getExtendedReferenceClass().getIsNamedBy().getType().getName().getNameString() + "STATIC";
        imports.addImport(nameBaseImport + nameImport, "Name type");
        imports.addImport(ertd.getExtendedReferenceClass().getIsNamedBy().getType().getPrimitiveType(), "Name type");
        imports.addImport(nameBaseImport + staticNameType, "Static type for name");
        imports.addImport(ertd.getExtendedReferenceClass().getDmoImport(), "Object based constructor");
        imports.addImport("org.dmd.dmc.DmcExtendedReferenceIF", "Marker interface for extended references");
        imports.addImport("java.io.Serializable", "Serialization support");
        imports.addImport("org.dmd.dmc.DmcInputStreamIF", "Serialization support");
        imports.addImport("org.dmd.dmc.DmcOutputStreamIF", "Serialization support");
        imports.addImport("org.dmd.dmc.types.IntegerVar", "Parsing support");
        if (hasRefs) {
            imports.addImport("org.dmd.dmc.DmcNameResolverIF", "Object reference support");
            imports.addImport("org.dmd.dmc.DmcNamedObjectIF", "Object reference support");
            imports.addImport("org.dmd.dmc.DmcNamedObjectREF", "Object reference support");
            imports.addImport("org.dmd.dmc.DmcContainerIF", "Object reference support");
        }
        imports.addImport("org.dmd.dmc.DmcValueException", "Value exceptions");
        ExtendedReferenceTypeFormatter.getComplexTypeImports(ertd, imports);
        out.write(imports.getFormattedImports() + "\n\n");
        out.write("@SuppressWarnings(\"serial\")\n");
        out.write("/**\n * The " + ctn + " class.\n");
        out.write(" * This code was auto-generated and shouldn't be alterred manually.\n");
        out.write(" * \n");
        out.write(" * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write(" */\n");
        out.write("public class " + ctn + " extends " + ertd.getExtendedReferenceClass().getName() + "REF implements Serializable, DmcExtendedReferenceIF {\n\n");
        out.write(ExtendedReferenceTypeFormatter.getComplexTypeFieldInstances(ertd));
        out.write("    /**\n");
        out.write("     * Default constructor.\n");
        out.write("     */\n");
        out.write("    public " + ctn + "(){\n");
        out.write("    }\n\n");
        out.write("    /**\n");
        out.write("     * Copy constructor.\n");
        out.write("     * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("     */\n");
        out.write("    public " + ctn + "(" + ctn + " original){\n");
        out.write("        myName = original.myName;\n");
        out.write("        object = original.object;\n");
        fields = ertd.getField();
        while (fields.hasNext()) {
            Field field3 = fields.next();
            out.write("        _" + field3.getName() + " = original._" + field3.getName() + ";\n");
        }
        out.write("    }\n\n");
        String nametype = ertd.getExtendedReferenceClass().getIsNamedBy().getType().getName().getNameString();
        String attrName = ertd.getExtendedReferenceClass().getIsNamedBy().getName().getNameString();
        out.write("    /**\n");
        out.write("     * All fields constructor.\n");
        out.write("     * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("     */\n");
        out.write("    public " + ctn + "(" + nametype + " name, ");
        int fnum = 1;
        fields = ertd.getField();
        while (fields.hasNext()) {
            field = fields.next();
            out.write(((Field)field).getType().getObjectName() + " " + ((Field)field).getName());
            if (++fnum > ertd.getFieldSize()) continue;
            out.write(", ");
        }
        out.write(") {\n");
        out.write("        setName(name);\n");
        fnum = 1;
        fields = ertd.getField();
        while (fields.hasNext()) {
            field = fields.next();
            type = (TypeDefinition)((TypeDefinitionDMO)((Field)field).getType().getObject()).getContainer();
            if (type.getIsRefType().booleanValue()) {
                out.write("        _" + ((Field)field).getName() + " = " + ((Field)field).getName() + ";\n");
            } else {
                out.write("        _" + ((Field)field).getName() + " = " + ((Field)field).getName() + ";\n");
            }
            ++fnum;
        }
        out.write("    }\n\n");
        out.write("    /**\n");
        out.write("     * All fields constructor.\n");
        out.write("     * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("     */\n");
        out.write("    public " + ctn + "(" + ertd.getExtendedReferenceClass().getName().getNameString() + "DMO obj, ");
        fnum = 1;
        fields = ertd.getField();
        while (fields.hasNext()) {
            field = fields.next();
            out.write(((Field)field).getType().getObjectName() + " " + ((Field)field).getName());
            if (++fnum > ertd.getFieldSize()) continue;
            out.write(", ");
        }
        out.write(") {\n");
        out.write("        super(obj);\n");
        fnum = 1;
        fields = ertd.getField();
        while (fields.hasNext()) {
            field = fields.next();
            type = (TypeDefinition)((TypeDefinitionDMO)((Field)field).getType().getObject()).getContainer();
            if (type.getIsRefType().booleanValue()) {
                out.write("        _" + ((Field)field).getName() + " = " + ((Field)field).getName() + ";\n");
            } else {
                out.write("        _" + ((Field)field).getName() + " = " + ((Field)field).getName() + ";\n");
            }
            ++fnum;
        }
        out.write("    }\n\n");
        out.write("    /**\n");
        out.write("     * String based constructor.\n");
        out.write("     * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("     */\n");
        out.write("    public " + ctn + "(String input) throws DmcValueException {\n");
        out.write("        IntegerVar seppos = new IntegerVar(-1);\n");
        out.write("        " + nametype + " n = DmcType" + nametype + "STATIC.instance.typeCheck(getNextField(input,seppos,\"object name\",false));\n");
        out.write("        myName = new DmcType" + nametype + "SV(__" + attrName + ");\n");
        out.write("        myName.set(n);\n\n");
        fnum = 1;
        fields = ertd.getField();
        while (fields.hasNext()) {
            field = fields.next();
            type = (TypeDefinition)((TypeDefinitionDMO)((Field)field).getType().getObject()).getContainer();
            String REF = "";
            if (type.getIsRefType().booleanValue()) {
                REF = "REF";
            }
            if (fnum == ertd.getFieldSize()) {
                out.write("        _" + ((Field)field).getName() + " = DmcType" + ((Field)field).getType().getObjectName() + REF + "STATIC.instance.typeCheck(getNextField(input,seppos,\"" + ((Field)field).getName() + "\",true));\n");
            } else {
                out.write("        _" + ((Field)field).getName() + " = DmcType" + ((Field)field).getType().getObjectName() + REF + "STATIC.instance.typeCheck(getNextField(input,seppos,\"" + ((Field)field).getName() + "\",false));\n");
            }
            ++fnum;
        }
        out.write("    }\n\n");
        out.write("    /**\n");
        out.write("     * Serialization.\n");
        out.write("     * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("     */\n");
        out.write("    public void serializeIt(DmcOutputStreamIF dos) throws Exception {\n");
        out.write("        DmcType" + nametype + "STATIC.instance.serializeValue(dos, myName.getSV());\n");
        fields = ertd.getField();
        while (fields.hasNext()) {
            field = fields.next();
            type = (TypeDefinition)((TypeDefinitionDMO)((Field)field).getType().getObject()).getContainer();
            if (type.getIsRefType().booleanValue()) {
                out.write("        DmcType" + ((Field)field).getType().getObjectName() + "REFSTATIC.instance.serializeValue(dos, _" + ((Field)field).getName() + ");\n");
                continue;
            }
            out.write("        DmcType" + ((Field)field).getType().getObjectName() + "STATIC.instance.serializeValue(dos, _" + ((Field)field).getName() + ");\n");
        }
        out.write("    }\n\n");
        out.write("    /**\n");
        out.write("     * Deserialization.\n");
        out.write("     * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("     */\n");
        out.write("    public void deserializeIt(DmcInputStreamIF dis) throws Exception {\n");
        out.write("        " + nametype + " n = DmcType" + nametype + "STATIC.instance.deserializeValue(dis);\n");
        out.write("        myName = new DmcType" + nametype + "SV(__" + attrName + ");\n");
        out.write("        myName.set(n);\n\n");
        fields = ertd.getField();
        while (fields.hasNext()) {
            field = fields.next();
            type = (TypeDefinition)((TypeDefinitionDMO)((Field)field).getType().getObject()).getContainer();
            if (type.getIsRefType().booleanValue()) {
                out.write("        _" + ((Field)field).getName() + " = DmcType" + ((Field)field).getType().getObjectName() + "REFSTATIC.instance.deserializeValue(dis);\n");
                continue;
            }
            out.write("        _" + ((Field)field).getName() + " = DmcType" + ((Field)field).getType().getObjectName() + "STATIC.instance.deserializeValue(dis);\n");
        }
        out.write("    }\n\n");
        out.write("    /**\n");
        out.write("     * String form.\n");
        out.write("     */\n");
        out.write("    public String toString(){\n");
        fnum = 1;
        out.write("        return(");
        out.write("myName.getSV().getNameString()");
        if (ertd.getFieldSize() > 0) {
            out.write(" + \"" + fieldSeparator + "\" + ");
        }
        fields = ertd.getField();
        while (fields.hasNext()) {
            field = fields.next();
            out.write("_" + ((Field)field).getName() + ".toString()");
            if (fnum < ertd.getFieldSize()) {
                out.write(" + \"" + fieldSeparator + "\" + ");
            }
            ++fnum;
        }
        out.write(");\n");
        out.write("    }\n\n");
        out.write("    public void setName(" + nametype + " name){\n");
        out.write("        try{\n");
        out.write("            super.setName(name);\n");
        out.write("            object = null;\n");
        out.write("        } catch (DmcValueException e) {\n");
        out.write("            throw new IllegalStateException(\"Setting name with a specific type shouldn't throw an exception.\",e);\n");
        out.write("        }\n\n");
        out.write("    }\n\n");
        out.write("    public void setObject(" + ertd.getExtendedReferenceClass().getName().getNameString() + "DMO obj){\n");
        out.write("        super.setObject(obj);\n");
        out.write("    }\n\n");
        fields = ertd.getField();
        while (fields.hasNext()) {
            field = fields.next();
            type = (TypeDefinition)((TypeDefinitionDMO)((Field)field).getType().getObject()).getContainer();
            if (type.getIsRefType().booleanValue()) {
                out.write("    public " + ((Field)field).getType().getObjectName() + "REF get" + Manipulator.capFirstChar(((Field)field).getName()) + "(){\n");
            } else {
                out.write("    public " + ((Field)field).getType().getObjectName() + " get" + Manipulator.capFirstChar(((Field)field).getName()) + "(){\n");
            }
            out.write("        return(_" + ((Field)field).getName() + ");\n");
            out.write("    }\n\n");
            if (type.getIsRefType().booleanValue()) {
                out.write("    public void set" + Manipulator.capFirstChar(((Field)field).getName()) + "(" + ((Field)field).getType().getObjectName() + " " + ((Field)field).getName() + "){\n");
            } else {
                out.write("    public void set" + Manipulator.capFirstChar(((Field)field).getName()) + "(" + ((Field)field).getType().getObjectName() + " " + ((Field)field).getName() + "){\n");
            }
            out.write("        _" + ((Field)field).getName() + " = " + ((Field)field).getName() + ";\n");
            out.write("    }\n\n");
        }
        if (hasRefs) {
            out.write("    @SuppressWarnings(\"unchecked\")\n");
            out.write("    public void resolve(DmcNameResolverIF resolver, String attrName) throws DmcValueException {\n");
            out.write("        DmcNamedObjectIF  obj = null;\n\n");
            for (String fn : refFields) {
                out.write("        obj = resolver.findNamedObject(" + fn + ".getObjectName());\n");
                out.write("        if (obj == null)\n");
                out.write("            throw(new DmcValueException(\"Could not resolve reference to: \" + " + fn + ".getObjectName() + \" via attribute: \" + attrName));\n");
                out.write("        \n");
                out.write("        if (obj instanceof DmcContainerIF)\n");
                out.write("            ((DmcNamedObjectREF)" + fn + ").setObject((DmcNamedObjectIF) ((DmcContainerIF)obj).getDmcObject());\n");
                out.write("        else\n");
                out.write("            ((DmcNamedObjectREF)" + fn + ").setObject(obj);\n");
                out.write("        \n");
            }
            out.write("    }\n\n");
        }
        out.write("    String getNextField(String input, IntegerVar seppos, String fn, boolean last) throws DmcValueException {\n");
        out.write("    \t   String rc = null;\n");
        out.write("    \t   int start = seppos.intValue();\n");
        out.write("\n");
        out.write("    \t   if ( (start+1) >= input.length())\n");
        out.write("    \t\t   throw (new DmcValueException(\"Missing value for field: \" + fn + \" in complex type: " + ctn + "\"));\n");
        out.write("\n");
        out.write("    \t   if (last){\n");
        out.write("    \t       rc = input.substring(start+1);\n");
        out.write("    \t   }\n");
        out.write("    \t   else{\n");
        out.write("    \t       int pos = -1;\n");
        out.write("    \t       if (start > 0)\n");
        out.write("    \t\t       pos = input.indexOf(\"" + fieldSeparator + "\", start+1);\n");
        out.write("    \t       else\n");
        out.write("    \t\t       pos = input.indexOf(\"" + fieldSeparator + "\");\n");
        out.write("\n");
        out.write("    \t       if (pos == -1)\n");
        out.write("    \t\t       throw (new DmcValueException(\"Missing value for field: \" + fn + \" in complex type: " + ctn + "\"));\n");
        out.write("\n");
        out.write("    \t\t   while(pos < (input.length()-1)){\n");
        out.write("    \t\t       if ( input.charAt(pos+1) == '" + fieldSeparator + "')\n");
        out.write("    \t\t           pos++;\n");
        out.write("    \t\t       else\n");
        out.write("    \t\t           break;\n");
        out.write("    \t\t   }\n");
        out.write("\n");
        out.write("    \t       rc = input.substring(start+1, pos).trim();\n");
        out.write("\n");
        out.write("    \t       seppos.set(pos);\n");
        out.write("        }\n");
        out.write("\n");
        out.write("        return(rc);\n");
        out.write("    }\n\n");
        out.write("    @Override\n");
        out.write("    public boolean equals(Object obj){\n");
        out.write("        boolean rc = false;\n");
        out.write("\n");
        out.write("        if (obj instanceof " + ctn + "){\n");
        out.write("            " + ctn + " other = (" + ctn + ")obj;\n");
        out.write("            rc = myName.equals(other.myName);\n");
        out.write("\n");
        fields = ertd.getField();
        while (fields.hasNext()) {
            field = fields.next();
            out.write("            if(rc)\n");
            out.write("                rc = _" + ((Field)field).getName() + ".equals(other._" + ((Field)field).getName() + ");\n");
        }
        out.write("        }\n");
        out.write("\n");
        out.write("        return(rc);\n");
        out.write("    }\n\n");
        out.write("}\n");
        ((BufferedWriter)out).close();
        GenUtility.dumpExtendedReferenceTypeDmcType(header, ((SchemaDefinitionDMW)ertd.getDefinedIn()).getSchemaPackage(), od, ctn, hasRefs, ertd);
    }

    static String getComplexTypeFieldInstances(ComplexTypeDefinition ctd) {
        StringBuffer sb = new StringBuffer();
        Iterator<Field> fields = ctd.getField();
        while (fields.hasNext()) {
            Field field = fields.next();
            TypeDefinition type = (TypeDefinition)((TypeDefinitionDMO)field.getType().getObject()).getContainer();
            sb.append("    // " + field.getDescription() + "\n");
            if (type.getIsRefType().booleanValue()) {
                sb.append("    " + field.getType().getObjectName() + "REF _" + field.getName() + ";\n\n");
                continue;
            }
            sb.append("    " + field.getType().getObjectName() + " _" + field.getName() + ";\n\n");
        }
        return sb.toString();
    }

    static String getComplexTypeImports(ComplexTypeDefinition ctd) throws ResultException {
        String comment;
        StringBuffer sb = new StringBuffer();
        Iterator<Field> fields = ctd.getField();
        TreeMap<String, String> uniqueImports = new TreeMap<String, String>();
        while (fields.hasNext()) {
            Field field = fields.next();
            TypeDefinition type = (TypeDefinition)((TypeDefinitionDMO)field.getType().getObject()).getContainer();
            String primitiveType = type.getPrimitiveType();
            if (type.getInternallyGenerated().booleanValue() && !type.getIsEnumType().booleanValue()) {
                uniqueImports.put(type.getOriginalClass().getJavaClass(), "Object reference");
                uniqueImports.put(type.getOriginalClass().getDmtREFImport(), "Object reference");
            }
            if (primitiveType != null && !type.getIsRefType().booleanValue()) {
                uniqueImports.put(primitiveType, "Primitive type");
            }
            if (type.getTypeClassName() == null) continue;
            String sp = ((SchemaDefinitionDMW)type.getDefinedIn()).getSchemaPackage();
            String imp = null;
            comment = "";
            if (type.getInternallyGenerated().booleanValue()) {
                imp = type.getTypeClassName() + "STATIC";
                comment = "Internally generated type";
            } else {
                imp = sp + ".generated.types.DmcType" + type.getName() + "STATIC";
                comment = "Standard type";
            }
            uniqueImports.put(imp, comment);
        }
        int longest = 0;
        for (String importStr : uniqueImports.keySet()) {
            if (importStr.length() <= longest) continue;
            longest = importStr.length();
        }
        int padding = longest + 17;
        PrintfFormat format = new PrintfFormat("%-" + padding + "s");
        for (String importStr : uniqueImports.keySet()) {
            comment = (String)uniqueImports.get(importStr);
            sb.append(format.sprintf("import " + importStr + ";") + "// " + comment + "\n");
        }
        sb.append("\n");
        return sb.toString();
    }

    static void getComplexTypeImports(ComplexTypeDefinition ctd, ImportManager imports) throws ResultException {
        Iterator<Field> fields = ctd.getField();
        while (fields.hasNext()) {
            Field field = fields.next();
            TypeDefinition type = (TypeDefinition)((TypeDefinitionDMO)field.getType().getObject()).getContainer();
            String primitiveType = type.getPrimitiveType();
            if (type.getInternallyGenerated().booleanValue() && !type.getIsEnumType().booleanValue()) {
                imports.addImport(type.getOriginalClass().getJavaClass(), "References to " + type.getOriginalClass().getName());
                imports.addImport(type.getOriginalClass().getDmtREFImport(), "References to " + type.getOriginalClass().getName());
            }
            if (primitiveType != null && !type.getIsRefType().booleanValue()) {
                imports.addImport(primitiveType, "Primitive type");
            }
            if (type.getTypeClassName() == null) continue;
            String sp = ((SchemaDefinitionDMW)type.getDefinedIn()).getSchemaPackage();
            String imp = null;
            String comment = "";
            if (type.getInternallyGenerated().booleanValue()) {
                imp = type.getTypeClassName() + "STATIC";
                comment = "Internally generated type";
            } else {
                imp = sp + ".generated.types.DmcType" + type.getName() + "STATIC";
                comment = "Standard type";
            }
            imports.addImport(imp, comment);
        }
    }
}

