/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DefinitionName;
import org.dmd.dmc.types.IntegerVar;
import org.dmd.dms.ActionDefinition;
import org.dmd.dms.AttributeDefinition;
import org.dmd.dms.ClassDefinition;
import org.dmd.dms.DSDefinition;
import org.dmd.dms.DmsDefinition;
import org.dmd.dms.ExtendedReferenceTypeDefinition;
import org.dmd.dms.MetaSchema;
import org.dmd.dms.SchemaDefinition;
import org.dmd.dms.TypeDefinition;
import org.dmd.dms.generated.dmw.AttributeDefinitionDMW;
import org.dmd.dms.generated.dmw.SchemaDefinitionDMW;
import org.dmd.dms.generated.enums.ClassTypeEnum;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.util.AdapterFormatter;
import org.dmd.dms.util.TypeAndAttr;
import org.dmd.util.BooleanVar;
import org.dmd.util.FileUpdateManager;
import org.dmd.util.ManagedFileWriter;
import org.dmd.util.codegen.ImportManager;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.exceptions.ResultException;
import org.dmd.util.formatting.PrintfFormat;

public class GenUtility {
    public static StringBuffer attributeInfo;

    public static String getImports(ActionDefinition ad, ArrayList<AttributeDefinition> allAttr, BooleanVar anySVAttributes, BooleanVar anyMVAttributes) throws ResultException {
        attributeInfo = new StringBuffer();
        return GenUtility.getImports((ClassDefinition)null, ad, (Iterator<AttributeDefinition>)ad.getMayParm(), (Iterator<AttributeDefinition>)ad.getMustParm(), allAttr, anySVAttributes, anyMVAttributes);
    }

    public static String getImports(ClassDefinition cd, Iterator<AttributeDefinition> may, Iterator<AttributeDefinition> must, ArrayList<AttributeDefinition> allAttr, BooleanVar anySVAttributes, BooleanVar anyMVAttributes) throws ResultException {
        return GenUtility.getImports(cd, null, may, must, allAttr, anySVAttributes, anyMVAttributes);
    }

    static String getImports(ClassDefinition cd, ActionDefinition act, Iterator<AttributeDefinition> may, Iterator<AttributeDefinition> must, ArrayList<AttributeDefinition> allAttr, BooleanVar anySVAttributes, BooleanVar anyMVAttributes) throws ResultException {
        TypeAndAttr ta;
        TypeDefinition td;
        Iterator ad;
        boolean anyAttributes = false;
        boolean anyAttributesAtThisLevel = false;
        IntegerVar longestImport = new IntegerVar();
        TreeMap<DefinitionName, TypeDefinition> types = new TreeMap<DefinitionName, TypeDefinition>();
        TreeMap<String, TypeAndAttr> typeAndAttr = new TreeMap<String, TypeAndAttr>();
        TreeSet<String> genericImports = new TreeSet<String>();
        anyMVAttributes.set(false);
        anySVAttributes.set(false);
        if (cd != null && cd.getName().getNameString().startsWith("WifiStatsInfo")) {
            DebugInfo.debug("HERE");
        }
        TreeMap<String, String> uniqueImports = new TreeMap<String, String>();
        if (may != null) {
            while (may.hasNext()) {
                ad = may.next();
                anyAttributes = true;
                td = ((AttributeDefinitionDMW)((Object)ad)).getType();
                types.put(td.getName(), td);
                ta = new TypeAndAttr(td, ((AttributeDefinitionDMW)((Object)ad)).getValueType(), ((AttributeDefinitionDMW)((Object)ad)).getIndexSize());
                typeAndAttr.put(ta.name, ta);
                switch (((AttributeDefinitionDMW)((Object)ad)).getValueType()) {
                    case SINGLE: {
                        anySVAttributes.set(true);
                        break;
                    }
                    case MULTI: {
                        if (((AttributeDefinitionDMW)((Object)ad)).getIndexSize() == null) {
                            anyMVAttributes.set(true);
                            break;
                        }
                        if (td.getIsRefType().booleanValue()) break;
                        anyMVAttributes.set(true);
                        break;
                    }
                    case HASHMAPPED: 
                    case TREEMAPPED: 
                    case HASHSET: 
                    case TREESET: {
                        anyMVAttributes.set(true);
                    }
                }
                if (((AttributeDefinitionDMW)((Object)ad)).getGenericArgsImport() != null) {
                    genericImports.add(((AttributeDefinitionDMW)((Object)ad)).getGenericArgsImport());
                }
                if (attributeInfo != null) {
                    GenUtility.appendAttributeInfo(attributeInfo, ((AttributeDefinitionDMW)((Object)ad)).getName().getNameString(), (int)((AttributeDefinitionDMW)((Object)ad)).getDmdID(), ((AttributeDefinitionDMW)((Object)ad)).getType().getName().getNameString(), ((AttributeDefinitionDMW)((Object)ad)).getValueType(), "true");
                }
                if (cd != null && cd.getClassType() == ClassTypeEnum.AUXILIARY) {
                    GenUtility.addImport(uniqueImports, longestImport, ((SchemaDefinition)((DSDefinition)((Object)ad)).getDefinedIn()).getDMSASGImport(), "Attribute from " + ((SchemaDefinitionDMW)((DSDefinition)((Object)ad)).getDefinedIn()).getName() + " schema");
                }
                if (cd != null && ((DSDefinition)((Object)ad)).getDefinedIn() != cd.getDefinedIn()) {
                    GenUtility.addImport(uniqueImports, longestImport, ((SchemaDefinition)((DSDefinition)((Object)ad)).getDefinedIn()).getDMSASGImport(), "Attribute from " + ((SchemaDefinitionDMW)((DSDefinition)((Object)ad)).getDefinedIn()).getName() + " schema");
                }
                if (act != null && ((DSDefinition)((Object)ad)).getDefinedIn() != act.getDefinedIn()) {
                    GenUtility.addImport(uniqueImports, longestImport, ((SchemaDefinition)((DSDefinition)((Object)ad)).getDefinedIn()).getDMSASGImport(), "Attribute from " + ((SchemaDefinitionDMW)((DSDefinition)((Object)ad)).getDefinedIn()).getName() + " schema");
                }
                allAttr.add((AttributeDefinition)((Object)ad));
            }
        }
        if (must != null) {
            while (must.hasNext()) {
                ad = must.next();
                anyAttributes = true;
                td = ((AttributeDefinitionDMW)((Object)ad)).getType();
                types.put(td.getName(), td);
                if (td.getIsRefType().booleanValue()) {
                    GenUtility.addImport(uniqueImports, longestImport, "org.dmd.dmc.DmcOmni", "Lazy resolution");
                }
                ta = new TypeAndAttr(td, ((AttributeDefinitionDMW)((Object)ad)).getValueType(), ((AttributeDefinitionDMW)((Object)ad)).getIndexSize());
                typeAndAttr.put(ta.name, ta);
                switch (((AttributeDefinitionDMW)((Object)ad)).getValueType()) {
                    case SINGLE: {
                        anySVAttributes.set(true);
                        break;
                    }
                    case MULTI: {
                        if (((AttributeDefinitionDMW)((Object)ad)).getIndexSize() == null) {
                            anyMVAttributes.set(true);
                            break;
                        }
                        if (td.getIsRefType().booleanValue()) break;
                        anyMVAttributes.set(true);
                        break;
                    }
                    case HASHMAPPED: 
                    case TREEMAPPED: 
                    case HASHSET: 
                    case TREESET: {
                        anyMVAttributes.set(true);
                    }
                }
                if (((AttributeDefinitionDMW)((Object)ad)).getGenericArgsImport() != null) {
                    genericImports.add(((AttributeDefinitionDMW)((Object)ad)).getGenericArgsImport());
                }
                if (attributeInfo != null) {
                    GenUtility.appendAttributeInfo(attributeInfo, ((AttributeDefinitionDMW)((Object)ad)).getName().getNameString(), (int)((AttributeDefinitionDMW)((Object)ad)).getDmdID(), ((AttributeDefinitionDMW)((Object)ad)).getType().getName().getNameString(), ((AttributeDefinitionDMW)((Object)ad)).getValueType(), "true");
                }
                if (cd != null && cd.getClassType() == ClassTypeEnum.AUXILIARY) {
                    GenUtility.addImport(uniqueImports, longestImport, ((SchemaDefinition)((DSDefinition)((Object)ad)).getDefinedIn()).getDMSASGImport(), "Attribute from " + ((SchemaDefinitionDMW)((DSDefinition)((Object)ad)).getDefinedIn()).getName() + " schema");
                }
                if (cd != null && ((DSDefinition)((Object)ad)).getDefinedIn() != cd.getDefinedIn()) {
                    GenUtility.addImport(uniqueImports, longestImport, ((SchemaDefinition)((DSDefinition)((Object)ad)).getDefinedIn()).getDMSASGImport(), "Attribute from " + ((SchemaDefinitionDMW)((DSDefinition)((Object)ad)).getDefinedIn()).getName() + " schema");
                }
                if (act != null && ((DSDefinition)((Object)ad)).getDefinedIn() != act.getDefinedIn()) {
                    GenUtility.addImport(uniqueImports, longestImport, ((SchemaDefinition)((DSDefinition)((Object)ad)).getDefinedIn()).getDMSASGImport(), "Attribute from " + ((SchemaDefinitionDMW)((DSDefinition)((Object)ad)).getDefinedIn()).getName() + " schema");
                }
                allAttr.add((AttributeDefinition)((Object)ad));
            }
        }
        anyAttributesAtThisLevel = anyAttributes;
        if (cd != null && cd.getFullAttrMap().size() > 0) {
            anyAttributes = true;
        }
        if (anyMVAttributes.booleanValue()) {
            GenUtility.addImport(uniqueImports, longestImport, "java.util.*", "Always required if we have any MV attributes");
        }
        if (cd != null && cd.getClassType() != ClassTypeEnum.AUXILIARY) {
            GenUtility.addImport(uniqueImports, longestImport, "java.io.Serializable", "Always required");
        }
        if (cd != null && cd.getClassType() != ClassTypeEnum.ABSTRACT && cd.getClassType() != ClassTypeEnum.AUXILIARY) {
            GenUtility.addImport(uniqueImports, longestImport, "org.dmd.dms.generated.types.DmcTypeModifierMV", "Required for MODREC constructor");
            GenUtility.addImport(uniqueImports, longestImport, "org.dmd.dms.generated.dmo.MetaDMSAG", "Required for MODREC constructor");
            GenUtility.addImport(uniqueImports, longestImport, "org.dmd.dmc.DmcSliceInfo", "Required for object slicing");
        }
        if (cd != null && cd.getClassType() == ClassTypeEnum.AUXILIARY) {
            GenUtility.addImport(uniqueImports, longestImport, "org.dmd.dmc.DmcAttributeInfo", "To support common aux functions");
            GenUtility.addImport(uniqueImports, longestImport, "org.dmd.dmc.DmcObject", "To support aux addition/removal");
        }
        if (anyAttributesAtThisLevel) {
            GenUtility.addImport(uniqueImports, longestImport, "org.dmd.dmc.DmcAttribute", "Any attributes");
            GenUtility.addImport(uniqueImports, longestImport, "org.dmd.dmc.DmcValueException", "Any attributes");
        }
        for (String s : genericImports) {
            GenUtility.addImport(uniqueImports, longestImport, s, "Generic args import");
        }
        for (TypeAndAttr ta2 : typeAndAttr.values()) {
            TypeDefinition td2 = ta2.td;
            if (td2.getPrimitiveType() != null && cd != null) {
                if (td2.getInternallyGenerated().booleanValue() && td2.getIsRefType().booleanValue()) {
                    if (cd.getDefinedIn() != td2.getDefinedIn()) {
                        // empty if block
                    }
                } else {
                    GenUtility.addImport(uniqueImports, longestImport, td2.getPrimitiveType(), "Primitive type");
                }
            }
            if (td2.getPrimitiveType() != null && act != null) {
                if (td2.getInternallyGenerated().booleanValue() && td2.getIsRefType().booleanValue()) {
                    if (act.getDefinedIn() != td2.getDefinedIn()) {
                        // empty if block
                    }
                } else {
                    GenUtility.addImport(uniqueImports, longestImport, td2.getPrimitiveType(), "Primitive type and !auxiliary class");
                }
            }
            if (td2.getAltType() != null && td2.getAltTypeImport() != null) {
                GenUtility.addImport(uniqueImports, longestImport, td2.getAltTypeImport(), "Alternative type for " + td2.getName() + " values");
            }
            if (td2.getIsRefType().booleanValue() && !td2.getIsExtendedRefType().booleanValue()) {
                GenUtility.addImport(uniqueImports, longestImport, ta2.getImport(), "Reference type");
                if (ta2.valueType == ValueTypeEnum.TREEMAPPED && td2.getOriginalClass().getIsNamedBy() != null) {
                    GenUtility.addImport(uniqueImports, longestImport, td2.getOriginalClass().getIsNamedBy().getType().getPrimitiveType(), "Name attribute type");
                }
                GenUtility.addImport(uniqueImports, longestImport, td2.getOriginalClass().getDmoImport(), "Type specific set/add");
                if (td2.getOriginalClass().getInternalTypeRef().getHelperClassName() != null) {
                    GenUtility.addImport(uniqueImports, longestImport, td2.getOriginalClass().getInternalTypeRef().getHelperClassName(), "Reference type helper class");
                    if (cd != null && cd.getClassType() != ClassTypeEnum.AUXILIARY) {
                        GenUtility.addImport(uniqueImports, longestImport, "org.dmd.dmc.DmcOmni", "Lazy resolution");
                    }
                }
            } else {
                if (td2.getIsExtendedRefType().booleanValue()) {
                    GenUtility.addImport(uniqueImports, longestImport, td2.getPrimitiveType(), "Extended reference type");
                }
                GenUtility.addImport(uniqueImports, longestImport, ta2.getImport(), "Required type");
            }
            if (td2.getIsExtendedRefType().booleanValue()) {
                GenUtility.addImport(uniqueImports, longestImport, "org.dmd.dmc.DmcOmni", "Lazy resolution");
            }
            if (td2.getHelperClassName() != null) {
                GenUtility.addImport(uniqueImports, longestImport, td2.getHelperClassName(), "Helper class");
            }
            if (td2.getKeyImport() == null) continue;
            GenUtility.addImport(uniqueImports, longestImport, td2.getKeyImport(), "Key class");
        }
        if (cd != null) {
            if (cd.getDerivedFrom() == null) {
                if (cd.getClassType() == ClassTypeEnum.AUXILIARY) {
                    GenUtility.addImport(uniqueImports, longestImport, "org.dmd.dmc.DmcObject", "Auxiliary class");
                    GenUtility.addImport(uniqueImports, longestImport, "org.dmd.dmc.DmcAttributeInfo", "Auxiliary class");
                } else {
                    GenUtility.addImport(uniqueImports, longestImport, "org.dmd.dmc.DmcObject", "Structural class");
                }
            } else if (cd != null && cd.getClassType() != ClassTypeEnum.AUXILIARY) {
                GenUtility.addImport(uniqueImports, longestImport, cd.getDerivedFrom().getDmoImport(), "Base class");
            }
            if (cd.getIsNamedBy() != null) {
                AttributeDefinition isNamedBy = cd.getIsNamedBy();
                String nameAttributeType = isNamedBy.getType().getPrimitiveType();
                if (nameAttributeType == null) {
                    ResultException ex = new ResultException("Naming attribute for class " + cd.getName() + " must be a complex type.");
                    ex.result.lastResult().moreMessages("Check the type of attribute " + isNamedBy.getName().getNameString());
                    ex.result.lastResult().fileName(isNamedBy.getFile());
                    ex.result.lastResult().lineNumber(isNamedBy.getLineNumber());
                    throw ex;
                }
                GenUtility.addImport(uniqueImports, longestImport, nameAttributeType, "Naming attribute type");
                if (isNamedBy.getType().getIsHierarchicName().booleanValue()) {
                    GenUtility.addImport(uniqueImports, longestImport, "org.dmd.dmc.DmcHierarchicNamedObjectIF", "Named object");
                }
                GenUtility.addImport(uniqueImports, longestImport, "org.dmd.dmc.DmcNamedObjectIF", "Named object");
                GenUtility.addImport(uniqueImports, longestImport, "org.dmd.dmc.DmcAttribute", "Named object");
            }
        }
        return GenUtility.formatImports(uniqueImports, longestImport.intValue());
    }

    public static void addImport(TreeMap<String, String> map, IntegerVar longest, String i, String c) {
        if (i.length() > longest.intValue()) {
            longest.set(i.length());
        }
        map.put(i, c + " - " + DebugInfo.getShortWhereWeWereCalledFrom());
    }

    public static String formatImports(TreeMap<String, String> map, int longest) {
        int padding = longest + 17;
        StringBuffer sb = new StringBuffer();
        PrintfFormat format = new PrintfFormat("%-" + padding + "s");
        sb.append("// Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        for (String key : map.keySet()) {
            sb.append(format.sprintf("import " + key + ";") + "// " + map.get(key) + "\n");
        }
        sb.append("\n");
        return sb.toString();
    }

    public static String dotNameToCamelCase(String in) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(in, ".");
        while (tokenizer.hasMoreTokens()) {
            StringBuffer t = new StringBuffer(tokenizer.nextToken());
            t.setCharAt(0, Character.toUpperCase(t.charAt(0)));
            sb.append(t.toString());
        }
        return sb.toString();
    }

    public static void appendAttributeInfo(StringBuffer out, String n, int ID, String t, ValueTypeEnum vte, String opt) {
        out.append("    public final static DmcAttributeInfo __" + n + " = new DmcAttributeInfo(");
        out.append("\"" + n + "\",");
        out.append(ID + ",");
        out.append("\"" + t + "\",");
        out.append("ValueTypeEnum." + vte.toString() + ",");
        out.append(opt + ");\n");
    }

    public static void appendAttributeInfo(BufferedWriter out, String n, int ID, String t, ValueTypeEnum vte, String opt) throws IOException {
        out.write("    public final static DmcAttributeInfo __" + n + " = new DmcAttributeInfo(");
        out.write("\"" + n + "\",");
        out.write(ID + ",");
        out.write("\"" + t + "\",");
        out.write("ValueTypeEnum." + vte.toString() + ",");
        out.write(opt + ");\n");
    }

    public static void appendAttributeInfo(BufferedWriter out, AttributeDefinition ad) throws IOException {
        out.write("    public final static DmcAttributeInfo __" + ad.getName().getNameString() + " = new DmcAttributeInfo(");
        out.write("\"" + ad.getName().getNameString() + "\",");
        out.write(ad.getDmdID() + ",");
        out.write("\"" + ad.getType().getName().getNameString() + "\",");
        out.write("ValueTypeEnum." + (Object)((Object)ad.getValueType()) + ",");
        out.write("DataTypeEnum." + (Object)((Object)ad.getDataType()) + ");\n");
    }

    static void getImports(StringBuffer sb, DmsDefinition def, Iterator<AttributeDefinition> must, Iterator<AttributeDefinition> may, ArrayList<AttributeDefinition> allAttr, BooleanVar anySVAttributes, BooleanVar anyMVAttributes) {
        TypeDefinition td2;
        Object ad;
        ClassDefinition cd = null;
        boolean needJavaUtil = false;
        boolean anyAttributes = false;
        TreeMap<DefinitionName, TypeDefinition> types = new TreeMap<DefinitionName, TypeDefinition>();
        TreeSet<String> genericImports = new TreeSet<String>();
        anyMVAttributes.set(false);
        anySVAttributes.set(false);
        attributeInfo = new StringBuffer();
        allAttr = new ArrayList();
        if (def instanceof ClassDefinition) {
            cd = (ClassDefinition)def;
        }
        if (may != null) {
            anyAttributes = true;
            while (may.hasNext()) {
                ad = may.next();
                td2 = ((AttributeDefinitionDMW)ad).getType();
                types.put(td2.getName(), td2);
                switch (((AttributeDefinitionDMW)ad).getValueType()) {
                    case SINGLE: {
                        anySVAttributes.set(true);
                        break;
                    }
                    case MULTI: 
                    case HASHMAPPED: 
                    case TREEMAPPED: 
                    case HASHSET: 
                    case TREESET: {
                        anyMVAttributes.set(true);
                        needJavaUtil = true;
                    }
                }
                GenUtility.appendAttributeInfo(attributeInfo, ((AttributeDefinitionDMW)ad).getName().getNameString(), (int)((AttributeDefinitionDMW)ad).getDmdID(), ((AttributeDefinitionDMW)ad).getType().getName().getNameString(), ((AttributeDefinitionDMW)ad).getValueType(), "true");
                if (((AttributeDefinitionDMW)ad).getGenericArgsImport() != null) {
                    genericImports.add(((AttributeDefinitionDMW)ad).getGenericArgsImport());
                }
                allAttr.add((AttributeDefinition)ad);
            }
        }
        if (must != null) {
            anyAttributes = true;
            while (must.hasNext()) {
                ad = must.next();
                td2 = ((AttributeDefinitionDMW)ad).getType();
                types.put(td2.getName(), td2);
                switch (((AttributeDefinitionDMW)ad).getValueType()) {
                    case SINGLE: {
                        anySVAttributes.set(true);
                        break;
                    }
                    case MULTI: 
                    case HASHMAPPED: 
                    case TREEMAPPED: 
                    case HASHSET: 
                    case TREESET: {
                        anyMVAttributes.set(true);
                        needJavaUtil = true;
                    }
                }
                GenUtility.appendAttributeInfo(attributeInfo, ((AttributeDefinitionDMW)ad).getName().getNameString(), (int)((AttributeDefinitionDMW)ad).getDmdID(), ((AttributeDefinitionDMW)ad).getType().getName().getNameString(), ((AttributeDefinitionDMW)ad).getValueType(), "false");
                if (((AttributeDefinitionDMW)ad).getGenericArgsImport() != null) {
                    genericImports.add(((AttributeDefinitionDMW)ad).getGenericArgsImport());
                }
                allAttr.add((AttributeDefinition)ad);
            }
        }
        if (needJavaUtil) {
            sb.append("import java.util.*;\n\n");
        }
        if (anyAttributes) {
            sb.append("import org.dmd.dmc.DmcAttribute;\n");
            sb.append("import org.dmd.dmc.DmcValueException;\n");
            sb.append("import org.dmd.dmc.DmcAttributeInfo;\n");
            sb.append("import org.dmd.dms.generated.enums.ValueTypeEnum;\n");
        }
        for (String s : genericImports) {
            sb.append("import " + s + ";\n");
        }
        if (cd != null && cd.getClassType() == ClassTypeEnum.AUXILIARY) {
            try {
                types.put(new DefinitionName("String"), MetaSchema._String);
            }
            catch (DmcValueException e) {
                e.printStackTrace();
            }
        }
        for (TypeDefinition td2 : types.values()) {
            if (cd != null && td2.getPrimitiveType() != null && cd.getClassType() != ClassTypeEnum.AUXILIARY) {
                if (td2.getInternallyGenerated().booleanValue() && td2.getIsRefType().booleanValue()) {
                    if (cd.getDefinedIn() != td2.getDefinedIn()) {
                        sb.append("// import 1\n");
                        sb.append("import " + td2.getPrimitiveType() + ";\n");
                    }
                } else {
                    sb.append("// import 2\n");
                    sb.append("import " + td2.getPrimitiveType() + ";\n");
                }
            }
            sb.append("// import 3 " + td2.getName() + "\n");
            if (td2.getIsRefType().booleanValue()) {
                sb.append("import " + td2.getOriginalClass().getDmtImport() + ";\n");
            } else {
                sb.append("import " + td2.getTypeClassName() + ";\n");
            }
            if (td2.getHelperClassName() == null) continue;
            sb.append("// import 4\n");
            sb.append("import " + td2.getHelperClassName() + ";\n");
        }
    }

    public static void formatSV(AttributeDefinition ad, StringBuffer sb) {
        int lastPeriod;
        String typeClassName = ad.getType().getTypeClassName();
        String attrType = "DmcType" + ad.getType().getName();
        String nullReturnValue = ad.getNullReturnValue();
        String typeName = ad.getType().getName().getNameString();
        String genericArgs = ad.getGenericArgs();
        if (genericArgs == null) {
            genericArgs = "<?>";
        }
        if (nullReturnValue == null) {
            nullReturnValue = ad.getType().getNullReturnValue();
        }
        if (ad.getType().getIsRefType().booleanValue()) {
            attrType = attrType + "REF";
        }
        if (typeClassName != null && (lastPeriod = typeClassName.lastIndexOf(46)) != -1) {
            attrType = typeClassName.substring(lastPeriod + 1);
        }
        attrType = attrType + "SV";
        StringBuffer functionName = new StringBuffer();
        functionName.append(ad.getName());
        functionName.setCharAt(0, Character.toUpperCase(functionName.charAt(0)));
        if (ad.getType().getIsRefType().booleanValue() && !ad.getType().getIsExtendedRefType().booleanValue()) {
            if (ad.getType().getOriginalClass().getIsNamedBy() == null) {
                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    /**\n");
                sb.append("     * @return the " + typeName + "DMO\n");
                sb.append("     */\n");
                sb.append("    public " + typeName + "DMO get" + functionName + "(){\n");
                sb.append("        " + attrType + " attr = (" + attrType + ") get(" + ad.getDMSAGReference() + ");\n");
                sb.append("        if (attr == null)\n");
                if (nullReturnValue == null) {
                    sb.append("            return(null);\n");
                } else {
                    sb.append("            return(" + nullReturnValue + ");\n");
                }
                sb.append("\n");
                sb.append("        return(attr.getSV());\n");
                sb.append("    }\n\n");
            } else {
                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    /**\n");
                sb.append("     * @return the " + typeName + "REF\n");
                sb.append("     */\n");
                sb.append("    public " + typeName + "REF get" + functionName + "(){\n");
                sb.append("        " + attrType + " attr = (" + attrType + ") get(" + ad.getDMSAGReference() + ");\n");
                sb.append("        if (attr == null)\n");
                if (nullReturnValue == null) {
                    sb.append("            return(null);\n");
                } else {
                    sb.append("            return(" + nullReturnValue + ");\n");
                }
                sb.append("\n");
                sb.append("        if (DmcOmni.instance().lazyResolution()){\n");
                sb.append("            if (attr.doLazyResolution(this)){\n");
                sb.append("                rem(attr.getAttributeInfo());\n");
                sb.append("                return(null);\n");
                sb.append("            }\n");
                sb.append("        }\n");
                sb.append("\n");
                sb.append("        return(attr.getSV());\n");
                sb.append("    }\n\n");
                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    /**\n");
                sb.append("     * @return the reference to " + typeName + " without attempting lazy resolution (if turned on).\n");
                sb.append("     */\n");
                sb.append("    public " + typeName + "REF get" + functionName + "REF(){\n");
                sb.append("        " + attrType + " attr = (" + attrType + ") get(" + ad.getDMSAGReference() + ");\n");
                sb.append("        if (attr == null)\n");
                if (nullReturnValue == null) {
                    sb.append("            return(null);\n");
                } else {
                    sb.append("            return(" + nullReturnValue + ");\n");
                }
                sb.append("\n");
                sb.append("        return(attr.getSV());\n");
                sb.append("    }\n\n");
            }
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    /**\n");
            sb.append("     * Sets " + ad.getName() + " to the specified value.\n");
            sb.append("     * @param value " + typeName + "DMO\n");
            sb.append("     */\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    public void set" + functionName + "(" + typeName + "DMO value) {\n");
            sb.append("        DmcAttribute<?> attr = get(" + ad.getDMSAGReference() + ");\n");
            sb.append("        if (attr == null)\n");
            sb.append("            attr = new " + attrType + "(" + ad.getDMSAGReference() + ");\n");
            if (ad.getType().getIsRefType().booleanValue() && ad.getType().getOriginalClass().getIsNamedBy() != null) {
                sb.append("        else\n");
                sb.append("            ((" + attrType + ")attr).removeBackReferences();\n");
            }
            sb.append("        \n");
            sb.append("        try{\n");
            sb.append("            attr.set(value);\n");
            sb.append("            set(" + ad.getDMSAGReference() + ",attr);\n");
            sb.append("        }\n");
            sb.append("        catch(DmcValueException ex){\n");
            sb.append("            throw(new IllegalStateException(\"The type specific set() method shouldn't throw exceptions!\",ex));\n");
            sb.append("        }\n");
            sb.append("    }\n\n");
        } else {
            if (ad.getType().getIsExtendedRefType().booleanValue()) {
                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    /**\n");
                sb.append("     * @return The " + typeName + ", attempting lazy resolution (if it's turned on).\n");
                sb.append("     */\n");
                sb.append("    public " + typeName + " get" + functionName + "(){\n");
                sb.append("        " + attrType + " attr = (" + attrType + ") get(" + ad.getDMSAGReference() + ");\n");
                sb.append("        if (attr == null)\n");
                if (nullReturnValue == null) {
                    sb.append("            return(null);\n");
                } else {
                    sb.append("            return(" + nullReturnValue + ");\n");
                }
                sb.append("\n");
                sb.append("        if (DmcOmni.instance().lazyResolution()){\n");
                sb.append("            if (attr.doLazyResolution(this)){\n");
                sb.append("                rem(attr.getAttributeInfo());\n");
                sb.append("                return(null);\n");
                sb.append("            }\n");
                sb.append("        }\n");
                sb.append("\n");
                sb.append("        return(attr.getSV());\n");
                sb.append("    }\n\n");
                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    /**\n");
                sb.append("     * @return The " + typeName + " without attempting lazy resolution (if it's turned on).\n");
                sb.append("     */\n");
                sb.append("    public " + typeName + " get" + functionName + "REF(){\n");
                sb.append("        " + attrType + " attr = (" + attrType + ") get(" + ad.getDMSAGReference() + ");\n");
                sb.append("        if (attr == null)\n");
                if (nullReturnValue == null) {
                    sb.append("            return(null);\n");
                } else {
                    sb.append("            return(" + nullReturnValue + ");\n");
                }
                sb.append("\n");
                sb.append("        return(attr.getSV());\n");
                sb.append("    }\n\n");
            } else {
                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                if (typeName.equals("DmcAttribute")) {
                    if (!genericArgs.equals("<?>")) {
                        sb.append("    @SuppressWarnings(\"unchecked\")\n");
                    }
                    sb.append("    public DmcAttribute" + genericArgs + " get" + functionName + "(){\n");
                } else if (ad.getType() == MetaSchema._Boolean) {
                    sb.append("    public " + typeName + " is" + functionName + "(){\n");
                } else {
                    sb.append("    public " + typeName + " get" + functionName + "(){\n");
                }
                sb.append("        " + attrType + " attr = (" + attrType + ") get(" + ad.getDMSAGReference() + ");\n");
                sb.append("        if (attr == null)\n");
                if (nullReturnValue == null) {
                    sb.append("            return(null);\n");
                } else {
                    sb.append("            return(" + nullReturnValue + ");\n");
                }
                sb.append("\n");
                if (typeName.equals("DmcAttribute")) {
                    if (!genericArgs.equals("<?>")) {
                        sb.append("        return((DmcAttribute" + genericArgs + ")attr.getSV());\n");
                    } else {
                        sb.append("        return(attr.getSV());\n");
                    }
                } else {
                    sb.append("        return(attr.getSV());\n");
                }
                sb.append("    }\n\n");
            }
            sb.append("    /**\n");
            sb.append("     * Sets " + ad.getName() + " to the specified value.\n");
            sb.append("     * @param value " + typeName + "\n");
            sb.append("     */\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            if (typeName.equals("DmcAttribute")) {
                sb.append("    public void set" + functionName + "(DmcAttribute" + genericArgs + " value) {\n");
            } else {
                sb.append("    public void set" + functionName + "(" + typeName + " value) {\n");
            }
            sb.append("        DmcAttribute<?> attr = get(" + ad.getDMSAGReference() + ");\n");
            sb.append("        if (attr == null)\n");
            sb.append("            attr = new " + attrType + "(" + ad.getDMSAGReference() + ");\n");
            sb.append("        \n");
            sb.append("        try{\n");
            sb.append("            attr.set(value);\n");
            sb.append("            set(" + ad.getDMSAGReference() + ",attr);\n");
            sb.append("        }\n");
            sb.append("        catch(DmcValueException ex){\n");
            sb.append("            throw(new IllegalStateException(\"The type specific set() method shouldn't throw exceptions!\",ex));\n");
            sb.append("        }\n");
            sb.append("    }\n\n");
            if (ad.getType().getAltType() != null) {
                sb.append("    /**\n");
                sb.append("     * Sets " + ad.getName() + " to the specified value.\n");
                sb.append("     * @param value " + typeName + "\n");
                sb.append("     */\n");
                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    public void set" + functionName + "(" + ad.getType().getAltType() + " value) {\n");
                sb.append("        DmcAttribute<?> attr = get(" + ad.getDMSAGReference() + ");\n");
                sb.append("        if (attr == null)\n");
                sb.append("            attr = new " + attrType + "(" + ad.getDMSAGReference() + ");\n");
                sb.append("        \n");
                sb.append("        try{\n");
                sb.append("            attr.set(value);\n");
                sb.append("            set(" + ad.getDMSAGReference() + ",attr);\n");
                sb.append("        }\n");
                sb.append("        catch(DmcValueException ex){\n");
                sb.append("            throw(new IllegalStateException(\"The alternative type specific set() method shouldn't throw exceptions!\",ex));\n");
                sb.append("        }\n");
                sb.append("    }\n\n");
            }
        }
        sb.append("    /**\n");
        sb.append("     * Sets " + ad.getName() + " to the specified value.\n");
        sb.append("     * @param value A value compatible with " + attrType + "\n");
        sb.append("     * @throws DmcValueException if value is not correct\n");
        sb.append("     */\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    public void set" + functionName + "(Object value) throws DmcValueException {\n");
        sb.append("        " + attrType + " attr  = (" + attrType + ") get(" + ad.getDMSAGReference() + ");\n");
        sb.append("        if (attr == null)\n");
        sb.append("            attr = new " + attrType + "(" + ad.getDMSAGReference() + ");\n");
        if (ad.getType().getIsRefType().booleanValue() && ad.getType().getOriginalClass().getIsNamedBy() != null) {
            sb.append("        else\n");
            sb.append("            attr.removeBackReferences();\n");
        }
        sb.append("        \n");
        sb.append("        attr.set(value);\n");
        sb.append("        set(" + ad.getDMSAGReference() + ",attr);\n");
        sb.append("    }\n\n");
        sb.append("    /**\n");
        sb.append("     * Removes the " + ad.getName() + " attribute value.\n");
        sb.append("     */\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    public void rem" + functionName + "(){\n");
        sb.append("         rem(" + ad.getDMSAGReference() + ");\n");
        sb.append("    }\n\n");
    }

    public static void formatSVObjectAccess(AttributeDefinition ad, StringBuffer sb) {
        if (ad.getType().getOriginalClass().getIsNamedBy() == null) {
            GenUtility.formatSV(ad, sb);
            return;
        }
        String attrType = "DmcTypeDmcObjectSV";
        String nullReturnValue = ad.getNullReturnValue();
        String typeName = ad.getType().getName().getNameString();
        String genericArgs = ad.getGenericArgs();
        if (genericArgs == null) {
            genericArgs = "<?>";
        }
        if (nullReturnValue == null) {
            nullReturnValue = ad.getType().getNullReturnValue();
        }
        StringBuffer functionName = new StringBuffer();
        functionName.append(ad.getName());
        functionName.setCharAt(0, Character.toUpperCase(functionName.charAt(0)));
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    public " + typeName + "DMO get" + functionName + "(){\n");
        sb.append("        " + attrType + " attr = (" + attrType + ") get(" + ad.getDMSAGReference() + ");\n");
        sb.append("        if (attr == null)\n");
        if (nullReturnValue == null) {
            sb.append("            return(null);\n");
        } else {
            sb.append("            return(" + nullReturnValue + ");\n");
        }
        sb.append("\n");
        sb.append("        return((" + typeName + "DMO)attr.getSV());\n");
        sb.append("    }\n\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    /**\n");
        sb.append("     * Sets " + ad.getName() + " to the specified value.\n");
        sb.append("     * @param value A value compatible with " + attrType + "\n");
        sb.append("     */\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    public void set" + functionName + "(" + typeName + "DMO value){\n");
        sb.append("        " + attrType + " attr  = (" + attrType + ") get(" + ad.getDMSAGReference() + ");\n");
        sb.append("        if (attr == null)\n");
        sb.append("            attr = new " + attrType + "(" + ad.getDMSAGReference() + ");\n");
        sb.append("        \n");
        sb.append("        try {\n");
        sb.append("            attr.set(value);\n");
        sb.append("            set(" + ad.getDMSAGReference() + ",attr);\n");
        sb.append("        } catch (DmcValueException e) {\n");
        sb.append("            throw(new IllegalStateException(\"This set" + functionName + "() call should never throw an exception\", e));\n");
        sb.append("        }\n");
        sb.append("    }\n\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    /**\n");
        sb.append("     * Removes the " + ad.getName() + " attribute value.\n");
        sb.append("     */\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    public void rem" + functionName + "(){\n");
        sb.append("         rem(" + ad.getDMSAGReference() + ");\n");
        sb.append("    }\n\n");
    }

    public static void formatMVObjectAccess(AttributeDefinition ad, StringBuffer sb) {
        if (ad.getType().getOriginalClass().getIsNamedBy() == null) {
            GenUtility.formatMV(ad, sb);
            return;
        }
        String attrType = "DmcTypeDmcObjectMV";
        String nullReturnValue = ad.getNullReturnValue();
        String typeName = ad.getType().getName().getNameString();
        String genericArgs = ad.getGenericArgs();
        if (genericArgs == null) {
            genericArgs = "<?>";
        }
        if (nullReturnValue == null) {
            nullReturnValue = ad.getType().getNullReturnValue();
        }
        StringBuffer functionName = new StringBuffer();
        functionName.append(ad.getName());
        functionName.setCharAt(0, Character.toUpperCase(functionName.charAt(0)));
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    public DmcAttribute<?> add" + functionName + "(" + typeName + "DMO value) {\n");
        sb.append("        DmcAttribute<?> attr = get(" + ad.getDMSAGReference() + ");\n");
        sb.append("        if (attr == null)\n");
        sb.append("            attr = new " + attrType + "(" + ad.getDMSAGReference() + ");\n");
        sb.append("        \n");
        sb.append("        try{\n");
        sb.append("            setLastValue(attr.add(value));\n");
        sb.append("            add(" + ad.getDMSAGReference() + ",attr);\n");
        sb.append("        }\n");
        sb.append("        catch(DmcValueException ex){\n");
        sb.append("            throw(new IllegalStateException(\"The type specific add() method shouldn't throw exceptions!\",ex));\n");
        sb.append("        }\n");
        sb.append("        return(attr);\n");
        sb.append("    }\n");
        sb.append("\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    @SuppressWarnings(\"unchecked\")\n");
        sb.append("    public Iterator<" + typeName + "DMO> get" + functionName + "(){\n");
        sb.append("        " + attrType + " attr = (" + attrType + ") get(" + ad.getDMSAGReference() + ");\n");
        sb.append("        if (attr == null)\n");
        sb.append("            return( ((List<" + typeName + "DMO>) Collections.EMPTY_LIST).iterator() );\n");
        sb.append("        else {\n");
        sb.append("            ArrayList<" + typeName + "DMO> list = new ArrayList<>();\n");
        sb.append("            Iterator<DmcObject> it = attr.getMV();\n");
        sb.append("            while(it.hasNext()) {\n");
        sb.append("                list.add((" + typeName + "DMO) it.next());\n");
        sb.append("            }\n");
        sb.append("            return(list.iterator());\n");
        sb.append("        }\n");
        sb.append("    }\n");
        sb.append("\n");
    }

    public static void formatMV(AttributeDefinition ad, StringBuffer sb) {
        int lastPeriod;
        String typeClassName = ad.getType().getTypeClassName();
        String attrType = "DmcType" + ad.getType().getName();
        String typeName = ad.getType().getName().getNameString();
        if (ad.getType().getIsRefType().booleanValue()) {
            attrType = attrType + "REF";
        }
        if (typeClassName != null && (lastPeriod = typeClassName.lastIndexOf(46)) != -1) {
            attrType = typeClassName.substring(lastPeriod + 1);
        }
        StringBuffer functionName = new StringBuffer();
        functionName.append(ad.getName());
        functionName.setCharAt(0, Character.toUpperCase(functionName.charAt(0)));
        if (ad.getValueType() == ValueTypeEnum.MULTI) {
            attrType = attrType + "MV";
        } else if (ad.getValueType() == ValueTypeEnum.HASHSET) {
            attrType = attrType + "SET";
        } else if (ad.getValueType() == ValueTypeEnum.TREESET) {
            attrType = attrType + "SET";
        }
        if (ad.getType().getIsRefType().booleanValue()) {
            String REF = "REF";
            String DMO = "DMO";
            if (ad.getType().getIsExtendedRefType().booleanValue()) {
                REF = "";
                DMO = "";
            }
            if (ad.getIndexSize() == null) {
                sb.append("    /**\n");
                sb.append("     * @return An Iterator of " + typeName + "DMO objects.\n");
                sb.append("     */\n");
                sb.append("    @SuppressWarnings(\"unchecked\")\n");
                if (ad.getType().getOriginalClass().getIsNamedBy() == null) {
                    sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                    sb.append("    public Iterator<" + typeName + "DMO> get" + functionName + "(){\n");
                    sb.append("        " + attrType + " attr = (" + attrType + ") get(" + ad.getDMSAGReference() + ");\n");
                    sb.append("        if (attr == null)\n");
                    sb.append("            return( ((List<" + typeName + "DMO>) Collections.EMPTY_LIST).iterator() );\n");
                    sb.append("\n");
                    sb.append("        return(attr.getMV());\n");
                    sb.append("    }\n\n");
                } else {
                    sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                    sb.append("    public Iterator<" + typeName + REF + "> get" + functionName + "(){\n");
                    sb.append("        " + attrType + " attr = (" + attrType + ") get(" + ad.getDMSAGReference() + ");\n");
                    sb.append("        if (attr == null)\n");
                    sb.append("            return( ((List<" + typeName + REF + ">) Collections.EMPTY_LIST).iterator() );\n");
                    sb.append("\n");
                    sb.append("        if (DmcOmni.instance().lazyResolution()){\n");
                    sb.append("            if (attr.doLazyResolution(this)){\n");
                    sb.append("                rem(attr.getAttributeInfo());\n");
                    sb.append("                return( ((List<" + typeName + REF + ">) Collections.EMPTY_LIST).iterator() );\n");
                    sb.append("            }\n");
                    sb.append("        }\n");
                    sb.append("\n");
                    sb.append("        return(attr.getMV());\n");
                    sb.append("    }\n\n");
                    sb.append("    /**\n");
                    sb.append("     * @return An Iterator of " + typeName + "REFs without attempting lazy resolution (if it's turned on).\n");
                    sb.append("     */\n");
                    sb.append("    @SuppressWarnings(\"unchecked\")\n");
                    sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                    sb.append("    public Iterator<" + typeName + REF + "> get" + functionName + "REFs(){\n");
                    sb.append("        " + attrType + " attr = (" + attrType + ") get(" + ad.getDMSAGReference() + ");\n");
                    sb.append("        if (attr == null)\n");
                    sb.append("            return( ((List<" + typeName + REF + ">) Collections.EMPTY_LIST).iterator() );\n");
                    sb.append("\n");
                    sb.append("        return(attr.getMV());\n");
                    sb.append("    }\n\n");
                }
                sb.append("    /**\n");
                sb.append("     * Adds another " + ad.getName() + " to the specified value.\n");
                sb.append("     * @param value " + typeName + "\n");
                sb.append("     * @return the attribute instance\n");
                sb.append("     */\n");
                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    public DmcAttribute<?> add" + functionName + "(" + typeName + DMO + " value) {\n");
                sb.append("        DmcAttribute<?> attr = get(" + ad.getDMSAGReference() + ");\n");
                sb.append("        if (attr == null)\n");
                sb.append("            attr = new " + attrType + "(" + ad.getDMSAGReference() + ");\n");
                sb.append("        \n");
                sb.append("        try{\n");
                sb.append("            setLastValue(attr.add(value));\n");
                sb.append("            add(" + ad.getDMSAGReference() + ",attr);\n");
                sb.append("        }\n");
                sb.append("        catch(DmcValueException ex){\n");
                sb.append("            throw(new IllegalStateException(\"The type specific add() method shouldn't throw exceptions!\",ex));\n");
                sb.append("        }\n");
                sb.append("        return(attr);\n");
                sb.append("    }\n\n");
            } else {
                if (ad.getType().getOriginalClass().getIsNamedBy() == null) {
                    sb.append("    /**\n");
                    sb.append("     * @return The nth " + typeName + " value without attempting lazy resolution.\n");
                    sb.append("     */\n");
                    sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                    sb.append("    public " + typeName + DMO + " getNth" + functionName + "(int i){\n");
                    sb.append("        " + attrType + " attr = (" + attrType + ") get(" + ad.getDMSAGReference() + ");\n");
                    sb.append("        if (attr == null)\n");
                    sb.append("            return(null);\n");
                    sb.append("\n");
                    sb.append("        return(attr.getMVnth(i));\n");
                    sb.append("    }\n\n");
                } else {
                    sb.append("    /**\n");
                    sb.append("     * @return The nth " + typeName + " value and attempt lazy resolution if it's on.\n");
                    sb.append("     */\n");
                    sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                    sb.append("    public " + typeName + REF + " getNth" + functionName + "(int i){\n");
                    sb.append("        " + attrType + " attr = (" + attrType + ") get(" + ad.getDMSAGReference() + ");\n");
                    sb.append("        if (attr == null)\n");
                    sb.append("            return(null);\n");
                    sb.append("\n");
                    sb.append("        if (DmcOmni.instance().lazyResolution()){\n");
                    sb.append("            if (attr.doLazyResolution(this)){\n");
                    sb.append("                rem(attr.getAttributeInfo());\n");
                    sb.append("                return(null);\n");
                    sb.append("            }\n");
                    sb.append("        }\n");
                    sb.append("\n");
                    sb.append("        return(attr.getMVnth(i));\n");
                    sb.append("    }\n\n");
                    sb.append("    /**\n");
                    sb.append("     * @return The nth " + typeName + " value without attempting lazy resolution.\n");
                    sb.append("     */\n");
                    sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                    sb.append("    public " + typeName + REF + " getNth" + functionName + "REF(int i){\n");
                    sb.append("        " + attrType + " attr = (" + attrType + ") get(" + ad.getDMSAGReference() + ");\n");
                    sb.append("        if (attr == null)\n");
                    sb.append("            return(null);\n");
                    sb.append("\n");
                    sb.append("        return(attr.getMVnth(i));\n");
                    sb.append("    }\n\n");
                }
                sb.append("    /**\n");
                sb.append("     * Sets the " + ad.getName() + " value at the specified index.\n");
                sb.append("     * @param value " + typeName + "\n");
                sb.append("     */\n");
                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    public DmcAttribute<?> setNth" + functionName + "(int index, " + typeName + DMO + " value) {\n");
                sb.append("        DmcAttribute<?> attr = get(" + ad.getDMSAGReference() + ");\n");
                sb.append("        if (attr == null){\n");
                sb.append("            if (value == null){\n");
                sb.append("                if (getModifier() == null)\n");
                sb.append("                    throw(new IllegalStateException(\"Calling setNth() on a non-existent attribute with a null value makes no sense!\"));\n");
                sb.append("                else{\n");
                sb.append("                    nthNullFromEmptyAttribute(" + ad.getDMSAGReference() + ", index);\n");
                sb.append("                    return(null);\n");
                sb.append("                }\n");
                sb.append("            }\n");
                sb.append("            else\n");
                sb.append("                attr = new " + attrType + "(" + ad.getDMSAGReference() + ");\n");
                sb.append("        }\n");
                sb.append("        \n");
                sb.append("        try{\n");
                if (ad.getType().getOriginalClass().getIsNamedBy() == null) {
                    sb.append("            setLastValue(attr.setMVnth(index, value));\n");
                    sb.append("            nth(" + ad.getDMSAGReference() + ", index ,attr, null);\n");
                } else {
                    sb.append("            " + typeName + REF + " previous = (" + typeName + REF + ") attr.getMVnth(index);\n");
                    sb.append("            setLastValue(attr.setMVnth(index, value));\n");
                    sb.append("            nth(" + ad.getDMSAGReference() + ",index ,attr,previous);\n");
                }
                sb.append("        }\n");
                sb.append("        catch(DmcValueException ex){\n");
                sb.append("            throw(new IllegalStateException(\"The type specific setNth() method shouldn't throw exceptions!\",ex));\n");
                sb.append("        }\n");
                sb.append("        return(attr);\n");
                sb.append("    }\n\n");
            }
        } else {
            sb.append("    /**\n");
            sb.append("     * @return An Iterator of " + typeName + " objects.\n");
            sb.append("     */\n");
            sb.append("    @SuppressWarnings(\"unchecked\")\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    public Iterator<" + typeName + "> get" + functionName + "(){\n");
            sb.append("        " + attrType + " attr = (" + attrType + ") get(" + ad.getDMSAGReference() + ");\n");
            sb.append("        if (attr == null)\n");
            sb.append("            return( ((List<" + typeName + ">) Collections.EMPTY_LIST).iterator());\n");
            sb.append("\n");
            sb.append("        return(attr.getMV());\n");
            sb.append("    }\n\n");
            sb.append("    /**\n");
            sb.append("     * @param i the index\n");
            sb.append("     * @return The nth " + typeName + " value.\n");
            sb.append("     */\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    public " + typeName + " getNth" + functionName + "(int i){\n");
            sb.append("        " + attrType + " attr = (" + attrType + ") get(" + ad.getDMSAGReference() + ");\n");
            sb.append("        if (attr == null)\n");
            sb.append("            return(null);\n");
            sb.append("\n");
            sb.append("        return(attr.getMVnth(i));\n");
            sb.append("    }\n\n");
            if (ad.getIndexSize() == null) {
                sb.append("    /**\n");
                sb.append("     * Adds another " + ad.getName() + " to the specified value.\n");
                sb.append("     * @param value " + typeName + "\n");
                sb.append("     * @return the attribute instance\n");
                sb.append("     */\n");
                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    public DmcAttribute<?> add" + functionName + "(" + typeName + " value) {\n");
                sb.append("        DmcAttribute<?> attr = get(" + ad.getDMSAGReference() + ");\n");
                sb.append("        if (attr == null)\n");
                sb.append("            attr = new " + attrType + "(" + ad.getDMSAGReference() + ");\n");
                sb.append("        \n");
                sb.append("        try{\n");
                sb.append("            setLastValue(attr.add(value));\n");
                sb.append("            add(" + ad.getDMSAGReference() + ",attr);\n");
                sb.append("        }\n");
                sb.append("        catch(DmcValueException ex){\n");
                sb.append("            throw(new IllegalStateException(\"The type specific add() method shouldn't throw exceptions!\",ex));\n");
                sb.append("        }\n");
                sb.append("        return(attr);\n");
                sb.append("    }\n\n");
            } else {
                sb.append("    /**\n");
                sb.append("     * Sets the value at the specified index.\n");
                sb.append("     * @param value " + typeName + "\n");
                sb.append("     */\n");
                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    public DmcAttribute<?> setNth" + functionName + "(int index, " + typeName + " value) {\n");
                sb.append("        DmcAttribute<?> attr = get(" + ad.getDMSAGReference() + ");\n");
                sb.append("        if (attr == null){\n");
                sb.append("            if (value == null){\n");
                sb.append("                if (getModifier() == null)\n");
                sb.append("                    throw(new IllegalStateException(\"Calling setNth() on a non-existent attribute with a null value makes no sense!\"));\n");
                sb.append("                else{\n");
                sb.append("                    nthNullFromEmptyAttribute(" + ad.getDMSAGReference() + ", index);\n");
                sb.append("                    return(null);\n");
                sb.append("                }\n");
                sb.append("            }\n");
                sb.append("            else\n");
                sb.append("                attr = new " + attrType + "(" + ad.getDMSAGReference() + ");\n");
                sb.append("        }\n");
                sb.append("        \n");
                sb.append("        try{\n");
                sb.append("            " + typeName + " previous = (" + typeName + ") attr.getMVnth(index);\n");
                sb.append("            setLastValue(attr.setMVnth(index, value));\n");
                sb.append("            nth(" + ad.getDMSAGReference() + ",index ,attr,previous);\n");
                sb.append("        }\n");
                sb.append("        catch(DmcValueException ex){\n");
                sb.append("            throw(new IllegalStateException(\"The type specific setNth() method shouldn't throw exceptions!\",ex));\n");
                sb.append("        }\n");
                sb.append("        return(attr);\n");
                sb.append("    }\n\n");
            }
            if (ad.getType().getAltType() != null) {
                sb.append("    /**\n");
                sb.append("     * Adds another " + ad.getName() + " to the specified value.\n");
                sb.append("     * @param value " + typeName + "\n");
                sb.append("     */\n");
                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    public DmcAttribute<?> add" + functionName + "(" + ad.getType().getAltType() + " value) {\n");
                sb.append("        DmcAttribute<?> attr = get(" + ad.getDMSAGReference() + ");\n");
                sb.append("        if (attr == null)\n");
                sb.append("            attr = new " + attrType + "(" + ad.getDMSAGReference() + ");\n");
                sb.append("        \n");
                sb.append("        try{\n");
                sb.append("            setLastValue(attr.add(value));\n");
                sb.append("            add(" + ad.getDMSAGReference() + ",attr);\n");
                sb.append("        }\n");
                sb.append("        catch(DmcValueException ex){\n");
                sb.append("            throw(new IllegalStateException(\"The alternative type specific add() method shouldn't throw exceptions!\",ex));\n");
                sb.append("        }\n");
                sb.append("        return(attr);\n");
                sb.append("    }\n\n");
            }
            sb.append("    /**\n");
            sb.append("     * @param value " + typeName + "\n");
            sb.append("     * @return true if we contain a valued keyed by the specified " + typeName + ".\n");
            sb.append("     */\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    public boolean " + ad.getName() + "Contains(" + typeName + " value) {\n");
            sb.append("        DmcAttribute<?> attr = get(" + ad.getDMSAGReference() + ");\n");
            sb.append("        if (attr == null)\n");
            sb.append("            return(false);\n");
            sb.append("        return(attr.contains(value));\n");
            sb.append("    }\n\n");
            if (ad.getType().getAltType() != null) {
                String alt = ad.getType().getAltType();
                sb.append("    /**\n");
                sb.append("     * @param value " + alt + "\n");
                sb.append("     * @return true if we contain a valued keyed by the specified " + alt + ".\n");
                sb.append("     */\n");
                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    public boolean " + ad.getName() + "Contains(" + alt + " value) {\n");
                sb.append("        DmcAttribute<?> attr = get(" + ad.getDMSAGReference() + ");\n");
                sb.append("        if (attr == null)\n");
                sb.append("            return(false);\n");
                sb.append("        return(attr.contains(value));\n");
                sb.append("    }\n\n");
            }
        }
        sb.append("    /**\n");
        sb.append("     * Adds another " + ad.getName() + " value.\n");
        sb.append("     * @param value A value compatible with " + typeName + "\n");
        sb.append("     * @return the attribute instance\n");
        sb.append("     * @throws DmcValueException if value is not correct\n");
        sb.append("     */\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    public DmcAttribute<?> add" + functionName + "(Object value) throws DmcValueException {\n");
        sb.append("        DmcAttribute<?> attr = get(" + ad.getDMSAGReference() + ");\n");
        sb.append("        if (attr == null)\n");
        sb.append("            attr = new " + attrType + "(" + ad.getDMSAGReference() + ");\n");
        sb.append("        \n");
        sb.append("        setLastValue(attr.add(value));\n");
        sb.append("        add(" + ad.getDMSAGReference() + ",attr);\n");
        sb.append("        return(attr);\n");
        sb.append("    }\n\n");
        sb.append("    /**\n");
        sb.append("     * @return the number of values in " + ad.getName() + "\n");
        sb.append("     */\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    public int get" + functionName + "Size(){\n");
        sb.append("        DmcAttribute<?> attr = get(" + ad.getDMSAGReference() + ");\n");
        sb.append("        if (attr == null){\n");
        sb.append("            if (" + ad.getDMSAGReference() + ".indexSize == 0)\n");
        sb.append("                return(0);\n");
        sb.append("            else\n");
        sb.append("                return(" + ad.getDMSAGReference() + ".indexSize);\n");
        sb.append("        }\n");
        sb.append("        return(attr.getMVSize());\n");
        sb.append("    }\n\n");
        if (ad.getType().getIsRefType().booleanValue()) {
            if (ad.getType().getOriginalClass().getIsNamedBy() == null) {
                sb.append("    /**\n");
                sb.append("     * Deletes a " + ad.getName() + " value.\n");
                sb.append("     * @param value The " + typeName + " to be deleted from set of attribute values.\n");
                sb.append("     * @return the deleted attribute instance");
                sb.append("     */\n");
                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    public DmcAttribute<?> del" + functionName + "(Object value){\n");
                sb.append("        DmcAttribute<?> attr = get(" + ad.getDMSAGReference() + ");\n");
                sb.append("        \n");
                sb.append("        if ( (attr == null) && (getModifier()!= null))\n");
                sb.append("            delFromEmptyAttribute(new " + attrType + "(" + ad.getDMSAGReference() + "), value);\n");
                sb.append("        else\n");
                sb.append("            attr = del(" + ad.getDMSAGReference() + ", value);\n");
                sb.append("        \n");
                sb.append("        return(attr);\n");
                sb.append("    }\n\n");
            } else {
                sb.append("    /**\n");
                sb.append("     * Deletes a " + ad.getName() + " value.\n");
                sb.append("     * @param value The " + typeName + " to be deleted from set of attribute values.\n");
                sb.append("     * @return the deleted attribute instance");
                sb.append("     */\n");
                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    public DmcAttribute<?> del" + functionName + "(Object value){\n");
                sb.append("        DmcAttribute<?> attr = get(" + ad.getDMSAGReference() + ");\n");
                sb.append("        \n");
                sb.append("        if ( (attr == null) && (getModifier()!= null))\n");
                sb.append("            delFromEmptyAttribute(new " + attrType + "(" + ad.getDMSAGReference() + "), value);\n");
                sb.append("        else\n");
                sb.append("            attr = del(" + ad.getDMSAGReference() + ", value);\n");
                sb.append("        \n");
                sb.append("        return(attr);\n");
                sb.append("    }\n\n");
            }
        } else {
            sb.append("    /**\n");
            sb.append("     * Deletes a " + ad.getName() + " value.\n");
            sb.append("     * @param value The " + typeName + " to be deleted from set of attribute values.\n");
            sb.append("     * @return the deleted attribute instance\n");
            sb.append("     * @throws DmcValueException if the value is incorrect\n");
            sb.append("     */\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    public DmcAttribute<?> del" + functionName + "(Object value) throws DmcValueException {\n");
            sb.append("        DmcAttribute<?> attr = get(" + ad.getDMSAGReference() + ");\n");
            sb.append("        \n");
            sb.append("        if ( (attr == null) && (getModifier()!= null))\n");
            sb.append("            delFromEmptyAttribute(new " + attrType + "(" + ad.getDMSAGReference() + "), value);\n");
            sb.append("        else\n");
            sb.append("            attr = del(" + ad.getDMSAGReference() + ", value);\n");
            sb.append("        \n");
            sb.append("        return(attr);\n");
            sb.append("    }\n\n");
            sb.append("    /**\n");
            sb.append("     * Deletes a " + ad.getName() + " from the specified value.\n");
            sb.append("     * @param value " + typeName + "\n");
            sb.append("     * @return the deleted attribute instance");
            sb.append("     */\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    public DmcAttribute<?> del" + functionName + "(" + typeName + " value) {\n");
            sb.append("        DmcAttribute<?> attr = get(" + ad.getDMSAGReference() + ");\n");
            sb.append("        \n");
            sb.append("        if ( (attr == null) && (getModifier()!= null))\n");
            sb.append("            delFromEmptyAttribute(new " + attrType + "(" + ad.getDMSAGReference() + "), value);\n");
            sb.append("        else\n");
            sb.append("            attr = del(" + ad.getDMSAGReference() + ", value);\n");
            sb.append("        \n");
            sb.append("        return(attr);\n");
            sb.append("    }\n\n");
        }
        sb.append("    /**\n");
        sb.append("     * Removes the " + ad.getName() + " attribute value.\n");
        sb.append("     */\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    public void rem" + functionName + "(){\n");
        sb.append("         rem(" + ad.getDMSAGReference() + ");\n");
        sb.append("    }\n\n");
    }

    public static void formatMAPPED(AttributeDefinition ad, StringBuffer sb) {
        int lastPeriod;
        String typeClassName = ad.getType().getTypeClassName();
        String attrType = "DmcType" + ad.getType().getName();
        String typeName = ad.getType().getName().getNameString();
        if (ad.getType().getIsRefType().booleanValue()) {
            attrType = attrType + "REF";
        }
        if (typeClassName != null && (lastPeriod = typeClassName.lastIndexOf(46)) != -1) {
            attrType = typeClassName.substring(lastPeriod + 1);
        }
        StringBuffer functionName = new StringBuffer();
        functionName.append(ad.getName());
        functionName.setCharAt(0, Character.toUpperCase(functionName.charAt(0)));
        attrType = attrType + "MAP";
        if (ad.getType().getIsRefType().booleanValue()) {
            sb.append("    /**\n");
            sb.append("     * @return An Iterator of " + typeName + "DMO objects.\n");
            sb.append("     */\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            if (ad.getType().getOriginalClass().getIsNamedBy() == null) {
                sb.append("    public Iterator<" + typeName + "DMO> get" + functionName + "(){\n");
                sb.append("        " + attrType + " attr = (" + attrType + ") get(" + ad.getDMSAGReference() + ");\n");
                sb.append("        if (attr == null)\n");
                sb.append("            return(Collections.<" + typeName + "DMO> emptyList().iterator());\n");
                sb.append("\n");
                sb.append("        return(attr.getMV());\n");
                sb.append("    }\n\n");
            } else {
                sb.append("    @SuppressWarnings(\"unchecked\")\n");
                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    public Iterator<" + typeName + "REF> get" + functionName + "(){\n");
                sb.append("        " + attrType + " attr = (" + attrType + ") get(" + ad.getDMSAGReference() + ");\n");
                sb.append("        if (attr == null)\n");
                sb.append("            return( ((List<" + typeName + "REF>) Collections.EMPTY_LIST).iterator() );\n");
                sb.append("\n");
                sb.append("        if (DmcOmni.instance().lazyResolution()){\n");
                sb.append("            if (attr.doLazyResolution(this)){\n");
                sb.append("                rem(attr.getAttributeInfo());\n");
                sb.append("                return( ((List<" + typeName + "REF>) Collections.EMPTY_LIST).iterator() );\n");
                sb.append("            }\n");
                sb.append("        }\n");
                sb.append("\n");
                sb.append("        return(attr.getMV());\n");
                sb.append("    }\n\n");
                sb.append("    /**\n");
                sb.append("     * @return An Iterator of " + typeName + "REFs without attempting lazy resolution (if it's turned on).\n");
                sb.append("     */\n");
                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    @SuppressWarnings(\"unchecked\")\n");
                sb.append("    public Iterator<" + typeName + "REF> get" + functionName + "REFs(){\n");
                sb.append("        " + attrType + " attr = (" + attrType + ") get(" + ad.getDMSAGReference() + ");\n");
                sb.append("        if (attr == null)\n");
                sb.append("            return( ((List<" + typeName + "REF>) Collections.EMPTY_LIST).iterator() );\n");
                sb.append("\n");
                sb.append("        return(attr.getMV());\n");
                sb.append("    }\n\n");
            }
        } else {
            sb.append("    /**\n");
            sb.append("     * @return An Iterator of " + typeName + " objects.\n");
            sb.append("     */\n");
            sb.append("    @SuppressWarnings(\"unchecked\")\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    public Iterator<" + typeName + "> get" + functionName + "(){\n");
            sb.append("        " + attrType + " attr = (" + attrType + ") get(" + ad.getDMSAGReference() + ");\n");
            sb.append("        if (attr == null)\n");
            sb.append("            return( ((List<" + typeName + ">) Collections.EMPTY_LIST).iterator());\n");
            sb.append("\n");
            sb.append("        return(attr.getMV());\n");
            sb.append("    }\n\n");
        }
        if (ad.getType().getIsRefType().booleanValue()) {
            sb.append("    /**\n");
            sb.append("     * @param key The key of the value you want.\n");
            sb.append("     * @return The " + typeName + " associated with the specified key.\n");
            sb.append("     */\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    public " + typeName + "REF get" + functionName + "(Object key){\n");
            sb.append("        " + attrType + " attr = (" + attrType + ") get(" + ad.getDMSAGReference() + ");\n");
            sb.append("        if (attr == null)\n");
            sb.append("            return(null);\n");
            sb.append("\n");
            sb.append("        return(attr.getByKey(key));\n");
            sb.append("    }\n\n");
        } else {
            sb.append("    /**\n");
            sb.append("     * @param key The key of the value you want.\n");
            sb.append("     * @return The " + typeName + " associated with the specified key.\n");
            sb.append("     */\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    public " + typeName + " get" + functionName + "(Object key){\n");
            sb.append("        " + attrType + " attr = (" + attrType + ") get(" + ad.getDMSAGReference() + ");\n");
            sb.append("        if (attr == null)\n");
            sb.append("            return(null);\n");
            sb.append("\n");
            sb.append("        return(attr.getByKey(key));\n");
            sb.append("    }\n\n");
        }
        if (ad.getValueType() == ValueTypeEnum.TREEMAPPED) {
            String keyClass = ad.getType().getKeyClass();
            if (ad.getType().getIsRefType().booleanValue()) {
                keyClass = ad.getType().getOriginalClass().getIsNamedBy().getType().getName().getNameString();
            }
            sb.append("    /**\n");
            sb.append("     * @return The first key of the map.\n");
            sb.append("     */\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    public " + keyClass + " get" + functionName + "FirstKey(){\n");
            sb.append("        " + attrType + " attr = (" + attrType + ") get(" + ad.getDMSAGReference() + ");\n");
            sb.append("        if (attr == null)\n");
            sb.append("            return(null);\n");
            sb.append("\n");
            sb.append("        return(attr.firstKey());\n");
            sb.append("    }\n\n");
        }
        sb.append("    /**\n");
        sb.append("     * Adds another " + ad.getName() + " value.\n");
        sb.append("     * @param value A value compatible with " + typeName + "\n");
        sb.append("     */\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    public DmcAttribute<?> add" + functionName + "(Object value) throws DmcValueException {\n");
        sb.append("        DmcAttribute<?> attr = get(" + ad.getDMSAGReference() + ");\n");
        sb.append("        if (attr == null)\n");
        sb.append("            attr = new " + attrType + "(" + ad.getDMSAGReference() + ");\n");
        sb.append("        \n");
        sb.append("        setLastValue(attr.add(value));\n");
        sb.append("        add(" + ad.getDMSAGReference() + ",attr);\n");
        sb.append("        return(attr);\n");
        sb.append("    }\n\n");
        if (ad.getType().getIsRefType().booleanValue()) {
            sb.append("    /**\n");
            sb.append("     * Adds another " + ad.getName() + " value.\n");
            sb.append("     * @param value " + typeName + "\n");
            sb.append("     */\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    public DmcAttribute<?> add" + functionName + "(" + typeName + "DMO value) {\n");
            sb.append("        DmcAttribute<?> attr = get(" + ad.getDMSAGReference() + ");\n");
            sb.append("        if (attr == null)\n");
            sb.append("            attr = new " + attrType + "(" + ad.getDMSAGReference() + ");\n");
            sb.append("        \n");
            sb.append("        try{\n");
            sb.append("            setLastValue(attr.add(value));\n");
            sb.append("            add(" + ad.getDMSAGReference() + ",attr);\n");
            sb.append("        }\n");
            sb.append("        catch(DmcValueException ex){\n");
            sb.append("            throw(new IllegalStateException(\"The type specific add() method shouldn't throw exceptions!\",ex));\n");
            sb.append("        }\n");
            sb.append("        return(attr);\n");
            sb.append("    }\n\n");
        } else {
            sb.append("    /**\n");
            sb.append("     * Adds another " + ad.getName() + " value.\n");
            sb.append("     * @param value " + typeName + "\n");
            sb.append("     */\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    public DmcAttribute<?> add" + functionName + "(" + typeName + " value) {\n");
            sb.append("        DmcAttribute<?> attr = get(" + ad.getDMSAGReference() + ");\n");
            sb.append("        if (attr == null)\n");
            sb.append("            attr = new " + attrType + "(" + ad.getDMSAGReference() + ");\n");
            sb.append("        \n");
            sb.append("        try{\n");
            sb.append("            setLastValue(attr.add(value));\n");
            sb.append("            add(" + ad.getDMSAGReference() + ",attr);\n");
            sb.append("        }\n");
            sb.append("        catch(DmcValueException ex){\n");
            sb.append("            throw(new IllegalStateException(\"The type specific add() method shouldn't throw exceptions!\",ex));\n");
            sb.append("        }\n");
            sb.append("        return(attr);\n");
            sb.append("    }\n\n");
        }
        if (ad.getType().getIsRefType().booleanValue()) {
            if (ad.getType().getOriginalClass().getIsNamedBy() == null) {
                DebugInfo.debug("*** Mapped value deletion not yet supported for non object reference types.");
            } else {
                sb.append("    /**\n");
                sb.append("     * Deletes a " + ad.getName() + " value.\n");
                sb.append("     * @param value The " + typeName + " to be deleted from set of attribute values.\n");
                sb.append("     */\n");
                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    public DmcAttribute<?> del" + functionName + "(Object value) throws DmcValueException {\n");
                sb.append("        DmcAttribute<?> attr = get(" + ad.getDMSAGReference() + ");\n");
                sb.append("        \n");
                sb.append("        if ( (attr == null) && (getModifier()!= null))\n");
                sb.append("            delFromEmptyAttribute(new " + attrType + "(" + ad.getDMSAGReference() + "), value);\n");
                sb.append("        else\n");
                sb.append("            attr = del(" + ad.getDMSAGReference() + ", value);\n");
                sb.append("        \n");
                sb.append("        return(attr);\n");
                sb.append("    }\n\n");
                sb.append("    /**\n");
                sb.append("     * Deletes a " + ad.getName() + " value.\n");
                sb.append("     * @param value The " + typeName + " to be deleted from set of attribute values.\n");
                sb.append("     */\n");
                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    public DmcAttribute<?> del" + functionName + "(" + typeName + "DMO value){\n");
                sb.append("        DmcAttribute<?> attr = get(" + ad.getDMSAGReference() + ");\n");
                sb.append("        \n");
                sb.append("        if ( (attr == null) && (getModifier()!= null))\n");
                sb.append("            delFromEmptyAttribute(new " + attrType + "(" + ad.getDMSAGReference() + "), value.getObjectName());\n");
                sb.append("        else\n");
                sb.append("            attr = del(" + ad.getDMSAGReference() + ", value.getObjectName());\n");
                sb.append("        \n");
                sb.append("        return(attr);\n");
                sb.append("    }\n\n");
            }
        } else {
            sb.append("    /**\n");
            sb.append("     * Deletes a " + ad.getName() + " value.\n");
            sb.append("     * @param key The key of the " + typeName + " to be deleted from the map of attribute values.\n");
            sb.append("     */\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    public DmcAttribute<?> del" + functionName + "(Object key){\n");
            sb.append("        DmcAttribute<?> attr = get(" + ad.getDMSAGReference() + ");\n");
            sb.append("        \n");
            sb.append("        if ( (attr == null) && (getModifier()!= null))\n");
            sb.append("            delFromEmptyAttribute(new " + attrType + "(" + ad.getDMSAGReference() + "), key);\n");
            sb.append("        if (attr == null)\n");
            sb.append("            return(null);\n");
            sb.append("        \n");
            sb.append("        attr = del(" + ad.getDMSAGReference() + ", key);\n");
            sb.append("        \n");
            sb.append("        return(attr);\n");
            sb.append("    }\n\n");
            sb.append("    /**\n");
            sb.append("     * Deletes a " + ad.getName() + " value.\n");
            sb.append("     * @param key the " + ad.getType().getKeyClass() + " key value\n");
            sb.append("     */\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    public DmcAttribute<?> del" + functionName + "(" + ad.getType().getKeyClass() + " key) {\n");
            sb.append("        DmcAttribute<?> attr = get(" + ad.getDMSAGReference() + ");\n");
            sb.append("        \n");
            sb.append("        if ( (attr == null) && (getModifier()!= null))\n");
            sb.append("            delFromEmptyAttribute(new " + attrType + "(" + ad.getDMSAGReference() + "), key);\n");
            sb.append("        if (attr == null)\n");
            sb.append("            return(null);\n");
            sb.append("        \n");
            sb.append("        attr = del(" + ad.getDMSAGReference() + ", key);\n");
            sb.append("        \n");
            sb.append("        return(attr);\n");
            sb.append("    }\n\n");
        }
        sb.append("    /**\n");
        sb.append("     * Removes the " + ad.getName() + " attribute value.\n");
        sb.append("     */\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    public void rem" + functionName + "(){\n");
        sb.append("         rem(" + ad.getDMSAGReference() + ");\n");
        sb.append("    }\n\n");
    }

    public static String getClassFromImport(String value) {
        int lastDot = value.lastIndexOf(".");
        return value.substring(lastDot + 1);
    }

    public static void dumpIterable(String dmwdir, String basePackage, String typeImport, String typeName, String genericArgs, String fileHeader, PrintStream progress) throws IOException {
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(dmwdir, typeName + "IterableDMW.java");
        if (fileHeader != null) {
            out.write(fileHeader);
        }
        out.write("package " + basePackage + ".generated.dmw;\n\n");
        ImportManager imports = new ImportManager();
        imports.addImport("java.util.Iterator", "Beacuse we're iterating");
        imports.addImport("org.dmd.dmw.DmwMVIterator", "The base multi-value iterator");
        if (typeImport != null) {
            imports.addImport(typeImport, "This is the type we're iterating");
        }
        out.write(imports.getFormattedImports() + "\n");
        String suffix = "";
        if (typeImport != null && typeImport.endsWith("DMO")) {
            suffix = "DMO";
        }
        String args = "";
        if (genericArgs != null) {
            args = genericArgs;
        }
        out.write("/**\n");
        out.write(" * The " + typeName + "IterableDMW wraps an Iterator for a particular type and makes \n");
        out.write(" * it Iterable.\n");
        out.write(" * <P>\n");
        out.write(" * This code was auto-generated and shouldn't be altered manually!\n");
        out.write(" * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write(" *    " + DebugInfo.getWhereWeWereCalledFrom() + "\n");
        out.write(" */\n");
        out.write("public class " + typeName + "IterableDMW extends DmwMVIterator<" + typeName + suffix + args + "> {\n");
        out.write("\n");
        out.write("    public final static " + typeName + "IterableDMW emptyList = new " + typeName + "IterableDMW();\n");
        out.write("\n");
        out.write("    protected " + typeName + "IterableDMW(){\n");
        out.write("        super();\n");
        out.write("    }\n");
        out.write("\n");
        out.write("    public " + typeName + "IterableDMW(Iterator<" + typeName + suffix + args + "> it){\n");
        out.write("        super(it);\n");
        out.write("    }\n");
        out.write("\n");
        out.write("}\n\n");
        ((BufferedWriter)out).close();
    }

    public static void dumpObjectIterable(String dmwdir, String basePackage, String typeImport, String typeName, String dmwImport, String genericArgs, String fileHeader, PrintStream progress) throws IOException {
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(dmwdir, typeName + "IterableDMW.java");
        if (fileHeader != null) {
            out.write(fileHeader);
        }
        out.write("package " + basePackage + ".generated.dmw;\n\n");
        out.write("import java.util.Iterator;\n\n");
        out.write("import org.dmd.dmw.DmwObjectIterator;\n");
        if (typeImport != null) {
            out.write("import " + typeImport + ";  // dmo type import\n");
        }
        if (dmwImport != null) {
            out.write("import " + dmwImport + ";  // wrapper type import\n");
        }
        String suffix = "";
        if (dmwImport != null && dmwImport.endsWith("DMW")) {
            suffix = "DMW";
        }
        String args = "";
        if (genericArgs != null) {
            args = genericArgs;
        }
        out.write("/**\n");
        out.write(" * The " + typeName + "IterableDMW wraps an Iterator for a particular type and makes \n");
        out.write(" * it Iterable.\n");
        out.write(" * <P>\n");
        out.write(" * This code was auto-generated and shouldn't be altered manually!\n");
        out.write(" * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write(" *    " + DebugInfo.getWhereWeWereCalledFrom() + "\n");
        out.write(" */\n");
        out.write("public class " + typeName + "IterableDMW extends DmwObjectIterator<" + typeName + suffix + args + ", " + typeName + "DMO" + args + "> {\n");
        out.write("\n");
        out.write("    public final static " + typeName + "IterableDMW emptyList = new " + typeName + "IterableDMW();\n");
        out.write("\n");
        out.write("    protected " + typeName + "IterableDMW(){\n");
        out.write("        super();\n");
        out.write("    }\n");
        out.write("\n");
        out.write("    public " + typeName + "IterableDMW(Iterator<" + typeName + "DMO" + args + "> it){\n");
        out.write("        super(it);\n");
        out.write("    }\n");
        out.write("\n");
        out.write("}\n\n");
        ((BufferedWriter)out).close();
    }

    public static void dumpIterableREF(String dmwdir, String basePackage, String className, boolean extended, String extendedPackage, String fileHeader, PrintStream progress) throws IOException {
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(dmwdir, className + "IterableDMW.java");
        if (fileHeader != null) {
            out.write(fileHeader);
        }
        String CAST = className + "DMW";
        String REF = className + "REF";
        out.write("package " + basePackage + ".generated.dmw;\n\n");
        ImportManager imports = new ImportManager();
        imports.addImport("java.util.Iterator", "Because we're iterating!");
        imports.addImport("org.dmd.dmw.DmwContainerIterator", "Because we're extending the parameterized class");
        imports.addImport(basePackage + ".generated.types." + className + "REF", "To access our reference type");
        if (extended) {
            imports.addImport(extendedPackage + "." + className, "Because " + className + " uses extended wrappers");
            CAST = className;
        } else {
            imports.addImport(basePackage + ".generated.dmw." + className + "DMW", "Because " + className + " is not extended");
        }
        out.write(imports.getFormattedImports() + "\n");
        out.write("/**\n");
        out.write(" * The " + className + "IteratorDMW will cast from an underlying " + REF + " class to \n");
        out.write(" * the associated wrapper class: " + CAST + " when accessing object references in a wrapper context.\n");
        out.write(" * <P>\n");
        out.write(" * This code was auto-generated by the dmggenerator utility and shouldn't be altered manually!\n");
        out.write(" * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write(" */\n");
        out.write("public class " + className + "IterableDMW extends DmwContainerIterator<" + CAST + "," + REF + "> {\n");
        out.write("\n");
        out.write("    public final static " + className + "IterableDMW emptyList = new " + className + "IterableDMW();\n");
        out.write("\n");
        out.write("    protected " + className + "IterableDMW(){\n");
        out.write("        super();\n");
        out.write("    }\n");
        out.write("\n");
        out.write("    public " + className + "IterableDMW(Iterator<" + REF + "> it){\n");
        out.write("        super(it);\n");
        out.write("    }\n");
        out.write("\n");
        out.write("}\n\n");
        ((BufferedWriter)out).close();
    }

    public static void dumpSVType(String dmotypedir, String basePackage, String baseTypeImport, String typeName, String dmcTypeImport, String nameAttrImport, String nameAttr, String nameAttrID, String genericArgs, boolean isRef, boolean isNameType, boolean isFilterType, String fileHeader, PrintStream progress) throws IOException {
        String DMO = "";
        String REF = "";
        boolean dmoREF = false;
        if (nameAttr == null && isRef) {
            DMO = "DMO";
            REF = "REF";
            dmoREF = true;
        }
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(dmotypedir, "DmcType" + typeName + REF + "SV.java");
        if (fileHeader != null) {
            out.write(fileHeader);
        }
        out.write("package " + basePackage + ".generated.types;\n\n");
        out.write("import java.io.Serializable;\n");
        out.write("import org.dmd.dmc.DmcAttribute;\n");
        out.write("import org.dmd.dmc.DmcAttributeInfo;\n");
        out.write("import org.dmd.dmc.DmcValueException;\n");
        if (baseTypeImport != null && !baseTypeImport.endsWith("DmcAttribute")) {
            out.write("import " + baseTypeImport + ";    // base type import\n");
        }
        if (dmcTypeImport != null) {
            out.write("import " + dmcTypeImport + DMO + ";    // DmcType import\n");
        }
        out.write("/**\n");
        out.write(" * The DmcType" + typeName + REF + "SV provides storage for a single-valued " + typeName + "\n");
        out.write(" * <P>\n");
        out.write(" * This code was auto-generated and shouldn't be altered manually!\n");
        out.write(" * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write(" *    " + DebugInfo.getWhereWeWereCalledFrom() + "\n");
        out.write(" */\n");
        out.write("@SuppressWarnings(\"serial\")\n");
        out.write("public class DmcType" + typeName + REF + "SV extends DmcType" + typeName + REF + " implements Serializable {\n");
        out.write("    \n");
        out.write("    protected " + typeName + DMO + genericArgs + " value;\n");
        out.write("    \n");
        out.write("    public DmcType" + typeName + REF + "SV(){\n");
        out.write("    \n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    public DmcType" + typeName + REF + "SV(DmcAttributeInfo ai){\n");
        out.write("        super(ai);\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    public DmcType" + typeName + REF + "SV getNew(){\n");
        out.write("        return(new DmcType" + typeName + REF + "SV(getAttributeInfo()));\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    public DmcType" + typeName + REF + "SV getNew(DmcAttributeInfo ai){\n");
        out.write("        return(new DmcType" + typeName + REF + "SV(ai));\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    @Override\n");
        out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        if (dmoREF) {
            out.write("    public DmcAttribute<" + typeName + DMO + genericArgs + "> cloneIt(){\n");
        } else {
            out.write("    public DmcAttribute<" + typeName + REF + genericArgs + "> cloneIt(){\n");
        }
        out.write("        DmcType" + typeName + REF + "SV rc = getNew();\n");
        out.write("        rc.value = value;\n");
        out.write("        return(rc);\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        if (dmoREF) {
            out.write("    public " + typeName + DMO + genericArgs + " getSVCopy(){\n");
        } else {
            out.write("    public " + typeName + REF + genericArgs + " getSVCopy(){\n");
        }
        out.write("        if (value == null)\n");
        out.write("            return(null);\n");
        out.write("        return(cloneValue(value));\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    @Override\n");
        out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    public " + typeName + DMO + genericArgs + " set(Object v) throws DmcValueException {\n");
        out.write("        " + typeName + DMO + genericArgs + " rc = typeCheck(v);\n");
        out.write("        // We only return a value if the value actually changed. This supports\n");
        out.write("        // the applyModifier() mechanism on DmcObject where we only return true\n");
        out.write("        // if something changed as a result of the modifier\n");
        out.write("        if (value == null)\n");
        out.write("            value = rc;\n");
        out.write("        else{\n");
        out.write("            if (value.equals(rc))\n");
        out.write("                rc = null;\n");
        out.write("            else\n");
        out.write("                value = rc;\n");
        out.write("        }\n");
        out.write("        return(rc);\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    @Override\n");
        out.write("    public " + typeName + DMO + genericArgs + " getSV(){\n");
        out.write("        return(value);\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    @Override\n");
        out.write("    public int getMVSize(){\n");
        out.write("        return(0);\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("}\n\n");
        ((BufferedWriter)out).close();
        GenUtility.dumpSTATICType(dmotypedir, basePackage, baseTypeImport, typeName, dmcTypeImport, nameAttrImport, nameAttr, nameAttrID, genericArgs, isRef, isNameType, isFilterType, fileHeader, progress);
        AdapterFormatter.dumpAdapterSV(dmotypedir, typeName, basePackage, REF);
    }

    public static void dumpSTATICType(String dmotypedir, String basePackage, String baseTypeImport, String typeName, String dmcTypeImport, String nameAttrImport, String nameAttr, String nameAttrID, String genericArgs, boolean isRef, boolean isNameType, boolean isFilterType, String fileHeader, PrintStream progress) throws IOException {
        String DMO = "";
        String REF = "";
        if (nameAttr == null && isRef) {
            return;
        }
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(dmotypedir, "DmcType" + typeName + REF + "STATIC.java");
        if (fileHeader != null) {
            out.write(fileHeader);
        }
        out.write("package " + basePackage + ".generated.types;\n\n");
        out.write("import org.dmd.dmc.DmcValueException;\n");
        out.write("import org.dmd.dmc.DmcInputStreamIF;\n");
        out.write("import org.dmd.dmc.DmcOutputStreamIF;\n");
        if (isNameType) {
            out.write("import org.dmd.dmc.DmcAttributeInfo;\n");
            out.write("import org.dmd.dmc.DmcObjectName;\n");
            out.write("import org.dmd.dmc.DmcNameBuilderIF;\n");
            out.write("import org.dmd.dmc.types.DmcTypeDmcObjectName;\n");
        }
        if (isFilterType) {
            out.write("import org.dmd.dmc.DmcAttributeInfo;\n");
            out.write("import org.dmd.dmc.DmcFilter;\n");
            out.write("import org.dmd.dmc.DmcFilterBuilderIF;\n");
            out.write("import org.dmd.dmc.types.DmcTypeDmcFilter;\n");
        }
        if (baseTypeImport != null && baseTypeImport.indexOf("DmcType") == -1) {
            out.write("import " + baseTypeImport + ";    // base type import\n");
        }
        if (dmcTypeImport != null && dmcTypeImport.endsWith("Enum")) {
            out.write("import " + dmcTypeImport + DMO + ";    // DmcType import\n");
        }
        out.write("\n");
        out.write("/**\n");
        out.write(" * The DmcType" + typeName + REF + "STATIC provides static access to functions used to manage values of type " + typeName + "\n");
        out.write(" * These methods are used to support ComplexTypeDefinitions.\n");
        out.write(" * <P>\n");
        out.write(" * This code was auto-generated and shouldn't be altered manually!\n");
        out.write(" * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write(" *    " + DebugInfo.getWhereWeWereCalledFrom() + "\n");
        out.write(" */\n");
        if (isNameType) {
            out.write("public class DmcType" + typeName + REF + "STATIC implements DmcNameBuilderIF {\n");
        } else if (isFilterType) {
            out.write("public class DmcType" + typeName + REF + "STATIC implements DmcFilterBuilderIF {\n");
        } else {
            out.write("public class DmcType" + typeName + REF + "STATIC {\n");
        }
        out.write("    \n");
        out.write("    public static DmcType" + typeName + REF + "STATIC instance;\n");
        out.write("    static DmcType" + typeName + REF + "SV typeHelper;\n");
        if (isNameType) {
            out.write("    static String    nameClass = \"" + typeName + "\";\n");
            out.write("    static final int attrID    = " + nameAttrID + ";\n");
        }
        if (isFilterType) {
            out.write("    static String    filterClass = \"" + typeName + "\";\n");
            out.write("    static final int attrID      = " + nameAttrID + ";\n");
        }
        out.write("    \n");
        out.write("    static {\n");
        out.write("        instance = new DmcType" + typeName + REF + "STATIC();\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    protected DmcType" + typeName + REF + "STATIC() {\n");
        out.write("        typeHelper = new DmcType" + typeName + REF + "SV();\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    public " + typeName + REF + genericArgs + " typeCheck(Object value) throws DmcValueException {\n");
        out.write("    \t   return(typeHelper.typeCheck(value));\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    public " + typeName + REF + genericArgs + " cloneValue(" + typeName + REF + genericArgs + " value) throws DmcValueException {\n");
        out.write("    \t   return(typeHelper.cloneValue(value));\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    public void serializeValue(DmcOutputStreamIF dos, " + typeName + REF + genericArgs + " value) throws Exception {\n");
        out.write("    \t   typeHelper.serializeValue(dos, value);\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    public " + typeName + REF + genericArgs + " deserializeValue(DmcInputStreamIF dis) throws Exception {\n");
        out.write("    \t   return(typeHelper.deserializeValue(dis));\n");
        out.write("    }\n");
        out.write("    \n");
        if (isNameType) {
            out.write("    @Override\n");
            out.write("    public DmcTypeDmcObjectName<?> getNewNameHolder(DmcObjectName name, DmcAttributeInfo ai){\n");
            out.write("        DmcTypeDmcObjectName<?> rc = typeHelper.getNew(ai);\n");
            out.write("        try {\n");
            out.write("            rc.set(name);\n");
            out.write("        } catch (DmcValueException e) {\n");
            out.write("            throw(new IllegalStateException(\"Shouldn't throw exception when setting a name attribute value in a DmcNameBuilderIF - occurred for type: \" + name.getNameClass(), e));\n");
            out.write("        }\n");
            out.write("        return(rc);\n");
            out.write("    }\n");
            out.write("    \n");
            out.write("    @Override\n");
            out.write("    public String getNameClass(){\n");
            out.write("    \t   return(nameClass);\n");
            out.write("    }\n");
            out.write("    \n");
            out.write("    @Override\n");
            out.write("    public int getNameAttributeID(){\n");
            out.write("    \t   return(attrID);\n");
            out.write("    }\n");
            out.write("    \n");
        }
        if (isFilterType) {
            out.write("    @Override\n");
            out.write("    public DmcTypeDmcFilter<?> getNewFilterHolder(DmcFilter filter, DmcAttributeInfo ai){\n");
            out.write("        DmcTypeDmcFilter<?> rc = typeHelper.getNew(ai);\n");
            out.write("        try {\n");
            out.write("            rc.set(filter);\n");
            out.write("        } catch (DmcValueException e) {\n");
            out.write("            throw(new IllegalStateException(\"Shouldn't throw exception when setting a filter attribute value in a DmcFilterBuilderIF - occurred for type: \" + filter.getFilterClass(), e));\n");
            out.write("        }\n");
            out.write("        return(rc);\n");
            out.write("    }\n");
            out.write("    \n");
            out.write("    @Override\n");
            out.write("    public String getFilterClass(){\n");
            out.write("    \t   return(filterClass);\n");
            out.write("    }\n");
            out.write("    \n");
            out.write("    @Override\n");
            out.write("    public int getFilterAttributeID(){\n");
            out.write("    \t   return(attrID);\n");
            out.write("    }\n");
            out.write("    \n");
        }
        out.write("}\n\n");
        ((BufferedWriter)out).close();
    }

    public static void dumpMVType(String dmotypedir, String basePackage, String baseTypeImport, String typeName, String dmcTypeImport, String nameAttrImport, String nameAttr, String genericArgs, boolean isRef, String fileHeader, PrintStream progress) throws IOException {
        String DMO = "";
        String REF = "";
        boolean dmoREF = false;
        if (nameAttr == null && isRef) {
            DMO = "DMO";
            REF = "REF";
            dmoREF = true;
        }
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(dmotypedir, "DmcType" + typeName + REF + "MV.java");
        if (fileHeader != null) {
            out.write(fileHeader);
        }
        out.write("package " + basePackage + ".generated.types;\n\n");
        out.write("import java.io.Serializable;\n");
        out.write("import java.util.ArrayList;\n");
        out.write("import java.util.Iterator;\n");
        out.write("import org.dmd.dmc.DmcAttribute;\n");
        out.write("import org.dmd.dmc.DmcAttributeInfo;\n");
        out.write("import org.dmd.dmc.DmcValueException;\n");
        if (typeName.equals("Modifier")) {
            out.write("import org.dmd.dms.generated.dmo.MetaDMSAG;\n");
        }
        if (baseTypeImport != null && !baseTypeImport.endsWith("DmcAttribute")) {
            out.write("import " + baseTypeImport + ";    // base type import\n");
        }
        if (dmcTypeImport != null) {
            out.write("import " + dmcTypeImport + DMO + ";    // DmcType import\n");
        }
        out.write("/**\n");
        out.write(" * The DmcType" + typeName + REF + "MV provides storage for a multi-valued " + typeName + "\n");
        out.write(" * <P>\n");
        out.write(" * This code was auto-generated and shouldn't be altered manually!\n");
        out.write(" * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write(" *    " + DebugInfo.getWhereWeWereCalledFrom() + "\n");
        out.write(" */\n");
        out.write("@SuppressWarnings(\"serial\")\n");
        out.write("public class DmcType" + typeName + REF + "MV extends DmcType" + typeName + REF + " implements Serializable {\n");
        out.write("    \n");
        out.write("    private final static Iterator<" + typeName + DMO + genericArgs + "> emptyList = (new ArrayList<" + typeName + DMO + genericArgs + ">()).iterator();\n");
        out.write("    \n");
        out.write("    protected ArrayList<" + typeName + DMO + genericArgs + "> value;\n");
        out.write("    \n");
        out.write("    public DmcType" + typeName + REF + "MV(){\n");
        if (typeName.equals("Modifier")) {
            out.write("        super(MetaDMSAG.__modify);\n");
        }
        out.write("    \n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    public DmcType" + typeName + REF + "MV(DmcAttributeInfo ai){\n");
        out.write("        super(ai);\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    @Override\n");
        out.write("    public DmcType" + typeName + REF + "MV getNew(){\n");
        out.write("        return(new DmcType" + typeName + REF + "MV(getAttributeInfo()));\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    @Override\n");
        out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        if (dmoREF) {
            out.write("    public DmcAttribute<" + typeName + DMO + genericArgs + "> cloneIt(){\n");
        } else {
            out.write("    public DmcAttribute<" + typeName + REF + genericArgs + "> cloneIt(){\n");
        }
        out.write("        synchronized(this){\n");
        out.write("            DmcType" + typeName + REF + "MV rc = getNew();\n");
        out.write("    \n");
        out.write("            if (value == null)\n");
        out.write("                return(rc);\n");
        out.write("    \n");
        out.write("            if (getAttributeInfo().indexSize == 0){\n");
        out.write("                for(" + typeName + DMO + genericArgs + " val: value)\n");
        out.write("                try {\n");
        out.write("                    rc.add(val);\n");
        out.write("                } catch (DmcValueException e) {\n");
        out.write("                    throw(new IllegalStateException(\"typeCheck() should never fail here!\",e));\n");
        out.write("                }\n");
        out.write("            }\n");
        out.write("            else{\n");
        out.write("                for(int index=0; index<value.size(); index++)\n");
        out.write("                    try {\n");
        out.write("                        rc.setMVnth(index, value.get(index));\n");
        out.write("                    } catch (DmcValueException e) {\n");
        out.write("                        throw(new IllegalStateException(\"typeCheck() should never fail here!\",e));\n");
        out.write("                    }\n");
        out.write("            }\n");
        out.write("            return(rc);\n");
        out.write("        }\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    @Override\n");
        out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    public " + typeName + DMO + genericArgs + " add(Object v) throws DmcValueException {\n");
        out.write("        synchronized(this){\n");
        out.write("            " + typeName + DMO + genericArgs + " rc = typeCheck(v);\n");
        out.write("            if (value == null)\n");
        out.write("                value = new ArrayList<" + typeName + DMO + genericArgs + ">();\n");
        out.write("            value.add(rc);\n");
        out.write("            return(rc);\n");
        out.write("        }\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    @Override\n");
        out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    public " + typeName + DMO + genericArgs + " del(Object v){\n");
        out.write("        synchronized(this){\n");
        out.write("            if (value == null)\n");
        out.write("                return(null);\n");
        out.write("    \n");
        out.write("            " + typeName + DMO + genericArgs + " key = null;\n");
        out.write("            " + typeName + DMO + genericArgs + " rc = null;\n");
        out.write("            try {\n");
        out.write("                key = typeCheck(v);\n");
        out.write("            } catch (DmcValueException e) {\n");
        out.write("                throw(new IllegalStateException(\"Incompatible type passed to del():\" + getName(),e));\n");
        out.write("            }\n");
        out.write("            int indexof = value.indexOf(key);\n");
        out.write("            if (indexof != -1){\n");
        out.write("                rc = value.get(indexof);\n");
        out.write("                value.remove(rc);\n");
        out.write("            }\n\n");
        out.write("            return(rc);\n");
        out.write("        }\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    @Override\n");
        out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    public Iterator<" + typeName + DMO + genericArgs + "> getMV(){\n");
        out.write("        synchronized(this){\n");
        out.write("            if (value == null)\n");
        out.write("                return(emptyList);\n");
        out.write("    \n");
        out.write("            ArrayList<" + typeName + DMO + genericArgs + "> clone = new ArrayList<" + typeName + DMO + genericArgs + ">(value);\n");
        out.write("            return(clone.iterator());\n");
        out.write("        }\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    public ArrayList<" + typeName + DMO + genericArgs + "> getMVCopy(){\n");
        out.write("        synchronized(this){\n");
        out.write("            if (value == null)\n");
        out.write("                return(new ArrayList<" + typeName + DMO + genericArgs + ">());\n");
        out.write("            else \n");
        out.write("                return(new ArrayList<" + typeName + DMO + genericArgs + ">(value));\n");
        out.write("        }\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    @Override\n");
        out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    public int getMVSize(){\n");
        out.write("        synchronized(this){\n");
        out.write("            if (getAttributeInfo().indexSize == 0){\n");
        out.write("                if (value == null)\n");
        out.write("                    return(0);\n");
        out.write("                return(value.size());\n");
        out.write("            }\n");
        out.write("            else\n");
        out.write("                return(getAttributeInfo().indexSize);\n");
        out.write("        }\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    @Override\n");
        out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    public " + typeName + DMO + genericArgs + " getMVnth(int index){\n");
        out.write("        synchronized(this){\n");
        out.write("            if (value == null)\n");
        out.write("                return(null);\n");
        out.write("            return(value.get(index));\n");
        out.write("        }\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    @Override\n");
        out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    public " + typeName + DMO + genericArgs + " setMVnth(int index, Object v) throws DmcValueException {\n");
        out.write("        synchronized(this){\n");
        out.write("            if (getAttributeInfo().indexSize == 0)\n");
        out.write("                throw(new IllegalStateException(\"Attribute: \" + getAttributeInfo().name + \" is not indexed. You can't use setMVnth().\"));\n");
        out.write("            \n");
        out.write("            if ( (index < 0) || (index >= getAttributeInfo().indexSize))\n");
        out.write("                throw(new IllegalStateException(\"Index \" + index + \" for attribute: \" + getAttributeInfo().name + \" is out of range: 0 <= index < \" + getAttributeInfo().indexSize));\n");
        out.write("            \n");
        out.write("            " + typeName + DMO + genericArgs + " rc = null;\n");
        out.write("            \n");
        out.write("            if (v != null)\n");
        out.write("                rc = typeCheck(v);\n");
        out.write("            \n");
        out.write("            if (value == null){\n");
        out.write("                value = new ArrayList<" + typeName + DMO + genericArgs + ">(getAttributeInfo().indexSize);\n");
        out.write("                for(int i=0;i<getAttributeInfo().indexSize;i++)\n");
        out.write("                    value.add(null);\n");
        out.write("            }\n");
        out.write("            \n");
        out.write("            value.set(index, rc);\n");
        out.write("            \n");
        out.write("            return(rc);\n");
        out.write("        }\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    @Override\n");
        out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    public boolean hasValue(){\n");
        out.write("        synchronized(this){\n");
        out.write("            boolean rc = false;\n");
        out.write("            \n");
        out.write("            if (getAttributeInfo().indexSize == 0)\n");
        out.write("                throw(new IllegalStateException(\"Attribute: \" + getAttributeInfo().name + \" is not indexed. You can't use hasValue().\"));\n");
        out.write("            \n");
        out.write("            if (value == null)\n");
        out.write("                return(rc);\n");
        out.write("            \n");
        out.write("            for(int i=0; i<value.size(); i++){\n");
        out.write("                if (value.get(i) != null){\n");
        out.write("                    rc = true;\n");
        out.write("                    break;\n");
        out.write("                }\n");
        out.write("            }\n");
        out.write("            \n");
        out.write("            return(rc);\n");
        out.write("        }\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    @Override\n");
        out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    public boolean contains(Object v){\n");
        out.write("        synchronized(this){\n");
        out.write("            if (value == null)\n");
        out.write("                return(false);\n");
        out.write("\n");
        out.write("            try {\n");
        out.write("                " + typeName + DMO + genericArgs + " val = typeCheck(v);\n");
        out.write("                return(value.contains(val));\n");
        out.write("            } catch (DmcValueException e) {\n");
        out.write("                return(false);\n");
        out.write("            }\n");
        out.write("        }\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("}\n\n");
        ((BufferedWriter)out).close();
        AdapterFormatter.dumpAdapterMV(dmotypedir, typeName, basePackage, REF);
    }

    public static void dumpSETType(String dmotypedir, String basePackage, String baseTypeImport, String typeName, String dmcTypeImport, String nameAttrImport, String nameAttr, String genericArgs, boolean isRef, String fileHeader, PrintStream progress) throws IOException {
        String DMO = "";
        String REF = "";
        boolean dmoREF = false;
        if (nameAttr == null && isRef) {
            DMO = "DMO";
            REF = "REF";
            dmoREF = true;
        }
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(dmotypedir, "DmcType" + typeName + REF + "SET.java");
        if (fileHeader != null) {
            out.write(fileHeader);
        }
        out.write("package " + basePackage + ".generated.types;\n\n");
        out.write("import java.io.Serializable;\n");
        out.write("import java.util.Set;\n");
        out.write("import java.util.HashSet;\n");
        out.write("import java.util.TreeSet;\n");
        out.write("import java.util.Iterator;\n");
        out.write("import org.dmd.dmc.DmcAttribute;\n");
        out.write("import org.dmd.dmc.DmcAttributeInfo;\n");
        out.write("import org.dmd.dmc.DmcValueException;\n");
        out.write("import org.dmd.dms.generated.enums.ValueTypeEnum;\n");
        if (baseTypeImport != null && !baseTypeImport.endsWith("DmcAttribute")) {
            out.write("import " + baseTypeImport + ";    // base type import\n");
        }
        if (dmcTypeImport != null && !dmcTypeImport.endsWith("ValueTypeEnum")) {
            out.write("import " + dmcTypeImport + DMO + ";    // DmcType import\n");
        }
        out.write("/**\n");
        out.write(" * The DmcType" + typeName + REF + "SET provides storage for a set of " + typeName + DMO + "\n");
        out.write(" * <P>\n");
        out.write(" * This code was auto-generated and shouldn't be altered manually!\n");
        out.write(" * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write(" *    " + DebugInfo.getWhereWeWereCalledFrom() + "\n");
        out.write(" */\n");
        out.write("@SuppressWarnings(\"serial\")\n");
        out.write("public class DmcType" + typeName + REF + "SET extends DmcType" + typeName + REF + " implements Serializable {\n");
        out.write("    \n");
        out.write("     private final static Iterator<" + typeName + DMO + genericArgs + "> emptyList =  (new HashSet<" + typeName + DMO + genericArgs + ">()).iterator();\n");
        out.write("    \n");
        out.write("    \n");
        out.write("    protected Set<" + typeName + DMO + genericArgs + "> value;\n");
        out.write("    \n");
        out.write("    public DmcType" + typeName + REF + "SET(){\n");
        out.write("        value = null;\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    public DmcType" + typeName + REF + "SET(DmcAttributeInfo ai){\n");
        out.write("        super(ai);\n");
        out.write("        initValue();\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    void initValue(){\n");
        out.write("        if (getAttributeInfo().valueType == ValueTypeEnum.HASHSET)\n");
        out.write("            value = new HashSet<" + typeName + DMO + genericArgs + ">();\n");
        out.write("        else\n");
        out.write("            value = new TreeSet<" + typeName + DMO + genericArgs + ">();\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    @Override\n");
        out.write("    public DmcType" + typeName + REF + "SET getNew(){\n");
        out.write("        return(new DmcType" + typeName + REF + "SET(getAttributeInfo()));\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    @Override\n");
        out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        if (dmoREF) {
            out.write("    public DmcAttribute<" + typeName + DMO + genericArgs + "> cloneIt(){\n");
        } else {
            out.write("    public DmcAttribute<" + typeName + REF + genericArgs + "> cloneIt(){\n");
        }
        out.write("        synchronized(this){\n");
        out.write("            DmcType" + typeName + REF + "SET rc = getNew();\n");
        out.write("    \n");
        out.write("            if (value == null)\n");
        out.write("                return(rc);\n");
        out.write("    \n");
        out.write("            for(" + typeName + DMO + genericArgs + " val: value)\n");
        out.write("            try {\n");
        out.write("                rc.add(val);\n");
        out.write("            } catch (DmcValueException e) {\n");
        out.write("                throw(new IllegalStateException(\"typeCheck() should never fail here!\",e));\n");
        out.write("            }\n");
        out.write("            return(rc);\n");
        out.write("       }\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    @Override\n");
        out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    public " + typeName + DMO + genericArgs + " add(Object v) throws DmcValueException {\n");
        out.write("        synchronized(this){\n");
        out.write("            " + typeName + DMO + genericArgs + " rc = typeCheck(v);\n");
        out.write("            if (value == null)\n");
        out.write("                initValue();\n");
        out.write("        \n");
        out.write("            // If false is returned, we didn't modify the set, so return null\n");
        out.write("            if (!value.add(rc))\n");
        out.write("                rc = null;\n");
        out.write("        \n");
        out.write("            return(rc);\n");
        out.write("        }\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    @Override\n");
        out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    public " + typeName + DMO + genericArgs + " del(Object v){\n");
        out.write("        synchronized(this){\n");
        out.write("            " + typeName + DMO + genericArgs + " rc = null;\n");
        out.write("            if (value == null)\n");
        out.write("                return(rc);\n");
        out.write("            \n");
        out.write("            try {\n");
        out.write("                rc = typeCheck(v);\n");
        out.write("            } catch (DmcValueException e) {\n");
        out.write("                throw(new IllegalStateException(\"Incompatible type passed to del():\" + getName(),e));\n");
        out.write("            }\n");
        out.write("            if (value.contains(rc)){\n");
        out.write("                value.remove(rc);\n");
        out.write("                if (value.size() == 0)\n");
        out.write("                    value = null;\n");
        out.write("            }\n");
        out.write("            else\n");
        out.write("                rc = null;\n");
        out.write("            return(rc);\n");
        out.write("        }\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    @Override\n");
        out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    public Iterator<" + typeName + DMO + genericArgs + "> getMV(){\n");
        out.write("        synchronized(this){\n");
        out.write("            if (value == null)\n");
        out.write("                return(emptyList);\n");
        out.write("\n");
        out.write("            if (getAttributeInfo().valueType == ValueTypeEnum.HASHSET)\n");
        out.write("                return( (new HashSet<" + typeName + DMO + genericArgs + ">(value)).iterator() );\n");
        out.write("            else\n");
        out.write("                return( (new TreeSet<" + typeName + DMO + genericArgs + ">(value)).iterator() );\n");
        out.write("        }\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    public Set<" + typeName + DMO + genericArgs + "> getMVCopy(){\n");
        out.write("        synchronized(this){\n");
        out.write("            if (getAttributeInfo().valueType == ValueTypeEnum.HASHSET){\n");
        out.write("                if (value == null)\n");
        out.write("                    return(new HashSet<" + typeName + DMO + genericArgs + ">());\n");
        out.write("                else\n");
        out.write("                    return(new HashSet<" + typeName + DMO + genericArgs + ">(value));\n");
        out.write("            }\n");
        out.write("            else{\n");
        out.write("                if (value == null)\n");
        out.write("                    return(new TreeSet<" + typeName + DMO + genericArgs + ">(value));\n");
        out.write("                else\n");
        out.write("                    return(new TreeSet<" + typeName + DMO + genericArgs + ">(value));\n");
        out.write("            }\n");
        out.write("        }\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    @Override\n");
        out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    public int getMVSize(){\n");
        out.write("        synchronized(this){\n");
        out.write("            if (value == null)\n");
        out.write("                return(0);\n");
        out.write("            return(value.size());\n");
        out.write("        }\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    @Override\n");
        out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    public boolean contains(Object v){\n");
        out.write("        synchronized(this){\n");
        out.write("            if (value == null)\n");
        out.write("                return(false);\n");
        out.write("            \n");
        out.write("            try {\n");
        out.write("                " + typeName + DMO + genericArgs + " val = typeCheck(v);\n");
        out.write("                return(value.contains(val));\n");
        out.write("            } catch (DmcValueException e) {\n");
        out.write("                return(false);\n");
        out.write("            }\n");
        out.write("        }\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("}\n\n");
        ((BufferedWriter)out).close();
        AdapterFormatter.dumpAdapterSET(dmotypedir, typeName, basePackage, REF);
    }

    public static void dumpMAPType(String dmotypedir, String basePackage, String baseTypeImport, String typeName, String primitiveImport, String nameAttrImport, String nameAttr, String genericArgs, String keyClass, String keyImport, String fileHeader, PrintStream progress) throws IOException {
        AdapterFormatter.dumpAdapterMAP(dmotypedir, typeName, basePackage);
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(dmotypedir, "DmcType" + typeName + "MAP.java");
        if (fileHeader != null) {
            out.write(fileHeader);
        }
        out.write("package " + basePackage + ".generated.types;\n\n");
        out.write("import java.io.Serializable;\n");
        out.write("import java.util.Map;\n");
        out.write("import java.util.HashMap;\n");
        out.write("import java.util.TreeMap;\n");
        out.write("import java.util.Iterator;\n");
        out.write("import org.dmd.dmc.DmcAttribute;\n");
        out.write("import org.dmd.dmc.DmcAttributeInfo;\n");
        out.write("import org.dmd.dmc.DmcValueException;\n");
        out.write("import org.dmd.dmc.DmcMappedAttributeIF;\n");
        out.write("import org.dmd.dms.generated.enums.ValueTypeEnum;\n");
        if (baseTypeImport != null) {
            out.write("import " + baseTypeImport + ";    // base type import\n");
        }
        if (primitiveImport != null && !primitiveImport.endsWith("DmcAttribute")) {
            out.write("import " + primitiveImport + ";    // primitive import\n");
        }
        if (keyImport != null) {
            out.write("import " + keyImport + ";    // key type import\n");
        }
        out.write("/**\n");
        out.write(" * The DmcType" + typeName + "MAP provides storage for a map of " + typeName + "\n");
        out.write(" * <P>\n");
        out.write(" * This code was auto-generated and shouldn't be altered manually!\n");
        out.write(" * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write(" *    " + DebugInfo.getWhereWeWereCalledFrom() + "\n");
        out.write(" */\n");
        out.write("@SuppressWarnings(\"serial\")\n");
        if (nameAttr == null) {
            out.write("// public class DmcType" + typeName + "MAP extends DmcType" + typeName + "<" + typeName + "> {\n");
            out.write("public class DmcType" + typeName + "MAP extends DmcType" + typeName + " implements Serializable {\n");
        } else {
            out.write("// public class DmcType" + typeName + "MAP extends DmcType" + typeName + "<" + typeName + "," + nameAttr + "> {\n");
            out.write("public class DmcType" + typeName + "MAP extends DmcType" + typeName + " implements Serializable {\n");
        }
        out.write("    \n");
        out.write("    private final static Iterator<" + typeName + genericArgs + "> emptyList = (new HashMap<" + keyClass + "," + typeName + genericArgs + ">()).values().iterator();\n");
        out.write("    \n");
        out.write("    protected Map<" + keyClass + "," + typeName + genericArgs + "> value;\n");
        out.write("    \n");
        out.write("    public DmcType" + typeName + "MAP(){\n");
        out.write("        value = null;\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    public DmcType" + typeName + "MAP(DmcAttributeInfo ai){\n");
        out.write("        super(ai);\n");
        out.write("        initValue();\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    void initValue(){\n");
        out.write("        if (getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED)\n");
        out.write("            value = new HashMap<" + keyClass + "," + typeName + genericArgs + ">();\n");
        out.write("        else\n");
        out.write("            value = new TreeMap<" + keyClass + "," + typeName + genericArgs + ">();\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    public " + keyClass + " firstKey(){\n");
        out.write("        if (getAttributeInfo().valueType == ValueTypeEnum.TREEMAPPED){\n");
        out.write("            if (value == null)\n");
        out.write("                return(null);\n");
        out.write("            TreeMap<" + keyClass + "," + typeName + genericArgs + "> map = (TreeMap<" + keyClass + "," + typeName + genericArgs + ">)value;\n");
        out.write("            return(map.firstKey());\n");
        out.write("        }\n");
        out.write("        throw(new IllegalStateException(\"Attribute \" + getAttributeInfo().name + \" is HASHMAPPED and doesn't support firstKey()\"));\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    @Override\n");
        out.write("    public DmcType" + typeName + "MAP getNew(){\n");
        out.write("        return(new DmcType" + typeName + "MAP(getAttributeInfo()));\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    @Override\n");
        out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    public DmcAttribute<" + typeName + genericArgs + "> cloneIt(){\n");
        out.write("        synchronized(this){\n");
        out.write("            DmcType" + typeName + "MAP rc = getNew();\n");
        out.write("    \n");
        out.write("            if (value == null)\n");
        out.write("                return(rc);\n");
        out.write("    \n");
        out.write("            for(" + typeName + genericArgs + " val: value.values())\n");
        out.write("            try {\n");
        out.write("                rc.add(val);\n");
        out.write("            } catch (DmcValueException e) {\n");
        out.write("                throw(new IllegalStateException(\"typeCheck() should never fail here!\",e));\n");
        out.write("            }\n");
        out.write("            return(rc);\n");
        out.write("        }\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    @Override\n");
        out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    public " + typeName + genericArgs + " add(Object v) throws DmcValueException {\n");
        out.write("        synchronized(this){\n");
        out.write("            " + typeName + genericArgs + " newval = typeCheck(v);\n");
        out.write("            if (value == null)\n");
        out.write("                initValue();\n");
        out.write("            " + keyClass + " key = (" + keyClass + ")((DmcMappedAttributeIF)newval).getKey();\n");
        out.write("            " + typeName + genericArgs + " oldval = value.put(key,newval);\n");
        out.write("            \n");
        out.write("            if (oldval != null){\n");
        out.write("                // We had a value with this key, ensure that the value actually changed\n");
        out.write("                if (oldval.valuesAreEqual(newval))\n");
        out.write("                    newval = null;\n");
        out.write("            }\n");
        out.write("            \n");
        out.write("            return(newval);\n");
        out.write("        }\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    @Override\n");
        out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    public " + typeName + genericArgs + " del(Object key){\n");
        out.write("        synchronized(this){\n");
        out.write("    \n");
        out.write("            if (value == null)\n");
        out.write("                return(null);\n");
        out.write("    \n");
        out.write("           if (key instanceof " + keyClass + ")\n");
        out.write("                return(value.remove(key));\n");
        out.write("            else\n");
        out.write("                throw(new IllegalStateException(\"Incompatible key type: \" + key.getClass().getName() + \" passed to del():\" + getName()));\n");
        out.write("        }\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    @Override\n");
        out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    public Iterator<" + typeName + genericArgs + "> getMV(){\n");
        out.write("        synchronized(this){\n");
        out.write("    \n");
        out.write("            if (value == null)\n");
        out.write("                return(emptyList);\n");
        out.write("    \n");
        out.write("            Map<" + keyClass + "," + typeName + genericArgs + "> clone = null;\n");
        out.write("            if (getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED)\n");
        out.write("                clone = new HashMap<" + keyClass + "," + typeName + genericArgs + ">(value);\n");
        out.write("            else\n");
        out.write("                clone = new TreeMap<" + keyClass + "," + typeName + genericArgs + ">(value);\n");
        out.write("            return(clone.values().iterator());\n");
        out.write("        }\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    public Map<" + keyClass + "," + typeName + genericArgs + "> getMVCopy(){\n");
        out.write("        synchronized(this){\n");
        out.write("            Map<" + keyClass + "," + typeName + genericArgs + "> clone = null;\n");
        out.write("            if (getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED){\n");
        out.write("                if (value == null)\n");
        out.write("                    clone = new HashMap<" + keyClass + "," + typeName + genericArgs + ">();\n");
        out.write("                else\n");
        out.write("                    clone = new HashMap<" + keyClass + "," + typeName + genericArgs + ">(value);\n");
        out.write("            }\n");
        out.write("            else{\n");
        out.write("                if (value == null)\n");
        out.write("                    clone = new TreeMap<" + keyClass + "," + typeName + genericArgs + ">();\n");
        out.write("                else\n");
        out.write("                    clone = new TreeMap<" + keyClass + "," + typeName + genericArgs + ">(value);\n");
        out.write("            }\n");
        out.write("            return(clone);\n");
        out.write("        }\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    @Override\n");
        out.write("    public int getMVSize(){\n");
        out.write("        synchronized(this){\n");
        out.write("            if (value == null)\n");
        out.write("                return(0);\n");
        out.write("            return(value.size());\n");
        out.write("        }\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    @Override\n");
        out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    public " + typeName + genericArgs + " getByKey(Object key){\n");
        out.write("        synchronized(this){\n");
        out.write("           if (value == null)\n");
        out.write("               return(null);\n");
        out.write("    \n");
        out.write("            if (key instanceof " + keyClass + ")\n");
        out.write("                return(value.get((" + keyClass + ") key));\n");
        out.write("            else\n");
        out.write("                throw(new IllegalStateException(\"Incompatible type: \" + key.getClass().getName() + \" passed to del():\" + getName()));\n");
        out.write("        }\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    @Override\n");
        out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    public boolean contains(Object v){\n");
        out.write("        synchronized(this){\n");
        out.write("           if (value == null)\n");
        out.write("               return(false);\n");
        out.write("    \n");
        out.write("            try {\n");
        out.write("                " + typeName + genericArgs + " val = typeCheck(v);\n");
        out.write("                return(value.containsValue(val));\n");
        out.write("            } catch (DmcValueException e) {\n");
        out.write("                return(false);\n");
        out.write("            }\n");
        out.write("        }\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    @Override\n");
        out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    public boolean containsKey(Object key){\n");
        out.write("        synchronized(this){\n");
        out.write("           if (value == null)\n");
        out.write("               return(false);\n");
        out.write("    \n");
        out.write("           if (key instanceof " + keyClass + ")\n");
        out.write("                return(value.containsKey(key));\n");
        out.write("            return(false);\n");
        out.write("        }\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("}\n\n");
        ((BufferedWriter)out).close();
    }

    public static void dumpComplexTypeDmcType(String header, String basePackage, String od, String cn, boolean containsRefs) throws IOException {
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(od, "DmcType" + cn + ".java");
        if (header != null) {
            out.write(header);
        }
        ImportManager imports = new ImportManager();
        out.write("package " + basePackage + ".generated.types;\n\n");
        imports.addImport("java.io.Serializable", "Marker interface for serialization");
        imports.addImport("java.util.Iterator", "For JSON formatting");
        imports.addImport("org.dmd.dmc.DmcInputStreamIF", "To support serialization");
        imports.addImport("org.dmd.dmc.DmcOutputStreamIF", "To support serialization");
        imports.addImport("org.dmd.dmc.DmcAttributeInfo", "Constructor support");
        imports.addImport("org.dmd.dmc.DmcValueException", "Type checking");
        if (containsRefs) {
            imports.addImport("org.dmd.dmc.types.DmcTypeComplexTypeWithRefs", "Derivation base");
            imports.addImport("org.dmd.dmc.DmcNameResolverWithClashSupportIF", "Ambiguous reference resolution");
            imports.addImport("org.dmd.dmc.DmcNameClashResolverIF", "Ambiguous reference resolution");
            imports.addImport("org.dmd.dmc.DmcNameResolverIF", "Reference resolution");
            imports.addImport("org.dmd.dmc.DmcObject", "Ambiguous reference resolution");
            imports.addImport("org.dmd.dmc.DmcValueExceptionSet", "Ambiguous reference resolution");
        } else {
            imports.addImport("org.dmd.dmc.DmcAttribute", "Derivation base");
        }
        out.write(imports.getFormattedImports() + "\n\n");
        out.write("@SuppressWarnings(\"serial\")\n");
        out.write("/**\n * The DmcType" + cn + " class.\n");
        out.write(" * This code was auto-generated by the createmeta utility and shouldn't be alterred\n");
        out.write(" * manually.\n");
        out.write(" * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write(" *    Called from: " + DebugInfo.getWhereWeWereCalledFrom() + "\n");
        out.write(" */\n");
        if (containsRefs) {
            out.write("abstract public class DmcType" + cn + " extends DmcTypeComplexTypeWithRefs<" + cn + "> implements Serializable {\n\n");
        } else {
            out.write("abstract public class DmcType" + cn + " extends DmcAttribute<" + cn + "> implements Serializable {\n\n");
        }
        out.write("    /**\n");
        out.write("     * Default constructor.\n");
        out.write("     */\n");
        out.write("    public DmcType" + cn + "(){\n");
        out.write("    }\n\n");
        out.write("    /**\n");
        out.write("     * Default constructor.\n");
        out.write("     */\n");
        out.write("    public DmcType" + cn + "(DmcAttributeInfo ai){\n");
        out.write("        super(ai);\n");
        out.write("    }\n\n");
        out.write("    @Override\n");
        out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    public void formatValueAsJSON(StringBuffer sb, int padding, String indent) {\n");
        out.write("        if (getMVSize() == 0){\n");
        out.write("            getSV().toJSON(sb,padding,indent);\n");
        out.write("        }\n");
        out.write("        else {\n");
        out.write("            Iterator<" + cn + "> it = getMV();\n");
        out.write("            while(it.hasNext()){\n");
        out.write("                " + cn + " value = it.next();\n");
        out.write("                value.toJSON(sb,padding,indent);\n");
        out.write("                if (it.hasNext())\n");
        out.write("                    sb.append(\", \\n\");                    \n");
        out.write("            }\n");
        out.write("        }\n");
        out.write("    }\n\n");
        out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    public " + cn + " typeCheck(Object value) throws DmcValueException {\n");
        out.write("        " + cn + " rc = null;\n\n");
        out.write("        if (value instanceof " + cn + "){\n");
        out.write("            rc = (" + cn + ")value;\n");
        out.write("        }\n");
        out.write("        else if (value instanceof String){\n");
        out.write("            rc = new " + cn + "((String)value);\n");
        out.write("        }\n");
        out.write("        else{\n");
        out.write("            throw(new DmcValueException(\"Object of class: \" + value.getClass().getName() + \" passed where object compatible with " + cn + " expected.\"));\n");
        out.write("        }\n");
        out.write("        return(rc);\n");
        out.write("    }\n");
        out.write("\n");
        out.write("    /**\n");
        out.write("     * Returns a clone of a value associated with this type.\n");
        out.write("     * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("     */\n");
        out.write("    public " + cn + " cloneValue(" + cn + " val){\n");
        out.write("        return(new " + cn + "(val));\n");
        out.write("    }\n\n");
        out.write("    /**\n");
        out.write("     * Writes a " + cn + ".\n");
        out.write("     * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("     */\n");
        out.write("    @Override\n");
        out.write("    public void serializeValue(DmcOutputStreamIF dos, " + cn + " value) throws Exception {\n");
        out.write("        value.serializeIt(dos);\n");
        out.write("    }\n\n");
        out.write("    /**\n");
        out.write("     * Reads a " + cn + ".\n");
        out.write("     * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("     */\n");
        out.write("    @Override\n");
        out.write("    public " + cn + " deserializeValue(DmcInputStreamIF dis) throws Exception {\n");
        out.write("        " + cn + " rc = new " + cn + "();\n");
        out.write("        rc.deserializeIt(dis);\n");
        out.write("        return(rc);\n");
        out.write("    }\n\n");
        if (containsRefs) {
            out.write("    /**\n");
            out.write("     * Resolves a " + cn + ".\n");
            out.write("     * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            out.write("     */\n");
            out.write("    @Override\n");
            out.write("    public void resolveValue(DmcNameResolverIF resolver, " + cn + " value, String attrName) throws DmcValueException {\n");
            out.write("        value.resolve(resolver,attrName);\n");
            out.write("    }\n\n");
            out.write("    /**\n");
            out.write("     * Resolves a " + cn + ".\n");
            out.write("     * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            out.write("     */\n");
            out.write("    @Override\n");
            out.write("    public void resolveValue(DmcNameResolverWithClashSupportIF resolver, " + cn + " value, DmcObject object, DmcNameClashResolverIF ncr, DmcAttributeInfo ai) throws DmcValueException, DmcValueExceptionSet {\n");
            out.write("        value.resolve(resolver,object,ncr,ai);\n");
            out.write("    }\n\n");
            out.write("    /**\n");
            out.write("     * Removes references to other objects from a " + cn + ".\n");
            out.write("     * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            out.write("     */\n");
            out.write("    public void removeBackRefsFromValue(" + cn + " value){\n");
            out.write("        value.removeBackRefsFromValue();\n");
            out.write("    }\n\n");
        }
        out.write("\n");
        out.write("\n");
        out.write("}\n");
        ((BufferedWriter)out).close();
    }

    public static void dumpExtendedReferenceTypeDmcType(String header, String basePackage, String od, String cn, boolean containsRefs, ExtendedReferenceTypeDefinition ertd) throws IOException {
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(od, "DmcType" + cn + ".java");
        ImportManager imports = new ImportManager();
        imports.addImport("org.dmd.dmc.DmcInputStreamIF", "Serialization support");
        imports.addImport("org.dmd.dmc.DmcOutputStreamIF", "Serialization support");
        imports.addImport("org.dmd.dmc.DmcAttributeInfo", "Standard attribute interface");
        imports.addImport("org.dmd.dmc.DmcValueException", "Value exceptions");
        imports.addImport("org.dmd.dmc.types.DmcTypeNamedObjectREF", "The class we extend");
        imports.addImport(ertd.getExtendedReferenceClass().getDmoImport(), "The class we refer to");
        imports.addImport(ertd.getExtendedReferenceClass().getIsNamedBy().getType().getPrimitiveType(), "Name type");
        imports.addImport("org.dmd.dmc.DmcOutputStreamIF", "Serialization support");
        out.write(header);
        out.write("package " + basePackage + ".generated.types;\n\n");
        out.write(imports.getFormattedImports() + "\n\n");
        out.write("@SuppressWarnings(\"serial\")\n");
        out.write("/**\n * The DmcType" + cn + " class.\n");
        out.write(" * This code was auto-generated and shouldn't be alterred manually.\n");
        out.write(" * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write(" *    Called from: " + DebugInfo.getWhereWeWereCalledFrom() + "\n");
        out.write(" */\n");
        String nametype = ertd.getExtendedReferenceClass().getIsNamedBy().getType().getName().getNameString();
        out.write("abstract public class DmcType" + cn + " extends DmcTypeNamedObjectREF<" + ertd.getName() + ", " + nametype + "> {\n\n");
        out.write("    /**\n");
        out.write("     * Default constructor.\n");
        out.write("     */\n");
        out.write("    public DmcType" + cn + "(){\n");
        out.write("    }\n\n");
        out.write("    /**\n");
        out.write("     * Default constructor.\n");
        out.write("     */\n");
        out.write("    public DmcType" + cn + "(DmcAttributeInfo ai){\n");
        out.write("        super(ai);\n");
        out.write("    }\n\n");
        out.write("    @Override\n");
        out.write("    protected " + ertd.getName() + " getNewHelper(){\n");
        out.write("        return(new " + ertd.getName() + "());\n");
        out.write("    }\n\n");
        out.write("    @Override\n");
        out.write("    protected " + nametype + " getNewName(){\n");
        out.write("        return(new " + nametype + "());\n");
        out.write("    }\n\n");
        out.write("    @Override\n");
        out.write("    protected String getDMOClassName(){\n");
        out.write("        return(" + ertd.getExtendedReferenceClass().getName() + "DMO.class.getName());\n");
        out.write("    }\n\n");
        out.write("    @Override\n");
        out.write("    protected boolean isDMO(Object value){\n");
        out.write("        if (value instanceof " + ertd.getExtendedReferenceClass().getName() + "DMO)\n");
        out.write("            return(true);\n");
        out.write("        return(false);\n");
        out.write("    }\n\n");
        out.write("    protected " + cn + " typeCheck(Object value) throws DmcValueException {\n");
        out.write("        " + cn + " rc = null;\n\n");
        out.write("        if (value instanceof " + cn + "){\n");
        out.write("            rc = (" + cn + ")value;\n");
        out.write("        }\n");
        out.write("        else if (value instanceof String){\n");
        out.write("            rc = new " + cn + "((String)value);\n");
        out.write("        }\n");
        out.write("        else{\n");
        out.write("            throw(new DmcValueException(\"Object of class: \" + value.getClass().getName() + \" passed where object compatible with " + cn + " expected.\"));\n");
        out.write("        }\n");
        out.write("        return(rc);\n");
        out.write("    }\n");
        out.write("\n");
        out.write("    /**\n");
        out.write("     * Returns a clone of a value associated with this type.\n");
        out.write("     */\n");
        out.write("    public " + cn + " cloneValue(" + cn + " val){\n");
        out.write("        return(new " + cn + "(val));\n");
        out.write("    }\n\n");
        out.write("    /**\n");
        out.write("     * Writes a " + cn + ".\n");
        out.write("     */\n");
        out.write("    @Override\n");
        out.write("    public void serializeValue(DmcOutputStreamIF dos, " + cn + " value) throws Exception {\n");
        out.write("        value.serializeIt(dos);\n");
        out.write("    }\n\n");
        out.write("    /**\n");
        out.write("     * Reads a " + cn + ".\n");
        out.write("     */\n");
        out.write("    @Override\n");
        out.write("    public " + cn + " deserializeValue(DmcInputStreamIF dis) throws Exception {\n");
        out.write("        " + cn + " rc = new " + cn + "();\n");
        out.write("        rc.deserializeIt(dis);\n");
        out.write("        return(rc);\n");
        out.write("    }\n\n");
        if (containsRefs) {
            out.write("    /**\n");
            out.write("     * Resolves a " + cn + ".\n");
            out.write("     */\n");
            out.write("    @Override\n");
            out.write("    public void resolveValue(DmcNameResolverIF resolver, " + cn + " value, String attrName) throws DmcValueException {\n");
            out.write("        value.resolve(resolver,attrName);\n");
            out.write("    }\n\n");
        }
        out.write("\n");
        out.write("\n");
        out.write("}\n");
        ((BufferedWriter)out).close();
    }
}

