/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.dmd.dms.ComplexTypeDefinition;
import org.dmd.dms.TypeDefinition;
import org.dmd.dms.generated.dmo.TypeDefinitionDMO;
import org.dmd.dms.generated.dmw.SchemaDefinitionDMW;
import org.dmd.dms.generated.types.Part;
import org.dmd.dms.util.GenUtility;
import org.dmd.util.FileUpdateManager;
import org.dmd.util.ManagedFileWriter;
import org.dmd.util.codegen.ImportManager;
import org.dmd.util.codegen.Manipulator;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.exceptions.ResultException;

public class NewComplexTypeFormatter {
    static final String valSuffix = "V";

    static void dumpComplexType(String header, String od, ComplexTypeDefinition ctd) throws IOException, ResultException {
        String REF;
        String pn;
        TypeDefinition type;
        Part p;
        String ctn = ctd.getName().getNameString();
        String fieldSeparator = ctd.getFieldSeparator();
        Iterator<Part> parts = null;
        ArrayList<Part> combinedParts = new ArrayList<Part>();
        int requiredCount = ctd.getRequiredPartSize();
        boolean whiteSpaceSeparator = false;
        boolean anyMultiValued = false;
        if (fieldSeparator == null) {
            whiteSpaceSeparator = true;
            fieldSeparator = " ";
        }
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(od, ctn + ".java");
        if (ctd.getRequiredPartSize() > 0) {
            parts = ctd.getRequiredPart();
            while (parts.hasNext()) {
                p = parts.next();
                combinedParts.add(p);
                if (p.getMultivalued() == null || !p.getMultivalued().booleanValue()) continue;
                anyMultiValued = true;
            }
        }
        if (ctd.getOptionalPartSize() > 0) {
            parts = ctd.getOptionalPart();
            while (parts.hasNext()) {
                p = parts.next();
                combinedParts.add(p);
                if (p.getMultivalued() == null || !p.getMultivalued().booleanValue()) continue;
                anyMultiValued = true;
            }
        }
        boolean hasRefs = false;
        boolean isGreedy = false;
        ArrayList<Part> refFields = new ArrayList<Part>();
        ArrayList<Part> mvrefFields = new ArrayList<Part>();
        for (Part part : combinedParts) {
            TypeDefinition type2 = (TypeDefinition)((TypeDefinitionDMO)part.getType().getObject()).getContainer();
            if (type2 == null) {
                DebugInfo.debug("Unknown type in ComplexTypeDefinition: " + part.getType().getObjectName());
                System.exit(1);
            }
            if (type2.getIsRefType().booleanValue()) {
                hasRefs = true;
                if (part.getMultivalued() != null && part.getMultivalued().booleanValue()) {
                    mvrefFields.add(part);
                } else {
                    refFields.add(part);
                }
            }
            if (type2.getComplexType() != null && type2.getComplexType().hasReferenceTypeParts()) {
                hasRefs = true;
                if (part.getMultivalued() != null && part.getMultivalued().booleanValue()) {
                    mvrefFields.add(part);
                } else {
                    refFields.add(part);
                }
            }
            if (part.getGreedy() == null || !part.getGreedy().booleanValue()) continue;
            isGreedy = true;
        }
        if (header != null) {
            out.write(header);
        }
        out.write("package " + ((SchemaDefinitionDMW)ctd.getDefinedIn()).getSchemaPackage() + ".generated.types;\n\n");
        ImportManager imports = new ImportManager();
        imports.addImport("java.io.Serializable", "To prevent serialization warnings");
        imports.addImport("org.dmd.dmc.DmcInputStreamIF", "Standard serialization techniques");
        imports.addImport("org.dmd.dmc.DmcOutputStreamIF", "Standard serialization techniques");
        imports.addImport("org.dmd.dms.generated.enums.DataTypeEnum", "For fake DmcAttributeInfo");
        imports.addImport("org.dmd.dms.generated.enums.ValueTypeEnum", "For fake DmcAttributeInfo");
        imports.addImport("org.dmd.dmc.DmcAttributeInfo", "For fake DmcAttributeInfo");
        imports.addImport("org.dmd.dmc.util.ComplexTypeSplitter", "For parsing initial input");
        imports.addImport("java.util.ArrayList", "To store ParsedNameValuePairs");
        imports.addImport("org.dmd.dmc.util.ParsedNameValuePair", "To store values parsed from initial input");
        imports.addImport("org.dmd.dmc.util.JSONUtil", "To perform escaping of things in JSON");
        if (anyMultiValued) {
            imports.addImport("java.util.Iterator", "To support multi-valued optional parts");
        }
        if (hasRefs) {
            imports.addImport("org.dmd.dmc.DmcNameResolverIF", "To support object references");
            imports.addImport("org.dmd.dmc.DmcNamedObjectIF", "To support object references");
            imports.addImport("org.dmd.dmc.DmcNamedObjectREF", "To support object references");
            imports.addImport("org.dmd.dmc.DmcContainerIF", "To support object references");
            imports.addImport("org.dmd.dmc.DmcNameResolverWithClashSupportIF", "To support possible clashing object references");
            imports.addImport("org.dmd.dmc.DmcAttributeInfo", "To support possible clashing object references");
            imports.addImport("org.dmd.dmc.DmcNameClashResolverIF", "To support possible clashing object references");
            imports.addImport("org.dmd.dmc.DmcObject", "To support possible clashing object references");
            imports.addImport("org.dmd.dmc.DmcValueExceptionSet", "To support possible clashing object references");
            imports.addImport("org.dmd.dmc.DmcOmni", "To enable back reference tracking");
            imports.addImport("org.dmd.dmc.types.Modifier", "To enable back reference tracking");
            imports.addImport("org.dmd.dmc.DmcContainerIF", "To enable back reference tracking");
        }
        imports.addImport("org.dmd.dmc.DmcValueException", "Standard value exception");
        NewComplexTypeFormatter.getComplexTypeImports(combinedParts, imports);
        out.write(imports.getFormattedImports() + "\n\n");
        out.write("@SuppressWarnings(\"serial\")\n");
        out.write("/**\n * The " + ctn + " class.\n");
        out.write(" * This code was auto-generated and shouldn't be alterred manually.\n");
        out.write(" * \n");
        out.write(" * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write(" */\n");
        out.write("public class " + ctn + " implements Serializable {\n\n");
        out.write("    final static int requiredParts = " + requiredCount + ";\n\n");
        out.write(NewComplexTypeFormatter.getComplexTypeFieldInstances(combinedParts));
        out.write("    /**\n");
        out.write("     * Default constructor.\n");
        out.write("     */\n");
        out.write("    public " + ctn + "(){\n");
        out.write("    }\n\n");
        out.write("    /**\n");
        out.write("     * Copy constructor.\n");
        out.write("     */\n");
        if (anyMultiValued) {
            out.write("    @SuppressWarnings(\"unchecked\")\n");
        }
        out.write("    public " + ctn + "(" + ctn + " original){\n");
        out.write(NewComplexTypeFormatter.getCopyConstructorAssignments(combinedParts));
        out.write("    }\n\n");
        out.write("    /**\n");
        out.write("     * All fields constructor.\n");
        out.write("     * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("     */\n");
        out.write("    public " + ctn + "(");
        int fnum = 1;
        for (Part part : combinedParts) {
            type = (TypeDefinition)((TypeDefinitionDMO)part.getType().getObject()).getContainer();
            String mvs = "";
            String mve = "";
            if (part.getMultivalued() != null && part.getMultivalued().booleanValue()) {
                mvs = "ArrayList<";
                mve = ">";
            }
            if (type.getIsRefType().booleanValue()) {
                out.write(mvs + part.getType().getObjectName() + "REF" + mve + " " + part.getName() + "_");
            } else {
                out.write(mvs + part.getType().getObjectName() + mve + " " + part.getName() + "_");
            }
            if (++fnum > combinedParts.size()) continue;
            out.write(", ");
        }
        out.write(") throws DmcValueException {\n");
        fnum = 1;
        for (Part part : combinedParts) {
            type = (TypeDefinition)((TypeDefinitionDMO)part.getType().getObject()).getContainer();
            Iterator<Part> assignment = null;
            String ref = "";
            String pn2 = part.getName() + valSuffix;
            String pt = part.getType().getObjectName().getNameString();
            if (type.getIsRefType().booleanValue()) {
                ref = "REF";
                assignment = "        " + pn2 + " = DmcType" + pt + "REFSTATIC.instance.typeCheck(" + part.getName() + "_);\n";
            } else {
                assignment = "        " + pn2 + " = DmcType" + pt + "STATIC.instance.typeCheck(" + part.getName() + "_);\n";
            }
            if (fnum > requiredCount) {
                if (part.getMultivalued() != null && part.getMultivalued().booleanValue()) {
                    out.write("        if (" + part.getName() + "_ != null){\n");
                    out.write("            " + pn2 + " = new ArrayList<" + pt + ref + ">();\n");
                    out.write("            for(" + pt + ref + " v: " + part.getName() + "_){\n");
                    out.write("                " + pn2 + ".add(DmcType" + pt + ref + "STATIC.instance.typeCheck(v));\n");
                    out.write("            }\n");
                    out.write("        }\n");
                } else {
                    out.write("        if (" + part.getName() + "_ != null)\n");
                    out.write("    " + (String)((Object)assignment));
                }
            } else if (part.getMultivalued() != null && part.getMultivalued().booleanValue()) {
                out.write("        if (" + part.getName() + "_ != null){\n");
                out.write("            " + pn2 + " = new ArrayList<" + pt + ref + ">();\n");
                out.write("            for(" + pt + ref + " v: " + part.getName() + "_){\n");
                out.write("                " + pn2 + ".add(DmcType" + pt + ref + "STATIC.instance.typeCheck(v));\n");
                out.write("            }\n");
                out.write("        }\n");
            } else {
                out.write((String)((Object)assignment));
            }
            ++fnum;
        }
        out.write("    }\n\n");
        out.write("    /**\n");
        out.write("     * String based constructor.\n");
        out.write("     * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("     */\n");
        out.write("    public " + ctn + "(String initialInput) throws DmcValueException {\n");
        out.write("        initialize(initialInput);\n");
        out.write("    }\n");
        out.write("    /**\n");
        out.write("     * Initialize content based on string form.\n");
        out.write("     * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("     */\n");
        out.write("    void initialize(String initialInput) throws DmcValueException {\n");
        int stopAfter = combinedParts.size() - 1;
        if (whiteSpaceSeparator) {
            if (isGreedy) {
                out.write("        ArrayList<ParsedNameValuePair> nvp = ComplexTypeSplitter.parse(initialInput, ' ', " + stopAfter + ");\n\n");
            } else {
                out.write("        ArrayList<ParsedNameValuePair> nvp = ComplexTypeSplitter.parse(initialInput);\n\n");
            }
        } else if (isGreedy) {
            out.write("        ArrayList<ParsedNameValuePair> nvp = ComplexTypeSplitter.parse(initialInput,'" + fieldSeparator + "', " + stopAfter + ");\n\n");
        } else {
            out.write("        ArrayList<ParsedNameValuePair> nvp = ComplexTypeSplitter.parse(initialInput,'" + fieldSeparator + "');\n\n");
        }
        out.write("        if (nvp.size() < requiredParts)\n");
        out.write("            throw(new DmcValueException(\"Missing required values for complex type: " + ctn + "\\nValue: \" + initialInput));\n");
        out.write("\n");
        fnum = 0;
        String indent = "                    ";
        boolean firstOptional = true;
        for (Part part : combinedParts) {
            TypeDefinition type3 = (TypeDefinition)((TypeDefinitionDMO)part.getType().getObject()).getContainer();
            String REF2 = "";
            String openBrace = "";
            pn = part.getName() + valSuffix;
            boolean isMulti = false;
            if (type3.getIsRefType().booleanValue()) {
                REF2 = "REF";
            }
            if (part.getMultivalued() != null && part.getMultivalued().booleanValue()) {
                isMulti = true;
                openBrace = "{";
            }
            if (fnum < requiredCount) {
                if (isMulti) {
                    out.write("\n");
                    out.write("        if (nvp.size() >= requiredParts){\n");
                    out.write("            for(int i=0; i<nvp.size(); i++){\n");
                    out.write("                if (" + pn + " == null)\n");
                    out.write("                    " + pn + " = new ArrayList<" + part.getType().getObjectName() + REF2 + ">();\n");
                    out.write("                " + pn + ".add(DmcType" + part.getType().getObjectName() + REF2 + "STATIC.instance.typeCheck(nvp.get(i).getValue()));\n");
                    out.write("            }\n");
                    out.write("        }\n");
                } else {
                    out.write("        " + part.getName() + valSuffix + " = DmcType" + part.getType().getObjectName() + REF2 + "STATIC.instance.typeCheck(nvp.get(" + fnum + ").getValue());\n");
                }
            } else {
                if (firstOptional) {
                    out.write("\n");
                    out.write("        if (nvp.size() > requiredParts){\n");
                    out.write("            for(int i=" + requiredCount + "; i<nvp.size(); i++){\n");
                    out.write("                if (nvp.get(i).getName() == null){\n");
                    out.write("                    if (nvp.get(i).getValue() == null)\n");
                    out.write("                        throw(new DmcValueException(\"Expecting a partname=\\\"some value\\\" in complex type: " + ctn + "\\nValue: \" + initialInput));\n");
                    out.write("                    else\n");
                    out.write("                        throw(new DmcValueException(\"Expecting a partname=\\\"\" + nvp.get(i).getValue() + \"\\\" in complex type: " + ctn + "\\nValue: \" + initialInput));\n");
                    out.write("                }\n");
                    firstOptional = false;
                    out.write("                if (nvp.get(i).getName().equals(\"" + part.getName() + "\"))" + openBrace + "\n");
                } else {
                    out.write("                else if (nvp.get(i).getName().equals(\"" + part.getName() + "\"))" + openBrace + "\n");
                }
                if (isMulti) {
                    out.write(indent + "if (" + pn + " == null)\n");
                    out.write(indent + "    " + pn + " = new ArrayList<" + part.getType().getObjectName() + REF2 + ">();\n");
                    out.write(indent + pn + ".add(DmcType" + part.getType().getObjectName() + REF2 + "STATIC.instance.typeCheck(nvp.get(i).getValue()));\n");
                    out.write("                }\n");
                } else {
                    out.write(indent + pn + " = DmcType" + part.getType().getObjectName() + REF2 + "STATIC.instance.typeCheck(nvp.get(i).getValue());\n");
                }
            }
            ++fnum;
        }
        if (!firstOptional) {
            out.write("                else{\n");
            out.write("                    throw(new DmcValueException(\"Unknown field for complex type " + ctn + ": \"  + nvp.get(i).getName()));\n");
            out.write("                }\n");
            out.write("            }\n");
            out.write("        }\n\n");
        }
        out.write("    }\n\n");
        out.write("    /**\n");
        out.write("     * Serialization.\n");
        out.write("     */\n");
        out.write("    public void serializeIt(DmcOutputStreamIF dos) throws Exception {\n");
        out.write("        dos.writeUTF(toString());\n");
        out.write("    }\n\n");
        out.write("    /**\n");
        out.write("     * Deserialization.\n");
        out.write("     */\n");
        out.write("    public void deserializeIt(DmcInputStreamIF dis) throws Exception {\n");
        out.write("        initialize(dis.readUTF());\n");
        out.write("    }\n\n");
        out.write("    /**\n");
        out.write("     * String form.\n");
        out.write("     * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("     */\n");
        out.write("    public String toString(){\n");
        out.write("        StringBuffer sb = new StringBuffer();\n");
        fnum = 0;
        for (Part part : combinedParts) {
            TypeDefinition type4;
            boolean isMulti = false;
            boolean isQuoted = false;
            String pn3 = part.getName() + valSuffix;
            if (part.getMultivalued() != null && part.getMultivalued().booleanValue()) {
                isMulti = true;
            }
            if (part.getQuoted() != null && part.getQuoted().booleanValue()) {
                isQuoted = true;
            }
            String appendStatement = null;
            appendStatement = isQuoted ? "        sb.append(\"\\\"\" + " + pn3 + ".toString() + \"\\\"\");\n" : "        sb.append(" + pn3 + ".toString());\n";
            if (fnum < requiredCount) {
                if (isMulti) {
                    type4 = (TypeDefinition)((TypeDefinitionDMO)part.getType().getObject()).getContainer();
                    REF = "";
                    if (type4.getIsRefType().booleanValue()) {
                        REF = "REF";
                    }
                    out.write("            boolean first = true;\n");
                    out.write("            for(" + type4.getName() + REF + " v: " + pn3 + "){\n");
                    out.write("                if (first)\n");
                    out.write("                    first = false;\n");
                    out.write("                else\n");
                    out.write("                    sb.append('" + fieldSeparator + "');\n");
                    if (isQuoted) {
                        out.write("                sb.append(\"\\\"\" + v.toString() + \"\\\"\");\n");
                    } else {
                        out.write("                sb.append(v.toString());\n");
                    }
                    out.write("            }\n");
                } else if (fnum == 0) {
                    out.write(appendStatement);
                } else {
                    out.write("        sb.append('" + fieldSeparator + "');\n");
                    out.write(appendStatement);
                }
            } else {
                appendStatement = isQuoted ? "        sb.append(\"" + part.getName() + "=\" + \"\\\"\" + " + part.getName() + valSuffix + ".toString() + \"\\\"\");\n" : "        sb.append(\"" + part.getName() + "=\" + " + part.getName() + valSuffix + ".toString());\n";
                out.write("        if (" + part.getName() + valSuffix + " != null){\n");
                if (isMulti) {
                    type4 = (TypeDefinition)((TypeDefinitionDMO)part.getType().getObject()).getContainer();
                    REF = "";
                    if (type4.getIsRefType().booleanValue()) {
                        REF = "REF";
                    }
                    out.write("            for(" + type4.getName() + REF + " v: " + pn3 + "){\n");
                    out.write("                sb.append('" + fieldSeparator + "');\n");
                    if (isQuoted) {
                        out.write("                sb.append(\"" + part.getName() + "=\" + \"\\\"\" + v.toString() + \"\\\"\");\n");
                    } else {
                        out.write("                sb.append(\"" + part.getName() + "=\" + v.toString());\n");
                    }
                    out.write("            }\n");
                } else if (fnum == 0) {
                    out.write("    " + appendStatement);
                } else {
                    out.write("            sb.append('" + fieldSeparator + "');\n");
                    out.write("    " + appendStatement);
                }
                out.write("        }\n\n");
            }
            ++fnum;
        }
        out.write("        return(sb.toString());\n");
        out.write("    }\n\n");
        out.write("    @Override\n");
        out.write("    public boolean equals(Object obj) {\n");
        out.write("        if (obj instanceof " + ctn + ") {\n");
        out.write("            return(this.toString().equals(((" + ctn + ")obj).toString()));\n");
        out.write("        }\n");
        out.write("        return(false);\n");
        out.write("    }\n");
        out.write("    /**\n");
        out.write("     * JSON form.\n");
        out.write("     * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("     */\n");
        out.write("    public void toJSON(StringBuffer sb, int padding, String indent){\n");
        fnum = 0;
        out.write("        sb.append(indent + \"{\\n\");\n");
        for (Part part : combinedParts) {
            TypeDefinition type5 = (TypeDefinition)((TypeDefinitionDMO)part.getType().getObject()).getContainer();
            boolean isMulti = false;
            String key = part.getName();
            pn = part.getName() + valSuffix;
            boolean isComplex = false;
            if (type5.getComplexType() != null) {
                isComplex = true;
            }
            if (part.getMultivalued() != null && part.getMultivalued().booleanValue()) {
                isMulti = true;
            }
            if (fnum < requiredCount) {
                String ENDING = "";
                if (fnum + 1 < requiredCount) {
                    ENDING = ",\\n";
                }
                if (isMulti) {
                    String REF3 = "";
                    if (type5.getIsRefType().booleanValue()) {
                        REF3 = "REF";
                    }
                    if (isComplex) {
                        out.write("            sb.append(indent + \"  \\\"" + key + "\\\": [\\n\");\n");
                        out.write("            Iterator<" + type5.getName() + REF3 + "> it = " + pn + ".iterator();\n");
                        out.write("            while(it.hasNext()){\n");
                        out.write("                " + type5.getName() + REF3 + " v = it.next();\n");
                        out.write("                v.toJSON(sb, padding, indent + \"    \");\n");
                        out.write("                if (it.hasNext())\n");
                        out.write("                    sb.append(\",\\n\");\n");
                        out.write("            }" + ENDING + "\n");
                        out.write("            sb.append(\"\\n\" + indent + \"  ]\");\n");
                    } else {
                        out.write("            sb.append(indent + \"  \\\"" + key + "\\\": [\\n\");\n");
                        out.write("            Iterator<" + type5.getName() + REF3 + "> it = " + pn + ".iterator();\n");
                        out.write("            while(it.hasNext()){\n");
                        out.write("                " + type5.getName() + REF3 + " v = it.next();\n");
                        if (type5.getNumericOrBoolean().booleanValue()) {
                            out.write("                sb.append(indent + \"  \" + v.toString() + \"\");\n");
                        } else {
                            out.write("                sb.append(indent + \"  \\\"\" + JSONUtil.escape(v.toString()) + \"\\\"\");\n");
                        }
                        out.write("                if (it.hasNext())\n");
                        out.write("                    sb.append(\",\");\n");
                        out.write("            }" + ENDING + "\n");
                        out.write("            sb.append(\"\\n\" + indent + \"]\");\n");
                    }
                } else if (isComplex) {
                    out.write("        sb.append(indent + \"  \\\"" + key + "\\\": \");\n");
                    out.write("        " + pn + ".toJSON(sb, padding, indent);\n");
                    out.write("        sb.append(\"" + ENDING + "\");\n");
                } else if (type5.getNumericOrBoolean().booleanValue()) {
                    out.write("        sb.append(indent + \"  \\\"" + key + "\\\": \" + " + pn + ".toString() + \"" + ENDING + "\");\n");
                } else {
                    out.write("        sb.append(indent + \"  \\\"" + key + "\\\": \\\"\" + JSONUtil.escape(" + pn + ".toString()) + \"\\\"" + ENDING + "\");\n");
                }
            } else {
                out.write("        if (" + part.getName() + valSuffix + " != null){\n");
                out.write("            sb.append(\",\\n\");\n");
                if (isMulti) {
                    REF = "";
                    if (type5.getIsRefType().booleanValue()) {
                        REF = "REF";
                    }
                    if (isComplex) {
                        out.write("            sb.append(indent + \"  \\\"" + key + "\\\": [\\n\");\n");
                        out.write("            Iterator<" + type5.getName() + REF + "> it = " + pn + ".iterator();\n");
                        out.write("            while(it.hasNext()){\n");
                        out.write("                " + type5.getName() + REF + " v = it.next();\n");
                        out.write("                v.toJSON(sb, padding, indent + \"    \");\n");
                        out.write("                if (it.hasNext())\n");
                        out.write("                    sb.append(\",\\n\");\n");
                        out.write("            }\n");
                        out.write("            sb.append(\"\\n\" + indent + \"  ]\");\n");
                    } else {
                        out.write("            sb.append(indent + \"  \\\"" + key + "\\\": [\\n\");\n");
                        out.write("            Iterator<" + type5.getName() + REF + "> it = " + pn + ".iterator();\n");
                        out.write("            while(it.hasNext()){\n");
                        out.write("                " + type5.getName() + REF + " v = it.next();\n");
                        if (type5.getNumericOrBoolean().booleanValue()) {
                            out.write("                sb.append(indent + \"  \" + v.toString() + \"\");\n");
                        } else {
                            out.write("                sb.append(indent + \"  \\\"\" + JSONUtil.escape(v.toString()) + \"\\\"\");\n");
                        }
                        out.write("                if (it.hasNext())\n");
                        out.write("                    sb.append(\",\");\n");
                        out.write("            }\n");
                        out.write("            sb.append(\"\\n\" + indent + \"]\");\n");
                    }
                } else if (isComplex) {
                    out.write("            // complex: " + DebugInfo.getWhereWeAreNow() + "\n");
                    out.write("            sb.append(indent + \"  \\\"" + key + "\\\": \");\n");
                    out.write("            " + pn + ".toJSON(sb, padding, indent);\n");
                } else if (type5.getNumericOrBoolean().booleanValue()) {
                    out.write("            sb.append(indent + \"  \\\"" + key + "\\\": \" + " + pn + ".toString() + \"\");\n");
                } else {
                    out.write("            // non-complex non-numeric non-bool: " + DebugInfo.getWhereWeAreNow() + "\n");
                    out.write("            sb.append(indent + \"  \\\"" + key + "\\\": \\\"\" + JSONUtil.escape(" + pn + ".toString()) + \"\\\"\");\n");
                }
                out.write("        }\n\n");
            }
            ++fnum;
        }
        out.write("        sb.append(\"\\n\" + indent + \"}\");\n");
        out.write("    }\n\n");
        for (Part part : combinedParts) {
            TypeDefinition type6 = (TypeDefinition)((TypeDefinitionDMO)part.getType().getObject()).getContainer();
            boolean isMulti = false;
            pn = part.getName() + valSuffix;
            String ref = "";
            if (type6.getIsRefType().booleanValue()) {
                ref = "REF";
            }
            if (part.getMultivalued() != null && part.getMultivalued().booleanValue()) {
                isMulti = true;
            }
            if (isMulti) {
                out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                out.write("    public Iterator<" + part.getType().getObjectName() + ref + "> get" + Manipulator.capFirstChar(part.getName()) + "(){\n");
                out.write("        if (" + pn + " == null)\n");
                out.write("            return(null);\n");
                out.write("        return(" + pn + ".iterator());\n");
                out.write("    }\n\n");
                out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                out.write("    public boolean has" + Manipulator.capFirstChar(part.getName()) + "(){\n");
                out.write("        if (" + pn + " == null)\n");
                out.write("            return(false);\n");
                out.write("        return(true);\n");
                out.write("    }\n\n");
                out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                out.write("    public int get" + Manipulator.capFirstChar(part.getName()) + "Size(){\n");
                out.write("        if (" + pn + " == null)\n");
                out.write("            return(0);\n");
                out.write("        return(" + pn + ".size());\n");
                out.write("    }\n\n");
                out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                out.write("    public " + part.getType().getObjectName() + ref + " get" + Manipulator.capFirstChar(part.getName()) + "(int index){\n");
                out.write("        if (" + pn + " == null)\n");
                out.write("            return(null);\n");
                out.write("        return(" + pn + ".get(index));\n");
                out.write("    }\n\n");
                continue;
            }
            out.write("    public " + part.getType().getObjectName() + ref + " get" + Manipulator.capFirstChar(part.getName()) + "(){\n");
            out.write("        return(" + pn + ");\n");
            out.write("    }\n\n");
        }
        if (hasRefs) {
            out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            out.write("    @SuppressWarnings({\"unchecked\", \"rawtypes\"})\n");
            out.write("    public void resolve(DmcNameResolverIF resolver, String attrName) throws DmcValueException {\n");
            out.write("        DmcNamedObjectIF  obj = null;\n\n");
            for (Part part : refFields) {
                String pn4 = part.getName();
                TypeDefinition type7 = (TypeDefinition)((TypeDefinitionDMO)part.getType().getObject()).getContainer();
                if (type7.getComplexType() == null) {
                    out.write("        if ((" + pn4 + valSuffix + " != null) && (!" + pn4 + valSuffix + ".isResolved())){\n");
                    out.write("            obj = resolver.findNamedObject(" + pn4 + valSuffix + ".getObjectName());\n");
                    out.write("            if (" + pn4 + "AI.weakReference)\n");
                    out.write("                return;\n");
                    out.write("            if (obj == null)\n");
                    out.write("                throw(new DmcValueException(\"Could not resolve reference to: \" + " + pn4 + valSuffix + ".getObjectName() + \"(part: " + part.getName() + " - of type: " + type7.getName() + ") via attribute: \" + attrName));\n");
                    out.write("        \n");
                    out.write("            if (obj instanceof DmcContainerIF)\n");
                    out.write("                ((DmcNamedObjectREF)" + pn4 + valSuffix + ").setObject((DmcNamedObjectIF) ((DmcContainerIF)obj).getDmcObject());\n");
                    out.write("            else\n");
                    out.write("                ((DmcNamedObjectREF)" + pn4 + valSuffix + ").setObject(obj);\n");
                    out.write("        }\n");
                    out.write("        \n");
                    continue;
                }
                out.write("        if (" + pn4 + valSuffix + " != null){\n");
                out.write("            " + pn4 + valSuffix + ".resolve(resolver, attrName);\n");
                out.write("        }\n");
                out.write("        \n");
            }
            for (Part part : mvrefFields) {
                TypeDefinition type8 = (TypeDefinition)((TypeDefinitionDMO)part.getType().getObject()).getContainer();
                String pn5 = part.getName() + valSuffix;
                if (type8.getComplexType() == null) {
                    out.write("        if (" + pn5 + " != null){\n");
                    out.write("            for(" + type8.getName() + "REF v: " + pn5 + "){\n");
                    out.write("                if (v.isResolved())\n");
                    out.write("                    continue;\n");
                    out.write("                obj = resolver.findNamedObject(v.getObjectName());\n");
                    out.write("                if (" + part.getName() + "AI.weakReference)\n");
                    out.write("                    return;\n");
                    out.write("                if (obj == null)\n");
                    out.write("                    throw(new DmcValueException(\"Could not resolve reference to: \" + v.getObjectName() + \" (part: " + part.getName() + " - of type: " + type8.getName() + ") via attribute: \" + attrName));\n");
                    out.write("        \n");
                    out.write("                if (obj instanceof DmcContainerIF)\n");
                    out.write("                    ((DmcNamedObjectREF)v).setObject((DmcNamedObjectIF) ((DmcContainerIF)obj).getDmcObject());\n");
                    out.write("                else\n");
                    out.write("                    ((DmcNamedObjectREF)v).setObject(obj);\n");
                    out.write("            }\n");
                    out.write("        }\n");
                    out.write("        \n");
                    continue;
                }
                out.write("        if (" + pn5 + " != null){\n");
                out.write("            for(" + type8.getName() + " v: " + pn5 + "){\n");
                out.write("                v.resolve(resolver, attrName);\n");
                out.write("            }\n");
                out.write("        }\n");
                out.write("        \n");
            }
            out.write("    }\n\n");
            out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            out.write("    @SuppressWarnings({\"unchecked\", \"rawtypes\"})\n");
            out.write("    public void resolve(DmcNameResolverWithClashSupportIF resolver, DmcObject object, DmcNameClashResolverIF ncr, DmcAttributeInfo ai) throws DmcValueException, DmcValueExceptionSet {\n");
            out.write("        DmcNamedObjectIF  obj = null;\n\n");
            for (Part part : refFields) {
                TypeDefinition type9 = (TypeDefinition)((TypeDefinitionDMO)part.getType().getObject()).getContainer();
                String pn6 = part.getName();
                if (type9.getComplexType() == null) {
                    out.write("        if ((" + pn6 + valSuffix + " != null) && (!" + pn6 + valSuffix + ".isResolved())){\n");
                    out.write("            obj = resolver.findNamedObjectMayClash(object, " + pn6 + valSuffix + ".getObjectName(), ncr, " + pn6 + "AI);\n");
                    out.write("            if (" + pn6 + "AI.weakReference)\n");
                    out.write("                return;\n");
                    out.write("            if (obj == null)\n");
                    out.write("                throw(new DmcValueException(\"Could not resolve reference to: \" + " + pn6 + valSuffix + ".getObjectName() + \"(part: " + part.getName() + " - of type: " + type9.getName() + ") via attribute: \" + ai.name));\n");
                    out.write("        \n");
                    out.write("            if (obj instanceof DmcContainerIF)\n");
                    out.write("                ((DmcNamedObjectREF)" + pn6 + valSuffix + ").setObject((DmcNamedObjectIF) ((DmcContainerIF)obj).getDmcObject());\n");
                    out.write("            else\n");
                    out.write("                ((DmcNamedObjectREF)" + pn6 + valSuffix + ").setObject(obj);\n");
                    out.write("        \n");
                    out.write("            if (DmcOmni.instance().backRefTracking()){\n");
                    out.write("                Modifier backrefMod = new Modifier(\"" + pn6 + "\", object, " + pn6 + valSuffix + ", ai.id, ai.name);\n");
                    out.write("                if (obj instanceof DmcContainerIF)\n");
                    out.write("                    ((DmcContainerIF)obj).getDmcObject().addBackref(backrefMod);\n");
                    out.write("                else\n");
                    out.write("                    ((DmcObject)obj).addBackref(backrefMod);\n");
                    out.write("                " + pn6 + valSuffix + ".setBackrefModifier(backrefMod);\n");
                    out.write("            }\n");
                    out.write("        }\n");
                    out.write("        \n");
                    continue;
                }
                out.write("        if (" + pn6 + valSuffix + " != null){\n");
                out.write("            " + pn6 + valSuffix + ".resolve(resolver, object, ncr, ai);\n");
                out.write("        }\n");
                out.write("        \n");
            }
            for (Part part : mvrefFields) {
                TypeDefinition type10 = (TypeDefinition)((TypeDefinitionDMO)part.getType().getObject()).getContainer();
                String pn7 = part.getName() + valSuffix;
                if (type10.getComplexType() == null) {
                    out.write("        if (" + pn7 + " != null){\n");
                    out.write("            for(" + type10.getName() + "REF v: " + pn7 + "){\n");
                    out.write("                if (v.isResolved())\n");
                    out.write("                    continue;\n");
                    out.write("                obj = resolver.findNamedObjectMayClash(object, v.getObjectName(), ncr, " + part.getName() + "AI);\n");
                    out.write("                if (" + part.getName() + "AI.weakReference)\n");
                    out.write("                    return;\n");
                    out.write("                if (obj == null)\n");
                    out.write("                    throw(new DmcValueException(\"Could not resolve reference to: \" + v.getObjectName() + \" via attribute: \" + ai.name));\n");
                    out.write("        \n");
                    out.write("                if (obj instanceof DmcContainerIF)\n");
                    out.write("                    ((DmcNamedObjectREF)v).setObject((DmcNamedObjectIF) ((DmcContainerIF)obj).getDmcObject());\n");
                    out.write("                else\n");
                    out.write("                    ((DmcNamedObjectREF)v).setObject(obj);\n");
                    out.write("        \n");
                    out.write("                if (DmcOmni.instance().backRefTracking()){\n");
                    out.write("                    Modifier backrefMod = new Modifier(\"" + part.getName() + "\", object, v, ai.id);\n");
                    out.write("                    if (obj instanceof DmcContainerIF)\n");
                    out.write("                        ((DmcContainerIF)obj).getDmcObject().addBackref(backrefMod);\n");
                    out.write("                    else\n");
                    out.write("                        ((DmcObject)obj).addBackref(backrefMod);\n");
                    out.write("                    v.setBackrefModifier(backrefMod);\n");
                    out.write("                }\n");
                    out.write("            }\n");
                    out.write("        }\n");
                    out.write("        \n");
                    continue;
                }
                out.write("        if (" + pn7 + " != null){\n");
                out.write("            for(" + type10.getName() + " v: " + pn7 + "){\n");
                out.write("                v.resolve(resolver, object, ncr, ai);\n");
                out.write("            }\n");
                out.write("        }\n");
                out.write("        \n");
            }
            out.write("    }\n\n");
            out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            out.write("    public void removeBackRefsFromValue(){\n");
            for (Part part : refFields) {
                String pn8 = part.getName();
                TypeDefinition type11 = (TypeDefinition)((TypeDefinitionDMO)part.getType().getObject()).getContainer();
                if (type11.getComplexType() == null) {
                    out.write("        // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                    out.write("        if (" + pn8 + valSuffix + " != null){\n");
                    out.write("            " + pn8 + valSuffix + ".removeBackref();\n");
                    out.write("        }\n");
                    out.write("        \n");
                    continue;
                }
                if (type11.getComplexType().hasReferenceTypeParts()) {
                    out.write("        // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                    out.write("        if (" + pn8 + valSuffix + " != null){\n");
                    out.write("            " + pn8 + valSuffix + ".removeBackRefsFromValue();\n");
                    out.write("        }\n");
                    out.write("        \n");
                    continue;
                }
                out.write("        // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                out.write("        if (" + pn8 + valSuffix + " != null){\n");
                out.write("            " + pn8 + valSuffix + ".removeBackref();\n");
                out.write("        }\n");
                out.write("        \n");
            }
            for (Part part : mvrefFields) {
                TypeDefinition type12 = (TypeDefinition)((TypeDefinitionDMO)part.getType().getObject()).getContainer();
                String pn9 = part.getName() + valSuffix;
                if (type12.getComplexType() == null) {
                    out.write("        // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                    out.write("        if (" + pn9 + " != null){\n");
                    out.write("            for(" + type12.getName() + "REF v: " + pn9 + "){\n");
                    out.write("                v.removeBackref();\n");
                    out.write("            }\n");
                    out.write("        }\n");
                    out.write("        \n");
                    continue;
                }
                out.write("        // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                out.write("        if (" + pn9 + " != null){\n");
                out.write("            for(" + type12.getName() + " v: " + pn9 + "){\n");
                out.write("                v.removeBackref();\n");
                out.write("            }\n");
                out.write("        }\n");
                out.write("        \n");
            }
            out.write("    }\n\n");
        }
        out.write("}\n");
        ((BufferedWriter)out).close();
        GenUtility.dumpComplexTypeDmcType(header, ((SchemaDefinitionDMW)ctd.getDefinedIn()).getSchemaPackage(), od, ctn, hasRefs);
    }

    static String getComplexTypeFieldInstances(ArrayList<Part> combinedParts) {
        StringBuffer sb = new StringBuffer();
        for (Part part : combinedParts) {
            TypeDefinition type = (TypeDefinition)((TypeDefinitionDMO)part.getType().getObject()).getContainer();
            sb.append("    // " + part.getDescription() + "\n");
            String mvs = "";
            String mve = "";
            if (part.getMultivalued() != null && part.getMultivalued().booleanValue()) {
                mvs = "ArrayList<";
                mve = ">";
            }
            String indexSize = ", 0";
            String weakReference = ", false";
            if (part.getWeakref() != null && part.getWeakref().booleanValue()) {
                weakReference = ", true";
            }
            if (type.getIsRefType().booleanValue()) {
                sb.append("    " + mvs + part.getType().getObjectName() + "REF" + mve + " " + part.getName() + valSuffix + ";\n\n");
            } else {
                sb.append("    " + mvs + part.getType().getObjectName() + mve + " " + part.getName() + valSuffix + ";\n\n");
            }
            sb.append("    final static DmcAttributeInfo " + part.getName() + "AI = new DmcAttributeInfo(\"" + part.getName() + "\",0,\"" + part.getType().getObjectName() + "\",ValueTypeEnum.SINGLE,DataTypeEnum.UNKNOWN" + indexSize + weakReference + ");\n\n");
        }
        return sb.toString();
    }

    static String getCopyConstructorAssignments(ArrayList<Part> combinedParts) {
        StringBuffer sb = new StringBuffer();
        sb.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        for (Part part : combinedParts) {
            TypeDefinition type = (TypeDefinition)((TypeDefinitionDMO)part.getType().getObject()).getContainer();
            String ts = part.getType().getObjectName().getNameString();
            String cast = "";
            String clone = "";
            if (part.getMultivalued() != null && part.getMultivalued().booleanValue()) {
                if (type.getIsRefType().booleanValue()) {
                    ts = ts + "REF";
                }
                cast = "(ArrayList<" + ts + ">)";
                clone = ".clone()";
            }
            sb.append("        " + part.getName() + valSuffix + " = " + cast + " original." + part.getName() + valSuffix + clone + ";\n");
        }
        return sb.toString();
    }

    static void getComplexTypeImports(ArrayList<Part> combinedParts, ImportManager imports) throws ResultException {
        for (Part part : combinedParts) {
            TypeDefinition type = (TypeDefinition)((TypeDefinitionDMO)part.getType().getObject()).getContainer();
            String primitiveType = type.getPrimitiveType();
            if (type.getInternallyGenerated().booleanValue() && !type.getIsEnumType().booleanValue() && type.getIsRefType().booleanValue()) {
                imports.addImport(type.getOriginalClass().getDmtREFImport(), "Object reference");
            }
            if (primitiveType != null && !type.getIsRefType().booleanValue()) {
                imports.addImport(primitiveType, "Primitive type");
            }
            if (type.getTypeClassName() == null) continue;
            String sp = ((SchemaDefinitionDMW)type.getDefinedIn()).getSchemaPackage();
            String imp = null;
            String comment = "";
            if (type.getInternallyGenerated().booleanValue()) {
                imp = type.getTypeClassName() + "STATIC";
                comment = "Internally generated type";
            } else {
                imp = sp + ".generated.types.DmcType" + type.getName() + "STATIC";
                comment = "Standard type";
            }
            imports.addImport(imp, comment);
        }
    }
}

