/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import org.dmd.dmc.DmcNamedObjectIF;
import org.dmd.dmc.types.DefinitionName;
import org.dmd.dms.ActionDefinition;
import org.dmd.dms.AttributeDefinition;
import org.dmd.dms.ClassDefinition;
import org.dmd.dms.DmsDefinition;
import org.dmd.dms.EnumDefinition;
import org.dmd.dms.SchemaDefinition;
import org.dmd.dms.SchemaManager;
import org.dmd.dms.TypeDefinition;
import org.dmd.dms.generated.dmw.ActionDefinitionIterableDMW;
import org.dmd.dms.generated.dmw.AttributeDefinitionIterableDMW;
import org.dmd.dms.generated.dmw.ClassDefinitionIterableDMW;
import org.dmd.dms.generated.dmw.SchemaDefinitionDMW;
import org.dmd.dms.generated.dmw.TypeDefinitionIterableDMW;
import org.dmd.dms.generated.enums.ClassTypeEnum;
import org.dmd.dmw.DmwContainerIterator;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.parsing.Token;

public class SchemaDocHtmlFormatter {
    TreeMap<DefinitionName, ClassDefinition> classes = new TreeMap();
    TreeMap<DefinitionName, TypeDefinition> types = new TreeMap();
    TreeMap<DefinitionName, AttributeDefinition> attrs = new TreeMap();
    TreeMap<DefinitionName, ActionDefinition> actions = new TreeMap();
    TreeMap<DefinitionName, DmsDefinition> util = new TreeMap();
    TreeMap<String, TreeMap<String, Token>> index;
    String indexRefHTML;
    String javaDir;
    SchemaManager schema = null;
    String organization;
    String schemaUser;
    String userEmail;

    public SchemaDocHtmlFormatter(String org, String user, String email) {
        this.organization = org;
        this.schemaUser = user;
        this.userEmail = email;
    }

    void dumpHtml(SchemaDefinition sd, String fn) {
        ClassDefinition cd = null;
        TypeDefinition td = null;
        AttributeDefinition ad = null;
        ActionDefinition acd = null;
        Iterator<DefinitionName> entries = null;
        this.classes.clear();
        this.attrs.clear();
        this.actions.clear();
        this.types.clear();
        try {
            ClassDefinitionIterableDMW cdit;
            ActionDefinitionIterableDMW actit;
            AttributeDefinitionIterableDMW adit;
            Iterator<String> sdit;
            BufferedWriter out = new BufferedWriter(new FileWriter(fn));
            out.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\"\n");
            out.write("        \"http://www.w3.org/TR/REC-html40\">\n");
            out.write("<HTML>\n");
            out.write("<HEAD>\n");
            out.write("<TITLE> " + this.organization + " - The " + sd.getObjectName() + " Schema Documentation </TITLE>\n");
            out.write("<LINK href=\"/standard.css\" rel=\"stylesheet\" type=\"text/css\">\n");
            out.write("</HEAD>\n");
            out.write("<BODY BGCOLOR=\"FFFFFF\">\n\n");
            out.write("<TABLE WIDTH=600 CELLPADDING=10> <tr> \n");
            out.write("<TD WIDTH=120 CLASS=\"sidebar2\" VALIGN=TOP>\n");
            out.write("<TD>\n");
            out.write("<CENTER> \n");
            out.write("<P CLASS=\"pagehead\"> The " + sd.getObjectName() + " Schema \n");
            out.write("</CENTER> \n");
            out.write(this.indexRefHTML);
            out.write("<TABLE>\n");
            out.write("<tr>\n");
            out.write("<TD VALIGN=TOP CLASS=\"stronghead\"> Description </TD>\n");
            out.write("<TD CLASS=\"pagetextUnjust\">\n");
            out.write(this.getFormattedDescription(sd.getDescription()));
            out.write("</TD> </tr> \n");
            if (sd.getSchemaPackage() != null) {
                out.write("<tr>\n");
                out.write("<TD VALIGN=TOP CLASS=\"stronghead\"> Package </TD>\n");
                out.write("<TD CLASS=\"pagetextUnjust\">\n");
                String withSlashes = sd.getSchemaPackage().replace('.', '/');
                out.write("<A HREF=\"" + this.javaDir + File.separator + withSlashes + "/package-summary.html\"> " + sd.getSchemaPackage() + " </A>\n");
                out.write("</TD> </tr> \n");
            }
            if ((sdit = sd.getDependsOn()) != null) {
                TreeSet<String> ts = new TreeSet<String>();
                while (sdit.hasNext()) {
                    ts.add(sdit.next());
                }
                out.write("<tr> <TD VALIGN=TOP CLASS=\"stronghead\"> Depends on </TD>\n");
                out.write("<TD CLASS=\"pagetextUnjust\">\n");
                for (String s : ts) {
                    out.write("<A HREF=\"" + s + ".shtml\"> " + s + "</A> <BR>\n");
                }
                out.write("</TD> </tr> \n");
            }
            out.write("</TABLE> <P>\n");
            TypeDefinitionIterableDMW tdit = sd.getTypeDefList();
            if (tdit != null) {
                while (tdit.hasNext()) {
                    td = (TypeDefinition)tdit.next();
                    this.types.put(td.getObjectName(), td);
                }
            }
            if ((adit = sd.getAttributeDefList()) != null) {
                while (adit.hasNext()) {
                    ad = (AttributeDefinition)adit.next();
                    this.attrs.put(ad.getObjectName(), ad);
                }
            }
            if ((actit = sd.getActionDefList()) != null) {
                while (actit.hasNext()) {
                    acd = (ActionDefinition)actit.next();
                    this.actions.put(acd.getObjectName(), acd);
                }
            }
            if ((cdit = sd.getClassDefList()) != null) {
                while (cdit.hasNext()) {
                    cd = (ClassDefinition)cdit.next();
                    this.classes.put(cd.getObjectName(), cd);
                }
            }
            out.write("<P CLASS=\"stronghead\">\nClass Index<BR>Total Classes: ");
            out.write(this.classes.size() + "\n<P CLASS=\"pagetext\">\n");
            entries = this.classes.keySet().iterator();
            while (entries.hasNext()) {
                cd = this.classes.get(entries.next());
                out.write("<A HREF=\"#" + cd.getObjectName() + "\"> " + cd.getObjectName() + "</A> <BR>\n");
            }
            out.write("<P CLASS=\"stronghead\">\nAttribute Index<BR>Total Attributes: ");
            out.write(this.attrs.size() + "\n<P CLASS=\"pagetext\">\n");
            entries = this.attrs.keySet().iterator();
            while (entries.hasNext()) {
                ad = this.attrs.get(entries.next());
                out.write("<A HREF=\"#" + ad.getObjectName() + "\"> " + ad.getObjectName() + "</A> <BR>\n");
            }
            out.write("<P CLASS=\"stronghead\"> Action Index<BR>Total Actions: ");
            out.write(this.actions.size() + "\n<P CLASS=\"pagetext\">\n");
            entries = this.actions.keySet().iterator();
            while (entries.hasNext()) {
                acd = this.actions.get(entries.next());
                out.write("<A HREF=\"#" + acd.getObjectName() + "\"> " + acd.getObjectName() + "</A> <BR>\n");
            }
            if (this.types.size() > 0) {
                out.write("<P CLASS=\"stronghead\">\nType Index<BR>Total Types: ");
                out.write(this.types.size() + "\n<P CLASS=\"pagetext\">\n");
                entries = this.types.keySet().iterator();
                while (entries.hasNext()) {
                    td = this.types.get(entries.next());
                    out.write("<A HREF=\"#" + td.getObjectName() + "\"> " + td.getObjectName() + "</A> <BR>\n");
                }
            }
            this.formatClasses(sd, out);
            this.formatAttributes(sd, out);
            this.formatActions(sd, out);
            this.formatTypes(sd, out);
            out.write(this.getFooter(sd.getObjectName() + ".shtml"));
            out.write("</TD> </tr> </TABLE>");
            out.write("</BODY>\n");
            out.write("</HTML>\n");
            out.close();
        }
        catch (IOException e) {
            System.out.println("IO Error:\n" + e);
        }
    }

    String getFormattedDescription(Iterator<String> description) {
        if (description == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        while (description.hasNext()) {
            sb.append(description.next());
            if (!description.hasNext()) continue;
            sb.append("</p>");
        }
        return sb.toString();
    }

    private void formatClasses(SchemaDefinition currSchema, BufferedWriter out) {
        Iterator<DefinitionName> entries = this.classes.keySet().iterator();
        ClassDefinition cd = null;
        DmwContainerIterator it = null;
        if (this.classes.size() == 0) {
            return;
        }
        try {
            out.write("<P CLASS=\"stronghead\">\nClass Definitions \n");
            out.write("<TABLE> \n");
            while (entries.hasNext()) {
                Iterator<DmsDefinition> sorted;
                cd = this.classes.get(entries.next());
                out.write("<tr> <TH COLSPAN=2> <HR SIZE=3 NOSHADE> </TH> </tr>\n");
                out.write("<tr> <TD WIDTH=100 CLASS=\"stronghead\"> Class </TD>");
                out.write("<TD CLASS=\"pagetext\">");
                out.write("<A NAME=\"" + cd.getObjectName() + "\">" + cd.getObjectName() + "</A>\n");
                if (cd.getAbbrev() != null) {
                    out.write(" (" + cd.getAbbrev() + ")");
                }
                out.write("</TD></tr><tr>\n");
                if (cd.getJavaClass() != null) {
                    out.write("<tr> <TD  CLASS=\"pagetextUnjust\"> Java Class </TD>");
                    out.write("<TD CLASS=\"pagetext\">");
                    String withSlashes = cd.getJavaClass().replace('.', '/');
                    out.write("<A HREF=\"" + this.javaDir + File.separator + withSlashes + ".html\"> " + cd.getJavaClass() + " </A>\n");
                    out.write("</TD></tr><tr>\n");
                }
                out.write("<tr> <TD  CLASS=\"pagetextUnjust\"> Class Type </TD>");
                out.write("<TD CLASS=\"pagetext\">");
                out.write((Object)((Object)cd.getClassType()) + "\n");
                out.write("</TD></tr><tr>\n");
                if (cd.getDerivedFrom() != null) {
                    out.write("<tr> <TD VALIGN=TOP CLASS=\"pagetext\"> Derived from </TD>");
                    out.write("<TD CLASS=\"pagetext\">");
                    if (cd.getDerivedFrom().getDefinedIn() == currSchema) {
                        out.write("<A HREF=\"#" + cd.getDerivedFrom().getObjectName() + "\">" + cd.getDerivedFrom().getObjectName() + "</A> \n");
                    } else {
                        out.write("<A HREF=\"" + ((SchemaDefinitionDMW)cd.getDerivedFrom().getDefinedIn()).getObjectName() + ".shtml#" + cd.getDerivedFrom().getObjectName() + "\">" + cd.getDerivedFrom().getObjectName() + "</A> \n");
                    }
                    out.write("</TD></tr><tr>\n");
                }
                if (cd.getAllImplementors() != null) {
                    it = cd.getAllImplementors().iterator();
                    sorted = this.sort(it);
                    out.write("<tr> <TD VALIGN=TOP CLASS=\"pagetext\"> Implementors </TD>");
                    out.write("<TD CLASS=\"pagetext\">");
                    out.write(this.formatTable(sorted, this.util.size(), 4));
                    out.write("</TD></tr><tr>\n");
                }
                if ((it = cd.getDerivedClasses()) != null) {
                    sorted = this.sort(it);
                    out.write("<tr> <TD VALIGN=TOP CLASS=\"pagetext\"> Derived classes </TD>");
                    out.write("<TD CLASS=\"pagetext\">");
                    out.write(this.formatTable(sorted, this.util.size(), 4));
                    out.write("</TD></tr><tr>\n");
                }
                if ((it = cd.getMust()) != null) {
                    sorted = this.sort(it);
                    out.write("<tr> <TD VALIGN=TOP CLASS=\"pagetext\"> Must have </TD>");
                    out.write("<TD CLASS=\"pagetext\">");
                    out.write(this.formatTable(sorted, this.util.size(), 4));
                    out.write("</TD></tr><tr>\n");
                }
                if ((it = cd.getMay()) != null) {
                    sorted = this.sort(it);
                    out.write("<tr> <TD VALIGN=TOP CLASS=\"pagetext\"> May have </TD>");
                    out.write("<TD CLASS=\"pagetext\">");
                    out.write(this.formatTable(sorted, this.util.size(), 4));
                    out.write("</TD></tr><tr>\n");
                }
                if ((it = cd.getActions()) != null) {
                    sorted = this.sort(it);
                    out.write("<tr> <TD VALIGN=TOP CLASS=\"pagetext\"> Actions </TD>");
                    out.write("<TD CLASS=\"pagetext\">");
                    out.write(this.formatTable(sorted, this.util.size(), 4));
                    out.write("</TD></tr><tr>\n");
                }
                out.write("<tr> <TD VALIGN=TOP CLASS=\"pagetext\"> Description </TD>");
                out.write("<TD CLASS=\"pagetext\">");
                out.write("<A NAME=\"" + cd.getDescription() + "\">" + cd.getDescription() + "</A>\n");
                out.write("</TD></tr><tr>\n");
            }
            out.write("</TABLE>\n\n");
        }
        catch (IOException e) {
            System.out.println("IO Error:\n" + e);
        }
    }

    private void formatAttributes(SchemaDefinition currSchema, BufferedWriter out) {
        Iterator<DefinitionName> entries = this.attrs.keySet().iterator();
        AttributeDefinition ad = null;
        try {
            out.write("<P CLASS=\"stronghead\">\nAttribute Definitions \n");
            out.write("<TABLE> \n");
            while (entries.hasNext()) {
                int i;
                ad = this.attrs.get(entries.next());
                out.write("<tr> <TH COLSPAN=2> <HR SIZE=3 NOSHADE> </TH> </tr>\n");
                out.write("<tr> <TD CLASS=\"stronghead\"> Attribute </TD>");
                out.write("<TD CLASS=\"pagetext\">");
                out.write("<A NAME=\"" + ad.getObjectName() + "\">" + ad.getObjectName() + "</A>\n");
                if (ad.getAbbrev() != null) {
                    out.write(" (" + ad.getAbbrev() + ")");
                }
                out.write("</TD></tr><tr>\n");
                out.write("<tr> <TD VALIGN=TOP CLASS=\"pagetext\"> Type </TD>");
                out.write("<TD CLASS=\"pagetext\">");
                out.write(ad.getValueType().toString());
                out.write("<A HREF=\"" + ((SchemaDefinitionDMW)ad.getType().getDefinedIn()).getObjectName() + ".shtml#" + ad.getType().getObjectName() + "\">" + ad.getType().getObjectName() + "</A>\n");
                out.write("</TD></tr><tr>\n");
                if (ad.getUsedByClassesSize() > 0) {
                    out.write("<tr> <TD  CLASS=\"pagetext\"> Used In Classes </TD>");
                    out.write("<TD CLASS=\"pagetext\">");
                    for (i = 0; i < ad.getUsedByClassesSize(); ++i) {
                        out.write(this.defLink(ad.getUsedByClassesNth(i), null) + " ");
                    }
                    out.write("\n</TD></tr><tr>\n");
                }
                if (ad.getUsedByActionsSize() > 0) {
                    out.write("<tr> <TD  CLASS=\"pagetext\"> Used In Actions </TD>");
                    out.write("<TD CLASS=\"pagetext\">");
                    for (i = 0; i < ad.getUsedByActionsSize(); ++i) {
                        out.write(this.defLink(ad.getUsedByActionsNth(i), null) + " ");
                    }
                    out.write("\n</TD></tr><tr>\n");
                }
                out.write("<tr> <TD VALIGN=TOP CLASS=\"pagetext\"> Description </TD>");
                out.write("<TD CLASS=\"pagetext\">");
                out.write("<A NAME=\"" + ad.getDescription() + "\">" + ad.getDescription() + "</A>\n");
                out.write("</TD></tr><tr>\n");
            }
            out.write("</TABLE>\n\n");
        }
        catch (IOException e) {
            System.out.println("IO Error:\n" + e);
        }
    }

    private void formatActions(SchemaDefinition currSchema, BufferedWriter out) {
        Iterator<DefinitionName> entries = this.actions.keySet().iterator();
        ActionDefinition ad = null;
        AttributeDefinitionIterableDMW it = null;
        try {
            out.write("<P CLASS=\"stronghead\">\nAction Definitions \n");
            out.write("<TABLE> \n");
            while (entries.hasNext()) {
                Iterator<DmsDefinition> sorted;
                ad = this.actions.get(entries.next());
                out.write("<tr> <TH COLSPAN=2> <HR SIZE=3 NOSHADE> </TH> </tr>\n");
                out.write("<tr> <TD CLASS=\"stronghead\"> Action </TD>");
                out.write("<TD CLASS=\"pagetext\">");
                out.write("<A NAME=\"" + ad.getObjectName() + "\">" + ad.getObjectName() + "</A>\n");
                out.write("</TD></tr><tr>\n");
                it = ad.getMustParm();
                if (it != null) {
                    sorted = this.sort(it);
                    out.write("<tr> <TD VALIGN=TOP CLASS=\"pagetext\"> Must parms </TD>");
                    out.write("<TD CLASS=\"pagetext\">");
                    out.write(this.formatTable(sorted, this.util.size(), 4));
                    out.write("</TD></tr><tr>\n");
                }
                if ((it = ad.getMayParm()) != null) {
                    sorted = this.sort(it);
                    out.write("<tr> <TD VALIGN=TOP CLASS=\"pagetext\"> May parms </TD>");
                    out.write("<TD CLASS=\"pagetext\">");
                    out.write(this.formatTable(sorted, this.util.size(), 4));
                    out.write("</TD></tr><tr>\n");
                }
                if (ad.usedByClasses != null) {
                    out.write("<tr> <TD  CLASS=\"pagetext\"> Used In Classes </TD>");
                    out.write("<TD CLASS=\"pagetext\">");
                    for (int i = 0; i < ad.usedByClasses.size(); ++i) {
                        out.write(this.defLink(ad.usedByClasses.get(i), null) + " ");
                    }
                    out.write("\n</TD></tr><tr>\n");
                }
                if (ad.attachedToClasses != null) {
                    out.write("<tr> <TD  CLASS=\"pagetext\"> Attached To Classes </TD>");
                    out.write("<TD CLASS=\"pagetext\">");
                    for (int i = 0; i < ad.attachedToClasses.size(); ++i) {
                        out.write(this.defLink(ad.attachedToClasses.get(i), null) + " ");
                    }
                    out.write("\n</TD></tr><tr>\n");
                }
                out.write("<tr> <TD VALIGN=TOP CLASS=\"pagetext\"> Description </TD>");
                out.write("<TD CLASS=\"pagetext\">");
                out.write("<A NAME=\"" + ad.getDescription() + "\">" + ad.getDescription() + "</A>\n");
                out.write("</TD></tr><tr>\n");
            }
            out.write("</TABLE>\n\n");
        }
        catch (IOException e) {
            System.out.println("IO Error:\n" + e);
        }
    }

    private void formatTypes(SchemaDefinition currSchema, BufferedWriter out) {
        Iterator<DefinitionName> entries = this.types.keySet().iterator();
        TypeDefinition td = null;
        try {
            out.write("<P CLASS=\"stronghead\">\nType Definitions \n");
            out.write("<TABLE> \n");
            while (entries.hasNext()) {
                td = this.types.get(entries.next());
                out.write("<tr> <TH COLSPAN=2> <HR SIZE=3 NOSHADE> </TH> </tr>\n");
                out.write("<tr> <TD CLASS=\"stronghead\"> Type </TD>");
                out.write("<TD CLASS=\"pagetext\">");
                out.write("<A NAME=\"" + td.getObjectName() + "\">" + td.getObjectName() + "</A>\n");
                out.write("</TD></tr><tr>\n");
                out.write("<tr> <TD CLASS=\"pagetext\" VALIGN=TOP> Description </TD>");
                out.write("<TD CLASS=\"pagetext\">");
                out.write("<A NAME=\"" + td.getDescription() + "\">" + td.getDescription() + "</A>\n");
                out.write("</TD></tr><tr>\n");
            }
            out.write("</TABLE>\n\n");
        }
        catch (IOException e) {
            System.out.println("IO Error:\n" + e);
        }
    }

    public Iterator<DmsDefinition> sort(Iterator<DmsDefinition> it) {
        this.util = new TreeMap();
        while (it.hasNext()) {
            DmsDefinition go = it.next();
            this.util.put(go.getObjectName(), go);
        }
        return this.util.values().iterator();
    }

    public String formatTable(Iterator<DmsDefinition> it, int size, int cols) {
        int curr = 1;
        StringBuffer sb = new StringBuffer();
        sb.append("<TABLE>\n");
        sb.append("<tr>\n");
        while (it.hasNext()) {
            DmsDefinition go = it.next();
            sb.append("  <TD CLASS=\"pagetextUnjust\">\n");
            DmcNamedObjectIF sd = go.getDefinedIn();
            sb.append("<A HREF=\"" + ((SchemaDefinitionDMW)sd).getObjectName() + ".shtml#" + go.getObjectName() + "\">" + go.getObjectName() + "</A> \n");
            sb.append("  </TD>\n");
            if (curr % cols == 0 && curr < size) {
                sb.append("</tr>\n<tr>\n");
            }
            ++curr;
        }
        sb.append("</tr>\n</TABLE>\n");
        return sb.toString();
    }

    public void generateIndex(String dir) {
        TreeMap<String, Token> tm;
        StringBuffer sb = new StringBuffer();
        this.initIndex();
        DebugInfo.debugWithTrace("\n\n*** NEED TO USE THE SCHEMA'S GLOBAL INDEX ***\n\n");
        sb.append("<P> <HR SIZE=3 NOSHADE>");
        sb.append("<TABLE>\n");
        sb.append("<tr> <TD CLASS=\"pagetextUnjust\"> <A HREF=\"index-allSchemas.shtml\"> Schema Summary </A></TD><TD></TD> </tr>\n");
        sb.append("<tr> <TD CLASS=\"pagetextUnjust\"> <A HREF=\"classHierarchy.shtml\"> Class Hierarchy </A></TD><TD></TD> </tr>\n");
        sb.append("<tr> <TD CLASS=\"pagetextUnjust\"> <A HREF=\"instanceHierarchy.shtml\"> Instance Hierarchy </A></TD><TD></TD> </tr>\n");
        sb.append("<tr> <TD CLASS=\"pagetextUnjust\"> Definitions Index </TD> <TD>\n");
        for (String key : this.index.keySet()) {
            tm = this.index.get(key);
            if (tm.size() > 0) {
                sb.append("<A HREF=\"index-" + key + ".shtml\">" + key + "</A> \n");
                continue;
            }
            sb.append(key + "  ");
        }
        sb.append("</TD> </tr> </TABLE> <HR SIZE=3 NOSHADE> <P>\n");
        this.indexRefHTML = sb.toString();
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(dir + "/index-allSchemas.shtml"));
            out.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\"\n");
            out.write("        \"http://www.w3.org/TR/REC-html40\">\n");
            out.write("<HTML>\n");
            out.write("<HEAD>\n");
            out.write("<LINK href=\"/standard.css\" rel=\"stylesheet\" type=\"text/css\">\n");
            out.write("<TITLE> " + this.organization + " - Schema Summary </TITLE>\n");
            out.write("</HEAD>\n");
            out.write("<BODY BGCOLOR=\"FFFFFF\">\n\n");
            out.write("<TABLE WIDTH=600 CELLPADDING=10> <tr>\n");
            out.write("<TD WIDTH=120 CLASS=\"sidebar2\" VALIGN=TOP>\n");
            out.write("<TD>\n\n");
            out.write("<P CLASS=\"pagehead\">" + this.organization + " Schema Summary\n");
            out.write(this.indexRefHTML);
            out.write("<TABLE>\n");
            Iterator<SchemaDefinition> schemaIT = this.schema.getSchemas();
            while (schemaIT.hasNext()) {
                SchemaDefinition sd = schemaIT.next();
                out.write("<tr> <TD VALIGN=TOP CLASS=\"pagetextUnjust\">\n");
                out.write(this.schemaLink(sd));
                out.write("</TD> <TD CLASS=\"pagetextUnjust\">\n");
                out.write(this.getFormattedDescription(sd.getDescription()));
                out.write("</TD> </tr>");
            }
            out.write("</TABLE>");
            out.write("</TD> </tr> </TABLE>");
            out.write("</BODY>\n");
            out.write("</HTML>\n");
            out.close();
        }
        catch (IOException e) {
            System.out.println("IO Error:\n" + e);
        }
        for (String key : this.index.keySet()) {
            tm = this.index.get(key);
            String fn = new String(dir + File.separator + "index-" + key + ".shtml");
            if (tm.size() <= 0) continue;
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter(fn));
                Iterator<Token> defsIt = tm.values().iterator();
                System.out.println("Generating index - " + fn);
                out.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\"\n");
                out.write("        \"http://www.w3.org/TR/REC-html40\">\n");
                out.write("<HTML>\n");
                out.write("<HEAD>\n");
                out.write("<LINK href=\"/standard.css\" rel=\"stylesheet\" type=\"text/css\">\n");
                out.write("<TITLE> " + this.organization + " - Schema Definitions Starting With The Letter - " + key + "</TITLE>\n");
                out.write("</HEAD>\n");
                out.write("<BODY BGCOLOR=\"FFFFFF\">\n\n");
                out.write("<TABLE WIDTH=600 CELLPADDING=10> <tr> \n");
                out.write("<TD WIDTH=120 CLASS=\"sidebar2\" VALIGN=TOP>\n");
                out.write("<TD>\n\n");
                out.write(this.indexRefHTML);
                out.write("<H1> - " + key + " - </H1> <P>");
                out.write("<TABLE>\n");
                while (defsIt.hasNext()) {
                    Token t = defsIt.next();
                    DmsDefinition go = (DmsDefinition)t.getUserData();
                    out.write("<tr> <TD VALIGN=TOP>\n");
                    if (go instanceof AttributeDefinition) {
                        AttributeDefinition ad = (AttributeDefinition)go;
                        if (this.schema.attrAbbrevs.get(t.getValue()) != null) {
                            out.write(this.defLink(go, t.getValue()) + "</TD> <TD>\n");
                            out.write("the abbreviated name of the " + this.defLink(ad, null) + " attribute of type " + this.defLink(ad.getType(), null) + " from the " + this.schemaLink((SchemaDefinition)ad.getDefinedIn()) + " schema");
                        } else {
                            out.write(this.defLink(go, null) + "</TD> <TD>\n");
                            out.write(" an attribute of type " + this.defLink(ad.getType(), null) + " from the " + this.schemaLink((SchemaDefinition)ad.getDefinedIn()) + " schema");
                        }
                    } else if (go instanceof ClassDefinition) {
                        ClassDefinition cd = (ClassDefinition)go;
                        if (this.schema.attrAbbrevs.get(t.getValue()) != null) {
                            out.write(this.defLink(go, t.getValue()) + "</TD> <TD>\n");
                            out.write("the abbreviated name of the " + this.defLink(cd, null) + " class from the " + this.schemaLink((SchemaDefinition)cd.getDefinedIn()) + " schema");
                        } else {
                            out.write(this.defLink(go, null) + "</TD> <TD>\n");
                            out.write(" a class from the " + this.schemaLink((SchemaDefinition)cd.getDefinedIn()) + " schema");
                        }
                    } else if (go instanceof ActionDefinition) {
                        ActionDefinition acd = (ActionDefinition)go;
                        out.write(this.defLink(go, null) + "</TD> <TD>\n");
                        out.write(" an action from the " + this.schemaLink((SchemaDefinition)acd.getDefinedIn()) + " schema");
                    } else if (go instanceof TypeDefinition) {
                        TypeDefinition td = (TypeDefinition)go;
                        out.write(this.defLink(go, null) + "</TD> <TD>\n");
                        out.write(" a type from the " + this.schemaLink((SchemaDefinition)td.getDefinedIn()) + " schema");
                    } else if (go instanceof EnumDefinition) {
                        EnumDefinition evd = (EnumDefinition)go;
                        out.write(this.defLink(go, null) + "</TD> <TD>\n");
                        out.write(" an enum definition from the " + this.schemaLink((SchemaDefinition)evd.getDefinedIn()) + " schema");
                    } else if (go instanceof SchemaDefinition) {
                        SchemaDefinition sd = (SchemaDefinition)go;
                        out.write(this.schemaLink(sd) + "</TD> <TD>\n");
                        out.write(" the " + this.schemaLink(sd) + " schema");
                    }
                    out.write("\n</TD> </tr>\n");
                }
                out.write("</TABLE>");
                out.write("</TD> </tr> </TABLE>");
                out.write("</BODY>\n");
                out.write("</HTML>\n");
                out.close();
            }
            catch (IOException e) {
                System.out.println("IO Error:\n" + e);
            }
        }
    }

    void formatClassList(Iterator<ClassDefinition> it, int size, BufferedWriter out) {
        try {
            out.write("<UL>");
            for (int i = 0; i < size; ++i) {
                ClassDefinition cd = it.next();
                String description = this.getFormattedDescription(cd.getDescription());
                if (cd.getClassType() != ClassTypeEnum.STRUCTURAL) continue;
                if (description == null) {
                    out.write("<LI TYPE=\"circle\"> " + cd.getObjectName() + "</LI>\n");
                    continue;
                }
                out.write("<LI TYPE=\"circle\"> " + cd.getObjectName() + " - " + description + "</LI>\n");
            }
            out.write("</UL>");
        }
        catch (IOException e) {
            System.out.println("IO Error:\n" + e);
        }
    }

    void dumpInstanceHierarchy(String dir) {
        this.classes.clear();
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(dir + "/instanceHierarchy.shtml"));
            out.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\"\n");
            out.write("        \"http://www.w3.org/TR/REC-html40\">\n");
            out.write("<HTML>\n");
            out.write("<HEAD>\n");
            out.write("<TITLE> Class Instance Hierarchy </TITLE>\n");
            out.write("<LINK href=\"/standard.css\" rel=\"stylesheet\" type=\"text/css\">\n");
            out.write("</HEAD>\n");
            out.write("<BODY BGCOLOR=\"FFFFFF\">\n\n");
            out.write("<TABLE WIDTH=600 CELLPADDING=10> <tr> \n");
            out.write("<TD WIDTH=120 CLASS=\"sidebar2\" VALIGN=TOP>\n");
            out.write("<TD>\n");
            out.write("<CENTER> \n");
            out.write("<P CLASS=\"pagehead\"> The Class Instance Hierarchy \n");
            out.write("</CENTER> \n");
            out.write(this.indexRefHTML);
            out.write("<TD> </tr> </TABLE>");
            out.write("</BODY>\n");
            out.write("</HTML>\n");
            out.close();
        }
        catch (IOException e) {
            System.out.println("IO Error:\n" + e);
        }
    }

    void dumpDataTypeInfo(String dir) {
        this.classes.clear();
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(dir + "/dataTypeInfo.shtml"));
            out.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\"\n");
            out.write("        \"http://www.w3.org/TR/REC-html40\">\n");
            out.write("<HTML>\n");
            out.write("<HEAD>\n");
            out.write("<TITLE> " + this.organization + " - Class Data Types </TITLE>\n");
            out.write("<LINK href=\"/standard.css\" rel=\"stylesheet\" type=\"text/css\">\n");
            out.write("</HEAD>\n");
            out.write("<BODY BGCOLOR=\"FFFFFF\">\n\n");
            out.write("<TABLE WIDTH=600 CELLPADDING=10> <tr> \n");
            out.write("<TD WIDTH=120 CLASS=\"sidebar2\" VALIGN=TOP>\n");
            out.write("<TD>\n");
            out.write("<CENTER> \n");
            out.write("<P CLASS=\"pagehead\"> Class Data Types \n");
            out.write("</CENTER> \n");
            out.write(this.indexRefHTML);
            out.write("<TD> </tr> </TABLE>");
            out.write("</BODY>\n");
            out.write("</HTML>\n");
            out.close();
        }
        catch (IOException e) {
            System.out.println("IO Error:\n" + e);
        }
    }

    void formatClassHierarchy(Iterator<ClassDefinition> it, int size, BufferedWriter out) {
        try {
            out.write("<UL>");
            for (int i = 0; i < size; ++i) {
                ClassDefinition cd = it.next();
                out.write("<LI TYPE=\"circle\"> " + this.defLink(cd, null) + "</LI>\n");
                if (cd.getDerivedClasses() == null) continue;
                this.formatDerivedClassHierarchy(cd.getDerivedClasses(), out);
            }
            out.write("</UL>");
        }
        catch (IOException e) {
            System.out.println("IO Error:\n" + e);
        }
    }

    void formatDerivedClassHierarchy(Iterator<ClassDefinition> it, BufferedWriter out) {
        try {
            out.write("<UL>");
            while (it.hasNext()) {
                ClassDefinition cd = it.next();
                out.write("<LI TYPE=\"circle\"> " + this.defLink(cd, null) + "</LI>\n");
                if (cd.getDerivedClasses() == null) continue;
                this.formatDerivedClassHierarchy(cd.getDerivedClasses(), out);
            }
            out.write("</UL>");
        }
        catch (IOException e) {
            System.out.println("IO Error:\n" + e);
        }
    }

    void initIndex() {
        this.index = new TreeMap();
        this.index.put(new String("0"), new TreeMap());
        this.index.put(new String("1"), new TreeMap());
        this.index.put(new String("2"), new TreeMap());
        this.index.put(new String("3"), new TreeMap());
        this.index.put(new String("4"), new TreeMap());
        this.index.put(new String("5"), new TreeMap());
        this.index.put(new String("6"), new TreeMap());
        this.index.put(new String("7"), new TreeMap());
        this.index.put(new String("8"), new TreeMap());
        this.index.put(new String("9"), new TreeMap());
        this.index.put(new String("A"), new TreeMap());
        this.index.put(new String("B"), new TreeMap());
        this.index.put(new String("C"), new TreeMap());
        this.index.put(new String("D"), new TreeMap());
        this.index.put(new String("E"), new TreeMap());
        this.index.put(new String("F"), new TreeMap());
        this.index.put(new String("G"), new TreeMap());
        this.index.put(new String("H"), new TreeMap());
        this.index.put(new String("I"), new TreeMap());
        this.index.put(new String("J"), new TreeMap());
        this.index.put(new String("K"), new TreeMap());
        this.index.put(new String("L"), new TreeMap());
        this.index.put(new String("M"), new TreeMap());
        this.index.put(new String("N"), new TreeMap());
        this.index.put(new String("O"), new TreeMap());
        this.index.put(new String("P"), new TreeMap());
        this.index.put(new String("Q"), new TreeMap());
        this.index.put(new String("R"), new TreeMap());
        this.index.put(new String("S"), new TreeMap());
        this.index.put(new String("T"), new TreeMap());
        this.index.put(new String("U"), new TreeMap());
        this.index.put(new String("V"), new TreeMap());
        this.index.put(new String("W"), new TreeMap());
        this.index.put(new String("X"), new TreeMap());
        this.index.put(new String("Y"), new TreeMap());
        this.index.put(new String("Z"), new TreeMap());
    }

    String schemaLink(SchemaDefinition sd) {
        return new String("<A HREF=\"" + sd.getObjectName() + ".shtml\">" + sd.getObjectName() + "</A> \n");
    }

    String defLink(DmsDefinition go, String alias) {
        DmsDefinition def = go;
        DmcNamedObjectIF sd = def.getDefinedIn();
        if (alias == null) {
            return new String("<A HREF=\"" + ((SchemaDefinitionDMW)sd).getObjectName() + ".shtml#" + go.getObjectName() + "\">" + go.getObjectName() + "</A> \n");
        }
        return new String("<A HREF=\"" + ((SchemaDefinitionDMW)sd).getObjectName() + ".shtml#" + go.getObjectName() + "\">" + alias + "</A> \n");
    }

    String getFooter(String filename) {
        StringBuffer sb = new StringBuffer();
        sb.append("<CENTER>\n");
        sb.append("<TABLE> <tr> <TD CLASS=\"smalltext\">\n");
        sb.append("URL: http://www.dark-matter-data.org<!--#echo var=\"DOCUMENT_URI\" -->\n");
        sb.append("<BR>\n");
        sb.append("Comments to: <A HREF=\"mailto:" + this.userEmail + "\">" + this.schemaUser + " </A>\n");
        sb.append("<BR>\n");
        sb.append("Modified:\n");
        sb.append("<!--#config timefmt=\"%B %d, %Y\" -->\n");
        sb.append("<!--#flastmod file=\"" + filename + "\" -->\n");
        sb.append("Copyright &#169;\n");
        sb.append("<!--#config timefmt=\"%Y\" -->\n");
        sb.append("<!--#flastmod file=\"" + filename + "\" -->\n");
        sb.append(this.organization + "\n");
        sb.append("</TD> </tr> </TABLE> \n");
        return sb.toString();
    }
}

