/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.util;

import org.dmd.dms.TypeDefinition;
import org.dmd.dms.generated.dmw.SchemaDefinitionDMW;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class TypeAndAttr {
    public TypeDefinition td;
    public ValueTypeEnum valueType;
    public int indexSize;
    public boolean indexed;
    public String name;

    public TypeAndAttr(TypeDefinition t, ValueTypeEnum v, Integer idxSize) {
        this.td = t;
        this.valueType = v;
        this.name = this.td.getName().getNameString() + "-" + (Object)((Object)this.valueType);
        this.indexed = false;
        if (idxSize == null) {
            this.indexSize = 0;
        } else {
            this.indexSize = idxSize;
            if (this.indexSize > 0) {
                this.indexed = true;
            }
        }
    }

    public String getImport() {
        if (this.td.getIsRefType().booleanValue() && !this.td.getIsExtendedRefType().booleanValue()) {
            if (this.td.getName().getNameString().endsWith("REF")) {
                return ((SchemaDefinitionDMW)this.td.getDefinedIn()).getSchemaPackage() + ".generated.types.DmcType" + this.td.getName() + this.getSuffix();
            }
            return ((SchemaDefinitionDMW)this.td.getDefinedIn()).getSchemaPackage() + ".generated.types.DmcType" + this.td.getName() + "REF" + this.getSuffix();
        }
        if (this.td.getName().getNameString().endsWith("REF") && this.td.getIsEnumType().booleanValue()) {
            return ((SchemaDefinitionDMW)this.td.getDefinedIn()).getSchemaPackage() + ".generated.types.DmcType" + this.td.getEnumName() + this.getSuffix();
        }
        return ((SchemaDefinitionDMW)this.td.getDefinedIn()).getSchemaPackage() + ".generated.types.DmcType" + this.td.getName() + this.getSuffix();
    }

    String getSuffix() {
        String rc = null;
        switch (this.valueType) {
            case SINGLE: {
                rc = "SV";
                break;
            }
            case MULTI: {
                rc = "MV";
                break;
            }
            case HASHMAPPED: 
            case TREEMAPPED: {
                rc = "MAP";
                break;
            }
            case HASHSET: 
            case TREESET: {
                rc = "SET";
            }
        }
        return rc;
    }
}

