/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.dsd.dsda.server.generated.dsd;

import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcClassInfo;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcNameClashObjectSet;
import org.dmd.dmc.DmcNameClashResolverIF;
import org.dmd.dmc.DmcNameResolverWithClashSupportIF;
import org.dmd.dmc.DmcNamedObjectIF;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.DmcObjectName;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.DmcValueExceptionSet;
import org.dmd.dmc.definitions.DmcDefinitionSet;
import org.dmd.dmc.types.DotName;
import org.dmd.dms.DSDefinition;
import org.dmd.dmt.dsd.dsda.server.extended.ABConceptX;
import org.dmd.dmt.dsd.dsda.server.extended.AConceptBase;
import org.dmd.dmt.dsd.dsda.server.extended.AConceptX;
import org.dmd.dmt.dsd.dsda.server.extended.ModuleA;
import org.dmd.dmt.dsd.dsda.server.generated.dsd.ModuleADefinitionsIF;
import org.dmd.dmt.dsd.dsda.server.generated.dsd.ModuleAGlobalInterface;
import org.dmd.dmt.dsd.dsda.shared.generated.dmo.DsdADMSAG;
import org.dmd.dmw.DmwNamedObjectWrapper;
import org.dmd.util.exceptions.ResultException;

public class ModuleADefinitionManager
implements DmcNameClashResolverIF,
DmcNameResolverWithClashSupportIF,
ModuleAGlobalInterface,
ModuleADefinitionsIF {
    private DmcDefinitionSet<DSDefinition> allDefinitions = new DmcDefinitionSet("allDefinitions");
    private DmcDefinitionSet<AConceptBase> AConceptBaseDefs;
    private DmcDefinitionSet<ABConceptX> ABConceptXDefs;
    private DmcDefinitionSet<AConceptX> AConceptXDefs;
    private DmcDefinitionSet<ModuleA> ModuleADefs;
    private TreeMap<DmcClassInfo, DmcDefinitionSet<?>> indicesByClass = new TreeMap();

    public ModuleADefinitionManager() {
        this.AConceptBaseDefs = new DmcDefinitionSet("AConceptBase", this.allDefinitions);
        this.indicesByClass.put(DsdADMSAG.__AConceptBase, this.AConceptBaseDefs);
        this.AConceptXDefs = new DmcDefinitionSet("AConceptX", this.allDefinitions, this.AConceptBaseDefs);
        this.indicesByClass.put(DsdADMSAG.__AConceptX, this.AConceptXDefs);
        this.ABConceptXDefs = new DmcDefinitionSet("ABConceptX", this.allDefinitions, this.AConceptXDefs);
        this.indicesByClass.put(DsdADMSAG.__ABConceptX, this.ABConceptXDefs);
        this.ModuleADefs = new DmcDefinitionSet("ModuleA", this.allDefinitions, this.AConceptBaseDefs);
        this.indicesByClass.put(DsdADMSAG.__ModuleA, this.ModuleADefs);
    }

    public void resolveReferences() throws DmcValueExceptionSet {
        for (DSDefinition def : this.allDefinitions.values()) {
            def.resolveReferences(this, this);
        }
    }

    public Collection<DmwNamedObjectWrapper> getIndex(DmcClassInfo ci) {
        DmcDefinitionSet<?> dds = this.indicesByClass.get(ci);
        if (dds == null) {
            throw new IllegalStateException("No index available for class: " + ci.name);
        }
        return dds.getIndex();
    }

    @Override
    public DmcNamedObjectIF findNamedObject(DmcObjectName name) {
        DSDefinition def = null;
        try {
            def = this.allDefinitions.getDefinition(name.toString());
        }
        catch (DmcNameClashException e) {
            e.printStackTrace();
        }
        catch (DmcValueException e) {
            e.printStackTrace();
        }
        return def;
    }

    public DSDefinition findDefinition(DotName name) {
        return this.allDefinitions.getDefinition(name);
    }

    public void deleteDefinition(DotName name) throws ResultException {
        DSDefinition def = this.allDefinitions.getDefinition(name);
        if (def == null) {
            throw new ResultException("Could not find object to delete: " + name.getNameString());
        }
        DmcDefinitionSet<?> dds = this.indicesByClass.get(def.getConstructionClassInfo());
        dds.delete(name);
        def.youAreDeleted();
        AConceptBase base = (AConceptBase)def;
        ModuleA module = base.getDefinedInModuleA();
        if (def instanceof ABConceptX) {
            module.deleteABConceptX((ABConceptX)def);
        } else if (def instanceof AConceptX) {
            module.deleteAConceptX((AConceptX)def);
        } else if (def instanceof ModuleA) {
            // empty if block
        }
    }

    @Override
    public DmcNamedObjectIF findNamedObject(DmcObjectName name, int attributeID) {
        throw new IllegalStateException("This method is not supported on generated definition managers");
    }

    @Override
    public DmcObject findNamedDMO(DmcObjectName name) {
        DSDefinition def = null;
        try {
            def = this.allDefinitions.getDefinition(name.toString());
        }
        catch (DmcNameClashException e) {
            e.printStackTrace();
        }
        catch (DmcValueException e) {
            e.printStackTrace();
        }
        if (def == null) {
            return null;
        }
        return def.getDMO();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DmcNamedObjectIF findNamedObjectMayClash(DmcObject object, DmcObjectName name, DmcNameClashResolverIF resolver, DmcAttributeInfo ai) throws DmcValueException {
        void var5_9;
        Object var5_5 = null;
        DotName dn = new DotName(name.getNameString() + "." + ai.type);
        if (name.getNameString().indexOf(".") == -1) {
            try {
                DSDefinition dSDefinition = this.allDefinitions.getDefinitionByNameAndType(dn);
                return var5_9;
            }
            catch (DmcNameClashException e) {
                DmcNamedObjectIF dmcNamedObjectIF = resolver.resolveClash(object, ai, e.getClashSet());
                if (dmcNamedObjectIF != null) return var5_9;
                DmcValueException ex = new DmcValueException("The reference to : " + name.getNameString() + " is ambiguous. You must specify the module name as a prefix to the name. Here are your options:");
                Iterator<DmcNamedObjectIF> it = e.getMatches();
                while (it.hasNext()) {
                    AConceptBase def = (AConceptBase)it.next();
                    ex.addMoreInfo(def.getDefinedInModuleA().getName().getNameString() + "." + name.getNameString());
                }
                throw ex;
            }
        } else {
            DSDefinition dSDefinition = this.allDefinitions.getDefinition(dn);
        }
        return var5_9;
    }

    @Override
    public DmcNamedObjectIF resolveClash(DmcObject obj, DmcAttributeInfo ai, DmcNameClashObjectSet<?> ncos) throws DmcValueException {
        DSDefinition rc = null;
        DSDefinition resolving = (DSDefinition)obj.getContainer();
        Iterator<DmcNamedObjectIF> it = ncos.getMatches();
        while (it.hasNext()) {
            DSDefinition def = (DSDefinition)it.next();
            if (!resolving.getNameOfModuleWhereThisCameFrom().equals(def.getNameOfModuleWhereThisCameFrom())) continue;
            rc = def;
            break;
        }
        return rc;
    }

    void addAConceptBase(AConceptBase def) {
        this.AConceptBaseDefs.add(def);
    }

    void deleteAConceptBase(AConceptBase def) {
        try {
            this.AConceptBaseDefs.delete(def);
        }
        catch (ResultException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int getAConceptBaseCount() {
        return this.AConceptBaseDefs.size();
    }

    @Override
    public AConceptBase getAConceptBase(DotName name) {
        return this.AConceptBaseDefs.getDefinition(name);
    }

    @Override
    public Iterator<AConceptBase> getAllAConceptBase() {
        return this.AConceptBaseDefs.values().iterator();
    }

    @Override
    public void addABConceptX(ABConceptX def) {
        this.ABConceptXDefs.add(def);
        this.addAConceptX(def);
    }

    @Override
    public void deleteABConceptX(ABConceptX def) {
        try {
            this.ABConceptXDefs.delete(def);
        }
        catch (ResultException e) {
            throw new IllegalStateException(e);
        }
        this.deleteAConceptX(def);
    }

    @Override
    public int getABConceptXCount() {
        return this.ABConceptXDefs.size();
    }

    @Override
    public ABConceptX getABConceptX(DotName name) {
        return this.ABConceptXDefs.getDefinition(name);
    }

    @Override
    public Iterator<ABConceptX> getAllABConceptX() {
        return this.ABConceptXDefs.values().iterator();
    }

    @Override
    public ABConceptX getABConceptXDefinition(String name) throws DmcNameClashException, DmcValueException {
        return this.ABConceptXDefs.getDefinition(name);
    }

    @Override
    public Iterator<ABConceptX> getABConceptXDefinitionsByName(String name) throws DmcValueException {
        return this.ABConceptXDefs.getDefinitionsByName(name);
    }

    @Override
    public int getABConceptXDefinitionCountByName(String name) throws DmcValueException {
        return this.ABConceptXDefs.getDefinitionCountByName(name);
    }

    @Override
    public void addAConceptX(AConceptX def) {
        this.AConceptXDefs.add(def);
        this.addAConceptBase(def);
    }

    @Override
    public void deleteAConceptX(AConceptX def) {
        try {
            this.AConceptXDefs.delete(def);
        }
        catch (ResultException e) {
            throw new IllegalStateException(e);
        }
        this.deleteAConceptBase(def);
    }

    @Override
    public int getAConceptXCount() {
        return this.AConceptXDefs.size();
    }

    @Override
    public AConceptX getAConceptX(DotName name) {
        return this.AConceptXDefs.getDefinition(name);
    }

    @Override
    public Iterator<AConceptX> getAllAConceptX() {
        return this.AConceptXDefs.values().iterator();
    }

    @Override
    public AConceptX getAConceptXDefinition(String name) throws DmcNameClashException, DmcValueException {
        return this.AConceptXDefs.getDefinition(name);
    }

    @Override
    public Iterator<AConceptX> getAConceptXDefinitionsByName(String name) throws DmcValueException {
        return this.AConceptXDefs.getDefinitionsByName(name);
    }

    @Override
    public int getAConceptXDefinitionCountByName(String name) throws DmcValueException {
        return this.AConceptXDefs.getDefinitionCountByName(name);
    }

    @Override
    public void addModuleA(ModuleA def) {
        this.ModuleADefs.add(def);
        this.addAConceptBase(def);
    }

    @Override
    public void deleteModuleA(ModuleA def) {
        try {
            this.ModuleADefs.delete(def);
        }
        catch (ResultException e) {
            throw new IllegalStateException(e);
        }
        this.deleteAConceptBase(def);
    }

    @Override
    public int getModuleACount() {
        return this.ModuleADefs.size();
    }

    @Override
    public ModuleA getModuleA(DotName name) {
        return this.ModuleADefs.getDefinition(name);
    }

    @Override
    public Iterator<ModuleA> getAllModuleA() {
        return this.ModuleADefs.values().iterator();
    }

    @Override
    public ModuleA getModuleADefinition(String name) throws DmcNameClashException, DmcValueException {
        return this.ModuleADefs.getDefinition(name);
    }

    @Override
    public Iterator<ModuleA> getModuleADefinitionsByName(String name) throws DmcValueException {
        return this.ModuleADefs.getDefinitionsByName(name);
    }

    @Override
    public int getModuleADefinitionCountByName(String name) throws DmcValueException {
        return this.ModuleADefs.getDefinitionCountByName(name);
    }

    public void addDefinition(DSDefinition definition) {
        if (definition instanceof ABConceptX) {
            this.addABConceptX((ABConceptX)definition);
        } else if (definition instanceof AConceptX) {
            this.addAConceptX((AConceptX)definition);
        } else if (definition instanceof ModuleA) {
            this.addModuleA((ModuleA)definition);
        }
    }

    public void addDefinition(DSDefinition definition, ModuleA module) {
        if (definition instanceof ABConceptX) {
            this.addABConceptX((ABConceptX)definition);
            module.addABConceptX((ABConceptX)definition);
        } else if (definition instanceof AConceptX) {
            this.addAConceptX((AConceptX)definition);
            module.addAConceptX((AConceptX)definition);
        } else if (definition instanceof ModuleA) {
            this.addModuleA((ModuleA)definition);
        }
    }

    public String summary() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.AConceptBaseDefs.summary());
        sb.append(this.AConceptXDefs.summary());
        sb.append(this.ABConceptXDefs.summary());
        sb.append(this.ModuleADefs.summary());
        return sb.toString();
    }
}

