/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.dsd.dsda.server.generated.dsd;

import java.io.File;
import java.io.IOException;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.DmcValueExceptionSet;
import org.dmd.dmc.rules.DmcRuleExceptionSet;
import org.dmd.dmt.dsd.dsda.server.extended.ModuleA;
import org.dmd.dmt.dsd.dsda.server.generated.dsd.ModuleAGeneratorInterface;
import org.dmd.dmt.dsd.dsda.server.generated.dsd.ModuleAParsingCoordinator;
import org.dmd.util.BooleanVar;
import org.dmd.util.exceptions.ResultException;
import org.dmd.util.parsing.CommandLine;
import org.dmd.util.parsing.ConfigLocation;
import org.dmd.util.parsing.StringArrayList;

public abstract class ModuleAGenUtility
implements ModuleAGeneratorInterface {
    protected ModuleAParsingCoordinator parser;
    protected CommandLine commandLine = new CommandLine();
    protected BooleanVar helpFlag = new BooleanVar();
    protected StringArrayList srcdir = new StringArrayList();
    protected StringBuffer workspace = new StringBuffer();
    protected StringBuffer outdir = new StringBuffer();
    protected StringArrayList targets = new StringArrayList();
    protected BooleanVar debug = new BooleanVar();
    protected StringArrayList jars = new StringArrayList();
    protected StringArrayList searchPaths = new StringArrayList();

    protected ModuleAGenUtility() {
        this.commandLine.addOption("-h", this.helpFlag, "Dumps the help message.");
        this.commandLine.addOption("-srcdir", this.srcdir, "The source directories to search.");
        this.commandLine.addOption("-workspace", this.workspace, "The workspace base directory, this is appended to all srcdir directories.");
        this.commandLine.addOption("-outdir", this.outdir, "The output directory for generated artifacts.");
        this.commandLine.addOption("-targets", this.targets, "The names of the target configs. If this isn't specified, we generate for all configs.");
        this.commandLine.addOption("-debug", this.debug, "Dump debug information.");
        this.commandLine.addOption("-jars", this.jars, "The prefixs of jars to search for .tma config files.");
    }

    public void run(String[] args) throws ResultException, DmcValueException, IOException, DmcRuleExceptionSet, DmcNameClashException, DmcValueExceptionSet {
        this.commandLine.parseArgs(args);
        if (this.helpFlag.booleanValue()) {
            this.displayHelp();
            return;
        }
        for (String src : this.srcdir) {
            if (this.workspace.length() > 0) {
                this.searchPaths.add(this.workspace + File.separator + src);
                continue;
            }
            this.searchPaths.add(src);
        }
        this.initialize();
        this.parser = new ModuleAParsingCoordinator(this, this.searchPaths, this.jars);
        if (this.targets.size() > 0) {
            for (String target : this.targets) {
                this.parser.generateForConfig(target);
            }
        } else {
            this.parser.generateForAllConfigs();
        }
    }

    public void initialize() throws ResultException {
    }

    public ConfigLocation getLocation(ModuleA module) {
        return this.parser.getLocation(module);
    }
}

