/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.dsd.dsda.shared.generated.types;

import java.io.Serializable;
import java.util.ArrayList;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcNameClashResolverIF;
import org.dmd.dmc.DmcNameResolverIF;
import org.dmd.dmc.DmcNameResolverWithClashSupportIF;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.DmcOutputStreamIF;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.DmcValueExceptionSet;
import org.dmd.dmc.util.ComplexTypeSplitter;
import org.dmd.dmc.util.JSONUtil;
import org.dmd.dmc.util.ParsedNameValuePair;
import org.dmd.dms.generated.enums.DataTypeEnum;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.generated.types.DmcTypeStringSTATIC;
import org.dmd.dmt.dsd.dsda.shared.generated.types.DmcTypeTypeAndAttributeSTATIC;
import org.dmd.dmt.dsd.dsda.shared.generated.types.TypeAndAttribute;

public class ComplexWithComplex
implements Serializable {
    static final int requiredParts = 2;
    String variableV;
    static final DmcAttributeInfo variableAI = new DmcAttributeInfo("variable", 0, "String", ValueTypeEnum.SINGLE, DataTypeEnum.UNKNOWN, 0, false);
    TypeAndAttribute referenceV;
    static final DmcAttributeInfo referenceAI = new DmcAttributeInfo("reference", 0, "TypeAndAttribute", ValueTypeEnum.SINGLE, DataTypeEnum.UNKNOWN, 0, false);

    public ComplexWithComplex() {
    }

    public ComplexWithComplex(ComplexWithComplex original) {
        this.variableV = original.variableV;
        this.referenceV = original.referenceV;
    }

    public ComplexWithComplex(String variable_, TypeAndAttribute reference_) throws DmcValueException {
        this.variableV = DmcTypeStringSTATIC.instance.typeCheck(variable_);
        this.referenceV = DmcTypeTypeAndAttributeSTATIC.instance.typeCheck(reference_);
    }

    public ComplexWithComplex(String initialInput) throws DmcValueException {
        this.initialize(initialInput);
    }

    void initialize(String initialInput) throws DmcValueException {
        ArrayList<ParsedNameValuePair> nvp = ComplexTypeSplitter.parse(initialInput, '.');
        if (nvp.size() < 2) {
            throw new DmcValueException("Missing required values for complex type: ComplexWithComplex\nValue: " + initialInput);
        }
        this.variableV = DmcTypeStringSTATIC.instance.typeCheck(nvp.get(0).getValue());
        this.referenceV = DmcTypeTypeAndAttributeSTATIC.instance.typeCheck(nvp.get(1).getValue());
    }

    public void serializeIt(DmcOutputStreamIF dos) throws Exception {
        dos.writeUTF(this.toString());
    }

    public void deserializeIt(DmcInputStreamIF dis) throws Exception {
        this.initialize(dis.readUTF());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.variableV.toString());
        sb.append('.');
        sb.append(this.referenceV.toString());
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ComplexWithComplex) {
            return this.toString().equals(((ComplexWithComplex)obj).toString());
        }
        return false;
    }

    public void toJSON(StringBuffer sb, int padding, String indent) {
        sb.append(indent + "{\n");
        sb.append(indent + "  \"variable\": \"" + JSONUtil.escape(this.variableV.toString()) + "\",\n");
        sb.append(indent + "  \"reference\": ");
        this.referenceV.toJSON(sb, padding, indent);
        sb.append("");
        sb.append("\n" + indent + "}");
    }

    public String getVariable() {
        return this.variableV;
    }

    public TypeAndAttribute getReference() {
        return this.referenceV;
    }

    public void resolve(DmcNameResolverIF resolver, String attrName) throws DmcValueException {
        Object obj = null;
        if (this.referenceV != null) {
            this.referenceV.resolve(resolver, attrName);
        }
    }

    public void resolve(DmcNameResolverWithClashSupportIF resolver, DmcObject object, DmcNameClashResolverIF ncr, DmcAttributeInfo ai) throws DmcValueException, DmcValueExceptionSet {
        Object obj = null;
        if (this.referenceV != null) {
            this.referenceV.resolve(resolver, object, ncr, ai);
        }
    }

    public void removeBackRefsFromValue() {
        if (this.referenceV != null) {
            this.referenceV.removeBackRefsFromValue();
        }
    }
}

