/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.dsd.dsda.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.dsd.dsda.shared.generated.types.ABConceptXREF;
import org.dmd.dmt.dsd.dsda.shared.generated.types.DmcTypeABConceptXREF;

public class DmcTypeABConceptXREFSET
extends DmcTypeABConceptXREF
implements Serializable {
    private static final Iterator<ABConceptXREF> emptyList = new HashSet().iterator();
    protected Set<ABConceptXREF> value;

    public DmcTypeABConceptXREFSET() {
        this.value = null;
    }

    public DmcTypeABConceptXREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<ABConceptXREF>() : new TreeSet<ABConceptXREF>();
    }

    public DmcTypeABConceptXREFSET getNew() {
        return new DmcTypeABConceptXREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<ABConceptXREF> cloneIt() {
        DmcTypeABConceptXREFSET dmcTypeABConceptXREFSET = this;
        synchronized (dmcTypeABConceptXREFSET) {
            DmcTypeABConceptXREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (ABConceptXREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ABConceptXREF add(Object v) throws DmcValueException {
        DmcTypeABConceptXREFSET dmcTypeABConceptXREFSET = this;
        synchronized (dmcTypeABConceptXREFSET) {
            ABConceptXREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ABConceptXREF del(Object v) {
        DmcTypeABConceptXREFSET dmcTypeABConceptXREFSET = this;
        synchronized (dmcTypeABConceptXREFSET) {
            ABConceptXREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ABConceptXREF> getMV() {
        DmcTypeABConceptXREFSET dmcTypeABConceptXREFSET = this;
        synchronized (dmcTypeABConceptXREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<ABConceptXREF>(this.value).iterator();
            }
            return new TreeSet<ABConceptXREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ABConceptXREF> getMVCopy() {
        DmcTypeABConceptXREFSET dmcTypeABConceptXREFSET = this;
        synchronized (dmcTypeABConceptXREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<ABConceptXREF>();
                }
                return new HashSet<ABConceptXREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<ABConceptXREF>(this.value);
            }
            return new TreeSet<ABConceptXREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeABConceptXREFSET dmcTypeABConceptXREFSET = this;
        synchronized (dmcTypeABConceptXREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeABConceptXREFSET dmcTypeABConceptXREFSET = this;
        synchronized (dmcTypeABConceptXREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                ABConceptXREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

