/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.dsd.dsda.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.dsd.dsda.shared.generated.types.AConceptBaseREF;
import org.dmd.dmt.dsd.dsda.shared.generated.types.DmcTypeAConceptBaseREF;

public class DmcTypeAConceptBaseREFSET
extends DmcTypeAConceptBaseREF
implements Serializable {
    private static final Iterator<AConceptBaseREF> emptyList = new HashSet().iterator();
    protected Set<AConceptBaseREF> value;

    public DmcTypeAConceptBaseREFSET() {
        this.value = null;
    }

    public DmcTypeAConceptBaseREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<AConceptBaseREF>() : new TreeSet<AConceptBaseREF>();
    }

    public DmcTypeAConceptBaseREFSET getNew() {
        return new DmcTypeAConceptBaseREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<AConceptBaseREF> cloneIt() {
        DmcTypeAConceptBaseREFSET dmcTypeAConceptBaseREFSET = this;
        synchronized (dmcTypeAConceptBaseREFSET) {
            DmcTypeAConceptBaseREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (AConceptBaseREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AConceptBaseREF add(Object v) throws DmcValueException {
        DmcTypeAConceptBaseREFSET dmcTypeAConceptBaseREFSET = this;
        synchronized (dmcTypeAConceptBaseREFSET) {
            AConceptBaseREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AConceptBaseREF del(Object v) {
        DmcTypeAConceptBaseREFSET dmcTypeAConceptBaseREFSET = this;
        synchronized (dmcTypeAConceptBaseREFSET) {
            AConceptBaseREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<AConceptBaseREF> getMV() {
        DmcTypeAConceptBaseREFSET dmcTypeAConceptBaseREFSET = this;
        synchronized (dmcTypeAConceptBaseREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<AConceptBaseREF>(this.value).iterator();
            }
            return new TreeSet<AConceptBaseREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<AConceptBaseREF> getMVCopy() {
        DmcTypeAConceptBaseREFSET dmcTypeAConceptBaseREFSET = this;
        synchronized (dmcTypeAConceptBaseREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<AConceptBaseREF>();
                }
                return new HashSet<AConceptBaseREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<AConceptBaseREF>(this.value);
            }
            return new TreeSet<AConceptBaseREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeAConceptBaseREFSET dmcTypeAConceptBaseREFSET = this;
        synchronized (dmcTypeAConceptBaseREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeAConceptBaseREFSET dmcTypeAConceptBaseREFSET = this;
        synchronized (dmcTypeAConceptBaseREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                AConceptBaseREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

