/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.dsd.dsda.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.dsd.dsda.shared.generated.types.AConceptXREF;
import org.dmd.dmt.dsd.dsda.shared.generated.types.DmcTypeAConceptXREF;

public class DmcTypeAConceptXREFSET
extends DmcTypeAConceptXREF
implements Serializable {
    private static final Iterator<AConceptXREF> emptyList = new HashSet().iterator();
    protected Set<AConceptXREF> value;

    public DmcTypeAConceptXREFSET() {
        this.value = null;
    }

    public DmcTypeAConceptXREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<AConceptXREF>() : new TreeSet<AConceptXREF>();
    }

    public DmcTypeAConceptXREFSET getNew() {
        return new DmcTypeAConceptXREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<AConceptXREF> cloneIt() {
        DmcTypeAConceptXREFSET dmcTypeAConceptXREFSET = this;
        synchronized (dmcTypeAConceptXREFSET) {
            DmcTypeAConceptXREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (AConceptXREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AConceptXREF add(Object v) throws DmcValueException {
        DmcTypeAConceptXREFSET dmcTypeAConceptXREFSET = this;
        synchronized (dmcTypeAConceptXREFSET) {
            AConceptXREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AConceptXREF del(Object v) {
        DmcTypeAConceptXREFSET dmcTypeAConceptXREFSET = this;
        synchronized (dmcTypeAConceptXREFSET) {
            AConceptXREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<AConceptXREF> getMV() {
        DmcTypeAConceptXREFSET dmcTypeAConceptXREFSET = this;
        synchronized (dmcTypeAConceptXREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<AConceptXREF>(this.value).iterator();
            }
            return new TreeSet<AConceptXREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<AConceptXREF> getMVCopy() {
        DmcTypeAConceptXREFSET dmcTypeAConceptXREFSET = this;
        synchronized (dmcTypeAConceptXREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<AConceptXREF>();
                }
                return new HashSet<AConceptXREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<AConceptXREF>(this.value);
            }
            return new TreeSet<AConceptXREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeAConceptXREFSET dmcTypeAConceptXREFSET = this;
        synchronized (dmcTypeAConceptXREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeAConceptXREFSET dmcTypeAConceptXREFSET = this;
        synchronized (dmcTypeAConceptXREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                AConceptXREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

