/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.dsd.dsda.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.dsd.dsda.shared.generated.types.ComplexWithComplex;
import org.dmd.dmt.dsd.dsda.shared.generated.types.DmcTypeComplexWithComplex;

public class DmcTypeComplexWithComplexSET
extends DmcTypeComplexWithComplex
implements Serializable {
    private static final Iterator<ComplexWithComplex> emptyList = new HashSet().iterator();
    protected Set<ComplexWithComplex> value;

    public DmcTypeComplexWithComplexSET() {
        this.value = null;
    }

    public DmcTypeComplexWithComplexSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<ComplexWithComplex>() : new TreeSet<ComplexWithComplex>();
    }

    public DmcTypeComplexWithComplexSET getNew() {
        return new DmcTypeComplexWithComplexSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<ComplexWithComplex> cloneIt() {
        DmcTypeComplexWithComplexSET dmcTypeComplexWithComplexSET = this;
        synchronized (dmcTypeComplexWithComplexSET) {
            DmcTypeComplexWithComplexSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (ComplexWithComplex val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComplexWithComplex add(Object v) throws DmcValueException {
        DmcTypeComplexWithComplexSET dmcTypeComplexWithComplexSET = this;
        synchronized (dmcTypeComplexWithComplexSET) {
            ComplexWithComplex rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComplexWithComplex del(Object v) {
        DmcTypeComplexWithComplexSET dmcTypeComplexWithComplexSET = this;
        synchronized (dmcTypeComplexWithComplexSET) {
            ComplexWithComplex rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ComplexWithComplex> getMV() {
        DmcTypeComplexWithComplexSET dmcTypeComplexWithComplexSET = this;
        synchronized (dmcTypeComplexWithComplexSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<ComplexWithComplex>(this.value).iterator();
            }
            return new TreeSet<ComplexWithComplex>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ComplexWithComplex> getMVCopy() {
        DmcTypeComplexWithComplexSET dmcTypeComplexWithComplexSET = this;
        synchronized (dmcTypeComplexWithComplexSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<ComplexWithComplex>();
                }
                return new HashSet<ComplexWithComplex>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<ComplexWithComplex>(this.value);
            }
            return new TreeSet<ComplexWithComplex>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeComplexWithComplexSET dmcTypeComplexWithComplexSET = this;
        synchronized (dmcTypeComplexWithComplexSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeComplexWithComplexSET dmcTypeComplexWithComplexSET = this;
        synchronized (dmcTypeComplexWithComplexSET) {
            if (this.value == null) {
                return false;
            }
            try {
                ComplexWithComplex val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

