/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.dsd.dsda.shared.generated.types;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DefinitionName;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.dsd.dsda.shared.generated.types.DmcTypeModuleAREF;
import org.dmd.dmt.dsd.dsda.shared.generated.types.ModuleAREF;

public class DmcTypeModuleAREFMAP
extends DmcTypeModuleAREF
implements Serializable {
    private static final Iterator<ModuleAREF> emptyList = new HashMap().values().iterator();
    protected Map<DefinitionName, ModuleAREF> value;

    public DmcTypeModuleAREFMAP() {
        this.value = null;
    }

    public DmcTypeModuleAREFMAP(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<DefinitionName, ModuleAREF>() : new TreeMap<DefinitionName, ModuleAREF>();
    }

    public DefinitionName firstKey() {
        if (this.getAttributeInfo().valueType == ValueTypeEnum.TREEMAPPED) {
            if (this.value == null) {
                return null;
            }
            TreeMap map = (TreeMap)this.value;
            return (DefinitionName)map.firstKey();
        }
        throw new IllegalStateException("Attribute " + this.getAttributeInfo().name + " is HASHMAPPED and doesn't support firstKey()");
    }

    public DmcTypeModuleAREFMAP getNew() {
        return new DmcTypeModuleAREFMAP(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<ModuleAREF> cloneIt() {
        DmcTypeModuleAREFMAP dmcTypeModuleAREFMAP = this;
        synchronized (dmcTypeModuleAREFMAP) {
            DmcTypeModuleAREFMAP rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (ModuleAREF val : this.value.values()) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModuleAREF add(Object v) throws DmcValueException {
        DmcTypeModuleAREFMAP dmcTypeModuleAREFMAP = this;
        synchronized (dmcTypeModuleAREFMAP) {
            DefinitionName key;
            ModuleAREF oldval;
            ModuleAREF newval = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if ((oldval = this.value.put(key = (DefinitionName)newval.getKey(), newval)) != null && oldval.valuesAreEqual(newval)) {
                newval = null;
            }
            return newval;
        }
    }

    @Override
    public ModuleAREF del(Object key) {
        DmcTypeModuleAREFMAP dmcTypeModuleAREFMAP = this;
        synchronized (dmcTypeModuleAREFMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof DefinitionName) {
                return this.value.remove(key);
            }
            throw new IllegalStateException("Incompatible key type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ModuleAREF> getMV() {
        DmcTypeModuleAREFMAP dmcTypeModuleAREFMAP = this;
        synchronized (dmcTypeModuleAREFMAP) {
            if (this.value == null) {
                return emptyList;
            }
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<DefinitionName, ModuleAREF>(this.value) : new TreeMap<DefinitionName, ModuleAREF>(this.value);
            return clone.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<DefinitionName, ModuleAREF> getMVCopy() {
        DmcTypeModuleAREFMAP dmcTypeModuleAREFMAP = this;
        synchronized (dmcTypeModuleAREFMAP) {
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? (this.value == null ? new HashMap() : new HashMap<DefinitionName, ModuleAREF>(this.value)) : (this.value == null ? new TreeMap() : new TreeMap<DefinitionName, ModuleAREF>(this.value));
            return clone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeModuleAREFMAP dmcTypeModuleAREFMAP = this;
        synchronized (dmcTypeModuleAREFMAP) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    @Override
    public ModuleAREF getByKey(Object key) {
        DmcTypeModuleAREFMAP dmcTypeModuleAREFMAP = this;
        synchronized (dmcTypeModuleAREFMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof DefinitionName) {
                return this.value.get((DefinitionName)key);
            }
            throw new IllegalStateException("Incompatible type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeModuleAREFMAP dmcTypeModuleAREFMAP = this;
        synchronized (dmcTypeModuleAREFMAP) {
            if (this.value == null) {
                return false;
            }
            try {
                ModuleAREF val = this.typeCheck(v);
                return this.value.containsValue(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        DmcTypeModuleAREFMAP dmcTypeModuleAREFMAP = this;
        synchronized (dmcTypeModuleAREFMAP) {
            if (this.value == null) {
                return false;
            }
            if (key instanceof DefinitionName) {
                return this.value.containsKey(key);
            }
            return false;
        }
    }
}

