/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.dsd.dsda.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.dsd.dsda.shared.generated.types.DmcTypeModuleAREF;
import org.dmd.dmt.dsd.dsda.shared.generated.types.ModuleAREF;

public class DmcTypeModuleAREFSET
extends DmcTypeModuleAREF
implements Serializable {
    private static final Iterator<ModuleAREF> emptyList = new HashSet().iterator();
    protected Set<ModuleAREF> value;

    public DmcTypeModuleAREFSET() {
        this.value = null;
    }

    public DmcTypeModuleAREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<ModuleAREF>() : new TreeSet<ModuleAREF>();
    }

    public DmcTypeModuleAREFSET getNew() {
        return new DmcTypeModuleAREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<ModuleAREF> cloneIt() {
        DmcTypeModuleAREFSET dmcTypeModuleAREFSET = this;
        synchronized (dmcTypeModuleAREFSET) {
            DmcTypeModuleAREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (ModuleAREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModuleAREF add(Object v) throws DmcValueException {
        DmcTypeModuleAREFSET dmcTypeModuleAREFSET = this;
        synchronized (dmcTypeModuleAREFSET) {
            ModuleAREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModuleAREF del(Object v) {
        DmcTypeModuleAREFSET dmcTypeModuleAREFSET = this;
        synchronized (dmcTypeModuleAREFSET) {
            ModuleAREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ModuleAREF> getMV() {
        DmcTypeModuleAREFSET dmcTypeModuleAREFSET = this;
        synchronized (dmcTypeModuleAREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<ModuleAREF>(this.value).iterator();
            }
            return new TreeSet<ModuleAREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ModuleAREF> getMVCopy() {
        DmcTypeModuleAREFSET dmcTypeModuleAREFSET = this;
        synchronized (dmcTypeModuleAREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<ModuleAREF>();
                }
                return new HashSet<ModuleAREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<ModuleAREF>(this.value);
            }
            return new TreeSet<ModuleAREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeModuleAREFSET dmcTypeModuleAREFSET = this;
        synchronized (dmcTypeModuleAREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeModuleAREFSET dmcTypeModuleAREFSET = this;
        synchronized (dmcTypeModuleAREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                ModuleAREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

