/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.dsd.dsda.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.dsd.dsda.shared.generated.types.DmcTypeReference;
import org.dmd.dmt.dsd.dsda.shared.generated.types.Reference;

public class DmcTypeReferenceSET
extends DmcTypeReference
implements Serializable {
    private static final Iterator<Reference> emptyList = new HashSet().iterator();
    protected Set<Reference> value;

    public DmcTypeReferenceSET() {
        this.value = null;
    }

    public DmcTypeReferenceSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<Reference>() : new TreeSet<Reference>();
    }

    public DmcTypeReferenceSET getNew() {
        return new DmcTypeReferenceSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<Reference> cloneIt() {
        DmcTypeReferenceSET dmcTypeReferenceSET = this;
        synchronized (dmcTypeReferenceSET) {
            DmcTypeReferenceSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (Reference val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reference add(Object v) throws DmcValueException {
        DmcTypeReferenceSET dmcTypeReferenceSET = this;
        synchronized (dmcTypeReferenceSET) {
            Reference rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reference del(Object v) {
        DmcTypeReferenceSET dmcTypeReferenceSET = this;
        synchronized (dmcTypeReferenceSET) {
            Reference rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Reference> getMV() {
        DmcTypeReferenceSET dmcTypeReferenceSET = this;
        synchronized (dmcTypeReferenceSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<Reference>(this.value).iterator();
            }
            return new TreeSet<Reference>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Reference> getMVCopy() {
        DmcTypeReferenceSET dmcTypeReferenceSET = this;
        synchronized (dmcTypeReferenceSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<Reference>();
                }
                return new HashSet<Reference>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<Reference>(this.value);
            }
            return new TreeSet<Reference>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeReferenceSET dmcTypeReferenceSET = this;
        synchronized (dmcTypeReferenceSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeReferenceSET dmcTypeReferenceSET = this;
        synchronized (dmcTypeReferenceSET) {
            if (this.value == null) {
                return false;
            }
            try {
                Reference val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

