/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.dsd.dsda.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.dsd.dsda.shared.generated.types.DmcTypeTypeAndAttribute;
import org.dmd.dmt.dsd.dsda.shared.generated.types.TypeAndAttribute;

public class DmcTypeTypeAndAttributeSET
extends DmcTypeTypeAndAttribute
implements Serializable {
    private static final Iterator<TypeAndAttribute> emptyList = new HashSet().iterator();
    protected Set<TypeAndAttribute> value;

    public DmcTypeTypeAndAttributeSET() {
        this.value = null;
    }

    public DmcTypeTypeAndAttributeSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<TypeAndAttribute>() : new TreeSet<TypeAndAttribute>();
    }

    public DmcTypeTypeAndAttributeSET getNew() {
        return new DmcTypeTypeAndAttributeSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<TypeAndAttribute> cloneIt() {
        DmcTypeTypeAndAttributeSET dmcTypeTypeAndAttributeSET = this;
        synchronized (dmcTypeTypeAndAttributeSET) {
            DmcTypeTypeAndAttributeSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (TypeAndAttribute val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeAndAttribute add(Object v) throws DmcValueException {
        DmcTypeTypeAndAttributeSET dmcTypeTypeAndAttributeSET = this;
        synchronized (dmcTypeTypeAndAttributeSET) {
            TypeAndAttribute rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeAndAttribute del(Object v) {
        DmcTypeTypeAndAttributeSET dmcTypeTypeAndAttributeSET = this;
        synchronized (dmcTypeTypeAndAttributeSET) {
            TypeAndAttribute rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<TypeAndAttribute> getMV() {
        DmcTypeTypeAndAttributeSET dmcTypeTypeAndAttributeSET = this;
        synchronized (dmcTypeTypeAndAttributeSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<TypeAndAttribute>(this.value).iterator();
            }
            return new TreeSet<TypeAndAttribute>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<TypeAndAttribute> getMVCopy() {
        DmcTypeTypeAndAttributeSET dmcTypeTypeAndAttributeSET = this;
        synchronized (dmcTypeTypeAndAttributeSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<TypeAndAttribute>();
                }
                return new HashSet<TypeAndAttribute>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<TypeAndAttribute>(this.value);
            }
            return new TreeSet<TypeAndAttribute>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeTypeAndAttributeSET dmcTypeTypeAndAttributeSET = this;
        synchronized (dmcTypeTypeAndAttributeSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeTypeAndAttributeSET dmcTypeTypeAndAttributeSET = this;
        synchronized (dmcTypeTypeAndAttributeSET) {
            if (this.value == null) {
                return false;
            }
            try {
                TypeAndAttribute val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

