/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.dsd.dsdb.server.generated.dsd;

import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.definitions.DsdParserInterface;
import org.dmd.dmc.rules.DmcRuleExceptionSet;
import org.dmd.dmc.rules.SourceInfo;
import org.dmd.dmc.util.DmcUncheckedObject;
import org.dmd.dms.AttributeDefinition;
import org.dmd.dms.MetaSchema;
import org.dmd.dms.SchemaManager;
import org.dmd.dms.generated.dmw.AttributeDefinitionIterableDMW;
import org.dmd.dms.generated.dmw.StringIterableDMW;
import org.dmd.dmt.dsd.dsdb.server.extended.BConceptBase;
import org.dmd.dmt.dsd.dsdb.server.extended.BConceptX;
import org.dmd.dmt.dsd.dsdb.server.extended.ModuleB;
import org.dmd.dmt.dsd.dsdb.server.generated.DsdBSchemaAG;
import org.dmd.dmt.dsd.dsdb.server.generated.dsd.ModuleBGlobalInterface;
import org.dmd.dmt.dsd.dsdb.shared.generated.dmo.DsdBDMSAG;
import org.dmd.dmv.shared.DmvRuleManager;
import org.dmd.dmw.DmwObjectFactory;
import org.dmd.dmw.DmwWrapper;
import org.dmd.util.exceptions.ResultException;
import org.dmd.util.parsing.ConfigLocation;
import org.dmd.util.parsing.DmcUncheckedOIFHandlerIF;
import org.dmd.util.parsing.DmcUncheckedOIFParser;

public class ModuleBParser
implements DsdParserInterface,
DmcUncheckedOIFHandlerIF {
    static final String fileExtension = "tmb";
    SchemaManager schema;
    DmcUncheckedOIFParser parser = new DmcUncheckedOIFParser(this);
    DmwObjectFactory factory;
    ModuleBGlobalInterface definitions;
    DmvRuleManager rules;
    ConfigLocation location;
    ModuleB module;

    public ModuleBParser(ModuleBGlobalInterface d, DmvRuleManager r) throws ResultException, DmcValueException, DmcNameClashException {
        this.schema = new SchemaManager();
        DsdBSchemaAG sd = new DsdBSchemaAG();
        this.schema.manageSchema(sd.getInstance());
        if (sd.getAttributeDefListSize() > 0) {
            this.preserveNewLines(sd.getAttributeDefList());
        }
        this.preserveNewLines(MetaSchema._metaSchema.getAttributeDefList());
        this.factory = new DmwObjectFactory(this.schema);
        this.definitions = d;
        this.rules = r;
        this.rules.loadRules(DsdBDMSAG.instance());
    }

    public SchemaManager schema() {
        return this.schema;
    }

    void preserveNewLines(AttributeDefinitionIterableDMW attrs) {
        while (attrs.hasNext()) {
            AttributeDefinition ad = (AttributeDefinition)attrs.getNext();
            if (!ad.getPreserveNewlines().booleanValue()) continue;
            this.parser.addPreserveNewlinesAttribute(ad.getName().getNameString());
        }
    }

    @Override
    public String getFileExtension() {
        return fileExtension;
    }

    public ModuleB parseConfig(ConfigLocation l) throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException {
        this.location = l;
        this.module = null;
        if (this.location.isFromJAR()) {
            System.out.println("Reading: " + this.location.getFileName() + " - from " + this.location.getJarFilename());
            this.parser.parseFile(this.location.getFileName(), true);
        } else {
            System.out.println("Reading: " + this.location.getFileName());
            this.parser.parseFile(this.location.getFileName());
        }
        if (this.module.getDefFilesHasValue()) {
            StringIterableDMW it = this.module.getDefFilesIterable();
            while (it.hasNext()) {
                String fn = this.location.getDirectory() + "/" + (String)it.next();
                if (this.location.isFromJAR()) {
                    this.parser.parseFile(fn, true);
                    continue;
                }
                this.parser.parseFile(fn);
            }
        }
        return this.module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleObject(DmcUncheckedObject uco, String infile, int lineNumber) throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException {
        BConceptBase definition = null;
        DmwWrapper wrapper = null;
        try {
            wrapper = this.factory.createWrapper(uco);
            definition = (BConceptBase)wrapper;
        }
        catch (ClassNotFoundException e) {
            ResultException ex = new ResultException("Unknown object class: " + uco.classes.get(0));
            ex.result.lastResult().fileName(infile);
            ex.result.lastResult().lineNumber(lineNumber);
            throw ex;
        }
        catch (ResultException ex) {
            ex.setLocationInfo(infile, lineNumber);
            throw ex;
        }
        catch (DmcValueException e) {
            ResultException ex = new ResultException();
            ex.addError(e.getMessage());
            if (e.getAttributeName() != null) {
                ex.result.lastResult().moreMessages("Attribute: " + e.getAttributeName());
            }
            ex.setLocationInfo(infile, lineNumber);
            throw ex;
        }
        catch (ClassCastException e) {
            ResultException ex = new ResultException();
            ex.addError("All classes in your DSL must ultimately be derived from: BConceptBase");
            ex.addError("The following object is not valid in a .tmb file:\n\n" + wrapper.toOIF());
            ex.setLocationInfo(infile, lineNumber);
            throw ex;
        }
        definition.setLineNumber(lineNumber);
        definition.setFile(infile);
        try {
            this.rules.executeInitializers(definition.getDmcObject());
        }
        catch (DmcRuleExceptionSet ex) {
            ex.source(new SourceInfo(infile, lineNumber));
            throw ex;
        }
        if (this.module == null) {
            if (!(definition instanceof ModuleB)) {
                ResultException ex = new ResultException("Expecting a ModuleB module definition");
                ex.setLocationInfo(infile, lineNumber);
                throw ex;
            }
            this.module = (ModuleB)definition;
            int lastSep = infile.lastIndexOf("/");
            int period = infile.lastIndexOf(46);
            String fn = infile.substring(lastSep + 1, period);
            if (this.module.getName() == null) {
                ResultException ex = new ResultException("Missing name attribute for module definition");
                ex.setLocationInfo(infile, lineNumber);
                throw ex;
            }
            if (!this.module.getName().getNameString().equals(fn)) {
                ResultException ex = new ResultException("Module name: " + this.module.getName().getNameString() + " - must match file name: " + fn);
                ex.setLocationInfo(infile, lineNumber);
                throw ex;
            }
            definition.setDotName(this.module.getName() + "." + this.module.getName() + "." + definition.getConstructionClassName());
            this.module.setDefinedInModuleB(this.module);
            this.definitions.addModuleB(this.module);
        } else {
            if (definition instanceof ModuleB) {
                ResultException ex = new ResultException("Multiple ModuleB definitions while parsing config: " + this.location.getFileName());
                ex.setLocationInfo(infile, lineNumber);
                throw ex;
            }
            definition.setDefinedInModuleB(this.module);
            definition.setDmoFromModule(this.module.getName().getNameString());
            definition.setDotName(this.module.getName() + "." + definition.getName() + "." + definition.getConstructionClassName());
            try {
                this.rules.executeObjectValidation(definition.getDmcObject());
            }
            catch (DmcRuleExceptionSet ex) {
                ex.source(new SourceInfo(infile, lineNumber));
                throw ex;
            }
            if (definition instanceof BConceptX) {
                this.definitions.addBConceptX((BConceptX)definition);
                this.module.addBConceptX((BConceptX)definition);
            }
        }
        try {
            this.rules.executeAttributeValidation(definition.getDmcObject());
            this.rules.executeObjectValidation(definition.getDmcObject());
            return;
        }
        catch (DmcRuleExceptionSet ex) {
            ex.source(new SourceInfo(infile, lineNumber));
            throw ex;
        }
    }
}

