/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.dsd.dsdb.shared.generated.dsd;

import java.util.Iterator;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcNameClashObjectSet;
import org.dmd.dmc.DmcNameClashResolverIF;
import org.dmd.dmc.DmcNameResolverWithClashSupportIF;
import org.dmd.dmc.DmcNamedObjectIF;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.DmcObjectName;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.DmcValueExceptionSet;
import org.dmd.dmc.definitions.DMODefinitionSet;
import org.dmd.dmc.types.DotName;
import org.dmd.dms.generated.dmo.DSDefinitionDMO;
import org.dmd.dmt.dsd.dsda.shared.generated.dmo.ABConceptXDMO;
import org.dmd.dmt.dsd.dsda.shared.generated.dmo.AConceptBaseDMO;
import org.dmd.dmt.dsd.dsda.shared.generated.dmo.AConceptXDMO;
import org.dmd.dmt.dsd.dsda.shared.generated.dmo.DsdADMSAG;
import org.dmd.dmt.dsd.dsda.shared.generated.dmo.ModuleADMO;
import org.dmd.dmt.dsd.dsda.shared.generated.dsd.ModuleAGlobalInterface;
import org.dmd.dmt.dsd.dsdb.shared.generated.dmo.BConceptBaseDMO;
import org.dmd.dmt.dsd.dsdb.shared.generated.dmo.BConceptXDMO;
import org.dmd.dmt.dsd.dsdb.shared.generated.dmo.DsdBDMSAG;
import org.dmd.dmt.dsd.dsdb.shared.generated.dmo.ModuleBDMO;
import org.dmd.dmt.dsd.dsdb.shared.generated.dsd.ModuleBGlobalInterface;
import org.dmd.dmv.shared.DmvRuleManager;

public class ModuleBDefinitionDMOCache
implements DmcNameClashResolverIF,
DmcNameResolverWithClashSupportIF,
ModuleAGlobalInterface,
ModuleBGlobalInterface {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private DmvRuleManager ruleManager = new DmvRuleManager();
    private DMODefinitionSet<DSDefinitionDMO> allDefinitions;
    private TreeMap<String, DMODefinitionSet<?>> indicesByClass;
    private DMODefinitionSet<AConceptBaseDMO> AConceptBaseDefs;
    private DMODefinitionSet<ABConceptXDMO> ABConceptXDefs;
    private DMODefinitionSet<AConceptXDMO> AConceptXDefs;
    private DMODefinitionSet<ModuleADMO> ModuleADefs;
    private DMODefinitionSet<BConceptBaseDMO> BConceptBaseDefs;
    private DMODefinitionSet<BConceptXDMO> BConceptXDefs;
    private DMODefinitionSet<ModuleBDMO> ModuleBDefs;

    public ModuleBDefinitionDMOCache() {
        this.ruleManager.loadRules(DsdADMSAG.instance());
        this.ruleManager.loadRules(DsdBDMSAG.instance());
        this.allDefinitions = new DMODefinitionSet("allDefinitions");
        this.indicesByClass = new TreeMap();
        this.AConceptBaseDefs = new DMODefinitionSet("AConceptBase", this.allDefinitions);
        this.indicesByClass.put(this.AConceptBaseDefs.className(), this.AConceptBaseDefs);
        this.AConceptXDefs = new DMODefinitionSet("AConceptX", this.allDefinitions, this.AConceptBaseDefs);
        this.indicesByClass.put(this.AConceptXDefs.className(), this.AConceptXDefs);
        this.ABConceptXDefs = new DMODefinitionSet("ABConceptX", this.allDefinitions, this.AConceptXDefs);
        this.indicesByClass.put(this.ABConceptXDefs.className(), this.ABConceptXDefs);
        this.ModuleADefs = new DMODefinitionSet("ModuleA", this.allDefinitions, this.AConceptBaseDefs);
        this.indicesByClass.put(this.ModuleADefs.className(), this.ModuleADefs);
        this.BConceptBaseDefs = new DMODefinitionSet("BConceptBase", this.allDefinitions);
        this.indicesByClass.put(this.BConceptBaseDefs.className(), this.BConceptBaseDefs);
        this.BConceptXDefs = new DMODefinitionSet("BConceptX", this.allDefinitions, this.BConceptBaseDefs);
        this.indicesByClass.put(this.BConceptXDefs.className(), this.BConceptXDefs);
        this.ModuleBDefs = new DMODefinitionSet("ModuleB", this.allDefinitions, this.BConceptBaseDefs);
        this.indicesByClass.put(this.ModuleBDefs.className(), this.ModuleBDefs);
    }

    public DmvRuleManager ruleManager() {
        return this.ruleManager;
    }

    public void resolveReferences() throws DmcValueExceptionSet {
        for (DSDefinitionDMO def : this.allDefinitions.values()) {
            def.resolveReferencesExceptClass(this, this);
        }
    }

    @Override
    public DmcNamedObjectIF findNamedObject(DmcObjectName name) {
        DSDefinitionDMO def = null;
        try {
            def = this.allDefinitions.getDefinition(name.toString());
        }
        catch (DmcNameClashException e) {
            this.logger.fine(e.toString());
        }
        catch (DmcValueException e) {
            this.logger.fine(e.toString());
        }
        return def;
    }

    public DSDefinitionDMO findDefinition(DotName name) {
        return this.allDefinitions.getDefinition(name);
    }

    public void deleteDefinition(DotName name) throws Exception {
        DSDefinitionDMO def = this.allDefinitions.getDefinition(name);
        if (def == null) {
            throw new Exception("Could not find object to delete: " + name.getNameString());
        }
        DMODefinitionSet<?> dds = this.indicesByClass.get(def.getConstructionClassName());
        dds.delete(name);
        def.youAreDeleted();
    }

    @Override
    public DmcNamedObjectIF findNamedObject(DmcObjectName name, int attributeID) {
        throw new IllegalStateException("This method is not supported on generated definition managers");
    }

    @Override
    public DmcObject findNamedDMO(DmcObjectName name) {
        DSDefinitionDMO def = null;
        try {
            def = name instanceof DotName ? this.allDefinitions.getDefinition((DotName)name) : this.allDefinitions.getDefinition(name.toString());
        }
        catch (DmcNameClashException e) {
            this.logger.fine(e.toString());
        }
        catch (DmcValueException e) {
            this.logger.fine(e.toString());
        }
        return def;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DmcNamedObjectIF findNamedObjectMayClash(DmcObject object, DmcObjectName name, DmcNameClashResolverIF resolver, DmcAttributeInfo ai) throws DmcValueException {
        void var5_9;
        Object var5_5 = null;
        DotName dn = new DotName(name.getNameString() + "." + ai.type);
        if (name.getNameString().indexOf(".") == -1) {
            try {
                DSDefinitionDMO dSDefinitionDMO = this.allDefinitions.getDefinitionByNameAndType(dn);
                return var5_9;
            }
            catch (DmcNameClashException e) {
                DmcNamedObjectIF dmcNamedObjectIF = resolver.resolveClash(object, ai, e.getClashSet());
                if (dmcNamedObjectIF != null) return var5_9;
                DmcValueException ex = new DmcValueException("The reference to : " + name.getNameString() + " is ambiguous. You must specify the module name as a prefix to the name. Here are your options:");
                Iterator<DmcNamedObjectIF> it = e.getMatches();
                while (it.hasNext()) {
                    BConceptBaseDMO def = (BConceptBaseDMO)it.next();
                    ex.addMoreInfo(def.getDefinedInModuleB().getName().getNameString() + "." + name.getNameString());
                }
                throw ex;
            }
        } else {
            DSDefinitionDMO dSDefinitionDMO = this.allDefinitions.getDefinition(dn);
        }
        return var5_9;
    }

    @Override
    public DmcNamedObjectIF resolveClash(DmcObject obj, DmcAttributeInfo ai, DmcNameClashObjectSet<?> ncos) throws DmcValueException {
        DSDefinitionDMO rc = null;
        DSDefinitionDMO resolving = (DSDefinitionDMO)((Object)obj.getContainer());
        Iterator<DmcNamedObjectIF> it = ncos.getMatches();
        while (it.hasNext()) {
            DSDefinitionDMO def = (DSDefinitionDMO)it.next();
            if (!resolving.getDmoFromModule().equals(def.getDmoFromModule())) continue;
            rc = def;
            break;
        }
        return rc;
    }

    void addAConceptBase(AConceptBaseDMO def) {
        this.AConceptBaseDefs.add(def);
    }

    @Override
    public int getAConceptBaseCount() {
        return this.AConceptBaseDefs.size();
    }

    @Override
    public AConceptBaseDMO getAConceptBase(DotName name) {
        return this.AConceptBaseDefs.getDefinition(name);
    }

    @Override
    public Iterator<AConceptBaseDMO> getAllAConceptBase() {
        return this.AConceptBaseDefs.values().iterator();
    }

    @Override
    public void addABConceptX(ABConceptXDMO def) {
        this.ABConceptXDefs.add(def);
        this.addAConceptX(def);
    }

    @Override
    public int getABConceptXCount() {
        return this.ABConceptXDefs.size();
    }

    @Override
    public ABConceptXDMO getABConceptX(DotName name) {
        return this.ABConceptXDefs.getDefinition(name);
    }

    @Override
    public Iterator<ABConceptXDMO> getAllABConceptX() {
        return this.ABConceptXDefs.values().iterator();
    }

    @Override
    public ABConceptXDMO getABConceptXDefinition(String name) throws DmcNameClashException, DmcValueException {
        return this.ABConceptXDefs.getDefinition(name);
    }

    @Override
    public void addAConceptX(AConceptXDMO def) {
        this.AConceptXDefs.add(def);
        this.addAConceptBase(def);
    }

    @Override
    public int getAConceptXCount() {
        return this.AConceptXDefs.size();
    }

    @Override
    public AConceptXDMO getAConceptX(DotName name) {
        return this.AConceptXDefs.getDefinition(name);
    }

    @Override
    public Iterator<AConceptXDMO> getAllAConceptX() {
        return this.AConceptXDefs.values().iterator();
    }

    @Override
    public AConceptXDMO getAConceptXDefinition(String name) throws DmcNameClashException, DmcValueException {
        return this.AConceptXDefs.getDefinition(name);
    }

    @Override
    public void addModuleA(ModuleADMO def) {
        this.ModuleADefs.add(def);
        this.addAConceptBase(def);
    }

    @Override
    public int getModuleACount() {
        return this.ModuleADefs.size();
    }

    @Override
    public ModuleADMO getModuleA(DotName name) {
        return this.ModuleADefs.getDefinition(name);
    }

    @Override
    public Iterator<ModuleADMO> getAllModuleA() {
        return this.ModuleADefs.values().iterator();
    }

    @Override
    public ModuleADMO getModuleADefinition(String name) throws DmcNameClashException, DmcValueException {
        return this.ModuleADefs.getDefinition(name);
    }

    void addBConceptBase(BConceptBaseDMO def) {
        this.BConceptBaseDefs.add(def);
    }

    @Override
    public int getBConceptBaseCount() {
        return this.BConceptBaseDefs.size();
    }

    @Override
    public BConceptBaseDMO getBConceptBase(DotName name) {
        return this.BConceptBaseDefs.getDefinition(name);
    }

    @Override
    public Iterator<BConceptBaseDMO> getAllBConceptBase() {
        return this.BConceptBaseDefs.values().iterator();
    }

    @Override
    public void addBConceptX(BConceptXDMO def) {
        this.BConceptXDefs.add(def);
        this.addBConceptBase(def);
    }

    @Override
    public int getBConceptXCount() {
        return this.BConceptXDefs.size();
    }

    @Override
    public BConceptXDMO getBConceptX(DotName name) {
        return this.BConceptXDefs.getDefinition(name);
    }

    @Override
    public Iterator<BConceptXDMO> getAllBConceptX() {
        return this.BConceptXDefs.values().iterator();
    }

    @Override
    public BConceptXDMO getBConceptXDefinition(String name) throws DmcNameClashException, DmcValueException {
        return this.BConceptXDefs.getDefinition(name);
    }

    @Override
    public void addModuleB(ModuleBDMO def) {
        this.ModuleBDefs.add(def);
        this.addBConceptBase(def);
    }

    @Override
    public int getModuleBCount() {
        return this.ModuleBDefs.size();
    }

    @Override
    public ModuleBDMO getModuleB(DotName name) {
        return this.ModuleBDefs.getDefinition(name);
    }

    @Override
    public Iterator<ModuleBDMO> getAllModuleB() {
        return this.ModuleBDefs.values().iterator();
    }

    @Override
    public ModuleBDMO getModuleBDefinition(String name) throws DmcNameClashException, DmcValueException {
        return this.ModuleBDefs.getDefinition(name);
    }

    public void addDefinition(DSDefinitionDMO definition) {
        if (definition instanceof BConceptXDMO) {
            this.addBConceptX((BConceptXDMO)definition);
        } else if (definition instanceof ModuleBDMO) {
            this.addModuleB((ModuleBDMO)definition);
        }
    }

    public String summary() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.BConceptBaseDefs.summary());
        sb.append(this.BConceptXDefs.summary());
        sb.append(this.ModuleBDefs.summary());
        return sb.toString();
    }
}

