/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.dsd.dsdb.shared.generated.types;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DefinitionName;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.dsd.dsdb.shared.generated.types.BConceptBaseREF;
import org.dmd.dmt.dsd.dsdb.shared.generated.types.DmcTypeBConceptBaseREF;

public class DmcTypeBConceptBaseREFMAP
extends DmcTypeBConceptBaseREF
implements Serializable {
    private static final Iterator<BConceptBaseREF> emptyList = new HashMap().values().iterator();
    protected Map<DefinitionName, BConceptBaseREF> value;

    public DmcTypeBConceptBaseREFMAP() {
        this.value = null;
    }

    public DmcTypeBConceptBaseREFMAP(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<DefinitionName, BConceptBaseREF>() : new TreeMap<DefinitionName, BConceptBaseREF>();
    }

    public DefinitionName firstKey() {
        if (this.getAttributeInfo().valueType == ValueTypeEnum.TREEMAPPED) {
            if (this.value == null) {
                return null;
            }
            TreeMap map = (TreeMap)this.value;
            return (DefinitionName)map.firstKey();
        }
        throw new IllegalStateException("Attribute " + this.getAttributeInfo().name + " is HASHMAPPED and doesn't support firstKey()");
    }

    public DmcTypeBConceptBaseREFMAP getNew() {
        return new DmcTypeBConceptBaseREFMAP(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<BConceptBaseREF> cloneIt() {
        DmcTypeBConceptBaseREFMAP dmcTypeBConceptBaseREFMAP = this;
        synchronized (dmcTypeBConceptBaseREFMAP) {
            DmcTypeBConceptBaseREFMAP rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (BConceptBaseREF val : this.value.values()) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BConceptBaseREF add(Object v) throws DmcValueException {
        DmcTypeBConceptBaseREFMAP dmcTypeBConceptBaseREFMAP = this;
        synchronized (dmcTypeBConceptBaseREFMAP) {
            DefinitionName key;
            BConceptBaseREF oldval;
            BConceptBaseREF newval = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if ((oldval = this.value.put(key = (DefinitionName)newval.getKey(), newval)) != null && oldval.valuesAreEqual(newval)) {
                newval = null;
            }
            return newval;
        }
    }

    @Override
    public BConceptBaseREF del(Object key) {
        DmcTypeBConceptBaseREFMAP dmcTypeBConceptBaseREFMAP = this;
        synchronized (dmcTypeBConceptBaseREFMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof DefinitionName) {
                return this.value.remove(key);
            }
            throw new IllegalStateException("Incompatible key type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<BConceptBaseREF> getMV() {
        DmcTypeBConceptBaseREFMAP dmcTypeBConceptBaseREFMAP = this;
        synchronized (dmcTypeBConceptBaseREFMAP) {
            if (this.value == null) {
                return emptyList;
            }
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<DefinitionName, BConceptBaseREF>(this.value) : new TreeMap<DefinitionName, BConceptBaseREF>(this.value);
            return clone.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<DefinitionName, BConceptBaseREF> getMVCopy() {
        DmcTypeBConceptBaseREFMAP dmcTypeBConceptBaseREFMAP = this;
        synchronized (dmcTypeBConceptBaseREFMAP) {
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? (this.value == null ? new HashMap() : new HashMap<DefinitionName, BConceptBaseREF>(this.value)) : (this.value == null ? new TreeMap() : new TreeMap<DefinitionName, BConceptBaseREF>(this.value));
            return clone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeBConceptBaseREFMAP dmcTypeBConceptBaseREFMAP = this;
        synchronized (dmcTypeBConceptBaseREFMAP) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    @Override
    public BConceptBaseREF getByKey(Object key) {
        DmcTypeBConceptBaseREFMAP dmcTypeBConceptBaseREFMAP = this;
        synchronized (dmcTypeBConceptBaseREFMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof DefinitionName) {
                return this.value.get((DefinitionName)key);
            }
            throw new IllegalStateException("Incompatible type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeBConceptBaseREFMAP dmcTypeBConceptBaseREFMAP = this;
        synchronized (dmcTypeBConceptBaseREFMAP) {
            if (this.value == null) {
                return false;
            }
            try {
                BConceptBaseREF val = this.typeCheck(v);
                return this.value.containsValue(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        DmcTypeBConceptBaseREFMAP dmcTypeBConceptBaseREFMAP = this;
        synchronized (dmcTypeBConceptBaseREFMAP) {
            if (this.value == null) {
                return false;
            }
            if (key instanceof DefinitionName) {
                return this.value.containsKey(key);
            }
            return false;
        }
    }
}

