/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.dsd.dsdb.shared.generated.types;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DefinitionName;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.dsd.dsdb.shared.generated.types.BConceptXREF;
import org.dmd.dmt.dsd.dsdb.shared.generated.types.DmcTypeBConceptXREF;

public class DmcTypeBConceptXREFMAP
extends DmcTypeBConceptXREF
implements Serializable {
    private static final Iterator<BConceptXREF> emptyList = new HashMap().values().iterator();
    protected Map<DefinitionName, BConceptXREF> value;

    public DmcTypeBConceptXREFMAP() {
        this.value = null;
    }

    public DmcTypeBConceptXREFMAP(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<DefinitionName, BConceptXREF>() : new TreeMap<DefinitionName, BConceptXREF>();
    }

    public DefinitionName firstKey() {
        if (this.getAttributeInfo().valueType == ValueTypeEnum.TREEMAPPED) {
            if (this.value == null) {
                return null;
            }
            TreeMap map = (TreeMap)this.value;
            return (DefinitionName)map.firstKey();
        }
        throw new IllegalStateException("Attribute " + this.getAttributeInfo().name + " is HASHMAPPED and doesn't support firstKey()");
    }

    public DmcTypeBConceptXREFMAP getNew() {
        return new DmcTypeBConceptXREFMAP(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<BConceptXREF> cloneIt() {
        DmcTypeBConceptXREFMAP dmcTypeBConceptXREFMAP = this;
        synchronized (dmcTypeBConceptXREFMAP) {
            DmcTypeBConceptXREFMAP rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (BConceptXREF val : this.value.values()) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BConceptXREF add(Object v) throws DmcValueException {
        DmcTypeBConceptXREFMAP dmcTypeBConceptXREFMAP = this;
        synchronized (dmcTypeBConceptXREFMAP) {
            DefinitionName key;
            BConceptXREF oldval;
            BConceptXREF newval = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if ((oldval = this.value.put(key = (DefinitionName)newval.getKey(), newval)) != null && oldval.valuesAreEqual(newval)) {
                newval = null;
            }
            return newval;
        }
    }

    @Override
    public BConceptXREF del(Object key) {
        DmcTypeBConceptXREFMAP dmcTypeBConceptXREFMAP = this;
        synchronized (dmcTypeBConceptXREFMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof DefinitionName) {
                return this.value.remove(key);
            }
            throw new IllegalStateException("Incompatible key type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<BConceptXREF> getMV() {
        DmcTypeBConceptXREFMAP dmcTypeBConceptXREFMAP = this;
        synchronized (dmcTypeBConceptXREFMAP) {
            if (this.value == null) {
                return emptyList;
            }
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<DefinitionName, BConceptXREF>(this.value) : new TreeMap<DefinitionName, BConceptXREF>(this.value);
            return clone.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<DefinitionName, BConceptXREF> getMVCopy() {
        DmcTypeBConceptXREFMAP dmcTypeBConceptXREFMAP = this;
        synchronized (dmcTypeBConceptXREFMAP) {
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? (this.value == null ? new HashMap() : new HashMap<DefinitionName, BConceptXREF>(this.value)) : (this.value == null ? new TreeMap() : new TreeMap<DefinitionName, BConceptXREF>(this.value));
            return clone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeBConceptXREFMAP dmcTypeBConceptXREFMAP = this;
        synchronized (dmcTypeBConceptXREFMAP) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    @Override
    public BConceptXREF getByKey(Object key) {
        DmcTypeBConceptXREFMAP dmcTypeBConceptXREFMAP = this;
        synchronized (dmcTypeBConceptXREFMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof DefinitionName) {
                return this.value.get((DefinitionName)key);
            }
            throw new IllegalStateException("Incompatible type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeBConceptXREFMAP dmcTypeBConceptXREFMAP = this;
        synchronized (dmcTypeBConceptXREFMAP) {
            if (this.value == null) {
                return false;
            }
            try {
                BConceptXREF val = this.typeCheck(v);
                return this.value.containsValue(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        DmcTypeBConceptXREFMAP dmcTypeBConceptXREFMAP = this;
        synchronized (dmcTypeBConceptXREFMAP) {
            if (this.value == null) {
                return false;
            }
            if (key instanceof DefinitionName) {
                return this.value.containsKey(key);
            }
            return false;
        }
    }
}

