/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.dsd.dsdb.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.dsd.dsdb.shared.generated.types.BConceptXREF;
import org.dmd.dmt.dsd.dsdb.shared.generated.types.DmcTypeBConceptXREF;

public class DmcTypeBConceptXREFSET
extends DmcTypeBConceptXREF
implements Serializable {
    private static final Iterator<BConceptXREF> emptyList = new HashSet().iterator();
    protected Set<BConceptXREF> value;

    public DmcTypeBConceptXREFSET() {
        this.value = null;
    }

    public DmcTypeBConceptXREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<BConceptXREF>() : new TreeSet<BConceptXREF>();
    }

    public DmcTypeBConceptXREFSET getNew() {
        return new DmcTypeBConceptXREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<BConceptXREF> cloneIt() {
        DmcTypeBConceptXREFSET dmcTypeBConceptXREFSET = this;
        synchronized (dmcTypeBConceptXREFSET) {
            DmcTypeBConceptXREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (BConceptXREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BConceptXREF add(Object v) throws DmcValueException {
        DmcTypeBConceptXREFSET dmcTypeBConceptXREFSET = this;
        synchronized (dmcTypeBConceptXREFSET) {
            BConceptXREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BConceptXREF del(Object v) {
        DmcTypeBConceptXREFSET dmcTypeBConceptXREFSET = this;
        synchronized (dmcTypeBConceptXREFSET) {
            BConceptXREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<BConceptXREF> getMV() {
        DmcTypeBConceptXREFSET dmcTypeBConceptXREFSET = this;
        synchronized (dmcTypeBConceptXREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<BConceptXREF>(this.value).iterator();
            }
            return new TreeSet<BConceptXREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<BConceptXREF> getMVCopy() {
        DmcTypeBConceptXREFSET dmcTypeBConceptXREFSET = this;
        synchronized (dmcTypeBConceptXREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<BConceptXREF>();
                }
                return new HashSet<BConceptXREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<BConceptXREF>(this.value);
            }
            return new TreeSet<BConceptXREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeBConceptXREFSET dmcTypeBConceptXREFSET = this;
        synchronized (dmcTypeBConceptXREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeBConceptXREFSET dmcTypeBConceptXREFSET = this;
        synchronized (dmcTypeBConceptXREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                BConceptXREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

