/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.dsd.dsdb.shared.generated.types;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DefinitionName;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.dsd.dsdb.shared.generated.types.DmcTypeModuleBREF;
import org.dmd.dmt.dsd.dsdb.shared.generated.types.ModuleBREF;

public class DmcTypeModuleBREFMAP
extends DmcTypeModuleBREF
implements Serializable {
    private static final Iterator<ModuleBREF> emptyList = new HashMap().values().iterator();
    protected Map<DefinitionName, ModuleBREF> value;

    public DmcTypeModuleBREFMAP() {
        this.value = null;
    }

    public DmcTypeModuleBREFMAP(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<DefinitionName, ModuleBREF>() : new TreeMap<DefinitionName, ModuleBREF>();
    }

    public DefinitionName firstKey() {
        if (this.getAttributeInfo().valueType == ValueTypeEnum.TREEMAPPED) {
            if (this.value == null) {
                return null;
            }
            TreeMap map = (TreeMap)this.value;
            return (DefinitionName)map.firstKey();
        }
        throw new IllegalStateException("Attribute " + this.getAttributeInfo().name + " is HASHMAPPED and doesn't support firstKey()");
    }

    public DmcTypeModuleBREFMAP getNew() {
        return new DmcTypeModuleBREFMAP(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<ModuleBREF> cloneIt() {
        DmcTypeModuleBREFMAP dmcTypeModuleBREFMAP = this;
        synchronized (dmcTypeModuleBREFMAP) {
            DmcTypeModuleBREFMAP rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (ModuleBREF val : this.value.values()) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModuleBREF add(Object v) throws DmcValueException {
        DmcTypeModuleBREFMAP dmcTypeModuleBREFMAP = this;
        synchronized (dmcTypeModuleBREFMAP) {
            DefinitionName key;
            ModuleBREF oldval;
            ModuleBREF newval = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if ((oldval = this.value.put(key = (DefinitionName)newval.getKey(), newval)) != null && oldval.valuesAreEqual(newval)) {
                newval = null;
            }
            return newval;
        }
    }

    @Override
    public ModuleBREF del(Object key) {
        DmcTypeModuleBREFMAP dmcTypeModuleBREFMAP = this;
        synchronized (dmcTypeModuleBREFMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof DefinitionName) {
                return this.value.remove(key);
            }
            throw new IllegalStateException("Incompatible key type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ModuleBREF> getMV() {
        DmcTypeModuleBREFMAP dmcTypeModuleBREFMAP = this;
        synchronized (dmcTypeModuleBREFMAP) {
            if (this.value == null) {
                return emptyList;
            }
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<DefinitionName, ModuleBREF>(this.value) : new TreeMap<DefinitionName, ModuleBREF>(this.value);
            return clone.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<DefinitionName, ModuleBREF> getMVCopy() {
        DmcTypeModuleBREFMAP dmcTypeModuleBREFMAP = this;
        synchronized (dmcTypeModuleBREFMAP) {
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? (this.value == null ? new HashMap() : new HashMap<DefinitionName, ModuleBREF>(this.value)) : (this.value == null ? new TreeMap() : new TreeMap<DefinitionName, ModuleBREF>(this.value));
            return clone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeModuleBREFMAP dmcTypeModuleBREFMAP = this;
        synchronized (dmcTypeModuleBREFMAP) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    @Override
    public ModuleBREF getByKey(Object key) {
        DmcTypeModuleBREFMAP dmcTypeModuleBREFMAP = this;
        synchronized (dmcTypeModuleBREFMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof DefinitionName) {
                return this.value.get((DefinitionName)key);
            }
            throw new IllegalStateException("Incompatible type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeModuleBREFMAP dmcTypeModuleBREFMAP = this;
        synchronized (dmcTypeModuleBREFMAP) {
            if (this.value == null) {
                return false;
            }
            try {
                ModuleBREF val = this.typeCheck(v);
                return this.value.containsValue(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        DmcTypeModuleBREFMAP dmcTypeModuleBREFMAP = this;
        synchronized (dmcTypeModuleBREFMAP) {
            if (this.value == null) {
                return false;
            }
            if (key instanceof DefinitionName) {
                return this.value.containsKey(key);
            }
            return false;
        }
    }
}

