/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.dsd.dsdb.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.dsd.dsdb.shared.generated.types.DmcTypeModuleBREF;
import org.dmd.dmt.dsd.dsdb.shared.generated.types.ModuleBREF;

public class DmcTypeModuleBREFSET
extends DmcTypeModuleBREF
implements Serializable {
    private static final Iterator<ModuleBREF> emptyList = new HashSet().iterator();
    protected Set<ModuleBREF> value;

    public DmcTypeModuleBREFSET() {
        this.value = null;
    }

    public DmcTypeModuleBREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<ModuleBREF>() : new TreeSet<ModuleBREF>();
    }

    public DmcTypeModuleBREFSET getNew() {
        return new DmcTypeModuleBREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<ModuleBREF> cloneIt() {
        DmcTypeModuleBREFSET dmcTypeModuleBREFSET = this;
        synchronized (dmcTypeModuleBREFSET) {
            DmcTypeModuleBREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (ModuleBREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModuleBREF add(Object v) throws DmcValueException {
        DmcTypeModuleBREFSET dmcTypeModuleBREFSET = this;
        synchronized (dmcTypeModuleBREFSET) {
            ModuleBREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModuleBREF del(Object v) {
        DmcTypeModuleBREFSET dmcTypeModuleBREFSET = this;
        synchronized (dmcTypeModuleBREFSET) {
            ModuleBREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ModuleBREF> getMV() {
        DmcTypeModuleBREFSET dmcTypeModuleBREFSET = this;
        synchronized (dmcTypeModuleBREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<ModuleBREF>(this.value).iterator();
            }
            return new TreeSet<ModuleBREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ModuleBREF> getMVCopy() {
        DmcTypeModuleBREFSET dmcTypeModuleBREFSET = this;
        synchronized (dmcTypeModuleBREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<ModuleBREF>();
                }
                return new HashSet<ModuleBREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<ModuleBREF>(this.value);
            }
            return new TreeSet<ModuleBREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeModuleBREFSET dmcTypeModuleBREFSET = this;
        synchronized (dmcTypeModuleBREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeModuleBREFSET dmcTypeModuleBREFSET = this;
        synchronized (dmcTypeModuleBREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                ModuleBREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

