/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.dsd.dsdc.server.generated.dsd;

import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcClassInfo;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcNameClashObjectSet;
import org.dmd.dmc.DmcNameClashResolverIF;
import org.dmd.dmc.DmcNameResolverWithClashSupportIF;
import org.dmd.dmc.DmcNamedObjectIF;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.DmcObjectName;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.DmcValueExceptionSet;
import org.dmd.dmc.definitions.DmcDefinitionSet;
import org.dmd.dmc.types.DotName;
import org.dmd.dms.DSDefinition;
import org.dmd.dmt.dsd.dsda.server.extended.ABConceptX;
import org.dmd.dmt.dsd.dsda.server.extended.AConceptBase;
import org.dmd.dmt.dsd.dsda.server.extended.AConceptX;
import org.dmd.dmt.dsd.dsda.server.extended.ModuleA;
import org.dmd.dmt.dsd.dsda.server.generated.dsd.ModuleADefinitionsIF;
import org.dmd.dmt.dsd.dsda.server.generated.dsd.ModuleAGlobalInterface;
import org.dmd.dmt.dsd.dsda.shared.generated.dmo.DsdADMSAG;
import org.dmd.dmt.dsd.dsdb.server.extended.BConceptBase;
import org.dmd.dmt.dsd.dsdb.server.extended.BConceptX;
import org.dmd.dmt.dsd.dsdb.server.extended.ModuleB;
import org.dmd.dmt.dsd.dsdb.server.generated.dsd.ModuleBDefinitionsIF;
import org.dmd.dmt.dsd.dsdb.server.generated.dsd.ModuleBGlobalInterface;
import org.dmd.dmt.dsd.dsdb.shared.generated.dmo.DsdBDMSAG;
import org.dmd.dmt.dsd.dsdc.server.extended.CConceptBase;
import org.dmd.dmt.dsd.dsdc.server.extended.CConceptX;
import org.dmd.dmt.dsd.dsdc.server.extended.ModuleC;
import org.dmd.dmt.dsd.dsdc.server.generated.dsd.ModuleCDefinitionsIF;
import org.dmd.dmt.dsd.dsdc.server.generated.dsd.ModuleCGlobalInterface;
import org.dmd.dmt.dsd.dsdc.shared.generated.dmo.DsdCDMSAG;
import org.dmd.dmw.DmwNamedObjectWrapper;
import org.dmd.util.exceptions.ResultException;

public class ModuleCDefinitionManager
implements DmcNameClashResolverIF,
DmcNameResolverWithClashSupportIF,
ModuleAGlobalInterface,
ModuleBGlobalInterface,
ModuleCGlobalInterface,
ModuleADefinitionsIF,
ModuleBDefinitionsIF,
ModuleCDefinitionsIF {
    private DmcDefinitionSet<DSDefinition> allDefinitions = new DmcDefinitionSet("allDefinitions");
    private DmcDefinitionSet<AConceptBase> AConceptBaseDefs;
    private DmcDefinitionSet<ABConceptX> ABConceptXDefs;
    private DmcDefinitionSet<AConceptX> AConceptXDefs;
    private DmcDefinitionSet<ModuleA> ModuleADefs;
    private DmcDefinitionSet<BConceptBase> BConceptBaseDefs;
    private DmcDefinitionSet<BConceptX> BConceptXDefs;
    private DmcDefinitionSet<ModuleB> ModuleBDefs;
    private DmcDefinitionSet<CConceptBase> CConceptBaseDefs;
    private DmcDefinitionSet<CConceptX> CConceptXDefs;
    private DmcDefinitionSet<ModuleC> ModuleCDefs;
    private TreeMap<DmcClassInfo, DmcDefinitionSet<?>> indicesByClass = new TreeMap();

    public ModuleCDefinitionManager() {
        this.AConceptBaseDefs = new DmcDefinitionSet("AConceptBase", this.allDefinitions);
        this.indicesByClass.put(DsdADMSAG.__AConceptBase, this.AConceptBaseDefs);
        this.AConceptXDefs = new DmcDefinitionSet("AConceptX", this.allDefinitions, this.AConceptBaseDefs);
        this.indicesByClass.put(DsdADMSAG.__AConceptX, this.AConceptXDefs);
        this.ABConceptXDefs = new DmcDefinitionSet("ABConceptX", this.allDefinitions, this.AConceptXDefs);
        this.indicesByClass.put(DsdADMSAG.__ABConceptX, this.ABConceptXDefs);
        this.ModuleADefs = new DmcDefinitionSet("ModuleA", this.allDefinitions, this.AConceptBaseDefs);
        this.indicesByClass.put(DsdADMSAG.__ModuleA, this.ModuleADefs);
        this.BConceptBaseDefs = new DmcDefinitionSet("BConceptBase", this.allDefinitions);
        this.indicesByClass.put(DsdBDMSAG.__BConceptBase, this.BConceptBaseDefs);
        this.BConceptXDefs = new DmcDefinitionSet("BConceptX", this.allDefinitions, this.BConceptBaseDefs);
        this.indicesByClass.put(DsdBDMSAG.__BConceptX, this.BConceptXDefs);
        this.ModuleBDefs = new DmcDefinitionSet("ModuleB", this.allDefinitions, this.BConceptBaseDefs);
        this.indicesByClass.put(DsdBDMSAG.__ModuleB, this.ModuleBDefs);
        this.CConceptBaseDefs = new DmcDefinitionSet("CConceptBase", this.allDefinitions);
        this.indicesByClass.put(DsdCDMSAG.__CConceptBase, this.CConceptBaseDefs);
        this.CConceptXDefs = new DmcDefinitionSet("CConceptX", this.allDefinitions, this.CConceptBaseDefs);
        this.indicesByClass.put(DsdCDMSAG.__CConceptX, this.CConceptXDefs);
        this.ModuleCDefs = new DmcDefinitionSet("ModuleC", this.allDefinitions, this.CConceptBaseDefs);
        this.indicesByClass.put(DsdCDMSAG.__ModuleC, this.ModuleCDefs);
    }

    public void resolveReferences() throws DmcValueExceptionSet {
        for (DSDefinition def : this.allDefinitions.values()) {
            def.resolveReferences(this, this);
        }
    }

    public Collection<DmwNamedObjectWrapper> getIndex(DmcClassInfo ci) {
        DmcDefinitionSet<?> dds = this.indicesByClass.get(ci);
        if (dds == null) {
            throw new IllegalStateException("No index available for class: " + ci.name);
        }
        return dds.getIndex();
    }

    @Override
    public DmcNamedObjectIF findNamedObject(DmcObjectName name) {
        DSDefinition def = null;
        try {
            def = this.allDefinitions.getDefinition(name.toString());
        }
        catch (DmcNameClashException e) {
            e.printStackTrace();
        }
        catch (DmcValueException e) {
            e.printStackTrace();
        }
        return def;
    }

    public DSDefinition findDefinition(DotName name) {
        return this.allDefinitions.getDefinition(name);
    }

    public void deleteDefinition(DotName name) throws ResultException {
        DSDefinition def = this.allDefinitions.getDefinition(name);
        if (def == null) {
            throw new ResultException("Could not find object to delete: " + name.getNameString());
        }
        DmcDefinitionSet<?> dds = this.indicesByClass.get(def.getConstructionClassInfo());
        dds.delete(name);
        def.youAreDeleted();
        CConceptBase base = (CConceptBase)def;
        ModuleC module = base.getDefinedInModuleC();
        if (def instanceof CConceptX) {
            module.deleteCConceptX((CConceptX)def);
        } else if (def instanceof ModuleC) {
            // empty if block
        }
    }

    @Override
    public DmcNamedObjectIF findNamedObject(DmcObjectName name, int attributeID) {
        throw new IllegalStateException("This method is not supported on generated definition managers");
    }

    @Override
    public DmcObject findNamedDMO(DmcObjectName name) {
        DSDefinition def = null;
        try {
            def = this.allDefinitions.getDefinition(name.toString());
        }
        catch (DmcNameClashException e) {
            e.printStackTrace();
        }
        catch (DmcValueException e) {
            e.printStackTrace();
        }
        if (def == null) {
            return null;
        }
        return def.getDMO();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DmcNamedObjectIF findNamedObjectMayClash(DmcObject object, DmcObjectName name, DmcNameClashResolverIF resolver, DmcAttributeInfo ai) throws DmcValueException {
        void var5_9;
        Object var5_5 = null;
        DotName dn = new DotName(name.getNameString() + "." + ai.type);
        if (name.getNameString().indexOf(".") == -1) {
            try {
                DSDefinition dSDefinition = this.allDefinitions.getDefinitionByNameAndType(dn);
                return var5_9;
            }
            catch (DmcNameClashException e) {
                DmcNamedObjectIF dmcNamedObjectIF = resolver.resolveClash(object, ai, e.getClashSet());
                if (dmcNamedObjectIF != null) return var5_9;
                DmcValueException ex = new DmcValueException("The reference to : " + name.getNameString() + " is ambiguous. You must specify the module name as a prefix to the name. Here are your options:");
                Iterator<DmcNamedObjectIF> it = e.getMatches();
                while (it.hasNext()) {
                    CConceptBase def = (CConceptBase)it.next();
                    ex.addMoreInfo(def.getDefinedInModuleC().getName().getNameString() + "." + name.getNameString());
                }
                throw ex;
            }
        } else {
            DSDefinition dSDefinition = this.allDefinitions.getDefinition(dn);
        }
        return var5_9;
    }

    @Override
    public DmcNamedObjectIF resolveClash(DmcObject obj, DmcAttributeInfo ai, DmcNameClashObjectSet<?> ncos) throws DmcValueException {
        DSDefinition rc = null;
        DSDefinition resolving = (DSDefinition)obj.getContainer();
        Iterator<DmcNamedObjectIF> it = ncos.getMatches();
        while (it.hasNext()) {
            DSDefinition def = (DSDefinition)it.next();
            if (!resolving.getNameOfModuleWhereThisCameFrom().equals(def.getNameOfModuleWhereThisCameFrom())) continue;
            rc = def;
            break;
        }
        return rc;
    }

    void addAConceptBase(AConceptBase def) {
        this.AConceptBaseDefs.add(def);
    }

    void deleteAConceptBase(AConceptBase def) {
        try {
            this.AConceptBaseDefs.delete(def);
        }
        catch (ResultException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int getAConceptBaseCount() {
        return this.AConceptBaseDefs.size();
    }

    @Override
    public AConceptBase getAConceptBase(DotName name) {
        return this.AConceptBaseDefs.getDefinition(name);
    }

    @Override
    public Iterator<AConceptBase> getAllAConceptBase() {
        return this.AConceptBaseDefs.values().iterator();
    }

    @Override
    public void addABConceptX(ABConceptX def) {
        this.ABConceptXDefs.add(def);
        this.addAConceptX(def);
    }

    @Override
    public void deleteABConceptX(ABConceptX def) {
        try {
            this.ABConceptXDefs.delete(def);
        }
        catch (ResultException e) {
            throw new IllegalStateException(e);
        }
        this.deleteAConceptX(def);
    }

    @Override
    public int getABConceptXCount() {
        return this.ABConceptXDefs.size();
    }

    @Override
    public ABConceptX getABConceptX(DotName name) {
        return this.ABConceptXDefs.getDefinition(name);
    }

    @Override
    public Iterator<ABConceptX> getAllABConceptX() {
        return this.ABConceptXDefs.values().iterator();
    }

    @Override
    public ABConceptX getABConceptXDefinition(String name) throws DmcNameClashException, DmcValueException {
        return this.ABConceptXDefs.getDefinition(name);
    }

    @Override
    public Iterator<ABConceptX> getABConceptXDefinitionsByName(String name) throws DmcValueException {
        return this.ABConceptXDefs.getDefinitionsByName(name);
    }

    @Override
    public int getABConceptXDefinitionCountByName(String name) throws DmcValueException {
        return this.ABConceptXDefs.getDefinitionCountByName(name);
    }

    @Override
    public void addAConceptX(AConceptX def) {
        this.AConceptXDefs.add(def);
        this.addAConceptBase(def);
    }

    @Override
    public void deleteAConceptX(AConceptX def) {
        try {
            this.AConceptXDefs.delete(def);
        }
        catch (ResultException e) {
            throw new IllegalStateException(e);
        }
        this.deleteAConceptBase(def);
    }

    @Override
    public int getAConceptXCount() {
        return this.AConceptXDefs.size();
    }

    @Override
    public AConceptX getAConceptX(DotName name) {
        return this.AConceptXDefs.getDefinition(name);
    }

    @Override
    public Iterator<AConceptX> getAllAConceptX() {
        return this.AConceptXDefs.values().iterator();
    }

    @Override
    public AConceptX getAConceptXDefinition(String name) throws DmcNameClashException, DmcValueException {
        return this.AConceptXDefs.getDefinition(name);
    }

    @Override
    public Iterator<AConceptX> getAConceptXDefinitionsByName(String name) throws DmcValueException {
        return this.AConceptXDefs.getDefinitionsByName(name);
    }

    @Override
    public int getAConceptXDefinitionCountByName(String name) throws DmcValueException {
        return this.AConceptXDefs.getDefinitionCountByName(name);
    }

    @Override
    public void addModuleA(ModuleA def) {
        this.ModuleADefs.add(def);
        this.addAConceptBase(def);
    }

    @Override
    public void deleteModuleA(ModuleA def) {
        try {
            this.ModuleADefs.delete(def);
        }
        catch (ResultException e) {
            throw new IllegalStateException(e);
        }
        this.deleteAConceptBase(def);
    }

    @Override
    public int getModuleACount() {
        return this.ModuleADefs.size();
    }

    @Override
    public ModuleA getModuleA(DotName name) {
        return this.ModuleADefs.getDefinition(name);
    }

    @Override
    public Iterator<ModuleA> getAllModuleA() {
        return this.ModuleADefs.values().iterator();
    }

    @Override
    public ModuleA getModuleADefinition(String name) throws DmcNameClashException, DmcValueException {
        return this.ModuleADefs.getDefinition(name);
    }

    @Override
    public Iterator<ModuleA> getModuleADefinitionsByName(String name) throws DmcValueException {
        return this.ModuleADefs.getDefinitionsByName(name);
    }

    @Override
    public int getModuleADefinitionCountByName(String name) throws DmcValueException {
        return this.ModuleADefs.getDefinitionCountByName(name);
    }

    void addBConceptBase(BConceptBase def) {
        this.BConceptBaseDefs.add(def);
    }

    void deleteBConceptBase(BConceptBase def) {
        try {
            this.BConceptBaseDefs.delete(def);
        }
        catch (ResultException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int getBConceptBaseCount() {
        return this.BConceptBaseDefs.size();
    }

    @Override
    public BConceptBase getBConceptBase(DotName name) {
        return this.BConceptBaseDefs.getDefinition(name);
    }

    @Override
    public Iterator<BConceptBase> getAllBConceptBase() {
        return this.BConceptBaseDefs.values().iterator();
    }

    @Override
    public void addBConceptX(BConceptX def) {
        this.BConceptXDefs.add(def);
        this.addBConceptBase(def);
    }

    @Override
    public void deleteBConceptX(BConceptX def) {
        try {
            this.BConceptXDefs.delete(def);
        }
        catch (ResultException e) {
            throw new IllegalStateException(e);
        }
        this.deleteBConceptBase(def);
    }

    @Override
    public int getBConceptXCount() {
        return this.BConceptXDefs.size();
    }

    @Override
    public BConceptX getBConceptX(DotName name) {
        return this.BConceptXDefs.getDefinition(name);
    }

    @Override
    public Iterator<BConceptX> getAllBConceptX() {
        return this.BConceptXDefs.values().iterator();
    }

    @Override
    public BConceptX getBConceptXDefinition(String name) throws DmcNameClashException, DmcValueException {
        return this.BConceptXDefs.getDefinition(name);
    }

    @Override
    public Iterator<BConceptX> getBConceptXDefinitionsByName(String name) throws DmcValueException {
        return this.BConceptXDefs.getDefinitionsByName(name);
    }

    @Override
    public int getBConceptXDefinitionCountByName(String name) throws DmcValueException {
        return this.BConceptXDefs.getDefinitionCountByName(name);
    }

    @Override
    public void addModuleB(ModuleB def) {
        this.ModuleBDefs.add(def);
        this.addBConceptBase(def);
    }

    @Override
    public void deleteModuleB(ModuleB def) {
        try {
            this.ModuleBDefs.delete(def);
        }
        catch (ResultException e) {
            throw new IllegalStateException(e);
        }
        this.deleteBConceptBase(def);
    }

    @Override
    public int getModuleBCount() {
        return this.ModuleBDefs.size();
    }

    @Override
    public ModuleB getModuleB(DotName name) {
        return this.ModuleBDefs.getDefinition(name);
    }

    @Override
    public Iterator<ModuleB> getAllModuleB() {
        return this.ModuleBDefs.values().iterator();
    }

    @Override
    public ModuleB getModuleBDefinition(String name) throws DmcNameClashException, DmcValueException {
        return this.ModuleBDefs.getDefinition(name);
    }

    @Override
    public Iterator<ModuleB> getModuleBDefinitionsByName(String name) throws DmcValueException {
        return this.ModuleBDefs.getDefinitionsByName(name);
    }

    @Override
    public int getModuleBDefinitionCountByName(String name) throws DmcValueException {
        return this.ModuleBDefs.getDefinitionCountByName(name);
    }

    void addCConceptBase(CConceptBase def) {
        this.CConceptBaseDefs.add(def);
    }

    void deleteCConceptBase(CConceptBase def) {
        try {
            this.CConceptBaseDefs.delete(def);
        }
        catch (ResultException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int getCConceptBaseCount() {
        return this.CConceptBaseDefs.size();
    }

    @Override
    public CConceptBase getCConceptBase(DotName name) {
        return this.CConceptBaseDefs.getDefinition(name);
    }

    @Override
    public Iterator<CConceptBase> getAllCConceptBase() {
        return this.CConceptBaseDefs.values().iterator();
    }

    @Override
    public void addCConceptX(CConceptX def) {
        this.CConceptXDefs.add(def);
        this.addCConceptBase(def);
    }

    @Override
    public void deleteCConceptX(CConceptX def) {
        try {
            this.CConceptXDefs.delete(def);
        }
        catch (ResultException e) {
            throw new IllegalStateException(e);
        }
        this.deleteCConceptBase(def);
    }

    @Override
    public int getCConceptXCount() {
        return this.CConceptXDefs.size();
    }

    @Override
    public CConceptX getCConceptX(DotName name) {
        return this.CConceptXDefs.getDefinition(name);
    }

    @Override
    public Iterator<CConceptX> getAllCConceptX() {
        return this.CConceptXDefs.values().iterator();
    }

    @Override
    public CConceptX getCConceptXDefinition(String name) throws DmcNameClashException, DmcValueException {
        return this.CConceptXDefs.getDefinition(name);
    }

    @Override
    public Iterator<CConceptX> getCConceptXDefinitionsByName(String name) throws DmcValueException {
        return this.CConceptXDefs.getDefinitionsByName(name);
    }

    @Override
    public int getCConceptXDefinitionCountByName(String name) throws DmcValueException {
        return this.CConceptXDefs.getDefinitionCountByName(name);
    }

    @Override
    public void addModuleC(ModuleC def) {
        this.ModuleCDefs.add(def);
        this.addCConceptBase(def);
    }

    @Override
    public void deleteModuleC(ModuleC def) {
        try {
            this.ModuleCDefs.delete(def);
        }
        catch (ResultException e) {
            throw new IllegalStateException(e);
        }
        this.deleteCConceptBase(def);
    }

    @Override
    public int getModuleCCount() {
        return this.ModuleCDefs.size();
    }

    @Override
    public ModuleC getModuleC(DotName name) {
        return this.ModuleCDefs.getDefinition(name);
    }

    @Override
    public Iterator<ModuleC> getAllModuleC() {
        return this.ModuleCDefs.values().iterator();
    }

    @Override
    public ModuleC getModuleCDefinition(String name) throws DmcNameClashException, DmcValueException {
        return this.ModuleCDefs.getDefinition(name);
    }

    @Override
    public Iterator<ModuleC> getModuleCDefinitionsByName(String name) throws DmcValueException {
        return this.ModuleCDefs.getDefinitionsByName(name);
    }

    @Override
    public int getModuleCDefinitionCountByName(String name) throws DmcValueException {
        return this.ModuleCDefs.getDefinitionCountByName(name);
    }

    public void addDefinition(DSDefinition definition) {
        if (definition instanceof CConceptX) {
            this.addCConceptX((CConceptX)definition);
        } else if (definition instanceof ModuleC) {
            this.addModuleC((ModuleC)definition);
        }
    }

    public void addDefinition(DSDefinition definition, ModuleC module) {
        if (definition instanceof CConceptX) {
            this.addCConceptX((CConceptX)definition);
            module.addCConceptX((CConceptX)definition);
        } else if (definition instanceof ModuleC) {
            this.addModuleC((ModuleC)definition);
        }
    }

    public String summary() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.CConceptBaseDefs.summary());
        sb.append(this.CConceptXDefs.summary());
        sb.append(this.ModuleCDefs.summary());
        return sb.toString();
    }
}

