/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.dsd.dsdc.server.generated.dsd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcNamedObjectNontransportableREF;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.DmcValueExceptionSet;
import org.dmd.dmc.rules.DmcRuleExceptionSet;
import org.dmd.dmc.types.DefinitionName;
import org.dmd.dms.DSDefinition;
import org.dmd.dmt.dsd.dsda.server.extended.ModuleA;
import org.dmd.dmt.dsd.dsda.server.generated.dsd.ModuleAParser;
import org.dmd.dmt.dsd.dsda.shared.generated.types.ModuleAREF;
import org.dmd.dmt.dsd.dsdb.server.extended.ModuleB;
import org.dmd.dmt.dsd.dsdb.server.generated.dsd.ModuleBParser;
import org.dmd.dmt.dsd.dsdb.shared.generated.types.ModuleBREF;
import org.dmd.dmt.dsd.dsdc.server.extended.ModuleC;
import org.dmd.dmt.dsd.dsdc.server.generated.dsd.ModuleCDefinitionManager;
import org.dmd.dmt.dsd.dsdc.server.generated.dsd.ModuleCGeneratorInterface;
import org.dmd.dmt.dsd.dsdc.server.generated.dsd.ModuleCParser;
import org.dmd.dmt.dsd.dsdc.shared.generated.types.ModuleCREF;
import org.dmd.dmv.shared.DmvRuleManager;
import org.dmd.util.exceptions.ResultException;
import org.dmd.util.parsing.ConfigFinder;
import org.dmd.util.parsing.ConfigLocation;
import org.dmd.util.parsing.ConfigVersion;

public class ModuleCParsingCoordinator {
    DmvRuleManager rules = new DmvRuleManager();
    ModuleCDefinitionManager definitions = new ModuleCDefinitionManager();
    ModuleCGeneratorInterface generator;
    TreeMap<String, ModuleInfoBase> loadedConfigs = new TreeMap();
    ModuleAParser parserForModuleA;
    ConfigFinder finderForModuleA = new ConfigFinder(".tma");
    TreeMap<DefinitionName, ModuleAInfo> loadedModuleAConfigs = new TreeMap();
    ModuleBParser parserForModuleB;
    ConfigFinder finderForModuleB = new ConfigFinder(".tmb");
    TreeMap<DefinitionName, ModuleBInfo> loadedModuleBConfigs = new TreeMap();
    ModuleCParser parserForModuleC;
    ConfigFinder finderForModuleC = new ConfigFinder(".tmc");
    TreeMap<DefinitionName, ModuleCInfo> loadedModuleCConfigs = new TreeMap();

    public ModuleCParsingCoordinator(ModuleCGeneratorInterface g, ArrayList<String> sourceDirs, ArrayList<String> jars) throws ResultException, DmcValueException, DmcNameClashException, DmcRuleExceptionSet, IOException {
        this.generator = g;
        this.parserForModuleA = new ModuleAParser(this.definitions, this.rules);
        this.finderForModuleA.setSourceAndJarInfo(sourceDirs, jars);
        this.finderForModuleA.findConfigs();
        this.parserForModuleB = new ModuleBParser(this.definitions, this.rules);
        this.finderForModuleB.setSourceAndJarInfo(sourceDirs, jars);
        this.finderForModuleB.findConfigs();
        this.parserForModuleC = new ModuleCParser(this.definitions, this.rules);
        this.finderForModuleC.setSourceAndJarInfo(sourceDirs, jars);
        this.finderForModuleC.findConfigs();
        this.loadBaseModuleModuleC("modcBase");
    }

    public DmvRuleManager getRuleManager() {
        return this.rules;
    }

    public ModuleAParser parserForModuleA() {
        return this.parserForModuleA;
    }

    public ModuleBParser parserForModuleB() {
        return this.parserForModuleB;
    }

    public ModuleCParser parserForModuleC() {
        return this.parserForModuleC;
    }

    void loadBaseModuleModuleC(String config) throws ResultException, DmcValueException, DmcNameClashException, DmcRuleExceptionSet, IOException {
        ConfigVersion version = this.finderForModuleC.getConfig(config);
        if (version == null) {
            ResultException ex = new ResultException("Could not find the specified base configuration file: " + config);
            ex.moreMessages("This is a base module required by the ModuleC DSD");
            ex.moreMessages(this.finderForModuleC.getSearchInfo());
            throw ex;
        }
        ConfigLocation location = version.getLatestVersion();
        this.loadModuleCModule(location);
    }

    public void generateForConfig(String configName) throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException, DmcValueExceptionSet, IOException {
        ConfigVersion version = this.finderForModuleC.getConfig(configName);
        if (version == null) {
            ResultException ex = new ResultException("Could not find the specified configuration file: " + configName);
            throw ex;
        }
        ConfigLocation location = version.getLatestVersion();
        ModuleC loaded = this.loadModuleCModule(location);
        if (location.isFromJAR()) {
            ResultException ex = new ResultException("We can't run generation for a config loaded from a JAR: " + configName);
            ex.moreMessages(location.toString());
            throw ex;
        }
        this.generator.parsingComplete(loaded, location, this.definitions);
        this.definitions.resolveReferences();
        this.generator.generate(loaded, location, this.definitions);
    }

    public void generateForAllConfigs() throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException, DmcValueExceptionSet, IOException {
        ModuleC loaded = null;
        ModuleCInfo loadedInfo = null;
        Iterator<ConfigLocation> it = this.finderForModuleC.getLocations();
        while (it.hasNext()) {
            ConfigLocation location = it.next();
            loadedInfo = (ModuleCInfo)this.loadedConfigs.get(location.getFileName());
            loaded = loadedInfo == null ? this.loadModuleCModule(location) : loadedInfo.module;
            this.generator.parsingComplete(loaded, location, this.definitions);
            this.definitions.resolveReferences();
            this.generator.objectResolutionComplete(loaded, location, this.definitions);
        }
        this.generator.generate(this.definitions);
    }

    ModuleA loadModuleAModule(ConfigLocation location) throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException {
        ModuleAInfo info = this.loadedModuleAConfigs.get(new DefinitionName(location.getConfigName()));
        if (info != null) {
            return info.module;
        }
        ModuleA loaded = this.parserForModuleA.parseConfig(location);
        ModuleAInfo loadedInfo = new ModuleAInfo(loaded, location);
        this.loadedModuleAConfigs.put(loaded.getName(), loadedInfo);
        this.loadedConfigs.put(location.getFileName(), loadedInfo);
        this.loadModuleDependencies(loadedInfo);
        return loaded;
    }

    public ConfigLocation getLocation(ModuleA module) {
        ModuleAInfo info = this.loadedModuleAConfigs.get(module.getName());
        if (info == null) {
            throw new IllegalStateException("Couldn't find ConfigLocation for module: \n\n" + module.toOIF());
        }
        return info.location;
    }

    ModuleB loadModuleBModule(ConfigLocation location) throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException {
        ModuleBInfo info = this.loadedModuleBConfigs.get(new DefinitionName(location.getConfigName()));
        if (info != null) {
            return info.module;
        }
        ModuleB loaded = this.parserForModuleB.parseConfig(location);
        ModuleBInfo loadedInfo = new ModuleBInfo(loaded, location);
        this.loadedModuleBConfigs.put(loaded.getName(), loadedInfo);
        this.loadedConfigs.put(location.getFileName(), loadedInfo);
        this.loadModuleDependencies(loadedInfo);
        return loaded;
    }

    public ConfigLocation getLocation(ModuleB module) {
        ModuleBInfo info = this.loadedModuleBConfigs.get(module.getName());
        if (info == null) {
            throw new IllegalStateException("Couldn't find ConfigLocation for module: \n\n" + module.toOIF());
        }
        return info.location;
    }

    ModuleC loadModuleCModule(ConfigLocation location) throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException {
        ModuleCInfo info = this.loadedModuleCConfigs.get(new DefinitionName(location.getConfigName()));
        if (info != null) {
            return info.module;
        }
        ModuleC loaded = this.parserForModuleC.parseConfig(location);
        ModuleCInfo loadedInfo = new ModuleCInfo(loaded, location);
        this.loadedModuleCConfigs.put(loaded.getName(), loadedInfo);
        this.loadedConfigs.put(location.getFileName(), loadedInfo);
        this.loadModuleDependencies(loadedInfo);
        return loaded;
    }

    public ConfigLocation getLocation(ModuleC module) {
        ModuleCInfo info = this.loadedModuleCConfigs.get(module.getName());
        if (info == null) {
            throw new IllegalStateException("Couldn't find ConfigLocation for module: \n\n" + module.toOIF());
        }
        return info.location;
    }

    void loadModuleDependencies(ModuleInfoBase mi) throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException {
        if (mi.dependenciesLoaded) {
            return;
        }
        if (mi instanceof ModuleAInfo) {
            ModuleAInfo info = (ModuleAInfo)mi;
            if (info.module.getDependsOnModuleAHasValue()) {
                Iterator<ModuleAREF> it = info.module.getDMO().getDependsOnModuleA();
                while (it.hasNext()) {
                    ModuleAREF ref = it.next();
                    ConfigVersion version = this.finderForModuleA.getConfig(ref.toString());
                    if (version == null) {
                        this.missingConfigError(info.module, ref.toString() + ".tma");
                    }
                    this.loadModuleAModule(version.getLatestVersion());
                }
            }
            info.dependenciesLoaded = true;
        } else if (mi instanceof ModuleBInfo) {
            ConfigVersion version;
            DmcNamedObjectNontransportableREF ref;
            Iterator<DmcNamedObjectNontransportableREF> it;
            ModuleBInfo info = (ModuleBInfo)mi;
            if (info.module.getDependsOnModuleAHasValue()) {
                it = info.module.getDMO().getDependsOnModuleA();
                while (it.hasNext()) {
                    ref = it.next();
                    version = this.finderForModuleA.getConfig(ref.toString());
                    if (version == null) {
                        this.missingConfigError(info.module, ref.toString() + ".tma");
                    }
                    this.loadModuleAModule(version.getLatestVersion());
                }
            }
            if (info.module.getDependsOnModuleBHasValue()) {
                it = info.module.getDMO().getDependsOnModuleB();
                while (it.hasNext()) {
                    ref = (ModuleBREF)it.next();
                    version = this.finderForModuleB.getConfig(ref.toString());
                    if (version == null) {
                        this.missingConfigError(info.module, ref.toString() + ".tmb");
                    }
                    this.loadModuleBModule(version.getLatestVersion());
                }
            }
            info.dependenciesLoaded = true;
        } else if (mi instanceof ModuleCInfo) {
            ConfigVersion version;
            DmcNamedObjectNontransportableREF ref;
            Iterator<DmcNamedObjectNontransportableREF> it;
            ModuleCInfo info = (ModuleCInfo)mi;
            if (info.module.getDependsOnModuleAHasValue()) {
                it = info.module.getDMO().getDependsOnModuleA();
                while (it.hasNext()) {
                    ref = it.next();
                    version = this.finderForModuleA.getConfig(ref.toString());
                    if (version == null) {
                        this.missingConfigError(info.module, ref.toString() + ".tma");
                    }
                    this.loadModuleAModule(version.getLatestVersion());
                }
            }
            if (info.module.getDependsOnModuleBHasValue()) {
                it = info.module.getDMO().getDependsOnModuleB();
                while (it.hasNext()) {
                    ref = (ModuleBREF)it.next();
                    version = this.finderForModuleB.getConfig(ref.toString());
                    if (version == null) {
                        this.missingConfigError(info.module, ref.toString() + ".tmb");
                    }
                    this.loadModuleBModule(version.getLatestVersion());
                }
            }
            if (info.module.getDependsOnModuleCHasValue()) {
                it = info.module.getDMO().getDependsOnModuleC();
                while (it.hasNext()) {
                    ref = (ModuleCREF)it.next();
                    version = this.finderForModuleC.getConfig(ref.toString());
                    if (version == null) {
                        this.missingConfigError(info.module, ref.toString() + ".tmc");
                    }
                    this.loadModuleCModule(version.getLatestVersion());
                }
            }
            info.dependenciesLoaded = true;
        }
    }

    void missingConfigError(String missing) throws ResultException {
        ResultException ex = new ResultException("Could not find config: " + missing);
        throw ex;
    }

    void missingConfigError(DSDefinition module, String missing) throws ResultException {
        ResultException ex = new ResultException("Could not find config: " + missing);
        ex.setLocationInfo(module.getFile(), module.getLineNumber());
        throw ex;
    }

    class ModuleCInfo
    extends ModuleInfoBase {
        ModuleC module;

        ModuleCInfo(ModuleC m, ConfigLocation l) {
            this.module = m;
            this.location = l;
        }
    }

    class ModuleBInfo
    extends ModuleInfoBase {
        ModuleB module;

        ModuleBInfo(ModuleB m, ConfigLocation l) {
            this.module = m;
            this.location = l;
        }
    }

    class ModuleAInfo
    extends ModuleInfoBase {
        ModuleA module;

        ModuleAInfo(ModuleA m, ConfigLocation l) {
            this.module = m;
            this.location = l;
        }
    }

    class ModuleInfoBase {
        ConfigLocation location;
        boolean dependenciesLoaded;

        ModuleInfoBase() {
        }
    }
}

