/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.dsd.dsdc.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.dsd.dsdc.shared.generated.types.CConceptBaseREF;
import org.dmd.dmt.dsd.dsdc.shared.generated.types.DmcTypeCConceptBaseREF;

public class DmcTypeCConceptBaseREFSET
extends DmcTypeCConceptBaseREF
implements Serializable {
    private static final Iterator<CConceptBaseREF> emptyList = new HashSet().iterator();
    protected Set<CConceptBaseREF> value;

    public DmcTypeCConceptBaseREFSET() {
        this.value = null;
    }

    public DmcTypeCConceptBaseREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<CConceptBaseREF>() : new TreeSet<CConceptBaseREF>();
    }

    public DmcTypeCConceptBaseREFSET getNew() {
        return new DmcTypeCConceptBaseREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<CConceptBaseREF> cloneIt() {
        DmcTypeCConceptBaseREFSET dmcTypeCConceptBaseREFSET = this;
        synchronized (dmcTypeCConceptBaseREFSET) {
            DmcTypeCConceptBaseREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (CConceptBaseREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CConceptBaseREF add(Object v) throws DmcValueException {
        DmcTypeCConceptBaseREFSET dmcTypeCConceptBaseREFSET = this;
        synchronized (dmcTypeCConceptBaseREFSET) {
            CConceptBaseREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CConceptBaseREF del(Object v) {
        DmcTypeCConceptBaseREFSET dmcTypeCConceptBaseREFSET = this;
        synchronized (dmcTypeCConceptBaseREFSET) {
            CConceptBaseREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<CConceptBaseREF> getMV() {
        DmcTypeCConceptBaseREFSET dmcTypeCConceptBaseREFSET = this;
        synchronized (dmcTypeCConceptBaseREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<CConceptBaseREF>(this.value).iterator();
            }
            return new TreeSet<CConceptBaseREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CConceptBaseREF> getMVCopy() {
        DmcTypeCConceptBaseREFSET dmcTypeCConceptBaseREFSET = this;
        synchronized (dmcTypeCConceptBaseREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<CConceptBaseREF>();
                }
                return new HashSet<CConceptBaseREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<CConceptBaseREF>(this.value);
            }
            return new TreeSet<CConceptBaseREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeCConceptBaseREFSET dmcTypeCConceptBaseREFSET = this;
        synchronized (dmcTypeCConceptBaseREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeCConceptBaseREFSET dmcTypeCConceptBaseREFSET = this;
        synchronized (dmcTypeCConceptBaseREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                CConceptBaseREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

