/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.dsd.dsdc.shared.generated.types;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DefinitionName;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.dsd.dsdc.shared.generated.types.CConceptXREF;
import org.dmd.dmt.dsd.dsdc.shared.generated.types.DmcTypeCConceptXREF;

public class DmcTypeCConceptXREFMAP
extends DmcTypeCConceptXREF
implements Serializable {
    private static final Iterator<CConceptXREF> emptyList = new HashMap().values().iterator();
    protected Map<DefinitionName, CConceptXREF> value;

    public DmcTypeCConceptXREFMAP() {
        this.value = null;
    }

    public DmcTypeCConceptXREFMAP(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<DefinitionName, CConceptXREF>() : new TreeMap<DefinitionName, CConceptXREF>();
    }

    public DefinitionName firstKey() {
        if (this.getAttributeInfo().valueType == ValueTypeEnum.TREEMAPPED) {
            if (this.value == null) {
                return null;
            }
            TreeMap map = (TreeMap)this.value;
            return (DefinitionName)map.firstKey();
        }
        throw new IllegalStateException("Attribute " + this.getAttributeInfo().name + " is HASHMAPPED and doesn't support firstKey()");
    }

    public DmcTypeCConceptXREFMAP getNew() {
        return new DmcTypeCConceptXREFMAP(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<CConceptXREF> cloneIt() {
        DmcTypeCConceptXREFMAP dmcTypeCConceptXREFMAP = this;
        synchronized (dmcTypeCConceptXREFMAP) {
            DmcTypeCConceptXREFMAP rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (CConceptXREF val : this.value.values()) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CConceptXREF add(Object v) throws DmcValueException {
        DmcTypeCConceptXREFMAP dmcTypeCConceptXREFMAP = this;
        synchronized (dmcTypeCConceptXREFMAP) {
            DefinitionName key;
            CConceptXREF oldval;
            CConceptXREF newval = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if ((oldval = this.value.put(key = (DefinitionName)newval.getKey(), newval)) != null && oldval.valuesAreEqual(newval)) {
                newval = null;
            }
            return newval;
        }
    }

    @Override
    public CConceptXREF del(Object key) {
        DmcTypeCConceptXREFMAP dmcTypeCConceptXREFMAP = this;
        synchronized (dmcTypeCConceptXREFMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof DefinitionName) {
                return this.value.remove(key);
            }
            throw new IllegalStateException("Incompatible key type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<CConceptXREF> getMV() {
        DmcTypeCConceptXREFMAP dmcTypeCConceptXREFMAP = this;
        synchronized (dmcTypeCConceptXREFMAP) {
            if (this.value == null) {
                return emptyList;
            }
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<DefinitionName, CConceptXREF>(this.value) : new TreeMap<DefinitionName, CConceptXREF>(this.value);
            return clone.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<DefinitionName, CConceptXREF> getMVCopy() {
        DmcTypeCConceptXREFMAP dmcTypeCConceptXREFMAP = this;
        synchronized (dmcTypeCConceptXREFMAP) {
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? (this.value == null ? new HashMap() : new HashMap<DefinitionName, CConceptXREF>(this.value)) : (this.value == null ? new TreeMap() : new TreeMap<DefinitionName, CConceptXREF>(this.value));
            return clone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeCConceptXREFMAP dmcTypeCConceptXREFMAP = this;
        synchronized (dmcTypeCConceptXREFMAP) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    @Override
    public CConceptXREF getByKey(Object key) {
        DmcTypeCConceptXREFMAP dmcTypeCConceptXREFMAP = this;
        synchronized (dmcTypeCConceptXREFMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof DefinitionName) {
                return this.value.get((DefinitionName)key);
            }
            throw new IllegalStateException("Incompatible type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeCConceptXREFMAP dmcTypeCConceptXREFMAP = this;
        synchronized (dmcTypeCConceptXREFMAP) {
            if (this.value == null) {
                return false;
            }
            try {
                CConceptXREF val = this.typeCheck(v);
                return this.value.containsValue(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        DmcTypeCConceptXREFMAP dmcTypeCConceptXREFMAP = this;
        synchronized (dmcTypeCConceptXREFMAP) {
            if (this.value == null) {
                return false;
            }
            if (key instanceof DefinitionName) {
                return this.value.containsKey(key);
            }
            return false;
        }
    }
}

