/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.dsd.dsdc.shared.generated.types;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DefinitionName;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.dsd.dsdc.shared.generated.types.DmcTypeModuleCREF;
import org.dmd.dmt.dsd.dsdc.shared.generated.types.ModuleCREF;

public class DmcTypeModuleCREFMAP
extends DmcTypeModuleCREF
implements Serializable {
    private static final Iterator<ModuleCREF> emptyList = new HashMap().values().iterator();
    protected Map<DefinitionName, ModuleCREF> value;

    public DmcTypeModuleCREFMAP() {
        this.value = null;
    }

    public DmcTypeModuleCREFMAP(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<DefinitionName, ModuleCREF>() : new TreeMap<DefinitionName, ModuleCREF>();
    }

    public DefinitionName firstKey() {
        if (this.getAttributeInfo().valueType == ValueTypeEnum.TREEMAPPED) {
            if (this.value == null) {
                return null;
            }
            TreeMap map = (TreeMap)this.value;
            return (DefinitionName)map.firstKey();
        }
        throw new IllegalStateException("Attribute " + this.getAttributeInfo().name + " is HASHMAPPED and doesn't support firstKey()");
    }

    public DmcTypeModuleCREFMAP getNew() {
        return new DmcTypeModuleCREFMAP(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<ModuleCREF> cloneIt() {
        DmcTypeModuleCREFMAP dmcTypeModuleCREFMAP = this;
        synchronized (dmcTypeModuleCREFMAP) {
            DmcTypeModuleCREFMAP rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (ModuleCREF val : this.value.values()) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModuleCREF add(Object v) throws DmcValueException {
        DmcTypeModuleCREFMAP dmcTypeModuleCREFMAP = this;
        synchronized (dmcTypeModuleCREFMAP) {
            DefinitionName key;
            ModuleCREF oldval;
            ModuleCREF newval = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if ((oldval = this.value.put(key = (DefinitionName)newval.getKey(), newval)) != null && oldval.valuesAreEqual(newval)) {
                newval = null;
            }
            return newval;
        }
    }

    @Override
    public ModuleCREF del(Object key) {
        DmcTypeModuleCREFMAP dmcTypeModuleCREFMAP = this;
        synchronized (dmcTypeModuleCREFMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof DefinitionName) {
                return this.value.remove(key);
            }
            throw new IllegalStateException("Incompatible key type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ModuleCREF> getMV() {
        DmcTypeModuleCREFMAP dmcTypeModuleCREFMAP = this;
        synchronized (dmcTypeModuleCREFMAP) {
            if (this.value == null) {
                return emptyList;
            }
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<DefinitionName, ModuleCREF>(this.value) : new TreeMap<DefinitionName, ModuleCREF>(this.value);
            return clone.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<DefinitionName, ModuleCREF> getMVCopy() {
        DmcTypeModuleCREFMAP dmcTypeModuleCREFMAP = this;
        synchronized (dmcTypeModuleCREFMAP) {
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? (this.value == null ? new HashMap() : new HashMap<DefinitionName, ModuleCREF>(this.value)) : (this.value == null ? new TreeMap() : new TreeMap<DefinitionName, ModuleCREF>(this.value));
            return clone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeModuleCREFMAP dmcTypeModuleCREFMAP = this;
        synchronized (dmcTypeModuleCREFMAP) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    @Override
    public ModuleCREF getByKey(Object key) {
        DmcTypeModuleCREFMAP dmcTypeModuleCREFMAP = this;
        synchronized (dmcTypeModuleCREFMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof DefinitionName) {
                return this.value.get((DefinitionName)key);
            }
            throw new IllegalStateException("Incompatible type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeModuleCREFMAP dmcTypeModuleCREFMAP = this;
        synchronized (dmcTypeModuleCREFMAP) {
            if (this.value == null) {
                return false;
            }
            try {
                ModuleCREF val = this.typeCheck(v);
                return this.value.containsValue(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        DmcTypeModuleCREFMAP dmcTypeModuleCREFMAP = this;
        synchronized (dmcTypeModuleCREFMAP) {
            if (this.value == null) {
                return false;
            }
            if (key instanceof DefinitionName) {
                return this.value.containsKey(key);
            }
            return false;
        }
    }
}

