/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.dsd.dsdc.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.dsd.dsdc.shared.generated.types.DmcTypeModuleCREF;
import org.dmd.dmt.dsd.dsdc.shared.generated.types.ModuleCREF;

public class DmcTypeModuleCREFSET
extends DmcTypeModuleCREF
implements Serializable {
    private static final Iterator<ModuleCREF> emptyList = new HashSet().iterator();
    protected Set<ModuleCREF> value;

    public DmcTypeModuleCREFSET() {
        this.value = null;
    }

    public DmcTypeModuleCREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<ModuleCREF>() : new TreeSet<ModuleCREF>();
    }

    public DmcTypeModuleCREFSET getNew() {
        return new DmcTypeModuleCREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<ModuleCREF> cloneIt() {
        DmcTypeModuleCREFSET dmcTypeModuleCREFSET = this;
        synchronized (dmcTypeModuleCREFSET) {
            DmcTypeModuleCREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (ModuleCREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModuleCREF add(Object v) throws DmcValueException {
        DmcTypeModuleCREFSET dmcTypeModuleCREFSET = this;
        synchronized (dmcTypeModuleCREFSET) {
            ModuleCREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModuleCREF del(Object v) {
        DmcTypeModuleCREFSET dmcTypeModuleCREFSET = this;
        synchronized (dmcTypeModuleCREFSET) {
            ModuleCREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ModuleCREF> getMV() {
        DmcTypeModuleCREFSET dmcTypeModuleCREFSET = this;
        synchronized (dmcTypeModuleCREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<ModuleCREF>(this.value).iterator();
            }
            return new TreeSet<ModuleCREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ModuleCREF> getMVCopy() {
        DmcTypeModuleCREFSET dmcTypeModuleCREFSET = this;
        synchronized (dmcTypeModuleCREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<ModuleCREF>();
                }
                return new HashSet<ModuleCREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<ModuleCREF>(this.value);
            }
            return new TreeSet<ModuleCREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeModuleCREFSET dmcTypeModuleCREFSET = this;
        synchronized (dmcTypeModuleCREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeModuleCREFSET dmcTypeModuleCREFSET = this;
        synchronized (dmcTypeModuleCREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                ModuleCREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

