/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.shared.generated.types;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DefinitionName;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.shared.generated.types.BaseObjREF;
import org.dmd.dmt.shared.generated.types.DmcTypeBaseObjREF;

public class DmcTypeBaseObjREFMAP
extends DmcTypeBaseObjREF
implements Serializable {
    private static final Iterator<BaseObjREF> emptyList = new HashMap().values().iterator();
    protected Map<DefinitionName, BaseObjREF> value;

    public DmcTypeBaseObjREFMAP() {
        this.value = null;
    }

    public DmcTypeBaseObjREFMAP(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<DefinitionName, BaseObjREF>() : new TreeMap<DefinitionName, BaseObjREF>();
    }

    public DefinitionName firstKey() {
        if (this.getAttributeInfo().valueType == ValueTypeEnum.TREEMAPPED) {
            if (this.value == null) {
                return null;
            }
            TreeMap map = (TreeMap)this.value;
            return (DefinitionName)map.firstKey();
        }
        throw new IllegalStateException("Attribute " + this.getAttributeInfo().name + " is HASHMAPPED and doesn't support firstKey()");
    }

    public DmcTypeBaseObjREFMAP getNew() {
        return new DmcTypeBaseObjREFMAP(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<BaseObjREF> cloneIt() {
        DmcTypeBaseObjREFMAP dmcTypeBaseObjREFMAP = this;
        synchronized (dmcTypeBaseObjREFMAP) {
            DmcTypeBaseObjREFMAP rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (BaseObjREF val : this.value.values()) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseObjREF add(Object v) throws DmcValueException {
        DmcTypeBaseObjREFMAP dmcTypeBaseObjREFMAP = this;
        synchronized (dmcTypeBaseObjREFMAP) {
            DefinitionName key;
            BaseObjREF oldval;
            BaseObjREF newval = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if ((oldval = this.value.put(key = (DefinitionName)newval.getKey(), newval)) != null && oldval.valuesAreEqual(newval)) {
                newval = null;
            }
            return newval;
        }
    }

    @Override
    public BaseObjREF del(Object key) {
        DmcTypeBaseObjREFMAP dmcTypeBaseObjREFMAP = this;
        synchronized (dmcTypeBaseObjREFMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof DefinitionName) {
                return this.value.remove(key);
            }
            throw new IllegalStateException("Incompatible key type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<BaseObjREF> getMV() {
        DmcTypeBaseObjREFMAP dmcTypeBaseObjREFMAP = this;
        synchronized (dmcTypeBaseObjREFMAP) {
            if (this.value == null) {
                return emptyList;
            }
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<DefinitionName, BaseObjREF>(this.value) : new TreeMap<DefinitionName, BaseObjREF>(this.value);
            return clone.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<DefinitionName, BaseObjREF> getMVCopy() {
        DmcTypeBaseObjREFMAP dmcTypeBaseObjREFMAP = this;
        synchronized (dmcTypeBaseObjREFMAP) {
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? (this.value == null ? new HashMap() : new HashMap<DefinitionName, BaseObjREF>(this.value)) : (this.value == null ? new TreeMap() : new TreeMap<DefinitionName, BaseObjREF>(this.value));
            return clone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeBaseObjREFMAP dmcTypeBaseObjREFMAP = this;
        synchronized (dmcTypeBaseObjREFMAP) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    @Override
    public BaseObjREF getByKey(Object key) {
        DmcTypeBaseObjREFMAP dmcTypeBaseObjREFMAP = this;
        synchronized (dmcTypeBaseObjREFMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof DefinitionName) {
                return this.value.get((DefinitionName)key);
            }
            throw new IllegalStateException("Incompatible type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeBaseObjREFMAP dmcTypeBaseObjREFMAP = this;
        synchronized (dmcTypeBaseObjREFMAP) {
            if (this.value == null) {
                return false;
            }
            try {
                BaseObjREF val = this.typeCheck(v);
                return this.value.containsValue(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        DmcTypeBaseObjREFMAP dmcTypeBaseObjREFMAP = this;
        synchronized (dmcTypeBaseObjREFMAP) {
            if (this.value == null) {
                return false;
            }
            if (key instanceof DefinitionName) {
                return this.value.containsKey(key);
            }
            return false;
        }
    }
}

