/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.shared.generated.types.BaseObjREF;
import org.dmd.dmt.shared.generated.types.DmcTypeBaseObjREF;

public class DmcTypeBaseObjREFSET
extends DmcTypeBaseObjREF
implements Serializable {
    private static final Iterator<BaseObjREF> emptyList = new HashSet().iterator();
    protected Set<BaseObjREF> value;

    public DmcTypeBaseObjREFSET() {
        this.value = null;
    }

    public DmcTypeBaseObjREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<BaseObjREF>() : new TreeSet<BaseObjREF>();
    }

    public DmcTypeBaseObjREFSET getNew() {
        return new DmcTypeBaseObjREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<BaseObjREF> cloneIt() {
        DmcTypeBaseObjREFSET dmcTypeBaseObjREFSET = this;
        synchronized (dmcTypeBaseObjREFSET) {
            DmcTypeBaseObjREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (BaseObjREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseObjREF add(Object v) throws DmcValueException {
        DmcTypeBaseObjREFSET dmcTypeBaseObjREFSET = this;
        synchronized (dmcTypeBaseObjREFSET) {
            BaseObjREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseObjREF del(Object v) {
        DmcTypeBaseObjREFSET dmcTypeBaseObjREFSET = this;
        synchronized (dmcTypeBaseObjREFSET) {
            BaseObjREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<BaseObjREF> getMV() {
        DmcTypeBaseObjREFSET dmcTypeBaseObjREFSET = this;
        synchronized (dmcTypeBaseObjREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<BaseObjREF>(this.value).iterator();
            }
            return new TreeSet<BaseObjREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<BaseObjREF> getMVCopy() {
        DmcTypeBaseObjREFSET dmcTypeBaseObjREFSET = this;
        synchronized (dmcTypeBaseObjREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<BaseObjREF>();
                }
                return new HashSet<BaseObjREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<BaseObjREF>(this.value);
            }
            return new TreeSet<BaseObjREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeBaseObjREFSET dmcTypeBaseObjREFSET = this;
        synchronized (dmcTypeBaseObjREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeBaseObjREFSET dmcTypeBaseObjREFSET = this;
        synchronized (dmcTypeBaseObjREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                BaseObjREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

