/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.shared.generated.dmo.ComplexTypeTestDMO;
import org.dmd.dmt.shared.generated.types.DmcTypeComplexTypeTestREF;

public class DmcTypeComplexTypeTestREFSET
extends DmcTypeComplexTypeTestREF
implements Serializable {
    private static final Iterator<ComplexTypeTestDMO> emptyList = new HashSet().iterator();
    protected Set<ComplexTypeTestDMO> value;

    public DmcTypeComplexTypeTestREFSET() {
        this.value = null;
    }

    public DmcTypeComplexTypeTestREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<ComplexTypeTestDMO>() : new TreeSet<ComplexTypeTestDMO>();
    }

    public DmcTypeComplexTypeTestREFSET getNew() {
        return new DmcTypeComplexTypeTestREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<ComplexTypeTestDMO> cloneIt() {
        DmcTypeComplexTypeTestREFSET dmcTypeComplexTypeTestREFSET = this;
        synchronized (dmcTypeComplexTypeTestREFSET) {
            DmcTypeComplexTypeTestREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (ComplexTypeTestDMO val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComplexTypeTestDMO add(Object v) throws DmcValueException {
        DmcTypeComplexTypeTestREFSET dmcTypeComplexTypeTestREFSET = this;
        synchronized (dmcTypeComplexTypeTestREFSET) {
            ComplexTypeTestDMO rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComplexTypeTestDMO del(Object v) {
        DmcTypeComplexTypeTestREFSET dmcTypeComplexTypeTestREFSET = this;
        synchronized (dmcTypeComplexTypeTestREFSET) {
            ComplexTypeTestDMO rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ComplexTypeTestDMO> getMV() {
        DmcTypeComplexTypeTestREFSET dmcTypeComplexTypeTestREFSET = this;
        synchronized (dmcTypeComplexTypeTestREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<ComplexTypeTestDMO>(this.value).iterator();
            }
            return new TreeSet<ComplexTypeTestDMO>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ComplexTypeTestDMO> getMVCopy() {
        DmcTypeComplexTypeTestREFSET dmcTypeComplexTypeTestREFSET = this;
        synchronized (dmcTypeComplexTypeTestREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<ComplexTypeTestDMO>();
                }
                return new HashSet<ComplexTypeTestDMO>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<ComplexTypeTestDMO>(this.value);
            }
            return new TreeSet<ComplexTypeTestDMO>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeComplexTypeTestREFSET dmcTypeComplexTypeTestREFSET = this;
        synchronized (dmcTypeComplexTypeTestREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeComplexTypeTestREFSET dmcTypeComplexTypeTestREFSET = this;
        synchronized (dmcTypeComplexTypeTestREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                ComplexTypeTestDMO val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

