/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.shared.generated.types.DmcTypeDmtField;
import org.dmd.dmt.shared.generated.types.DmtField;

public class DmcTypeDmtFieldSET
extends DmcTypeDmtField
implements Serializable {
    private static final Iterator<DmtField> emptyList = new HashSet().iterator();
    protected Set<DmtField> value;

    public DmcTypeDmtFieldSET() {
        this.value = null;
    }

    public DmcTypeDmtFieldSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<DmtField>() : new TreeSet<DmtField>();
    }

    public DmcTypeDmtFieldSET getNew() {
        return new DmcTypeDmtFieldSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<DmtField> cloneIt() {
        DmcTypeDmtFieldSET dmcTypeDmtFieldSET = this;
        synchronized (dmcTypeDmtFieldSET) {
            DmcTypeDmtFieldSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (DmtField val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmtField add(Object v) throws DmcValueException {
        DmcTypeDmtFieldSET dmcTypeDmtFieldSET = this;
        synchronized (dmcTypeDmtFieldSET) {
            DmtField rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmtField del(Object v) {
        DmcTypeDmtFieldSET dmcTypeDmtFieldSET = this;
        synchronized (dmcTypeDmtFieldSET) {
            DmtField rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<DmtField> getMV() {
        DmcTypeDmtFieldSET dmcTypeDmtFieldSET = this;
        synchronized (dmcTypeDmtFieldSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<DmtField>(this.value).iterator();
            }
            return new TreeSet<DmtField>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DmtField> getMVCopy() {
        DmcTypeDmtFieldSET dmcTypeDmtFieldSET = this;
        synchronized (dmcTypeDmtFieldSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<DmtField>();
                }
                return new HashSet<DmtField>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<DmtField>(this.value);
            }
            return new TreeSet<DmtField>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeDmtFieldSET dmcTypeDmtFieldSET = this;
        synchronized (dmcTypeDmtFieldSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeDmtFieldSET dmcTypeDmtFieldSET = this;
        synchronized (dmcTypeDmtFieldSET) {
            if (this.value == null) {
                return false;
            }
            try {
                DmtField val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

