/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.shared.types.DmcTypeDmtStringName;
import org.dmd.dmt.shared.types.DmtStringName;

public class DmcTypeDmtStringNameSET
extends DmcTypeDmtStringName
implements Serializable {
    private static final Iterator<DmtStringName> emptyList = new HashSet().iterator();
    protected Set<DmtStringName> value;

    public DmcTypeDmtStringNameSET() {
        this.value = null;
    }

    public DmcTypeDmtStringNameSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<DmtStringName>() : new TreeSet<DmtStringName>();
    }

    public DmcTypeDmtStringNameSET getNew() {
        return new DmcTypeDmtStringNameSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<DmtStringName> cloneIt() {
        DmcTypeDmtStringNameSET dmcTypeDmtStringNameSET = this;
        synchronized (dmcTypeDmtStringNameSET) {
            DmcTypeDmtStringNameSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (DmtStringName val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmtStringName add(Object v) throws DmcValueException {
        DmcTypeDmtStringNameSET dmcTypeDmtStringNameSET = this;
        synchronized (dmcTypeDmtStringNameSET) {
            DmtStringName rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmtStringName del(Object v) {
        DmcTypeDmtStringNameSET dmcTypeDmtStringNameSET = this;
        synchronized (dmcTypeDmtStringNameSET) {
            DmtStringName rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<DmtStringName> getMV() {
        DmcTypeDmtStringNameSET dmcTypeDmtStringNameSET = this;
        synchronized (dmcTypeDmtStringNameSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<DmtStringName>(this.value).iterator();
            }
            return new TreeSet<DmtStringName>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DmtStringName> getMVCopy() {
        DmcTypeDmtStringNameSET dmcTypeDmtStringNameSET = this;
        synchronized (dmcTypeDmtStringNameSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<DmtStringName>();
                }
                return new HashSet<DmtStringName>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<DmtStringName>(this.value);
            }
            return new TreeSet<DmtStringName>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeDmtStringNameSET dmcTypeDmtStringNameSET = this;
        synchronized (dmcTypeDmtStringNameSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeDmtStringNameSET dmcTypeDmtStringNameSET = this;
        synchronized (dmcTypeDmtStringNameSET) {
            if (this.value == null) {
                return false;
            }
            try {
                DmtStringName val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

