/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.shared.generated.dmo.ExtendedRefHSDMO;
import org.dmd.dmt.shared.generated.types.DmcTypeExtendedRefHSREF;

public class DmcTypeExtendedRefHSREFSET
extends DmcTypeExtendedRefHSREF
implements Serializable {
    private static final Iterator<ExtendedRefHSDMO> emptyList = new HashSet().iterator();
    protected Set<ExtendedRefHSDMO> value;

    public DmcTypeExtendedRefHSREFSET() {
        this.value = null;
    }

    public DmcTypeExtendedRefHSREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<ExtendedRefHSDMO>() : new TreeSet<ExtendedRefHSDMO>();
    }

    public DmcTypeExtendedRefHSREFSET getNew() {
        return new DmcTypeExtendedRefHSREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<ExtendedRefHSDMO> cloneIt() {
        DmcTypeExtendedRefHSREFSET dmcTypeExtendedRefHSREFSET = this;
        synchronized (dmcTypeExtendedRefHSREFSET) {
            DmcTypeExtendedRefHSREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (ExtendedRefHSDMO val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExtendedRefHSDMO add(Object v) throws DmcValueException {
        DmcTypeExtendedRefHSREFSET dmcTypeExtendedRefHSREFSET = this;
        synchronized (dmcTypeExtendedRefHSREFSET) {
            ExtendedRefHSDMO rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExtendedRefHSDMO del(Object v) {
        DmcTypeExtendedRefHSREFSET dmcTypeExtendedRefHSREFSET = this;
        synchronized (dmcTypeExtendedRefHSREFSET) {
            ExtendedRefHSDMO rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ExtendedRefHSDMO> getMV() {
        DmcTypeExtendedRefHSREFSET dmcTypeExtendedRefHSREFSET = this;
        synchronized (dmcTypeExtendedRefHSREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<ExtendedRefHSDMO>(this.value).iterator();
            }
            return new TreeSet<ExtendedRefHSDMO>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ExtendedRefHSDMO> getMVCopy() {
        DmcTypeExtendedRefHSREFSET dmcTypeExtendedRefHSREFSET = this;
        synchronized (dmcTypeExtendedRefHSREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<ExtendedRefHSDMO>();
                }
                return new HashSet<ExtendedRefHSDMO>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<ExtendedRefHSDMO>(this.value);
            }
            return new TreeSet<ExtendedRefHSDMO>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeExtendedRefHSREFSET dmcTypeExtendedRefHSREFSET = this;
        synchronized (dmcTypeExtendedRefHSREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeExtendedRefHSREFSET dmcTypeExtendedRefHSREFSET = this;
        synchronized (dmcTypeExtendedRefHSREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                ExtendedRefHSDMO val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

