/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.shared.generated.dmo.ExtendedRefMVDMO;
import org.dmd.dmt.shared.generated.types.DmcTypeExtendedRefMVREF;

public class DmcTypeExtendedRefMVREFSET
extends DmcTypeExtendedRefMVREF
implements Serializable {
    private static final Iterator<ExtendedRefMVDMO> emptyList = new HashSet().iterator();
    protected Set<ExtendedRefMVDMO> value;

    public DmcTypeExtendedRefMVREFSET() {
        this.value = null;
    }

    public DmcTypeExtendedRefMVREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<ExtendedRefMVDMO>() : new TreeSet<ExtendedRefMVDMO>();
    }

    public DmcTypeExtendedRefMVREFSET getNew() {
        return new DmcTypeExtendedRefMVREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<ExtendedRefMVDMO> cloneIt() {
        DmcTypeExtendedRefMVREFSET dmcTypeExtendedRefMVREFSET = this;
        synchronized (dmcTypeExtendedRefMVREFSET) {
            DmcTypeExtendedRefMVREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (ExtendedRefMVDMO val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExtendedRefMVDMO add(Object v) throws DmcValueException {
        DmcTypeExtendedRefMVREFSET dmcTypeExtendedRefMVREFSET = this;
        synchronized (dmcTypeExtendedRefMVREFSET) {
            ExtendedRefMVDMO rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExtendedRefMVDMO del(Object v) {
        DmcTypeExtendedRefMVREFSET dmcTypeExtendedRefMVREFSET = this;
        synchronized (dmcTypeExtendedRefMVREFSET) {
            ExtendedRefMVDMO rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ExtendedRefMVDMO> getMV() {
        DmcTypeExtendedRefMVREFSET dmcTypeExtendedRefMVREFSET = this;
        synchronized (dmcTypeExtendedRefMVREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<ExtendedRefMVDMO>(this.value).iterator();
            }
            return new TreeSet<ExtendedRefMVDMO>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ExtendedRefMVDMO> getMVCopy() {
        DmcTypeExtendedRefMVREFSET dmcTypeExtendedRefMVREFSET = this;
        synchronized (dmcTypeExtendedRefMVREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<ExtendedRefMVDMO>();
                }
                return new HashSet<ExtendedRefMVDMO>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<ExtendedRefMVDMO>(this.value);
            }
            return new TreeSet<ExtendedRefMVDMO>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeExtendedRefMVREFSET dmcTypeExtendedRefMVREFSET = this;
        synchronized (dmcTypeExtendedRefMVREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeExtendedRefMVREFSET dmcTypeExtendedRefMVREFSET = this;
        synchronized (dmcTypeExtendedRefMVREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                ExtendedRefMVDMO val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

