/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.shared.generated.dmo.ExtendedRefSVDMO;
import org.dmd.dmt.shared.generated.types.DmcTypeExtendedRefSVREF;

public class DmcTypeExtendedRefSVREFSET
extends DmcTypeExtendedRefSVREF
implements Serializable {
    private static final Iterator<ExtendedRefSVDMO> emptyList = new HashSet().iterator();
    protected Set<ExtendedRefSVDMO> value;

    public DmcTypeExtendedRefSVREFSET() {
        this.value = null;
    }

    public DmcTypeExtendedRefSVREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<ExtendedRefSVDMO>() : new TreeSet<ExtendedRefSVDMO>();
    }

    public DmcTypeExtendedRefSVREFSET getNew() {
        return new DmcTypeExtendedRefSVREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<ExtendedRefSVDMO> cloneIt() {
        DmcTypeExtendedRefSVREFSET dmcTypeExtendedRefSVREFSET = this;
        synchronized (dmcTypeExtendedRefSVREFSET) {
            DmcTypeExtendedRefSVREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (ExtendedRefSVDMO val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExtendedRefSVDMO add(Object v) throws DmcValueException {
        DmcTypeExtendedRefSVREFSET dmcTypeExtendedRefSVREFSET = this;
        synchronized (dmcTypeExtendedRefSVREFSET) {
            ExtendedRefSVDMO rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExtendedRefSVDMO del(Object v) {
        DmcTypeExtendedRefSVREFSET dmcTypeExtendedRefSVREFSET = this;
        synchronized (dmcTypeExtendedRefSVREFSET) {
            ExtendedRefSVDMO rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ExtendedRefSVDMO> getMV() {
        DmcTypeExtendedRefSVREFSET dmcTypeExtendedRefSVREFSET = this;
        synchronized (dmcTypeExtendedRefSVREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<ExtendedRefSVDMO>(this.value).iterator();
            }
            return new TreeSet<ExtendedRefSVDMO>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ExtendedRefSVDMO> getMVCopy() {
        DmcTypeExtendedRefSVREFSET dmcTypeExtendedRefSVREFSET = this;
        synchronized (dmcTypeExtendedRefSVREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<ExtendedRefSVDMO>();
                }
                return new HashSet<ExtendedRefSVDMO>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<ExtendedRefSVDMO>(this.value);
            }
            return new TreeSet<ExtendedRefSVDMO>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeExtendedRefSVREFSET dmcTypeExtendedRefSVREFSET = this;
        synchronized (dmcTypeExtendedRefSVREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeExtendedRefSVREFSET dmcTypeExtendedRefSVREFSET = this;
        synchronized (dmcTypeExtendedRefSVREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                ExtendedRefSVDMO val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

