/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.shared.generated.dmo.ExtendedRefTSDMO;
import org.dmd.dmt.shared.generated.types.DmcTypeExtendedRefTSREF;

public class DmcTypeExtendedRefTSREFSET
extends DmcTypeExtendedRefTSREF
implements Serializable {
    private static final Iterator<ExtendedRefTSDMO> emptyList = new HashSet().iterator();
    protected Set<ExtendedRefTSDMO> value;

    public DmcTypeExtendedRefTSREFSET() {
        this.value = null;
    }

    public DmcTypeExtendedRefTSREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<ExtendedRefTSDMO>() : new TreeSet<ExtendedRefTSDMO>();
    }

    public DmcTypeExtendedRefTSREFSET getNew() {
        return new DmcTypeExtendedRefTSREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<ExtendedRefTSDMO> cloneIt() {
        DmcTypeExtendedRefTSREFSET dmcTypeExtendedRefTSREFSET = this;
        synchronized (dmcTypeExtendedRefTSREFSET) {
            DmcTypeExtendedRefTSREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (ExtendedRefTSDMO val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExtendedRefTSDMO add(Object v) throws DmcValueException {
        DmcTypeExtendedRefTSREFSET dmcTypeExtendedRefTSREFSET = this;
        synchronized (dmcTypeExtendedRefTSREFSET) {
            ExtendedRefTSDMO rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExtendedRefTSDMO del(Object v) {
        DmcTypeExtendedRefTSREFSET dmcTypeExtendedRefTSREFSET = this;
        synchronized (dmcTypeExtendedRefTSREFSET) {
            ExtendedRefTSDMO rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ExtendedRefTSDMO> getMV() {
        DmcTypeExtendedRefTSREFSET dmcTypeExtendedRefTSREFSET = this;
        synchronized (dmcTypeExtendedRefTSREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<ExtendedRefTSDMO>(this.value).iterator();
            }
            return new TreeSet<ExtendedRefTSDMO>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ExtendedRefTSDMO> getMVCopy() {
        DmcTypeExtendedRefTSREFSET dmcTypeExtendedRefTSREFSET = this;
        synchronized (dmcTypeExtendedRefTSREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<ExtendedRefTSDMO>();
                }
                return new HashSet<ExtendedRefTSDMO>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<ExtendedRefTSDMO>(this.value);
            }
            return new TreeSet<ExtendedRefTSDMO>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeExtendedRefTSREFSET dmcTypeExtendedRefTSREFSET = this;
        synchronized (dmcTypeExtendedRefTSREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeExtendedRefTSREFSET dmcTypeExtendedRefTSREFSET = this;
        synchronized (dmcTypeExtendedRefTSREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                ExtendedRefTSDMO val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

