/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.shared.generated.types.DmcTypeIntegerNamedObjectREF;
import org.dmd.dmt.shared.generated.types.IntegerNamedObjectREF;

public class DmcTypeIntegerNamedObjectREFSET
extends DmcTypeIntegerNamedObjectREF
implements Serializable {
    private static final Iterator<IntegerNamedObjectREF> emptyList = new HashSet().iterator();
    protected Set<IntegerNamedObjectREF> value;

    public DmcTypeIntegerNamedObjectREFSET() {
        this.value = null;
    }

    public DmcTypeIntegerNamedObjectREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<IntegerNamedObjectREF>() : new TreeSet<IntegerNamedObjectREF>();
    }

    public DmcTypeIntegerNamedObjectREFSET getNew() {
        return new DmcTypeIntegerNamedObjectREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<IntegerNamedObjectREF> cloneIt() {
        DmcTypeIntegerNamedObjectREFSET dmcTypeIntegerNamedObjectREFSET = this;
        synchronized (dmcTypeIntegerNamedObjectREFSET) {
            DmcTypeIntegerNamedObjectREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (IntegerNamedObjectREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IntegerNamedObjectREF add(Object v) throws DmcValueException {
        DmcTypeIntegerNamedObjectREFSET dmcTypeIntegerNamedObjectREFSET = this;
        synchronized (dmcTypeIntegerNamedObjectREFSET) {
            IntegerNamedObjectREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IntegerNamedObjectREF del(Object v) {
        DmcTypeIntegerNamedObjectREFSET dmcTypeIntegerNamedObjectREFSET = this;
        synchronized (dmcTypeIntegerNamedObjectREFSET) {
            IntegerNamedObjectREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<IntegerNamedObjectREF> getMV() {
        DmcTypeIntegerNamedObjectREFSET dmcTypeIntegerNamedObjectREFSET = this;
        synchronized (dmcTypeIntegerNamedObjectREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<IntegerNamedObjectREF>(this.value).iterator();
            }
            return new TreeSet<IntegerNamedObjectREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<IntegerNamedObjectREF> getMVCopy() {
        DmcTypeIntegerNamedObjectREFSET dmcTypeIntegerNamedObjectREFSET = this;
        synchronized (dmcTypeIntegerNamedObjectREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<IntegerNamedObjectREF>();
                }
                return new HashSet<IntegerNamedObjectREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<IntegerNamedObjectREF>(this.value);
            }
            return new TreeSet<IntegerNamedObjectREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeIntegerNamedObjectREFSET dmcTypeIntegerNamedObjectREFSET = this;
        synchronized (dmcTypeIntegerNamedObjectREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeIntegerNamedObjectREFSET dmcTypeIntegerNamedObjectREFSET = this;
        synchronized (dmcTypeIntegerNamedObjectREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                IntegerNamedObjectREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

