/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.shared.generated.dmo.NameContainerTestDMO;
import org.dmd.dmt.shared.generated.types.DmcTypeNameContainerTestREF;

public class DmcTypeNameContainerTestREFSET
extends DmcTypeNameContainerTestREF
implements Serializable {
    private static final Iterator<NameContainerTestDMO> emptyList = new HashSet().iterator();
    protected Set<NameContainerTestDMO> value;

    public DmcTypeNameContainerTestREFSET() {
        this.value = null;
    }

    public DmcTypeNameContainerTestREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<NameContainerTestDMO>() : new TreeSet<NameContainerTestDMO>();
    }

    public DmcTypeNameContainerTestREFSET getNew() {
        return new DmcTypeNameContainerTestREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<NameContainerTestDMO> cloneIt() {
        DmcTypeNameContainerTestREFSET dmcTypeNameContainerTestREFSET = this;
        synchronized (dmcTypeNameContainerTestREFSET) {
            DmcTypeNameContainerTestREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (NameContainerTestDMO val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NameContainerTestDMO add(Object v) throws DmcValueException {
        DmcTypeNameContainerTestREFSET dmcTypeNameContainerTestREFSET = this;
        synchronized (dmcTypeNameContainerTestREFSET) {
            NameContainerTestDMO rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NameContainerTestDMO del(Object v) {
        DmcTypeNameContainerTestREFSET dmcTypeNameContainerTestREFSET = this;
        synchronized (dmcTypeNameContainerTestREFSET) {
            NameContainerTestDMO rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<NameContainerTestDMO> getMV() {
        DmcTypeNameContainerTestREFSET dmcTypeNameContainerTestREFSET = this;
        synchronized (dmcTypeNameContainerTestREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<NameContainerTestDMO>(this.value).iterator();
            }
            return new TreeSet<NameContainerTestDMO>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<NameContainerTestDMO> getMVCopy() {
        DmcTypeNameContainerTestREFSET dmcTypeNameContainerTestREFSET = this;
        synchronized (dmcTypeNameContainerTestREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<NameContainerTestDMO>();
                }
                return new HashSet<NameContainerTestDMO>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<NameContainerTestDMO>(this.value);
            }
            return new TreeSet<NameContainerTestDMO>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeNameContainerTestREFSET dmcTypeNameContainerTestREFSET = this;
        synchronized (dmcTypeNameContainerTestREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeNameContainerTestREFSET dmcTypeNameContainerTestREFSET = this;
        synchronized (dmcTypeNameContainerTestREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                NameContainerTestDMO val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

