/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.shared.generated.dmo.NamedObjHMDMO;
import org.dmd.dmt.shared.generated.types.DmcTypeNamedObjHMREF;

public class DmcTypeNamedObjHMREFSET
extends DmcTypeNamedObjHMREF
implements Serializable {
    private static final Iterator<NamedObjHMDMO> emptyList = new HashSet().iterator();
    protected Set<NamedObjHMDMO> value;

    public DmcTypeNamedObjHMREFSET() {
        this.value = null;
    }

    public DmcTypeNamedObjHMREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<NamedObjHMDMO>() : new TreeSet<NamedObjHMDMO>();
    }

    public DmcTypeNamedObjHMREFSET getNew() {
        return new DmcTypeNamedObjHMREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<NamedObjHMDMO> cloneIt() {
        DmcTypeNamedObjHMREFSET dmcTypeNamedObjHMREFSET = this;
        synchronized (dmcTypeNamedObjHMREFSET) {
            DmcTypeNamedObjHMREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (NamedObjHMDMO val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamedObjHMDMO add(Object v) throws DmcValueException {
        DmcTypeNamedObjHMREFSET dmcTypeNamedObjHMREFSET = this;
        synchronized (dmcTypeNamedObjHMREFSET) {
            NamedObjHMDMO rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamedObjHMDMO del(Object v) {
        DmcTypeNamedObjHMREFSET dmcTypeNamedObjHMREFSET = this;
        synchronized (dmcTypeNamedObjHMREFSET) {
            NamedObjHMDMO rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<NamedObjHMDMO> getMV() {
        DmcTypeNamedObjHMREFSET dmcTypeNamedObjHMREFSET = this;
        synchronized (dmcTypeNamedObjHMREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<NamedObjHMDMO>(this.value).iterator();
            }
            return new TreeSet<NamedObjHMDMO>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<NamedObjHMDMO> getMVCopy() {
        DmcTypeNamedObjHMREFSET dmcTypeNamedObjHMREFSET = this;
        synchronized (dmcTypeNamedObjHMREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<NamedObjHMDMO>();
                }
                return new HashSet<NamedObjHMDMO>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<NamedObjHMDMO>(this.value);
            }
            return new TreeSet<NamedObjHMDMO>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeNamedObjHMREFSET dmcTypeNamedObjHMREFSET = this;
        synchronized (dmcTypeNamedObjHMREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeNamedObjHMREFSET dmcTypeNamedObjHMREFSET = this;
        synchronized (dmcTypeNamedObjHMREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                NamedObjHMDMO val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

