/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.shared.generated.dmo.NamedObjMVIDXDMO;
import org.dmd.dmt.shared.generated.types.DmcTypeNamedObjMVIDXREF;

public class DmcTypeNamedObjMVIDXREFSET
extends DmcTypeNamedObjMVIDXREF
implements Serializable {
    private static final Iterator<NamedObjMVIDXDMO> emptyList = new HashSet().iterator();
    protected Set<NamedObjMVIDXDMO> value;

    public DmcTypeNamedObjMVIDXREFSET() {
        this.value = null;
    }

    public DmcTypeNamedObjMVIDXREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<NamedObjMVIDXDMO>() : new TreeSet<NamedObjMVIDXDMO>();
    }

    public DmcTypeNamedObjMVIDXREFSET getNew() {
        return new DmcTypeNamedObjMVIDXREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<NamedObjMVIDXDMO> cloneIt() {
        DmcTypeNamedObjMVIDXREFSET dmcTypeNamedObjMVIDXREFSET = this;
        synchronized (dmcTypeNamedObjMVIDXREFSET) {
            DmcTypeNamedObjMVIDXREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (NamedObjMVIDXDMO val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamedObjMVIDXDMO add(Object v) throws DmcValueException {
        DmcTypeNamedObjMVIDXREFSET dmcTypeNamedObjMVIDXREFSET = this;
        synchronized (dmcTypeNamedObjMVIDXREFSET) {
            NamedObjMVIDXDMO rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamedObjMVIDXDMO del(Object v) {
        DmcTypeNamedObjMVIDXREFSET dmcTypeNamedObjMVIDXREFSET = this;
        synchronized (dmcTypeNamedObjMVIDXREFSET) {
            NamedObjMVIDXDMO rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<NamedObjMVIDXDMO> getMV() {
        DmcTypeNamedObjMVIDXREFSET dmcTypeNamedObjMVIDXREFSET = this;
        synchronized (dmcTypeNamedObjMVIDXREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<NamedObjMVIDXDMO>(this.value).iterator();
            }
            return new TreeSet<NamedObjMVIDXDMO>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<NamedObjMVIDXDMO> getMVCopy() {
        DmcTypeNamedObjMVIDXREFSET dmcTypeNamedObjMVIDXREFSET = this;
        synchronized (dmcTypeNamedObjMVIDXREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<NamedObjMVIDXDMO>();
                }
                return new HashSet<NamedObjMVIDXDMO>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<NamedObjMVIDXDMO>(this.value);
            }
            return new TreeSet<NamedObjMVIDXDMO>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeNamedObjMVIDXREFSET dmcTypeNamedObjMVIDXREFSET = this;
        synchronized (dmcTypeNamedObjMVIDXREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeNamedObjMVIDXREFSET dmcTypeNamedObjMVIDXREFSET = this;
        synchronized (dmcTypeNamedObjMVIDXREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                NamedObjMVIDXDMO val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

