/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.shared.generated.dmo.NamedObjMVDMO;
import org.dmd.dmt.shared.generated.types.DmcTypeNamedObjMVREF;

public class DmcTypeNamedObjMVREFSET
extends DmcTypeNamedObjMVREF
implements Serializable {
    private static final Iterator<NamedObjMVDMO> emptyList = new HashSet().iterator();
    protected Set<NamedObjMVDMO> value;

    public DmcTypeNamedObjMVREFSET() {
        this.value = null;
    }

    public DmcTypeNamedObjMVREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<NamedObjMVDMO>() : new TreeSet<NamedObjMVDMO>();
    }

    public DmcTypeNamedObjMVREFSET getNew() {
        return new DmcTypeNamedObjMVREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<NamedObjMVDMO> cloneIt() {
        DmcTypeNamedObjMVREFSET dmcTypeNamedObjMVREFSET = this;
        synchronized (dmcTypeNamedObjMVREFSET) {
            DmcTypeNamedObjMVREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (NamedObjMVDMO val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamedObjMVDMO add(Object v) throws DmcValueException {
        DmcTypeNamedObjMVREFSET dmcTypeNamedObjMVREFSET = this;
        synchronized (dmcTypeNamedObjMVREFSET) {
            NamedObjMVDMO rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamedObjMVDMO del(Object v) {
        DmcTypeNamedObjMVREFSET dmcTypeNamedObjMVREFSET = this;
        synchronized (dmcTypeNamedObjMVREFSET) {
            NamedObjMVDMO rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<NamedObjMVDMO> getMV() {
        DmcTypeNamedObjMVREFSET dmcTypeNamedObjMVREFSET = this;
        synchronized (dmcTypeNamedObjMVREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<NamedObjMVDMO>(this.value).iterator();
            }
            return new TreeSet<NamedObjMVDMO>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<NamedObjMVDMO> getMVCopy() {
        DmcTypeNamedObjMVREFSET dmcTypeNamedObjMVREFSET = this;
        synchronized (dmcTypeNamedObjMVREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<NamedObjMVDMO>();
                }
                return new HashSet<NamedObjMVDMO>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<NamedObjMVDMO>(this.value);
            }
            return new TreeSet<NamedObjMVDMO>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeNamedObjMVREFSET dmcTypeNamedObjMVREFSET = this;
        synchronized (dmcTypeNamedObjMVREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeNamedObjMVREFSET dmcTypeNamedObjMVREFSET = this;
        synchronized (dmcTypeNamedObjMVREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                NamedObjMVDMO val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

