/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.shared.generated.dmo.NamedObjSVDMO;
import org.dmd.dmt.shared.generated.types.DmcTypeNamedObjSVREF;

public class DmcTypeNamedObjSVREFSET
extends DmcTypeNamedObjSVREF
implements Serializable {
    private static final Iterator<NamedObjSVDMO> emptyList = new HashSet().iterator();
    protected Set<NamedObjSVDMO> value;

    public DmcTypeNamedObjSVREFSET() {
        this.value = null;
    }

    public DmcTypeNamedObjSVREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<NamedObjSVDMO>() : new TreeSet<NamedObjSVDMO>();
    }

    public DmcTypeNamedObjSVREFSET getNew() {
        return new DmcTypeNamedObjSVREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<NamedObjSVDMO> cloneIt() {
        DmcTypeNamedObjSVREFSET dmcTypeNamedObjSVREFSET = this;
        synchronized (dmcTypeNamedObjSVREFSET) {
            DmcTypeNamedObjSVREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (NamedObjSVDMO val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamedObjSVDMO add(Object v) throws DmcValueException {
        DmcTypeNamedObjSVREFSET dmcTypeNamedObjSVREFSET = this;
        synchronized (dmcTypeNamedObjSVREFSET) {
            NamedObjSVDMO rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamedObjSVDMO del(Object v) {
        DmcTypeNamedObjSVREFSET dmcTypeNamedObjSVREFSET = this;
        synchronized (dmcTypeNamedObjSVREFSET) {
            NamedObjSVDMO rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<NamedObjSVDMO> getMV() {
        DmcTypeNamedObjSVREFSET dmcTypeNamedObjSVREFSET = this;
        synchronized (dmcTypeNamedObjSVREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<NamedObjSVDMO>(this.value).iterator();
            }
            return new TreeSet<NamedObjSVDMO>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<NamedObjSVDMO> getMVCopy() {
        DmcTypeNamedObjSVREFSET dmcTypeNamedObjSVREFSET = this;
        synchronized (dmcTypeNamedObjSVREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<NamedObjSVDMO>();
                }
                return new HashSet<NamedObjSVDMO>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<NamedObjSVDMO>(this.value);
            }
            return new TreeSet<NamedObjSVDMO>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeNamedObjSVREFSET dmcTypeNamedObjSVREFSET = this;
        synchronized (dmcTypeNamedObjSVREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeNamedObjSVREFSET dmcTypeNamedObjSVREFSET = this;
        synchronized (dmcTypeNamedObjSVREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                NamedObjSVDMO val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

