/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.shared.generated.dmo.NamedObjTMDMO;
import org.dmd.dmt.shared.generated.types.DmcTypeNamedObjTMREF;

public class DmcTypeNamedObjTMREFSET
extends DmcTypeNamedObjTMREF
implements Serializable {
    private static final Iterator<NamedObjTMDMO> emptyList = new HashSet().iterator();
    protected Set<NamedObjTMDMO> value;

    public DmcTypeNamedObjTMREFSET() {
        this.value = null;
    }

    public DmcTypeNamedObjTMREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<NamedObjTMDMO>() : new TreeSet<NamedObjTMDMO>();
    }

    public DmcTypeNamedObjTMREFSET getNew() {
        return new DmcTypeNamedObjTMREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<NamedObjTMDMO> cloneIt() {
        DmcTypeNamedObjTMREFSET dmcTypeNamedObjTMREFSET = this;
        synchronized (dmcTypeNamedObjTMREFSET) {
            DmcTypeNamedObjTMREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (NamedObjTMDMO val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamedObjTMDMO add(Object v) throws DmcValueException {
        DmcTypeNamedObjTMREFSET dmcTypeNamedObjTMREFSET = this;
        synchronized (dmcTypeNamedObjTMREFSET) {
            NamedObjTMDMO rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamedObjTMDMO del(Object v) {
        DmcTypeNamedObjTMREFSET dmcTypeNamedObjTMREFSET = this;
        synchronized (dmcTypeNamedObjTMREFSET) {
            NamedObjTMDMO rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<NamedObjTMDMO> getMV() {
        DmcTypeNamedObjTMREFSET dmcTypeNamedObjTMREFSET = this;
        synchronized (dmcTypeNamedObjTMREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<NamedObjTMDMO>(this.value).iterator();
            }
            return new TreeSet<NamedObjTMDMO>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<NamedObjTMDMO> getMVCopy() {
        DmcTypeNamedObjTMREFSET dmcTypeNamedObjTMREFSET = this;
        synchronized (dmcTypeNamedObjTMREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<NamedObjTMDMO>();
                }
                return new HashSet<NamedObjTMDMO>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<NamedObjTMDMO>(this.value);
            }
            return new TreeSet<NamedObjTMDMO>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeNamedObjTMREFSET dmcTypeNamedObjTMREFSET = this;
        synchronized (dmcTypeNamedObjTMREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeNamedObjTMREFSET dmcTypeNamedObjTMREFSET = this;
        synchronized (dmcTypeNamedObjTMREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                NamedObjTMDMO val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

