/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.shared.generated.dmo.ParseTestDMO;
import org.dmd.dmt.shared.generated.types.DmcTypeParseTestREF;

public class DmcTypeParseTestREFSET
extends DmcTypeParseTestREF
implements Serializable {
    private static final Iterator<ParseTestDMO> emptyList = new HashSet().iterator();
    protected Set<ParseTestDMO> value;

    public DmcTypeParseTestREFSET() {
        this.value = null;
    }

    public DmcTypeParseTestREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<ParseTestDMO>() : new TreeSet<ParseTestDMO>();
    }

    public DmcTypeParseTestREFSET getNew() {
        return new DmcTypeParseTestREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<ParseTestDMO> cloneIt() {
        DmcTypeParseTestREFSET dmcTypeParseTestREFSET = this;
        synchronized (dmcTypeParseTestREFSET) {
            DmcTypeParseTestREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (ParseTestDMO val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParseTestDMO add(Object v) throws DmcValueException {
        DmcTypeParseTestREFSET dmcTypeParseTestREFSET = this;
        synchronized (dmcTypeParseTestREFSET) {
            ParseTestDMO rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParseTestDMO del(Object v) {
        DmcTypeParseTestREFSET dmcTypeParseTestREFSET = this;
        synchronized (dmcTypeParseTestREFSET) {
            ParseTestDMO rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ParseTestDMO> getMV() {
        DmcTypeParseTestREFSET dmcTypeParseTestREFSET = this;
        synchronized (dmcTypeParseTestREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<ParseTestDMO>(this.value).iterator();
            }
            return new TreeSet<ParseTestDMO>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ParseTestDMO> getMVCopy() {
        DmcTypeParseTestREFSET dmcTypeParseTestREFSET = this;
        synchronized (dmcTypeParseTestREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<ParseTestDMO>();
                }
                return new HashSet<ParseTestDMO>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<ParseTestDMO>(this.value);
            }
            return new TreeSet<ParseTestDMO>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeParseTestREFSET dmcTypeParseTestREFSET = this;
        synchronized (dmcTypeParseTestREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeParseTestREFSET dmcTypeParseTestREFSET = this;
        synchronized (dmcTypeParseTestREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                ParseTestDMO val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

