/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.shared.generated.dmo.PrimitiveHSDMO;
import org.dmd.dmt.shared.generated.types.DmcTypePrimitiveHSREF;

public class DmcTypePrimitiveHSREFSET
extends DmcTypePrimitiveHSREF
implements Serializable {
    private static final Iterator<PrimitiveHSDMO> emptyList = new HashSet().iterator();
    protected Set<PrimitiveHSDMO> value;

    public DmcTypePrimitiveHSREFSET() {
        this.value = null;
    }

    public DmcTypePrimitiveHSREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<PrimitiveHSDMO>() : new TreeSet<PrimitiveHSDMO>();
    }

    public DmcTypePrimitiveHSREFSET getNew() {
        return new DmcTypePrimitiveHSREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<PrimitiveHSDMO> cloneIt() {
        DmcTypePrimitiveHSREFSET dmcTypePrimitiveHSREFSET = this;
        synchronized (dmcTypePrimitiveHSREFSET) {
            DmcTypePrimitiveHSREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (PrimitiveHSDMO val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrimitiveHSDMO add(Object v) throws DmcValueException {
        DmcTypePrimitiveHSREFSET dmcTypePrimitiveHSREFSET = this;
        synchronized (dmcTypePrimitiveHSREFSET) {
            PrimitiveHSDMO rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrimitiveHSDMO del(Object v) {
        DmcTypePrimitiveHSREFSET dmcTypePrimitiveHSREFSET = this;
        synchronized (dmcTypePrimitiveHSREFSET) {
            PrimitiveHSDMO rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<PrimitiveHSDMO> getMV() {
        DmcTypePrimitiveHSREFSET dmcTypePrimitiveHSREFSET = this;
        synchronized (dmcTypePrimitiveHSREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<PrimitiveHSDMO>(this.value).iterator();
            }
            return new TreeSet<PrimitiveHSDMO>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PrimitiveHSDMO> getMVCopy() {
        DmcTypePrimitiveHSREFSET dmcTypePrimitiveHSREFSET = this;
        synchronized (dmcTypePrimitiveHSREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<PrimitiveHSDMO>();
                }
                return new HashSet<PrimitiveHSDMO>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<PrimitiveHSDMO>(this.value);
            }
            return new TreeSet<PrimitiveHSDMO>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypePrimitiveHSREFSET dmcTypePrimitiveHSREFSET = this;
        synchronized (dmcTypePrimitiveHSREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypePrimitiveHSREFSET dmcTypePrimitiveHSREFSET = this;
        synchronized (dmcTypePrimitiveHSREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                PrimitiveHSDMO val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

