/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.shared.generated.dmo.PrimitiveMVIDXDMO;
import org.dmd.dmt.shared.generated.types.DmcTypePrimitiveMVIDXREF;

public class DmcTypePrimitiveMVIDXREFSET
extends DmcTypePrimitiveMVIDXREF
implements Serializable {
    private static final Iterator<PrimitiveMVIDXDMO> emptyList = new HashSet().iterator();
    protected Set<PrimitiveMVIDXDMO> value;

    public DmcTypePrimitiveMVIDXREFSET() {
        this.value = null;
    }

    public DmcTypePrimitiveMVIDXREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<PrimitiveMVIDXDMO>() : new TreeSet<PrimitiveMVIDXDMO>();
    }

    public DmcTypePrimitiveMVIDXREFSET getNew() {
        return new DmcTypePrimitiveMVIDXREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<PrimitiveMVIDXDMO> cloneIt() {
        DmcTypePrimitiveMVIDXREFSET dmcTypePrimitiveMVIDXREFSET = this;
        synchronized (dmcTypePrimitiveMVIDXREFSET) {
            DmcTypePrimitiveMVIDXREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (PrimitiveMVIDXDMO val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrimitiveMVIDXDMO add(Object v) throws DmcValueException {
        DmcTypePrimitiveMVIDXREFSET dmcTypePrimitiveMVIDXREFSET = this;
        synchronized (dmcTypePrimitiveMVIDXREFSET) {
            PrimitiveMVIDXDMO rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrimitiveMVIDXDMO del(Object v) {
        DmcTypePrimitiveMVIDXREFSET dmcTypePrimitiveMVIDXREFSET = this;
        synchronized (dmcTypePrimitiveMVIDXREFSET) {
            PrimitiveMVIDXDMO rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<PrimitiveMVIDXDMO> getMV() {
        DmcTypePrimitiveMVIDXREFSET dmcTypePrimitiveMVIDXREFSET = this;
        synchronized (dmcTypePrimitiveMVIDXREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<PrimitiveMVIDXDMO>(this.value).iterator();
            }
            return new TreeSet<PrimitiveMVIDXDMO>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PrimitiveMVIDXDMO> getMVCopy() {
        DmcTypePrimitiveMVIDXREFSET dmcTypePrimitiveMVIDXREFSET = this;
        synchronized (dmcTypePrimitiveMVIDXREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<PrimitiveMVIDXDMO>();
                }
                return new HashSet<PrimitiveMVIDXDMO>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<PrimitiveMVIDXDMO>(this.value);
            }
            return new TreeSet<PrimitiveMVIDXDMO>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypePrimitiveMVIDXREFSET dmcTypePrimitiveMVIDXREFSET = this;
        synchronized (dmcTypePrimitiveMVIDXREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypePrimitiveMVIDXREFSET dmcTypePrimitiveMVIDXREFSET = this;
        synchronized (dmcTypePrimitiveMVIDXREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                PrimitiveMVIDXDMO val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

