/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.shared.generated.dmo.PrimitiveMVDMO;
import org.dmd.dmt.shared.generated.types.DmcTypePrimitiveMVREF;

public class DmcTypePrimitiveMVREFSET
extends DmcTypePrimitiveMVREF
implements Serializable {
    private static final Iterator<PrimitiveMVDMO> emptyList = new HashSet().iterator();
    protected Set<PrimitiveMVDMO> value;

    public DmcTypePrimitiveMVREFSET() {
        this.value = null;
    }

    public DmcTypePrimitiveMVREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<PrimitiveMVDMO>() : new TreeSet<PrimitiveMVDMO>();
    }

    public DmcTypePrimitiveMVREFSET getNew() {
        return new DmcTypePrimitiveMVREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<PrimitiveMVDMO> cloneIt() {
        DmcTypePrimitiveMVREFSET dmcTypePrimitiveMVREFSET = this;
        synchronized (dmcTypePrimitiveMVREFSET) {
            DmcTypePrimitiveMVREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (PrimitiveMVDMO val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrimitiveMVDMO add(Object v) throws DmcValueException {
        DmcTypePrimitiveMVREFSET dmcTypePrimitiveMVREFSET = this;
        synchronized (dmcTypePrimitiveMVREFSET) {
            PrimitiveMVDMO rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrimitiveMVDMO del(Object v) {
        DmcTypePrimitiveMVREFSET dmcTypePrimitiveMVREFSET = this;
        synchronized (dmcTypePrimitiveMVREFSET) {
            PrimitiveMVDMO rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<PrimitiveMVDMO> getMV() {
        DmcTypePrimitiveMVREFSET dmcTypePrimitiveMVREFSET = this;
        synchronized (dmcTypePrimitiveMVREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<PrimitiveMVDMO>(this.value).iterator();
            }
            return new TreeSet<PrimitiveMVDMO>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PrimitiveMVDMO> getMVCopy() {
        DmcTypePrimitiveMVREFSET dmcTypePrimitiveMVREFSET = this;
        synchronized (dmcTypePrimitiveMVREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<PrimitiveMVDMO>();
                }
                return new HashSet<PrimitiveMVDMO>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<PrimitiveMVDMO>(this.value);
            }
            return new TreeSet<PrimitiveMVDMO>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypePrimitiveMVREFSET dmcTypePrimitiveMVREFSET = this;
        synchronized (dmcTypePrimitiveMVREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypePrimitiveMVREFSET dmcTypePrimitiveMVREFSET = this;
        synchronized (dmcTypePrimitiveMVREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                PrimitiveMVDMO val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

